<?php

session_start();

error_reporting(E_ALL);

// Set the HTTP Charset Parameter as UTF-8
header("Content-type: text/html; charset=utf-8");

// Require all functions
$mydir = opendir('../lib');
while($fn = readdir($mydir))
{
    if (substr($fn,-3) == 'php')
        require_once ("../lib/$fn");
}
closedir($mydir);

require_once ('../config.inc.php');

// Force HTTPS if required
if (FORCE_SSL == 1 && (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] != "on"))
{
    $url=$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"];
    header ("Location: https://$url");
}

// Set PHP error level
phamm_php_error_level();

$page_start = page_start();
$page_end = page_end();
$page_exit = page_exit();

// Set language
if (isset($_GET["language"]))
    $_SESSION["language"] = locale_set($_GET["language"]);

if (!isset($_SESSION["language"]))
    $_SESSION["language"] = $language;

$lang = locale_load($_SESSION["language"]);

phamm_print_xhtml($page_start);

$connect = phamm_ldap_connect ();

// Load Plugins values in $pv
$pv = plugins_load();

if (!$connect)
{
    phamm_print_message ('error',$lang["error_connection"]);
    echo $page_exit;
}

// Login section

// First login
if (!login_check() && isset($_POST["login_username"]) && isset($_POST["login_password"]))
{
    $proposed = login_dn_costructor($_POST["login_username"]);

    $r_bind = login_try($connect, $proposed, $_POST["login_password"],$_POST["login_username"]);

    phamm_log ('',$_POST["login_username"],'login',$r_bind);

    if (!$r_bind)
        phamm_print_message('error',$lang["invalid_credential"]);
}

// Logout
if (isset($_GET["exit"]))
{
    phamm_log ($pn,$_SESSION["login"]["username"],'logout',1);
    
    logout();

    phamm_print_message ('message',$lang["logout_message"]);

    refresh ( 'main.php', $force_meta = false, REFRESH_TIME );

    echo $page_exit;

    exit;
}

// Not logged
if (!login_check())
{
    $login_form = login_form();

    echo $login_form;
    echo $page_exit;

    exit;
}

// Logged
elseif(login_check())
{
    // Bind
    $r_bind = bind_try($connect, $_SESSION["login"]["dn"], $_SESSION["login"]["password"]);

    // When user or postmaster change password must exit
    if (!$r_bind)
	refresh ( 'main.php?exit=1', $force_meta = false, REFRESH_TIME );


    if (!isset($_SESSION["phamm"]["pn"]))
        $_SESSION["phamm"]["pn"] = DEFAULT_PLUGIN;

    // Set some variables
    $pn = phamm_set_var('pn');
    $initial = phamm_set_var('initial');
    
    if ($_SESSION["login"]["level"] > 2)
	$mail = phamm_set_var('mail');
    else
	$mail = $_SESSION["login"]["username"];

    if ($_SESSION["login"]["level"] > 4)
	$domain = phamm_set_var('domain');
    else
	$domain = $_SESSION["phamm"]["domain"];

    // Set action
    if (isset($_POST["action"]))
        $action = $_POST["action"];
    elseif (isset($_GET["action"]))
	$action = $_GET["action"];
    // Default action
    else
	    $action = null;
    
    $group_actions = array_merge($group_actions_accounts,$group_actions_domains);

    // Overwrite action for user login
    if (!in_array($action,array('update_account')) && $_SESSION["login"]["level"] == 2)
	    $action = 'modify_account';
    
    // Overwrite action for Postmaster
    elseif (!in_array($action,$group_actions) && !in_array($action,array('add_account','insert_account','modify_account','update_account','domain_property','catch_all')) && $_SESSION["login"]["level"] == 4)
	$action = 'domain_view';

    // Link to logount and language select
    phamm_print_xhtml ('<table width="100%"><tr><td align="left">');
    phamm_print_xhtml ( "<a href=\"?exit=1\">".$lang["logout"].' '.$_SESSION["login"]["username"].'</a></td><td align="right">' );

    phamm_print_xhtml (locale_select());
    phamm_print_xhtml ('</td></tr></table><hr/>');

    if (!in_array($action,array('modify_account','update_account','insert_account','add_account')))
	phamm_print_xhtml ( plugins_menu() );

    if ($_SESSION["login"]["level"] > 2)
	phamm_print_xhtml ( navigation($initial) );

    // echo $action;

    if (in_array($action,$group_actions))
    {
        // Re-write $action in $group_action
        $group_action = $action;
        $action = 'group_actions';
    }
    
    switch ($action) :

    // group_actions
    case "group_actions" :

    // List of accounts/domains to modify
    if (isset($_POST["accounts"]))
	$values = $_POST["accounts"];
    elseif (isset($_POST["domains"]))
	$values = $_POST["domains"];
    elseif (isset($_GET["domains"]))
	$values = $_GET["domains"];
    elseif (isset($_GET["accounts"]))
	$values = $_GET["accounts"];

    foreach ($values as $k => $v)
	phamm_print_message('success',$lang["modify"].' '.$k);

    $r = group_actions ($group_action,$values);
    
    phamm_log ($pn,$_SESSION["login"]["username"],$action,$r);

    if ($r)
    {
	$ga = explode(';',$group_action);

        if ($ga[0] == 'account')
            refresh ('main.php?action=domain_view&amp;domain='.$domain, $force_meta = false, REFRESH_TIME);
        else
            refresh ('main.php', $force_meta = false, REFRESH_TIME);
    }
    else
    {
        phamm_print_message('error',$lang["warning"]);
    }

    break;

    // Create dynamic form to add a new domain
    //
case "add_domain" :

    $syntax = check_syntax('domain',$_POST["domain_new"]);


    if ($syntax)
        phamm_print_xhtml ( form_add_domain_2 ($_POST["domain_new"],'insert_domain') );
    else
    {
        phamm_print_message('error',$lang["warning"]);
        phamm_print_xhtml ( form_add_domain ($_POST["domain_new"]) );
    }

    break;

    // Insert a new domain data
    //
case "insert_domain" :

    $values = $_POST["values"];
    $confirm = $_POST["confirm"];
    $domain_new = $_POST["domain_new"];
    $password1 = $_POST["password1"];
    $password2 = $_POST["password2"];

    $wrong_pw = wrong_pw ($password1,$password2);

    if ($wrong_pw)
    {
        phamm_print_message ('error',$wrong_pw);
        phamm_print_xhtml ( form_add_domain_2 ($_POST["domain_new"],'insert_domain') );
	phamm_log ($pn,$_SESSION["login"]["username"],$action.' '.$domain_new.' '.$wrong_pw,0);
    }


    else
    {
        $entry["objectclass"][0]	= "top";
        $entry["objectclass"][1]	= "VirtualDomain";

        $entry["vd"]				= $domain_new;
        $entry["lastChange"]		= time();
    
	// Merge static values with domain values
	$entry = array_merge($entry,$values["domain"]);
    
	// Purge values
	$values_purged = purge_empty_values($entry); // @todo 2th value
	
        $r = phamm_add ('vd='.$domain_new.','.LDAP_BASE,$values_purged);
    
	phamm_log ($pn,$_SESSION["login"]["username"],$action.' '.$domain_new,$r);

        unset($entry);

        $entry = array();

        // %%%%%%%%%%%%%%%%%%%%% tmp %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        $entry["objectclass"][0]	= "top";
        $entry["objectclass"][1]	= "VirtualMailAlias";

        // Add required plugin objectClass
        foreach ( $confirm as $p_name )
        {
            if ($pv[$p_name]["ISPOSTMASTERRELATED"])
            {
                if(isset($pv[$p_name]["POSTMASTER"]["OBJECTCLASSES"]))
                {
                    $oc = $pv[$p_name]["POSTMASTER"]["OBJECTCLASSES"];

                    foreach ($oc as $oc_name => $oc_val)
			$entry["objectclass"][] = $oc_name;
                }
            }
        }

        $entry["cn"] = "Postmaster";
        $entry["sn"] = "Postmaster";
        $entry["mail"] = "postmaster@".$domain_new;
        $entry["userPassword"]  = password_hash($password1);
        $entry["maildrop"] = "postmaster";
        $entry["accountActive"]		= "TRUE";
        $entry["creationDate"]		= date('Ymd');
        $entry["lastChange"]		= time();
        // %%%%%%%%%%%%%%%%%%%%% tmp %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        foreach ( $confirm as $p_name )
        {
            $entry = array_merge($entry,$values[$p_name]);
        }

	// Add postmaster alias
        $r = phamm_add ('cn=postmaster,vd='.$domain_new.','.LDAP_BASE,$entry);
        
	$entry_abuse["objectclass"][0]	= "top";
        $entry_abuse["objectclass"][1]	= "VirtualMailAlias";
        $entry_abuse["cn"] = "Abuse";
        $entry_abuse["sn"] = "Abuse";
        $entry_abuse["mail"] = "abuse@".$domain_new;
        $entry_abuse["maildrop"] = "postmaster";
        $entry_abuse["accountActive"] = "TRUE";
        $entry_abuse["creationDate"] = date('Ymd');
        $entry_abuse["lastChange"] = time();
	
	// Add abuse alias
        $r = phamm_add ('mail=abuse@'.$domain_new.',vd='.$domain_new.','.LDAP_BASE,$entry_abuse);

        if ($r)
        {
            phamm_print_message('success',$domain_new.' '.$lang["added"]);
            refresh ('main.php', $force_meta = false, REFRESH_TIME);
        }
        else
            phamm_print_message('error',$lang["error"].': '.$domain_new.' '.$lang["not_added"]);

    }

    break;

    /////////////
    // ACCOUNT //
    /////////////

    // Create dynamic form to add a new account
case "add_account" :

    $syntax = check_syntax('account',$_POST["account_new"]);

    if ($syntax)
        phamm_print_xhtml ( form_add_account_2 ($_POST["account_new"].'@'.$domain,'insert_account') );

    else
    {
        phamm_print_message('error',$lang["warning"]);
        phamm_print_xhtml ( form_add_account ($_POST["account_new"]) );
    }

    break;

    // Form to modify account
case "modify_account" :

    $dn = 'mail='.$mail.',vd='.$domain.','.LDAP_BASE;

    $values = self_values ($dn);

    $cn = $values[0]["cn"][0];
    $sn = $values[0]["sn"][0];

    phamm_print_xhtml ( form_add_account_2 ($values[0]["mail"][0], 'update_account') );

    break;

    // One domain selected - show domain's accounts and aliases
case "domain_view" :

    // Add domain form
    phamm_print_xhtml ( form_add_account() );

    // Link to modify domain Property
    phamm_print_xhtml ( '<a href="?action=domain_property&amp;domain='.$domain.'">'.$lang["domain_property"].'</a> ' );

    //Special link for catch-all
    if (in_array($pn,array('mail','alias')))
    {
	// Check if catch_all exists
	$catch_all_dn = 'vd='.$domain.','.LDAP_BASE;
	$values = phamm_search ($catch_all_dn,'mail=@'.$domain,array('mail'));

	if (isset($values[0]["mail"][0]))
	    phamm_print_message('warning','<br/>'.$lang["catch_all"].' '.$lang["active"]);
	else
	    phamm_print_xhtml ( ' - <a href="?action=catch_all&amp;domain='.$domain.'">'.$lang["catch_all"].'</a>' );
    }

    phamm_print_xhtml ('<br/>');

    $values = array();

    // Attributes in the table
    if (isset($pv[$pn]["ACCOUNT"]))
        $values = array_merge($values,$pv[$pn]["ACCOUNT"]);

    phamm_print_xhtml ( accounts_list($domain,$values) );
    phamm_print_xhtml ( action_select($group_actions_accounts) );

    break;

    // Insert a new account
    //
case "insert_account" :

    $values = $_POST["values"];
    $values_date = (isset($_POST["values_date"]) ? $_POST["values_date"] : null);
    $values_multi = (isset($_POST["values_multi"]) ? $_POST["values_multi"] : null);
    $confirm = $_POST["confirm"];
    $account_new = $_POST["account_new"];
    $password1 = $_POST["password1"];
    $password2 = $_POST["password2"];
    $cn = $_POST["cn"];
    $sn = $_POST["sn"];
    
    // Create empty array
    $entry = array();
    $values_multi_purged_one = array();
    $values_date_purged_one = array();
    $values_multi_purged = array();
    $values_date_purged = array();

    $check_cn = check_syntax ('name',$cn,2);
    $check_sn = check_syntax ('name',$sn,2);

    // Is alias account ?
    $is_alias = in_array('alias',$confirm);
    
    if ($is_alias)
	$wrong_pw = wrong_pw ($password1,$password2,0);
    else
	$wrong_pw = wrong_pw ($password1,$password2);

    if ($wrong_pw)
        phamm_print_message ('error',$wrong_pw);
    if (!$check_cn)
        phamm_print_message ('error',$lang["cn_is_not_valid"]);
    if (!$check_sn)
        phamm_print_message ('error',$lang["sn_is_not_valid"]);

    if ($wrong_pw || !$check_cn || !$check_sn)
    {
        phamm_print_xhtml ( form_add_account_2 ($_POST["account_new"], 'insert_account' ));
	phamm_log ($pn,$_SESSION["login"]["username"],$action.' '.$account_new.' '.$wrong_pw,0);
    }

    else
    {
        $entry["objectclass"][0]	= "top";

        // Add required plugin objectClass
        foreach ( $confirm as $p_name )
        {
            if ($pv[$p_name]["ISACCOUNTRELATED"])
            {
                if(isset($pv[$p_name]["ACCOUNT"]["OBJECTCLASSES"]))
                {
                    $oc = $pv[$p_name]["ACCOUNT"]["OBJECTCLASSES"];

                    foreach ($oc as $oc_name => $oc_val)
			$entry["objectclass"][] = $oc_name;
                }
            }
        }

        $mail						= $account_new;
        
	// in mail.xml
	// $uid = str_replace ( '@', CHR_UID_ACCOUNT, $mail);
        // $entry["uid"] = $uid; // @todo

        $entry["mail"] = $mail;
        $entry["userPassword"] = password_hash($password1);
        $entry["cn"] = $cn;
        $entry["sn"] = $sn;
        $entry["lastChange"] = time();
        $entry["creationDate"] = date('Ymd');

	$entry = purge_empty_values($entry);

        // Purge empty values and multiplier
        foreach ( $confirm as $p_name )
        {
	    // Clear and purge values
            $values_purged = purge_empty_values($values[$p_name],$pv[$p_name]["ACCOUNT"]["ATTRIBUTES"]);
	    $values_multi_purged_one = purge_empty_values($values_multi[$p_name]);
	    $values_date_purged_one = purge_empty_values($values_date[$p_name]);

	    // Merge values for each plugin
            $entry = array_merge($entry,$values_purged);

            $values_multi_purged = array_merge($values_multi_purged,$values_multi_purged_one);
            $values_date_purged = array_merge($values_date_purged,$values_date_purged_one);
        }

	// Values from textarea...
	if ($values_multi_purged)
	{
	    foreach ($values_multi_purged as $mv_name => $mv_array)
	    {
		$delimitators = array(" ",";","\t",":","\n");
		$values_multi_string = str_replace($delimitators,",","$mv_array");

		// Purge persistent \r
		$values_multi_string = str_replace("\r","","$values_multi_string");

		$values_multi_array = explode (",",$values_multi_string);

		for ($i=0; $i < count($values_multi_array); $i++)
		    $entry[$mv_name][$i] = $values_multi_array[$i];
	    }
	}

        $r = phamm_add ('mail='.$mail.',vd='.$domain.','.LDAP_BASE,$entry);
	
	phamm_log ($pn,$_SESSION["login"]["username"],$action.' '.$mail,$r);

        if ($r)
        {
	    // Send Welcome message to new mail account if required
	    if (SEND_WELCOME)
	    {
		$eol = "\n";

		// Custom or default welcome message
		$welcome_msg_custom = '../templates/welcome_'.$domain.'.txt';
		
		if (file_exists($welcome_msg_custom))
		    $msg = file_get_contents($welcome_msg_custom);
		else
		    $msg = file_get_contents($welcome_msg);
		
		$headers = '';
		$headers .= "Message-ID: <".time()."@".$_SERVER['SERVER_NAME'].">".$eol;
		$headers .= "X-Mailer: Phamm - PHP v".phpversion().$eol;

		$headers .= "From: <".$welcome_sender.">".$eol;
		$headers .= "Bcc: <".$welcome_bcc.">".$eol;

		$r = mail($mail,$welcome_subject,$msg,$headers,'-f '.$welcome_sender);
		phamm_log ($pn,$_SESSION["login"]["username"],'sent welcome message to '.$mail,$r);
	    }

            phamm_print_message('success',$account_new.' '.$lang["added"]);

            refresh ('main.php?action=domain_view&amp;domain='.$domain, $force_meta = false, REFRESH_TIME);
        }
        else
            phamm_print_message('error',$lang["error"].': '.$account_new.' '.$lang["not_added"]);
    }

    break;

    // Update account
    //
case "update_account" :

    $values = $_POST["values"];
    $values_date = (isset($_POST["values_date"]) ? $_POST["values_date"] : null);
    $values_multi = (isset($_POST["values_multi"]) ? $_POST["values_multi"] : null);
    $values_multi_del = (isset($_POST["values_multi_del"]) ? $_POST["values_multi_del"] : null);

    $confirm = $_POST["confirm"];
    $account = (isset($_POST["account_new"]) ? $_POST["account_new"] : null);
    $password1 = $_POST["password1"];
    $password2 = $_POST["password2"];
    $cn = (isset($_POST["cn"]) ? $_POST["cn"] : null);
    $sn = (isset($_POST["sn"]) ? $_POST["sn"] : null);

    // Create empty array
    $entry = array();
    $values_multi_purged_one = array();
    $values_date_purged_one = array();
    $values_multi_purged = array();
    $values_date_purged = array();

    $entry["cn"] = $cn;
    $entry["sn"] = $sn;

    // Tag and others
    $entry = purge_empty_values($entry);

    if ($password1)
        $wrong_pw = wrong_pw ($password1,$password2);
    else
        $wrong_pw = 0;

    if ($wrong_pw)
    {

        phamm_print_message ('error',$wrong_pw);
        phamm_print_xhtml ( form_add_account_2 ($account, 'insert_account' ));
	
	phamm_log ($pn,$_SESSION["login"]["username"],$action.' '.$wrong_pw,0);

        break;
    }

    if (is_array($confirm))
    {
	foreach ( $confirm as $p_name )
	{
	    // Purge empty values
	    $values_purged = purge_empty_values($values[$p_name],$pv[$p_name]["ACCOUNT"]["ATTRIBUTES"]);

	    if (isset($values_multi[$p_name]))
	    	$values_multi_purged_one = purge_empty_values($values_multi[$p_name]);
	    if (isset($values_date[$p_name]))
	    	$values_date_purged_one = purge_empty_values($values_date[$p_name]);

	    // Merge the values from each plugins confirmed
	    $entry = array_merge($entry,$values_purged);
	    $values_multi_purged = array_merge($values_multi_purged,$values_multi_purged_one);
	    $values_date_purged = array_merge($values_date_purged,$values_date_purged_one);
	}
    }

    $mail = $account;

    // Date Values (year-month-day)
    if (count($values_date_purged) > 0)
    {
	foreach ($values_date_purged as $k_date => $v_date)
	    $entry[$k_date] = $v_date["year"].'-'.$v_date["month"].'-'.$v_date["day"];


    }

    // Add Values from textarea...
    if (count($values_multi_purged) > 0)
    {
        foreach ($values_multi_purged as $mv_name => $mv_array)
        {
            $delimitators = array(" ", ";", "\t", "\n", ":");
            $values_multi_string = str_replace($delimitators,",","$mv_array");
	    
	    // Purge persistent \r
	    $values_multi_string = str_replace("\r","","$values_multi_string");
            
	    $values_multi_array = explode (",",$values_multi_string);

            for ($i=0; $i < count($values_multi_array); $i++)
                $entry_add[$mv_name][$i] = $values_multi_array[$i];
        }

	if (count($values_multi_array) > 0)
	{
	    $ra = phamm_mod_add ('mail='.$mail.',vd='.$domain.','.LDAP_BASE,$entry_add);
	}

    }

    // Del Values from checkbox
    if (isset($values_multi_del[$p_name]))
    {
        $rd = phamm_mod_del ('mail='.$mail.',vd='.$domain.','.LDAP_BASE,$values_multi_del[$p_name]);
    }


    // This swith action to change mail or postmaster value
    if ($mail)
    {
        $entry["lastChange"] = time();

	if ($password1)
	    $entry["userPassword"] = password_hash($password1);

	$r = phamm_modify ('mail='.$mail.',vd='.$domain.','.LDAP_BASE,$entry);
	
	phamm_log ($pn,$_SESSION["login"]["username"],$action.' '.$mail,$r);
    }
    else
    {
	// Skip static values cn and sn
	unset($entry["cn"]);
	unset($entry["sn"]);
        
	$entry["lastChange"] = time();

	if ($password1)
	    $entry["userPassword"] = password_hash($password1);

	$r = phamm_modify ('cn=postmaster,vd='.$domain.','.LDAP_BASE,$entry);
	
	phamm_log ($pn,$_SESSION["login"]["username"],$action.' postmaster@'.$domain,$r);
    }

    if ($r)
    {
        phamm_print_message('success',$account.' '.$lang["updated"]);
	refresh ('main.php?action=domain_view&amp;domain='.$domain, $force_meta = false, REFRESH_TIME);
    }
    else
        phamm_print_message('error',$lang["error"].': '.$account.' '.$lang["not_updated"]);

    break;

case "domain_property" :
    
	// Load domain values
	// $dn = 'vd='.$domain.','.LDAP_BASE;
	$dn = 'cn=postmaster,vd='.$domain.','.LDAP_BASE;
	$values = self_values ($dn);

	// action update_account => postmaster
        phamm_print_xhtml ( form_add_domain_2 ($domain, 'update_account') );
    break;

case "catch_all" :
    
	// action update_account => postmaster
        phamm_print_xhtml ( form_catch_all ($domain) );

    break;


default :

    // Plugin body
    // @todo if (
    $values = array();
    $values_domain["ATTRIBUTES"] = array();
    $values_postmaster["ATTRIBUTES"] = array();

    // Attributes in the table
    if (isset($pv[$pn]["DOMAIN"]))
        $values_domain = $pv[$pn]["DOMAIN"];
    
    // Attributes in the table
    if (isset($pv[$pn]["POSTMASTER"]))
        $values_postmaster = $pv[$pn]["POSTMASTER"];

    $values["ATTRIBUTES"] = array_merge($values_domain["ATTRIBUTES"],$values_postmaster["ATTRIBUTES"]);

    // @todo only one query...
    if ($_SESSION["login"]["level"] == 10)
    {
	if (isset($initial))
	    $vds = phamm_list(LDAP_BASE,"(&(objectClass=virtualDomain)(vd=$initial*))",array('vd'));
	else
	    $vds = phamm_list(LDAP_BASE,'objectClass=virtualDomain',array('vd'));

	phamm_print_xhtml ( form_add_domain() );

	phamm_print_xhtml ( domains_list($vds,$values) );
	phamm_print_xhtml ( action_select($group_actions_domains) );
    }

    break;

    endswitch;

}

echo $page_end;

?>
