# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from lib.reverse_translation import _t

#---PIL
def init():
    global Image, ImageFilter, imtools
    import Image, ImageFilter
    from lib import imtools

def common(image,radius,amount=100):
    """Apply a filter
    - amount: 0-1"""
    commoned  = image.filter(ImageFilter.ModeFilter(radius))
    if amount < 100:
        return imtools.blend(image, commoned, amount/100.0)
    return commoned

#---Phatch
class Action(models.Action):
    label       = _t('Common')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(common)
    version     = '0.1'
    tags        = [_t('filter')]
    __doc__     = _t("Copies the most common pixel value")

    def interface(self,fields):
        fields[_t('Radius')] = self.RankSizeField(self.RANK_SIZES[0])
        fields[_t('Amount')] = self.SliderField(100,1,100)

    icon = \
'x\xda\x01\x14\r\xeb\xf2\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0c\xcbIDATh\x81\xc5Y}\x8c]\xc5u\xff\x9d\x99\xb9\xf7\
\xbe\xb7o\xbf\xbc\x1f^w\xbd`\xbc\xfeX\xbc\xfe\x88\xf1\xc7\x9a\xb8\x18[4\t\
\x94\x08\xa4@@!%\x8d\xd4&"\xd0 \xc8\x1f%nS\xa9U+E%\xa5J#\xb7\x91\x9a\xa2\x86\
\xa8j\xd3\x00&"\x81\x02\xb6 \xc6q\xeb\x98\x8f`\x0c\xf6\xda\xc66\xde5\xbb\xeb\
\x8f\xf5\xb2\xfb\xf6}\xde;wN\xff\x98{\xf7\xbd\xdd}\xfb\xf6a"1\xd2\xe8\xbe\
\xbb{\xe7\xcc\xf9\x9d\xdf\x993s\xce\x10\xca\x1a3\xa3\x96FD\xd4\xd8):\xd3\xc3\
f\x84\x99MM\x83\xcaZ}\xbbp\xaf\xda\xa2\xeeX\xba^~\xa5e!m.\xfa@\xb1\xc0&\x93\
\xc6\x99\xf1\x11\xf3\xfc\xe8{\xe6\xb9\xc1\xdf\x04o\xcf1\xf7\xf4\xf7Z\x01\xf4\
\xfc\xa1\xbbu\xc1\x12\xf1u\'\x81-uu\xe8L.\x10M"\xc0\xc8\xd0\xd9p_v\x94\x9f{\
\xf7\x19\xff\xbfjQ~\xe5\xe7\x9c\xd5\xdd}\xea\xe7\xcb\xd7\xc9\x15M\xcd\x04\
\xe5\x00\x8e\x0bx.\xc1\xf5\x80\x89q\xc6\xd0 \x9b\xfe\xd7\xf4\x8f\xcf\x1e\nw\
\x0e\x1e\nF?\x16\x80\x9e[\xdc\x8d\xed+\xc5\xa3\xab6\xca\x9b\x96,\x13\xd4\xd6\
.\x10h\x86_\x04|\x1f\xc8\xa6\x19\xe7\x06\x0c\x8e\x1e\xd4?:\xf7\x9b\xf0\xc1\
\x0b\xc7\xb4_\xcd\x08\xabw\xa8\xdd\x8b\xbb\xc5"!\x00\x12\x80 @H\xc0\xf3\x08^\
\x02H$\t\xc9$`\x0c\xf0\xfa~=\xf2\xdb=\xfa\xbec\xbf\xf0\x7fyE\x00\xd6\xdd\xe5\
~c\xcd\x0e\xe7\xb1\x1b?\xabRJ\x01\xb9\x1c\xa3\x90\x07\xfc\x02\xa3X\x04\x8a>#\
\xd4v\xb2\x89q\xc6\xf1\xd7\xc3}g\xffW\xdf9|X\x8f\xcdT\xfe\x9a\x1b\x9c5+w\xa8\
W\xbbW\x89\x16\x90UDP\x04B\x00RZ \x89$!Y\x07\xd4\xa5\x08uu\x84\xe3G\xc2\xc2K\
O\xf8\xb7\xf7?\xe7\xef\xad\x04@\xcde\xad\xf5\xf7x\xdf\xbf\xf9\xab\xee\xc3\
\xab\xd7K\xe42V\xc1|\x8eQ\xc8\x01\xf9"\xc3\x84\xb0\xdd\x00\x86\x81d\x92\xb0t\
\x8d\xd8QH\xcb\x9d\x00\x1e\x99)\xafu\x99\xd8\xd9\xde%Z|\x1f \x02\x88\x18\x14\
Y_\x08B\x18Z\x10\xc60\x02\x1f\x08\xb5\xed=ke\xc2\xff\xb2\xb3\xfb\xda\xcf\xbb\
7\x1d\x7f\xde\x7fc\xa6\\QI\xf9\xb5_t\x1f\xdcq\xa7\xf3P\xef:\x89\xc9409\xc1HO\
0&\xc6\x19\x99,\x10D\xee\x13\xf8@\xe03\xb4\xcf\x08|F\xb2N\xa0\xf9jq\xff\xca\
\xcf9\xd7\x96\xcb[~\x93\xb3\xa5c\xb9\xbc\x9b\xc8\x8e\x99\x1a\x1b\x94d\x04\
\x01#\x08\x00\x1d\x00~\xd1\xce\x99I3&\xd3\x8c\xd5\xd7\xc9\x86\xe5\x1b\xe5\
\xf7+\xe9:\x8b\x81\xde\xdb\xdc?X\xb5\xdd\xf9\xde\xa76K\xcaL22\x93@v\x92\x91\
\xcbYw\tC\xb6\xddX\x06\xd8\x10\x8ca0[\x17lj\xa1\xfa\xecR\xf9\xb7\x00\xee\x8e\
e\xb6t\x8bGR\rp\x02\xdf\xba\xa8e\x00 A\x90\xc2\xb2 \r\xc0\x91\x1cc\x08\xcc@&\
\x13\x7fO\xd8\xb0]\xdd\xd0s\x8b{\x0b\x80\x17\xab2P\xdfA\xdf\xe9]/\x12\x99,\
\xac\xf2iF6\xc7\xd0\x01\xa05\xa0\x83\xe8\xb7\x1f[\x93\xadE\x8b\x0c\xdfgx.\
\x90j\xa3/^\xbdE\xad\x07\x80\x8e^\xf5{\r\x0b\xc5mZcj\xe1\xc7]\xc7\x96/c\xc4\
\xce\xc3\xd1\\@6\xcb\xc8e\x19\xcd-\x84\xae5\xe2\xebU\x19Xy\xb3{\xf3\x8a\xedr\
GG\xa7@.\xc3\xc8N2\xb2yF\x18)\x1fj\x86\xd6d\x19\x88\xd80&f\x81`\xa2 \x90H\
\x82\x16,\x957\x008\xdc\xb6BlS\t8\x81\x0f0l\xd4 a\x19\x08\xa3\xc5+e\xc4`YL!0\
\x88\x08\x14\x00\xb9,C)\xa0\xab[\xae\xa9\n\xa0\xa9\x8b\xbe\xb4b\x95\xa2b\xc1\
\xbaL>\xcf0e\xca\x07A\xe4B\x81u!\xad\xad\xfb\x98\x18\x08\x03`\x06\x83\x90h\
\xa4-\x00\xfe9\xb9\x806\xb2\xb1LE\x9a\xd9\xc5+\xec\xe25\xa6\x14\x08\x98\x19\
\xe0\xb2(C\x16D\xe0\x03\x85<`\x98\x17V\x05 \x1d\xba\xa6\xad\x1d(\xe4\x19\xf9\
l\xe4*!\xa0CF\xa8)b \xa27f \xb4\x91\xc3*B\x00\x13\x18\x80J\xe0\xd3\x00\xa0\
\x12\xb4)\x0cgN\x1b\x81\x90\xa5q\xa5\x08\x1eY>\x02\x19Fa6\x9fg\x14r\xc8T\x05\
@\x12]:\n_A`-\x13j\x86\xd1\x14)^R^\xc7l\x84\x84P#Z|\xa5}\xc4k\xa0e\xd7lu6t\
\xf5\xc9\xebf\xabo\xbf\x0f5\xc0&\xde\x7fhjqOmr\x02\x10\x82\x11\n\x82\x08\x81\
\xa0\xc0\xb3\xc2\xe8\xf4(\xc4\x98\x8c\x17f\x18\x02a\x14\xe7\xb5\x8e}\xdeNZZh\
v=T:\r\x91\x00\x9c\x14\xbe\xe45\xd0\x82J\x00\xe2f\x0c\x00\x1d\xef\x0b\xb1\
\xe5\xd9\xee\re\x9b\\\xa8\x81\xcb\x1f\x98_\xcd\x1c?-\n\x059\xde\x17\x04\x0c\
\x1doP\x91\x85\x8d\x01Bc\xdd(v\x1d\x1d\xb9T\xb5\xa3\x9ct\xa9\xad\x9a\xf2\xe5\
 \xe2\x1d\xdd\x98\xd2\x06\xc9&f\x16\x18<\x1e\xee;\xf0#\x7fWU\x00\xe9\x11\xb3\
\xf7\x83\xb3\x86Q\xb6\xb0\x8c\xb1l\x98\xd0\x820a\x99\xe5\xe79\xbcJ\x07U\xad?\
\x13D\x1c\x0cl/\xfd\x1e;o\xde\x7f{\x8f\xbe\x8b+\x1c\xd6\xa6\x018\xf9R\xf0\
\xc2\xd1\xfd\xe1\xae\xcc\xa4\xb5l,\x00\x86m\xa8\x0c\x11m`\xd5-?%\\\xd5\x0e\
\x8096X\x1c\x91l\xbf8`\x8e\x1eyE\xdf\xf1\xfe\xfe\xe9\xa7\xd2\xb8\xcd\xda\x89\
\x8f<\xe9?\xec\xd5\xa3\xabg\x8b\xba\xc3\xf3\x08\xcc\x0c\xc3\xd6\xfa\x1cE\x0c\
Sc\xde du\xff\xaf\x04\xc2\x86b ;\xc1\xd9\xb1\xb3f\xd7\xe1g\xfc\xbf\xc9\x8d\
\x99\xe2\\cf\x01`f\xee\xe8U\xf7\x86E|\xbbm\x19=\xd0\xd0"\xda\xa5\xb0\x9bP\
\x1c\xa7kMa\x84\xac\x9d\x01;9P\xcc\x9a\xfc\xd8 \xef\xbdp\xdc\xfc\xf5\x99}\
\xc1a<^}H\xd5\xe3\xf4U\x9bU{\xc7\x1a\xf9\xad\xfa\x0e\xf1\x8dd=- \x8a\x17rm\
\x0cL\x9e7\x99\x86E\xa2~\xbe\xeft\x01\x85\xc2\x04\xef/\xa4\xcd\xf3\x17\xfb\
\xcdS#o\xeb\x919\x15\xbe\x92\x8c\xac\xbdG\xb6v\xf4\xcam\x89f\xeaS\x1emVIl\
\xf2\xea\xa9y>\xc5\xd8\xd8pZ\xde\xc2\x00\xc6\x9f\xe4!\x13\xe2t\x18\xf0\x19?\
\x8bwGO\x84\xcf\x0c\xbd\xa5\x07\xe6\x93w\xc5\x00f\xb6D\xa3Hvm\x92\xdbH`-\x08\
]\xca\xa36\xe9\xa2M(\xb4\x0bEm^=\xda\xea;D*\xfe>{\x89\x0b\xc5\x0c\x7fh4\xc6\
\x85\xc2\xa8\xd7@\x82\x04\x9a\x88\xd0\xc4\x8c\x80C\x0c\x1a\xcd\xe7B\x1f\x83A\
\x9e\xcf\xe5\xc7\xf9\xd7\xef\xed\r\x8e\xfdN\x01\x10\x11um\x96\x9b[\x96\xca\
\xad^\x03\xb6H\x97\xfa\xbcF\xea\x96NM\x98\xe7mD\x80\xe3\x10H0\xfc\x02\xf9\
\xe9\xf3\xe1\xd3cg\xcc\x0fN\xbd\x1c\xbc\xf6\xb1\x00,\xde\xa0\x16v\xac\x96\
\xdf\xf6\x1a\xe8\xce\xba6ZB\xc0\xbc\xf1?n\xa1\x0f\x98\x90\xd9I\xce\x98\xb5\n\
\x00\xe5\x00\xaeg\x0fz~\x9e\xc3\x0b\xa7\xc3\xdd\'\xf6\xe8\xaf~8\x10\x16*\x01\
\x983\xa5l\xea\x92\xc9%[\xe5\x83\xdd\xdb\xd5C\xa9\x16\xeaT\xca.\xde`\xce\x94\
}v+Lp\x81\x19\xc6I\xa2n\xbeo\xe3\x10J\xb0\xa7Y)\x19\x8d-$\x9b[\xd5\xdd\x8eC>\
\x80\xafT\x1aW1\xa5\\\xba\xcd\xb9\xaa\xf7v\xe7\xe0\x92\xeb\xd4\xa3\x8b\x96\
\x88\xceT\xca\x9eQP\xa3\xe5\x01\xa0\x98\xe6\x9cJ\x00\xba\xc0\xf9Z\xc7T\xe2I9\
\x84\x9e\xeb\xe5\xbd\x1b\xff\xd8\xfb\x8bJcf\x01X\xbcA5]\xbdI>\xbd\xe2:\xf9\
\xa9\xe6V\x82\x9c\x93\xa3\xea-7\xc6i\xb7\x9e\x12F\xa36\x00\x04LU+PJ;\x01@)\
\xa0{\xad|`^\x00DD+w\xa8\xff^\xb9A\xf6\xb9n\x99\x90\xb2g\xad\xcdh\x14\x89\
\x006\xb5\x01\x90\xd2\x9eBm\xb6\x16\x95\\\x08 a\xab\x17\x0b:h\xf1\xe2\rjmU\
\x00=\x9fU7\xf7l\x94\xb78\x8a\xa6\x94\x8e\x8f\xb8\xa5,\xaa6\x00\xcc(D\xcfy\
\x01\x10\x01"RZ\x08\x9b\xe8@\x94\xcfK \x01j]&\xfa\xaa\x02\xe8\xbb\xcd\xb9/QG\
S\x153*+<\t\x11MR+\x00c}?~VkR\x12\xa4b\x08IQ\x9d\x08\xb6Z\x11W\xeeD\xb4\xc8\
\rtU\x00\xc9\x06\xda\x1a\x0f\xa0\x19\x02\x84\x04\xa4\x8a\xa9\xae\x01@\xc4\
\x00\xaa0@\x04(e\x95W\x92 \x9d(\xc9\x9fJ\xf6-8\x11\xb9n~\x9c\x87\xab\x020\
\x06\xae\x90%\xdaDT\xee\x13\x92\xa6J\x7fR\x11\x94\xaa\x0eB\x17P\x10\x92\x06\
\x8d\xb5\xd7\xacI\x01+K)\x82r\x18\x8e\xb2\xc1BI\x82\x8a\xe6\x10\x92\xa6\x0cG\
\x92\xe0\x17\x80\xf1\x01s\xa6:\x80\x10\xda\xf3\xa8\x84~\x9a%\x00%mD\x90\xcan\
8RV\x06PH\xf3\x81D\x13\xc9\xd0g\x1d\xfa82M\x86"\xb8.\xc1q\x00\xe5\xb2e\xc0\
\xb5\xe1R)\x86\x8c\xc0\xc8\xf8\xb7\x04\x94b\x0c\x9d\n\xdf\x1c=\x15\x9e\x9e9\
\xd7\xb4 \xa9\x03\xe4\xbc\x04P, \xaaUFU7\x03{\x8c.\xdb\x82\x85\x88,4U\x1b\
\xb2\x7fg\x00\xc54\xef\xf1\x1ai\xbbpHM\x9e\xe7a!\xac\xa5\x01\xd8R\t\x08B\x94\
\xb1\x1a\xd5\x86T\xc4n\xec\xaaR\x01B\x01~\x01\xb88\xc0\xff^\x91\xc9\xf2\x973\
\xc7\xc2\x17\x95\x03$\xea\xca\x04)X\xdfT\x91\x95\x1cX\xebEO\xc7!\xb8\x0e\xc1\
\xf5\x08\x8e\x0b\xc0@\x8f\x9e\n\x7f\xc1\x86\'\xa5\x03\x14&\xf8R\x18@;.\xc1q\
\xad\xf5=\x0f\x96\x05\xd7\xde\r(\xc7\xfeO9v.\xa50\x05&\x99$\\\x182\x1f\x0e\
\xbf\xa5+\xde?L\x030r,|\xf6\xfc\x10\xa3\xae\x0ep\xbd\xc8/#A\xca\x01\x9c\xf8\
\xdd\xa1Hy\xc0u\x01\xc7\x8b\xc0\xb8\x84\xdce~\xe3\x83\xd7\xf5\t6H\x03@\xc3"*\
\xfa\x19\x1ep]\xfb\xad\x1b)\xed\xba\x0c\xc7\xa1\xa8\xa3\xf4\x8c\xe4+\x07\xf0\
\x12v\xee3\xbf\r\x1f\xbbt"\x1c\x9f\x17\xc0\xe9_\xe9\x17\x8f\x1e\n\x8f$\x92\
\x84T\xbd\x9dL\xcd\x04\xe1\xc6\x9d\xa2\x1e)\xe6Y7\xca\\2?\x01\x00\x0e1\x01\
\x00um\xd4]\xcc\xf3\xbbnd\xfdx\x9c\x8a\x19p\xecS).1\xac\x80D\x82\xd0\xd0\x00\
\x0c\x9d6G\xdf\xf8\x0f\xff\xd1J\xca\xcf\x02\xc0\xcc\xe6\xdc\x91\xf0\xa1\xf3C\
\xacS\xf5\x84\xfa\x06{\xed\xa3\xa6,De\xae\x13[\x92\xa6\xfa\x87\x1f\x98W\xdfy\
:\xf8W\x00\xc8\x8f\xf3;\x00\x90h\xa4\xad\x93\xe7\xcd\x13\xc6p\xd9\xf7\xe5lDL\
D\x0b\xdbq\xed\xe5FC#!\x93f\x7f\xff\x93\xfe\xbd\xcc\\\xa1\xb6W\x01\x00\x00\
\x9c|\xc9\xdfw\xe8\xc5\xe0qf\xa0\xbe\xc1\nJ$\xac\xe2\xe5@\x9c2wp\\\xa0\x98\
\xe7\xe2\x85\x13\xe1#q\xe9\xe3\xd2q\xf3\xb2.\xa2\xa8\x92\xf4\xfb\xc7\x9e\r\
\x9e\x1d\x1b\xc6\x9bS\nG\x0c*\xb7\xa4\xb8r\xed\xedLC#\xa1\xb1\x89@\x02\xfa\
\xd0\xff\xe8\xfb\xde\xdb\x1b\x1c\x9eK\xf9\x8a\x00\x00`\xff\xbf\x14\xbf\xb9\
\xf7\xc9\xe0g\x8e\x83H \x90\xaa\xa72\xf7\xc1\x94;\xb8\xae\xdde\x06\xdf1?<\
\xb9\xa7\x94|\\<\xae\x87\x8bi~\xab\xae\x85z\xd6\xdc\xe1|m\xe8\x98\xfeG\xc3\
\xe5\x8c\x95XH\xa6\x08\x8d\x8d\x84\xa6fBc3\xa1X`\xbd\xe7?\xfd?}eW\xe1\x89j\
\xca\x03s\xe4\x03\xcc\x1c\x12\xd1=a\xc0\x97\xb7\xdd\xee\xdc\xdf\xd2F\x14/\
\xd8b\x01(\x16\xa2\x0b\x0e\x03\xe43\x1c\xf6\x1f\xd0\xdf{\xed\xc7\xfew0#\xd0e\
.\x9a\xc7S\xed\xf2\xfa\xc6N\xb1\xf3\xc4\x0b\xc1\xa6c\x8b\xc4\xcf7}\xc6\xf9\
\x82\xe7\xd9\x18\xefD~\xefD7\x94J\x01\x83\xa7\xcc\xe8\xab?\xf3\xff\xe4\xf5\
\x9f\x96.\xf6\xaa\xb5y3\xb2kou\xb7\xf5\xdd\xaa\xfe\xa1s\x99\xdc\xd2\xdafK\
\x8b\xd9\x0ccr\x921\xd0o\x86\xcf\x1c\xd6\x0f\x1fy\xca\x7f\xaa\xa2p"y\xfd\x03\
\xde\xa1\xba\x16\xda\x98\x1d\xe5g\xfa\x7f\x19\xdc\xbb\xf9\x1e\xe7\xb1U}\xea\
\xfe\xae%\x82\x1c\xd7*\xe0\x17\x81\xe1s\x1c\x1c\xde\x1f\xfc[\xff^\xfd\x97\
\x17\xfb\xf5\xc4\x9c\n_iN\xbc\xf4\x06\xa7\xaf\xbe\x83\xaeu\xeah\t3\xfc\xf1\
\x01\xf3\xeb\xb3\x07\xf4\xc1J\xe5\xbe\xf2\xb6\xe6\x0b\xee\xadm=r\xb7t\x90\
\xc8\\\xe0\xdd\xa7_\t\xfeha\xaf\xbci\xd1rq#\x08=\x93\xe3<\x9a\x1f\xe7\x83\
\x97O\x9aWF\xde\x99\xbf2\xf1;\xa9J|\xd4\xb6\xee.\xf7\xcfZW\xc8]B\x822\x17\
\xf8\xc0\xe5\xd3\xe1\xc3\xa7^\x0e\xde\xbc\x12Y\x9f\x08\x00\x00Xw\x97\xfb\xdd\
\xd6\x15r\xa7\x90 ]@v\xfc\x9cy\xec\xf4\xcb\xc1w3\x97\xccG\xc8\xb2?A\x00\x00\
\xb0\xea\xf3\xee\xd7\xdaz\xc4\xdf\xbb)j\x05\x80\xdce~m\xec}\xf3\xad\x13/\xf8\
\xffW\xab\x8cO\x14\x00\x00t\xdf\xe8\xac_\xd8+\x7f\x98j\xa7O\x03@\xe8#\x9f\
\x1e1?\x18<\xa8\xffn\xf4\xbd07\xdf\xf8O\x1c@\xa4\x84Zw\xb7\xfb\xcd\xc6\xc5\
\xf4\xe7n\x8a:\x01\xa00\xc1\x87/\x9d0_>\xf9\x92\xdf?\xcf\xd8i\xefWXs\xf8x\
\x8d\x995\x80\x7f\xea\xda\xa8~\xda\xb1V\xfe\x95WOw\xb2A\n@\xebG\x95\xf5\xffS\
\xf3\x7f\x96\x0f\xe8m\x80\x00\x00\x00\x00IEND\xaeB`\x82z\xdaQD'
