# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu).

from core import ct, models
from lib.reverse_translation import _t

#no need to lazily import these as they are always imported
import os, shutil

class Action(models.Action):
    """Defined variables: <filename> <type> <folder> <width> <height>"""

    label       = _t('Rename')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    version     = '0.1'
    tags        = [_t('file')]
    __doc__     = _t('Rename the original image')
    valid_last  = True

    def interface(self,fields):
        fields[_t('File Name')]    = self.FileNameField(choices=self.FILENAMES)
        fields[_t('In')]           = self.FolderField(self.DEFAULT_FOLDER,
                                        choices=self.FOLDERS)

    def apply(self,photo,setting,cache):
        #get info
        info                    = photo.info
        #get file values
        folder, filename, typ   = self.is_done_info(info)
        if setting('overwrite_existing_images') or not os.path.exists(filename):
            #ensure folder
            filename = self.ensure_path_or_desktop(folder, photo, filename)
            #do it
            os.rename(info['path'],filename)
        return photo

    def is_done_info(self,info):
        folder      = self.get_field('In',info)
        filename    = self.get_field('File Name',info)
        typ         = info['type']
        return folder, os.path.join(folder,'%s.%s'%(filename,typ)), typ

    def is_overwrite_existing_images_forced(self):
        """Force overwrite when using default values."""
        return (self.get_field_string('In') == self.FOLDER) and\
            (self.get_field_string('File Name') == self.FILENAME)

    icon = \
'x\xda\x01\x9c\x04c\xfb\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x04SIDATh\x81\xed\x98]\x88[E\x14\xc7\xffg\x92\xbd\xa6\
\xba\xban\xebWA\x10\xbb+T\xd6\xc4$c6\xc4me\x1f\xb4\x94\n\x16\x8a[\n\x8dE|\
\xab/U\x10\x14\x8a\x88_\xef\xf5\xebE\xc4\x17\x1fDj\xb5\x8a\x08\xa2\xa0\xed\
\x83KI\xc6,\xa9y\x10\xb2\xac\xae\xa8\x0f]vMP6\x9b\xee\xbd\xc7\x87&\xf5\xe6\
\xee\xdc\xe4N>\xd8\x97\xfc\xdef\xce\x993\xff\xff\xbd3\x97\xb9\x03\x0c\x192d\
\xc8vB\xdb-\x00\x00\xe2\xf1\xf8}\xe1p8\xc6\xcc\x02\x00\x98\x99\x00\xc4\x88h\
\r\xc0\xb2+uY)u\xc9=v\xdb\r$\x93\xc9,\x11}\x08`$H>\x11\x9d\xc9\xe7\xf3\xcf7\
\xdbb`\xca\x02"\x84x\x16\x01\xc5\x03\x003\x9f\x9c\x9a\x9a\xb2\xae\x8f\xefe\
\xf2L&\xb33\x95J\xdd\xd5K\rf\xfe\xd9p\xc8/\xa5R\xa9\xdel\x84\xbb\x99TJy\x00\
\xc0\x99z\xbd~\x7f\xa3}\x85\x88^\xcb\xe7\xf3\xef\x9a\xd6\xb2,\xebT\xbd^_\x01\
0\xd9\xe8\x8a\x02\xd8\xebI;\x0b\x00D\xb4f\xdb\xf6\xab\xee\x80\xf1\x1eh\x88\
\xff\n\xfa\xd7\xfe\xb2R\xea\r\xd3\x9a\x9e\xfaQ\x00EW\xd7e\xa5T\xcc/\xdfh\t\
\xcd\xce\xce\x86\x01\xbc\x0f\xff5\xfb\x8a\x94\xd2\xfb\xf4\x06\x8a\x91\x81j\
\xb5z\x04\xc0=mR\xc2\x00N\xf5\xa4\xc8\x10#\x03Dt2@Z6\x1e\x8f\xdf\xda\xa5\x1e\
c\x02\x1bH\xa5RS\x00f\x03\xa4\x8e\x86B\xa1\x13]+2$\xb0\x01\xc7q\x9e6\xa8\xfb\
\x8c\xb9\x94\xee\x08d`nn.\x04\xe0\xb8&t\x15\x8dO\x9c\x87\x07\x93\xc9\xa4\xef\
\x97\xa3\x9f\x042\xb0\xb4\xb4t\x00\xc0nM\xe8{\x00\x1f\xe8\xc6\x10\xd1S=\xe8\
\nL \x03\x8e\xe3\xf8\xad\xe9\xb3\x95J\xe5\x02\x80\x8a&v\xbc\xf1\xe6\x06JG\
\x03\xe9t\xfa\x16":\xac\tm\x028_.\x977\x00|\xa3\x89\xef^\\\\|\xacW\x81\x9d\
\xe8h`ss\xf3(\x80\x1d\xde~f\xfeA)\xb5\xd2h~\xa1\x1bKD\x03\xff\x1au4\xd0f-_\
\xdf\xbc\xb6m\x7f\x8dk\x1b\xda\xcb\xe1\x99\x99\x99\x9b\xbb\xd4\x16\x88\xb6\
\x06\xa6\xa7\xa7\xefe\xe6\xfd\x9a\x90\xcd\xcc\x9f7\x1b\x0b\x0b\x0b\x7f\x13\
\xd1EM\xde\x8d\xeb\xeb\xebO\xf6*\xb2\x1dm\r\xd8\xb6\x9d\x85\xfe\xc0w\xb1P(\\\
qw0\xf3\x97\xba\x1a\x83^F\xed\x0c\x10\x00\xbf\xc9?\xf5v8\x8e\xa3\xdd\x07\x00\
\x1eI$\x12\xed\xceO=\xe1k \x95Je\xf0\xff\x19\xdd\x8d#\x84\xf8\xcc\xdbY(\x14~\
\x03\xb0\xa0\x9b#\x14\ne\xbb\x97\xd8\x1e\xdf\x1f\x1a\xdb\xb6O\x10i\x7f\x17\
\xd6\x1c\xc7yNJ\xa9\x8b\xb1\xb6\x939\x0b\xe0\xcd\xae\x14v@k`rr\xf2\x06":\xea\
3f\x17\x80\x17\r\xe7\xd9+\xa5L{o\x14\xfa\x81v\t\x8d\x8d\x8d=\x01`\xbc\x9f\
\x13\r\xeah\xa150\x88\xc9\x98\xf9\x98\xfb6\xa1_l1\x10\x8b\xc5\xee`\xe6\x83\
\xfd\x9e\x08\xc0\xaeH$r\xa8\xdfE\xb7\x18\x18\x19\x199\x06\x83{\x1a\x13\x1a\
\x9b\xb9\xafl\xd9\xc4\xcc|\xc4\xe7\xeb\xf3\'\x80\x8f\x82\x14e\xe6\xfdD\xf4\
\xb0\xb7\x9f\x88\x0e\xc5b\xb1\x9b\x8a\xc5\xe2\xbf\xc6J}h1\x90H$n\'\xa2}>\xb9\
\x1f+\xa5^\nRTJ\xf98\xae]\xbdx\xd9aY\xd6A\x00\xe7\xccd\xfa\xd3\xb2\x84\x88(\
\r\xc0\xef\x0c\x7f>h\xd1J\xa5\xf2\x1d\x80\x7ft1f~(\xb0\xba\x00x\xf7\xc0m>y\
\xbf*\xa5~\x0cZ\xb4\\.o\xb8\x0f{n\x88\xe8\xce\xa0u\x82\xd0\xb2\x84\x88\xa8\
\xa8Kb\xe6\xb7\x008&\x85\x89\xe8=\x00[\x0e\x83\xba\xbbP)\xe5H\xbd^\x1f\x05\
\x00\xc7q\xc6\x85hy\xae\xe3\xd1ht\xbc\x11\xbbZ*\x95Z\xdelK\xa6R\xea\'f>\r`\
\xc3%\xe4\x93\x89\x89\x89wL\xc47j]\x02p\x1a\xae\xff\x04f>W\xab\xd5Z\xeeO\xa5\
\x94\xfb\x00,[\x96\xb5jY\xd6\xaa\x10\xe2\x82\xa7\xd4\xdd\xcdX$\x12\xa9J)\xdf\
v\x07\xb5\x9f\x1b)\xe5\x18\x11\xed!\xa2\x95\\.\xf7\xbb\xa9x7\x99Lfg\xadV\xdb\
#\x84\xf8C)\xf5\x977\x9eL&\xbf%\xa2GMj\n!\x1e\xc8\xe5r%\xc0\xe7,\xa4\x94\xaa\
\x00(t\xa5\xd8\xc3\xfc\xfc\xfc*\x80\xd56b\xaa\xcc\xda3\xa0\x1f\x0c\xa0\xdalt\
u\xbd\xdeO\x84\x10/\xd8\xb6=\n@\xa2\xf3/n\x85\x88^\xefuU\x0c\x192dH\xff\xf8\
\x0f\xb7\xe6I\r\x8d&\xf6#\x00\x00\x00\x00IEND\xaeB`\x82\xd4M$\xd4'
