#include <X11/cursorfont.h>

#include "phluid.h"
#include "debug.h"

void
init_x(void)
{
  char *fg_str = "white";
  char *bg_str = "slategrey";
  char *bd_str = "black";
	XGCValues gv;

  disp = XOpenDisplay(NULL);

  if (disp == NULL) {
    fprintf(stderr, 
            "phluid: Cannot connect to X display %s\n",
            XDisplayName(NULL));
    exit(-1);
  }

  root = DefaultRootWindow(disp);
  screen = DefaultScreen(disp);
  vis = DefaultVisual(disp, screen);
  depth = DefaultDepth(disp, screen);
  cm = DefaultColormap(disp, screen);
  move_curs = XCreateFontCursor(disp, XC_fleur);
  resize_curs = XCreateFontCursor(disp, XC_plus);
  pointer_curs = XCreateFontCursor(disp, XC_left_ptr);

  XDefineCursor(disp, root, pointer_curs);

  XAllocNamedColor(disp, cm, fg_str, &fg, &dummyc);
  XAllocNamedColor(disp, cm, bg_str, &bg, &dummyc);
  XAllocNamedColor(disp, cm, bd_str, &bd, &dummyc);

	gv.foreground = bd.pixel;
	gv.line_width = 1;
	gv.function = GXinvert;
	gv.subwindow_mode = IncludeInferiors;
	invert_gc = XCreateGC(disp, root, GCFunction|GCSubwindowMode|GCLineWidth, &gv);

  XSelectInput(disp, root,
               SubstructureRedirectMask | SubstructureNotifyMask |
               ButtonPressMask | PointerMotionMask);
}

void
init_imlib(void)
{
  bg_image = imlib_load_image("/home/matt/gradient.jpg");
  bg_image =
      imlib_load_image(PACKAGE_DATA_DIR "/themes/default/images/gradient.jpg");

  /* imlib settings */
  imlib_set_cache_size(2048 * 1024);
  imlib_set_color_usage(128);
  imlib_context_set_dither(1);
  imlib_context_set_blend(1);
  imlib_context_set_display(disp);
  imlib_context_set_visual(vis);
  imlib_context_set_colormap(cm);
}

Window
x_get_top_window(void)
{
  Window dummy, *children, top;
  unsigned int n;
  XQueryTree(disp, root, &dummy, &dummy, &children, &n);
  top = children[n - 1];
  XFree(children);
  return top;
}

int
handle_xerror(Display * disp, XErrorEvent * e)
{
  if (e->error_code == BadWindow) {
    /* Probably got an unmap event and called delete_client, but
       the window got destroyed before we could do anything about it.
       Just ignore this case.  I'll print out a debug message anyway. */
    DEBUG_PRINT("*** got a BadWindow error in remove_client().  ");
    DEBUG_PRINT("probably safe to ignore ***\n");
  }
  return 0;
}
