<?php

/*
	Phoronix Test Suite
	URLs: http://www.phoronix.com, http://www.phoronix-test-suite.com/
	Copyright (C) 2008 - 2011, Phoronix Media
	Copyright (C) 2008 - 2011, Michael Larabel

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

class openbenchmarking_login implements pts_option_interface
{
	const doc_section = 'OpenBenchmarking.org';
	const doc_description = 'This option is used for controlling your Phoronix Test Suite client options for OpenBechmarking.org and syncing the client to your account.';

	public static function run($r)
	{
		echo "\nIf you have not already registered for your free OpenBenchmarking.org account, you can do so at http://openbenchmarking.org/\n\nOnce you have registered your account and clicked the link within the verification email, enter your log-in information below.\n\n";
		echo "User-Name: ";
		$username = pts_user_io::read_user_input();
		echo "Password: ";
		$password = pts_user_io::read_user_input();

		$login_payload = array(
			's_u' => $username,
			's_p' => sha1($password),
			's_s' => base64_encode(phodevi::system_software(true)),
			's_h' => base64_encode(phodevi::system_hardware(true))
			);
		$login_state = pts_openbenchmarking::make_openbenchmarking_request('account_login', $login_payload);
		$json = json_decode($login_state, true);

		if(isset($json['openbenchmarking']['response']['error']))
		{
			echo PHP_EOL . PHP_EOL . 'ERROR: ' . $json['openbenchmarking']['response']['error'] . PHP_EOL . PHP_EOL;
			pts_storage_object::remove_in_file(PTS_CORE_STORAGE, 'openbenchmarking');
		}
		else
		{
			$openbenchmarking_payload = array(
				'user_name' => $json['openbenchmarking']['account']['user_name'],
				'communication_id' => $json['openbenchmarking']['account']['communication_id'],
				'sav' => $json['openbenchmarking']['account']['sav'],
				);
			pts_storage_object::set_in_file(PTS_CORE_STORAGE, 'openbenchmarking', $openbenchmarking_payload);
			echo PHP_EOL . PHP_EOL . 'The Account Has Been Setup.' . PHP_EOL . PHP_EOL;
		}
	}
}

?>
