Determine whether defaults elements merge correctly with empty tags


XML for defaults expansion follows:
===def

<photo>

  <roll id="2001-01">
    
    <defaults>
      <frame>
	<scene>
	  <occasion>
	    <date>2001-01-01</date>
	  </occasion>
	  <location>
	    <region>the-region</region>
	    <city>the-city</city>
	  </location>
	</scene>
      </frame>
    </defaults>

    <frame id="01">
      <scene>
	<location>
	  <place>the-place</place>
	</location>
      </scene>
    </frame>

    <!-- Element removal from a single frame -->
    <frame id="02">
      <scene>
        <?merge:reject occasion?>
	<location>
          <?merge:reject region?>
	  <place>another-place</place>
	</location>
      </scene>
    </frame>

    <!-- Element removal from ruling defaults -->
    <defaults>
      <frame>
	<scene>
          <?merge:reject occasion?>
	</scene>
      </frame>
    </defaults>

    <frame id="03">
      <scene>
	<location>
	    <city>another-city</city>
	  </location>
      </scene>
    </frame>

  </roll>
</photo>

===def

Expanded reference XML follows:
===ref

<photo>

  <roll id="2001-01">
    

    <frame id="01">
	<scene>
	  <occasion>
	    <date>2001-01-01</date>
	  </occasion>
	  <location>
	    <region>the-region</region>
	    <city>the-city</city>
	    <place>the-place</place>
	  </location>
	</scene>
      </frame>

    <!-- Element removal from a single frame -->
    <frame id="02">
	<scene>
	  <location>
	    <city>the-city</city>
	    <place>another-place</place>
	  </location>
	</scene>
      </frame>

    <!-- Element removal from ruling defaults -->

    <frame id="03">
	<scene>
	  <location>
            <region>the-region</region>
	    <city>another-city</city>
	  </location>
	</scene>
      </frame>

  </roll>
</photo>

===ref
