<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="str"
                version="1.0">

<!-- 
     This file contains templates for upgrading PhotoML files from
     DTD version 0.10 to version 0.11.

     Copyright © 2005 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

<xsl:output method="xml" indent="yes"
	    doctype-public="-//BW//DTD PhotoML 0.11//EN"
            doctype-system="photo.dtd"/>

<!-- Default template -->
<xsl:template match="*|@*|text()|processing-instruction()|comment()">
  <xsl:copy>
    <xsl:apply-templates select="*|@*|text()|processing-instruction()|comment()"/>
  </xsl:copy>
</xsl:template>


<!-- Handle renaming of subregion to segment -->
<xsl:template match="subregion">
  <segment>
    <xsl:apply-templates select="*|@*|text()|processing-instruction()|comment()"/>
  </segment>
</xsl:template>


<!-- Handle location content model change from region* to region? -->
<xsl:template match="region[preceding-sibling::region]">
  <subregion>
    <xsl:apply-templates select="@*"/>
    <xsl:value-of select="."/>
  </subregion>
</xsl:template>


<!-- Handle location content model change from region* to region? -->
<xsl:template match="region[preceding-sibling::region[preceding-sibling::region]]">
  <district>
    <xsl:apply-templates select="@*"/>
    <xsl:value-of select="."/>
  </district>
</xsl:template>


<!-- Handle location content model change from region* to region? -->
<xsl:template match="region[preceding-sibling::region[preceding-sibling::region[preceding-sibling::region]]]">
  <xsl:comment>
    <xsl:text> Upgrade warning: region could not be converted to new content model equivalent </xsl:text>
    <xsl:text> &lt;region</xsl:text>
    <xsl:if test="@type">
      <xsl:text> type="</xsl:text>
      <xsl:value-of select="@type"/>
      <xsl:text>&quot;</xsl:text>
    </xsl:if>
    <xsl:text>&gt;</xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>&lt;/region&gt; </xsl:text>
  </xsl:comment>
  <xsl:message>
    <xsl:text>Warning: manual editing of output required (position commented)
         A region element could not be represented within the new location 
         element content model</xsl:text>
  </xsl:message>
</xsl:template>


<!-- Handle removal of 'select' defaults combine mode -->
<xsl:template match="defaults[@combine='select']">
  <xsl:comment> Upgrade warning: The 'select' combine mode has been removed. Defaults need to be manually edited to obtain the same effect using the 'merge' mode, which is now the default. </xsl:comment>
  <xsl:message>
    <xsl:text>Warning: manual editing of output may be required (position commented)
         New combine attribute default value for defaults element</xsl:text>
  </xsl:message>
  <defaults combine='merge'>
    <xsl:apply-templates/>
  </defaults>
</xsl:template>


<!-- Handle removal of 'select' defaults combine mode -->
<xsl:template match="defaults[not(@combine)][1]">
  <xsl:message>
    <xsl:text>Warning: manual editing of output may be required (position not commented)
         New defaults element combine mode policy (see documentation)</xsl:text>
  </xsl:message>
  <xsl:copy>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>


<!-- Handle switch to more ISO compliant date/time format --> 
<xsl:template match="date[contains(.,' ')]">
  <xsl:variable name="tokens" select="str:tokenize(.,' ')"/>
  <xsl:variable name="d" select="string($tokens[1])"/>
  <xsl:variable name="t" select="string($tokens[2])"/>
  <xsl:variable name="z" select="string($tokens[3])"/>
  <date>
    <xsl:value-of select="concat($d,'T',$t,$z)"/>
  </date>
</xsl:template>


<!-- Handle switch to required id attributes for roll, sheet, and
     digital -->
<xsl:template match="roll[not(@id)] | sheet[not(@id)] | digital[not(@id)]">
  <xsl:comment> Upgrade warning: The id attribute is now required. </xsl:comment>
  <xsl:message>
    <xsl:text>Warning: manual editing of output required (position commented)
         Elements roll, sheet, and digital now require the id attribute</xsl:text>
  </xsl:message>
  <xsl:element name="{name(.)}">
    <xsl:attribute name="id">
      <xsl:value-of select="generate-id(.)"/>
    </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>
</xsl:template>


</xsl:stylesheet>
