#include <iostream>

#include <gtk/gtkmain.h>

#include "effectlist.h"
#include "effects_dialog.h"

#include "ppeffect_desaturate.h"
#include "ppeffect_temperature.h"

#include "../pixbufthumbnail/egg-pixbuf-thumbnail.h"

using namespace std;

int main(int argc,char **argv)
{
	cerr << "Starting..." << endl;
	if(argc==2)
	{
		gtk_init(&argc,&argv);
		PPEffectHeader header;
		GError *err=NULL;
		char *filename=argv[1];
		GdkPixbuf *pb=egg_pixbuf_get_thumbnail_for_file(filename,EGG_PIXBUF_THUMBNAIL_LARGE,&err);
		EffectsDialog(header,NULL,pb);
		g_object_unref(G_OBJECT(pb));
	}
	else
	{
		cerr << "No argument supplied" << endl;
		PPEffectHeader header;
		AvailableEffectSource fxs(header);

		EffectListItem *i1=fxs.GetEffect(0);
		i1->Action();
		EffectListItem *i2=fxs.GetEffect(1);
		i2->Action();

		CurrentEffectSource cxs(header,NULL);
		EffectListItem *i3=cxs.GetEffect(0);
		i3->Remove();
		delete i3;

		delete i1;
		delete i2;
	}

	return(0);
}
