<?php

declare(strict_types=1);

namespace Doctrine\Tests\Common\DataFixtures\TestEntity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use function md5;

/** @ORM\Entity */
#[ORM\Entity]
class User
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     */
    #[ORM\Column]
    #[ORM\Id]
    private ?int $id = null;

    /**
     * @ORM\Column(length=32)
     * @ORM\Id
     */
    #[ORM\Column(length: 32)]
    #[ORM\Id]
    private ?string $code = null;

    /** @ORM\Column(length=32) */
    #[ORM\Column(length: 32)]
    private ?string $password = null;

    /** @ORM\Column(length=255) */
    #[ORM\Column(length: 255)]
    private ?string $email = null;

    /** @ORM\ManyToOne(targetEntity=Role::class, cascade={"persist"}) */
    #[ORM\ManyToOne(cascade: ['persist'])]
    private ?Role $role = null;

    /**
     * @ORM\ManyToMany(targetEntity=User::class, inversedBy="authors")
     * @ORM\JoinTable(name="author_reader", schema="readers",
     *      joinColumns={@ORM\JoinColumn(name="author_id", referencedColumnName="id")},
     *      inverseJoinColumns={@ORM\JoinColumn(name="reader_id", referencedColumnName="id")}
     * )
     *
     * @var Collection<int, User>
     */
    #[ORM\ManyToMany(targetEntity: self::class, inversedBy: 'authors')]
    #[ORM\JoinTable(name: 'author_reader', schema: 'readers')]
    #[ORM\JoinColumn(name: 'author_id', referencedColumnName: 'id')]
    #[ORM\InverseJoinColumn(name: 'reader_id', referencedColumnName: 'id')]
    private Collection $readers;

    /**
     * @ORM\ManyToMany(targetEntity=User::class, mappedBy="readers")
     *
     * @var Collection<int, User>
     */
    #[ORM\ManyToMany(targetEntity: self::class, mappedBy: 'readers')]
    private Collection $authors;

    public function __construct()
    {
        $this->readers = new ArrayCollection();
        $this->authors = new ArrayCollection();
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setCode(string $code): void
    {
        $this->code = $code;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setPassword(string $password): void
    {
        $this->password = md5($password);
    }

    public function getPassword(): ?string
    {
        return $this->password;
    }

    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setRole(Role $role): void
    {
        $this->role = $role;
    }

    public function getRole(): ?Role
    {
        return $this->role;
    }

    /** @return Collection<int, User> */
    public function getReaders(): Collection
    {
        return $this->readers;
    }

    /**
     * @param Collection<int, User> $readers
     *
     * @return $this
     */
    public function setReaders(Collection $readers): self
    {
        $this->readers = $readers;

        return $this;
    }

    /** @return Collection<int, User> */
    public function getAuthors(): Collection
    {
        return $this->authors;
    }

    /**
     * @param Collection<int, User> $authors
     *
     * @return $this
     */
    public function setAuthors(Collection $authors): self
    {
        $this->authors = $authors;

        return $this;
    }
}
