<?php

/**
* Provides variables and methods for handling color
*
* The variables and methods in this class provide a way to get and set the
* color to be used by any text or drawing functions.
*
* @version 0.3
* @author  Matt McClanahan <cardinal@dodds.net>
* @package Imlib
* @access public
*/
class ImlibColor
{
   /**
   * The array defining the color (r,g,b,a)
   *
   * @var array $color
   * @access private
   */
   var $color;

   /**
   * ImlibColor constructor
   *
   * @access public
   */
   function ImlibColor()
   {
      $this->color = 0;
   }

   /**
   * Get the four color components as by-reference variables
   *
   * @param int &$r Red
   * @param int &$g Blue
   * @param int &$b Green
   * @param int &$a Alpha
   * @return mixed False if a color isn't set, the color array otherwise
   * @access public
   */
   function get_color(&$r,&$g,&$b,&$a)
   {
      if ($this->color)
         list($r,$g,$b,$a) = $this->color;
      else
         return false;

      return $this->color;
   }

   /**
   * Get the color array currently defined, if it is defined
   *
   * @return mixed False if a color isn't set, the color array otherwise
   * @access public
   */
   function get_color_array()
   {
      if (!$this->color)
         return false;

      return $this->color;
   }

   /**
   * Set the current color using the four components
   *
   * @param int Red
   * @param int Blue
   * @param int Green
   * @param int Alpha
   * @access public
   */
   function set_color($r,$g,$b,$a)
   {
      $this->color = Array($r,$g,$b,$a);
   }

   /**
   * Set the current color using an array of 4 elements (r,g,b,a)
   *
   * @param array Color array
   * @access public
   */
   function set_color_array($arr)
   {
      $this->color = $arr;
   }
};

?>
