<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See ../AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.6 $
 *
 *  ABOUT
 *  -----
 *
 *  A class for authenticating against the Kolab server.
 *
 */

/** The Kolab object db */
require_once('Kolab/Webadmin/db.php');

/**
 * This class provides authentication utilities for the Kolab server.
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/auth.class.php,v 1.6 2007/08/22 17:33:23 gunnar Exp $
 *
 * @author  Steffen Hansen <steffen@klaralvdalens-datakonsult.se>
 * @author  Gunnar Wrobel  <wrobel@pardus.de>
 * @package Kolab_Webadmin
 */
class KolabAuth {

    /**
     * The connection to the Kolab LDAP server
     *
     * @var KolabLDAP
     */
    var $_ldap;

    /**
     * The connection into the Kolab object db
     *
     * @var KolabObjectDb
     */
    var $_db;

    /**
     * The current user object
     *
     * @var KolabObject
     */
    var $_current_user = false;

    function KolabAuth($ldap) {
        $this->_ldap = $ldap;
        $this->_db =& new KolabObjectDb($ldap);
        if( isset($_GET['logout']) || isset($_POST['logout']) ) {
            $this->logout();
        }
    }

    function authenticate() {
        $auth = $this->isAuthenticated();
        if (is_a($auth, 'PEAR_Error')) {
            return $auth;
        }

        $bind_result = false;
        if ($auth) {
            $bind_result = $this->_ldap->bind($_SESSION['auth_dn'], 
                                              $_SESSION['auth_pw']);
            if (!$bind_result || is_a($bind_result, 'PEAR_Error')) {
                unset($_SESSION['auth_dn']);
                unset($_SESSION['auth_pw']);
                $this->_current_user = false;
            } else {
                $dn = $_SESSION['auth_dn'];
            }
        }
            
        if (!$bind_result) {
            // Anon. bind first
            if (!$this->_ldap->bind()) {
                return PEAR::raiseError(sprintf(_("Could not bind to LDAP server: %s"), 
                                                $this->_ldap->error()));
            }

            // Check if we got user and pass
            if (!isset($_POST['username']) || !isset($_POST['password'])) {
                return false;
            }

            $dn = $this->_db->dnForUidOrMail($_POST['username']);
            if (is_a($dn, 'PEAR_Error')) {
                return $dn;
            }
            if (!$dn) {
                return PEAR::raiseError(_('Incorrect username or password'));
            }

            $bind_result = $this->_ldap->bind($dn, $_POST['password']);
            if (is_a($bind_result, 'PEAR_Error')) {
                return $bind_result;
            }
            if (!$bind_result) {
                return PEAR::raiseError(_('Incorrect username or password.'));
            }
            $_SESSION['auth_dn'] = $dn;
            $_SESSION['auth_pw'] = $_POST['password'];
            $_SESSION['remote_ip'] = $_SERVER['REMOTE_ADDR'];
        }
        
        $user = $this->_db->fetch($dn);
        if (is_a($user, 'PEAR_Error')) {
            return $user;
        }

        if (!$user->login_allowed) {
            return PEAR::raiseError(_('User may not log in!'));
        }
        $this->_current_user = $user;

        return $user;
    }
  
    function logout() {
        session_unset();
        session_destroy();
        $this->error_string = false;
    }

    function isAuthenticated() {
        if (!isset($_SESSION['auth_dn'])) {
            return false;
        }
        if ($_SESSION['remote_ip'] != $_SERVER['REMOTE_ADDR']) {
            unset($_SESSION['auth_dn']);
            unset($_SESSION['auth_pw']);
            $this->_current_user = false;
            return PEAR::raiseError(_('Your IP seems to have changed. Please log in again!'));
        }
        return true;
    }

    function getCurrentUser() {
        return $this->_current_user;
    }

};
/*
  Local variables:
  mode: php
  indent-tabs-mode: f
  tab-width: 4
  buffer-file-coding-system: utf-8
  End:
 */
?>
