<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See ../AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.5 $
 *
 *  ABOUT
 *  -----
 *
 *  Generate the webadmin menu
 *
 */

/** Provides handling for the Kolab objects. */
require_once 'Kolab/Webadmin/db.php';

function generate_menu($user, $topdir)
{
    $menuitems = array();

    if(in_array($user->group(), array(KOLAB_OBJECT_ADMINISTRATOR,
                                      KOLAB_OBJECT_MAINTAINER,
                                      KOLAB_OBJECT_DOMAINMAINTAINER))) {
        $menuitems[KOLAB_OBJECT_USER] = array( 
            'name'    => _('Users'),
            'url'     => $topdir . '/list.php?type=' . KOLAB_OBJECT_USER,
            'title'   => _('Manage Email Users'),
            'submenu' => array( 
                array( 
                    'name' => _('Create New User'),
                    'url'  => 'user.php?action=create' 
                )
            )
        );
        $menuitems[KOLAB_OBJECT_SHAREDFOLDER] = array( 
            'name'    => _('Shared Folder'),
            'url'     => $topdir . '/list.php?type=' . KOLAB_OBJECT_SHAREDFOLDER,
            'title'   => _('Manage Shared Folders'),
            'submenu' => array( 
                array( 
                    'name' => _('Add Shared Folder'),
                    'url'  => 'sf.php?action=create' 
                )
            )
        );  
        $menuitems[KOLAB_OBJECT_GROUP] = array( 
            'name'    => _('Distribution Lists'),
            'url'     => $topdir . '/list.php?type=' . KOLAB_OBJECT_GROUP,
            'title'   => _('Manage Distribution Lists'),
            'submenu' => array(
                array( 
                    'name' => _('Create New List'),
                    'url'  => 'list.php?action=create' 
                ) 
            ) 
        );
    } else {
        $menuitems[KOLAB_OBJECT_USER] = array( 
            'name'    => _('My User Settings'),
            'url'     => $topdir . '/user/user.php?action=modify',
            'title'   => _('My User Settings'),
            'submenu' => array(
                array( 
                    'name' => _('Mail Delivery'),
                    'url'  => 'deliver.php'),
                array( 
                    'name' => _('Forward Email'),
                    'url'  => 'forward.php' ),
                array( 
                    'name' => _('Vacation'),
                    'url'  => 'vacation.php' 
                )
            )
        );
    }
    if(in_array($user->group(), array(KOLAB_OBJECT_ADMINISTRATOR,
                                      KOLAB_OBJECT_MAINTAINER))) {
        $menuitems[KOLAB_OBJECT_ADDRESS] = array( 
            'name'    => _('Addressbook'),
            'url'     => $topdir . '/list.php?type=' . KOLAB_OBJECT_ADDRESS,
            'title'   => _('Manage Address Book'),
            'submenu' => array( 
                array( 
                    'name' => _('Create New vCard'),
                    'url'  => 'addr.php?action=create' 
                )
            )
        );
    }

    if(in_array($user->group(), array(KOLAB_OBJECT_ADMINISTRATOR))) {
        $menuitems[KOLAB_OBJECT_ADMINISTRATOR] = array( 
            'name'    => _('Administrators'),
            'url'     => $topdir . '/list.php?type=' . KOLAB_OBJECT_ADMINISTRATOR,
            'title'   => _('Manage Administrators'),
            'submenu' => array(
                array( 
                    'name' => _('Create New Administrator'),
                    'url'   => 'admin.php?action=create' 
                ) 
            ) 
        );
        $menuitems[KOLAB_OBJECT_DOMAINMAINTAINER] = array( 
            'name'    => _('Domain Maintainers'),
            'url'     => $topdir . '/list.php?type=' . KOLAB_OBJECT_DOMAINMAINTAINER,
            'title'   => _('Manage Domain Maintainers'),
            'submenu' => array(
                array( 
                    'name' => _('Create New Domain Maintainer'),
                    'url'  => 'domainmaintainer.php?action=create' 
                ) 
            ) 
        );
        $menuitems[KOLAB_OBJECT_MAINTAINER] = array( 
            'name'    => _('Maintainers'),
            'url'     => $topdir . '/list.php?type=' . KOLAB_OBJECT_MAINTAINER,
            'title'   => _('Manage Maintainers'),
            'submenu' => array(
                array( 
                    'name' => _('Create New Maintainer'),
                    'url'   => 'maintainer.php?action=create' 
                ) 
            ) 
        );
        $menuitems['service'] = array( 
            'name'  => _('Services'),
            'url'   => $topdir.'/service/',
            'title' => _('Manage Services') 
        );
    } else if (in_array($user->group(), array(KOLAB_OBJECT_MAINTAINER))) {
        $mdn = $user->getDn();
        $menuitems[KOLAB_OBJECT_MAINTAINER] = array( 
            'name'  => _('Maintainers'),
            'url'   => $topdir . '/maintainer/maintainer.php?action=modify&dn=' . urlencode($mdn),
            'title' => _('Manage Maintainer') );  
        $menuitems[KOLAB_OBJECT_DOMAINMAINTAINER] = array( 
            'name'    => _('Domain Maintainers'),
            'url'     => $topdir . '/list.php?type=' . KOLAB_OBJECT_DOMAINMAINTAINER,
            'title'   => _('Manage Domain Maintainers'),
            'submenu' => array(
                array( 
                    'name' => _('Create New Domain Maintainer'),
                    'url'  => 'domainmaintainer.php?action=create' 
                ) 
            ) 
        );
    } else if(in_array($user->group(), array(KOLAB_OBJECT_DOMAINMAINTAINER))) {
        $mdn = $auth->dn();
        $menuitems[KOLAB_OBJECT_DOMAINMAINTAINER] = array( 
            'name'  => _('Domain Maintainers'),
            'url'   => $topdir . '/domainmaintainer/domainmaintainer.php?action=modify&dn=' . urlencode($mdn),
            'title' => _('Manage Domain Maintainer') );  
    }

    $menuitems['about'] = array( 
        'name' => _('About Kolab'),
        'url'  => $topdir.'/kolab/',
        'title' => _('About Kolab'),
        'submenu' => array( 
            array( 'name' => _('Erfrakon'),
                   'url'  => 'erfrakon.php' ),
            array( 'name' => _('Intevation'),
                   'url'  => 'intevation.php' ),
            array( 'name' => _('Klar&auml;lvdalens Datakonsult'),
                   'url'  => 'kdab.php' ),
            array( 'name' => _('Code Fusion'),
                   'url'  => 'codefusion.php' ),
            array( 'name' => _('KDE'),
                   'url'  => 'kde.php' )
        )
    );
    if(in_array($user->group(), array(KOLAB_OBJECT_ADMINISTRATOR,
                                      KOLAB_OBJECT_MAINTAINER,
                                      KOLAB_OBJECT_DOMAINMAINTAINER))) {
        $menuitems['about']['submenu'][] = array( 
            'name' => _('<b>Versions</b>'),
            'url'  => 'versions.php' 
        );
    }
    return $menuitems;
}

/*
  Local variables:
  mode: php
  indent-tabs-mode: f
  tab-width: 4
  buffer-file-coding-system: utf-8
  End:
  vim:encoding=utf-8:
 */
?>
