<?php
	/**************************************************************************\
	* phpGroupWare - Setup                                                     *
	* http://www.phpgroupware.org                                              *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	// $Id: tables_update.inc.php,v 1.53.2.9.2.41 2005/08/26 01:40:22 skwashd Exp $
	// $Source: /cvsroot/phpgwapi/phpgwapi/setup/tables_update.inc.php,v $

	/* Include older phpGroupWare update support */
	//include('tables_update_0_9_9.inc.php');
	//include('tables_update_0_9_10.inc.php');
	//include('tables_update_0_9_12.inc.php');

	/* This is since the last release */
	$test[] = '0.9.12';
	function phpgwapi_upgrade0_9_12()
	{
		//global $setup_info,$phpgw_setup;
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.001';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.001';
	function phpgwapi_upgrade0_9_13_001()
	{
		//global $setup_info,$phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->AlterColumn('phpgw_categories','cat_access', array('type' => 'varchar', 'precision' => 7));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.002';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.002';
	function phpgwapi_upgrade0_9_13_002()
	{
		//global $setup_info,$phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_accounts','account_file_space', array ('type' => 'varchar', 'precision' => 25));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.003';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.003';
	function phpgwapi_upgrade0_9_13_003()
	{
		//global $setup_info,$phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->AlterColumn('phpgw_access_log','sessionid',array('type' => 'char', 'precision' => 32));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.004';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	class phpgw
	{
		var $common;
		var $accounts;
		var $applications;
		var $db;
	}
	$test[] = '0.9.13.004';
	function phpgwapi_upgrade0_9_13_004()
	{
		//global $setup_info, $phpgw_setup, $phpgw_info, $phpgw;

		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_access_log','account_id',array('type' => 'int', 'precision' => 4, 'default' => 0, 'nullable' => False));

		$phpgw = new phpgw;
		$phpgw->common = CreateObject('phpgwapi.common');

		$GLOBALS['phpgw_setup']->db->query("SELECT config_name,config_value FROM phpgw_config WHERE config_name LIKE 'ldap%' OR config_name='account_repository'",__LINE__,__FILE__);
		while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$config[$GLOBALS['phpgw_setup']->oProc->f('config_name')] = $GLOBALS['phpgw_setup']->oProc->f('config_value');
		}
		$phpgw_info['server']['ldap_host']          = $config['ldap_host'];
		$phpgw_info['server']['ldap_context']       = $config['ldap_context'];
		$phpgw_info['server']['ldap_group_context'] = $config['ldap_group_context'];
		$phpgw_info['server']['ldap_root_dn']       = $config['ldap_root_dn'];
		$phpgw_info['server']['ldap_root_pw']       = $config['ldap_root_pw'];
		$phpgw_info['server']['account_repository'] = $config['account_repository'];

		$accounts = CreateObject('phpgwapi.accounts');
		$accounts->db = $GLOBALS['phpgw_setup']->db;

		$GLOBALS['phpgw_setup']->db->query("select * from phpgw_access_log");
		while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$lid         = explode('@',$GLOBALS['phpgw_setup']->oProc->f('loginid'));
			$account_lid = $lid[0];
			$account_id = $accounts->name2id($account_lid);

			$GLOBALS['phpgw_setup']->db->query("update phpgw_access_log set account_id='" . $account_id
				. "' where sessionid='" . $GLOBALS['phpgw_setup']->oProc->f('sessionid') . "'");
		}

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.005';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.005';
	function phpgwapi_upgrade0_9_13_005()
	{
		//global $setup_info, $phpgw_setup;

		$newtbldef = array(
			'fd' => array(
				'account_id' => array('type' => 'auto', 'nullable' => false),
				'account_lid' => array('type' => 'varchar', 'precision' => 25, 'nullable' => false),
				'account_pwd' => array('type' => 'varchar', 'precision' => 32, 'nullable' => false),
				'account_firstname' => array('type' => 'varchar', 'precision' => 50),
				'account_lastname' => array('type' => 'varchar', 'precision' => 50),
				'account_permissions' => array('type' => 'text', 'nullable' => true),
				'account_groups' => array('type' => 'varchar', 'precision' => 30, 'nullable' => true),
				'account_lastlogin' => array('type' => 'int', 'precision' => 4, 'nullable' => true),
				'account_lastloginfrom' => array('type' => 'varchar', 'precision' => 255, 'nullable' => true),
				'account_lastpwd_change' => array('type' => 'int', 'precision' => 4, 'nullable' => true),
				'account_status' => array('type' => 'char', 'precision' => 1, 'nullable' => false, 'default' => 'A'),
				'account_expires' => array('type' => 'int', 'precision' => 4),
				'account_type' => array('type' => 'char', 'precision' => 1, 'nullable' => true)
			),
			'pk' => array('account_id'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array('account_lid')
		);

		$GLOBALS['phpgw_setup']->oProc->DropColumn('phpgw_accounts',$newtbldef,'account_file_space');

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.006';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.006';
	function phpgwapi_upgrade0_9_13_006()
	{
		//global $setup_info, $phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->CreateTable(
			'phpgw_log', array(
				'fd' => array(
					'log_id' 	=> array('type' => 'auto',      'precision' => 4,  'nullable' => False),
					'log_date' 	=> array('type' => 'timestamp', 'nullable' => False),
					'log_user' 	=> array('type' => 'int',       'precision' => 4,  'nullable' => False),
					'log_app' 	=> array('type' => 'varchar',   'precision' => 50, 'nullable' => False),
					'log_severity' 	=> array('type' => 'char',  'precision' => 1,  'nullable' => False)
				),
				'pk' => array('log_id'),
				'fk' => array(),
				'ix' => array(),
				'uc' => array()
			)
		);

		$GLOBALS['phpgw_setup']->oProc->CreateTable(
			'phpgw_log_msg', array(
				'fd' => array(
					'log_msg_log_id' 	=> array('type' => 'auto',      'precision' => 4,  'nullable' => False),
					'log_msg_seq_no'	=> array('type' => 'int',       'precision' => 4,  'nullable' => False),
					'log_msg_date'		=> array('type' => 'timestamp',	'nullable' => False),
					'log_msg_tx_fid'	=> array('type' => 'varchar',   'precision' => 4,  'nullable' => True),
					'log_msg_tx_id'		=> array('type' => 'varchar',   'precision' => 4,  'nullable' => True),
					'log_msg_severity'	=> array('type' => 'char',      'precision' => 1,  'nullable' => False),
					'log_msg_code' 		=> array('type' => 'varchar',   'precision' => 30, 'nullable' => False),
					'log_msg_msg' 		=> array('type' => 'text', 'nullable' => False),
					'log_msg_parms'		=> array('type' => 'text', 'nullable' => False)
			 	),
				'pk' => array('log_msg_log_id', 'log_msg_seq_no'),
				'fk' => array(),
				'ix' => array(),
				'uc' => array()
			)
		);

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.007';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.007';
	function phpgwapi_upgrade0_9_13_007()
	{
		//global $setup_info, $phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->AlterColumn('phpgw_log_msg','log_msg_log_id',array('type' => 'int', 'precision' => 4, 'nullable'=> False));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.008';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.008';
	function phpgwapi_upgrade0_9_13_008()
	{
		//global $setup_info, $phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_log_msg','log_msg_file',array('type' => 'varchar', 'precision' => 255, 'nullable'=> False));
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_log_msg','log_msg_line',array('type' => 'int', 'precision' => 4, 'nullable'=> False));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.009';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.009';
	function phpgwapi_upgrade0_9_13_009()
	{
		//global $setup_info, $phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->CreateTable(
			'phpgw_interserv', array(
				'fd' => array(
					'server_id'   => array('type' => 'auto', 'nullable' => False),
					'server_name' => array('type' => 'varchar', 'precision' => 64,  'nullable' => True),
					'server_host' => array('type' => 'varchar', 'precision' => 255, 'nullable' => True),
					'server_url'  => array('type' => 'varchar', 'precision' => 255, 'nullable' => True),
					'trust_level' => array('type' => 'int',     'precision' => 4),
					'trust_rel'   => array('type' => 'int',     'precision' => 4),
					'username'    => array('type' => 'varchar', 'precision' => 64,  'nullable' => True),
					'password'    => array('type' => 'varchar', 'precision' => 255, 'nullable' => True),
					'admin_name'  => array('type' => 'varchar', 'precision' => 255, 'nullable' => True),
					'admin_email' => array('type' => 'varchar', 'precision' => 255, 'nullable' => True),
					'server_mode' => array('type' => 'varchar', 'precision' => 16,  'nullable' => False, 'default' => 'xmlrpc'),
					'server_security' => array('type' => 'varchar', 'precision' => 16,'nullable' => True)
				),
				'pk' => array('server_id'),
				'fk' => array(),
				'ix' => array(),
				'uc' => array()
			)
		);

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.010';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.010';
	function phpgwapi_upgrade0_9_13_010()
	{
		//global $setup_info, $phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->AlterColumn('phpgw_sessions','session_lid',array('type' => 'varchar', 'precision' => 255, 'nullable'=> False));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.011';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.011';
	function phpgwapi_upgrade0_9_13_011()
	{
		//global $setup_info, $phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->CreateTable(
			'phpgw_vfs', array(
				'fd' => array(
					'file_id' => array('type' => 'auto','nullable' => False),
					'owner_id' => array('type' => 'int', 'precision' => 4,'nullable' => False),
					'createdby_id' => array('type' => 'int', 'precision' => 4,'nullable' => True),
					'modifiedby_id' => array('type' => 'int', 'precision' => 4,'nullable' => True),
					'created' => array('type' => 'date','nullable' => False,'default' => '1970-01-01'),
					'modified' => array('type' => 'date','nullable' => True),
					'size' => array('type' => 'int', 'precision' => 4,'nullable' => True),
					'mime_type' => array('type' => 'varchar', 'precision' => 150,'nullable' => True),
					'deleteable' => array('type' => 'char', 'precision' => 1,'nullable' => True,'default' => 'Y'),
					'comment' => array('type' => 'text','nullable' => True),
					'app' => array('type' => 'varchar', 'precision' => 25,'nullable' => True),
					'directory' => array('type' => 'text','nullable' => True),
					'name' => array('type' => 'text','nullable' => False),
					'link_directory' => array('type' => 'text','nullable' => True),
					'link_name' => array('type' => 'text','nullable' => True),
					'version' => array('type' => 'varchar', 'precision' => 30,'nullable' => False,'default' => '0.0.0.0')
				),
				'pk' => array('file_id'),
				'fk' => array(),
				'ix' => array(),
				'uc' => array()
			)
		);
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.012';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.012';
	function phpgwapi_upgrade0_9_13_012()
	{
		//global $setup_info, $phpgw_setup;

		$GLOBALS['phpgw_setup']->oProc->AlterColumn('phpgw_applications', 'app_tables', array('type' => 'text'));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.013';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.013';
	function phpgwapi_upgrade0_9_13_013()
	{
		$GLOBALS['phpgw_setup']->oProc->CreateTable(
			'phpgw_history_log', array(
				'fd' => array(
					'history_id'        => array('type' => 'auto',      'precision' => 4,  'nullable' => False),
					'history_record_id' => array('type' => 'int',       'precision' => 4,  'nullable' => False),
					'history_appname'   => array('type' => 'varchar',   'precision' => 64, 'nullable' => False),
					'history_owner'     => array('type' => 'int',       'precision' => 4,  'nullable' => False),
					'history_status'    => array('type' => 'char',      'precision' => 2,  'nullable' => False),
					'history_new_value' => array('type' => 'text',      'nullable' => False),
					'history_timestamp' => array('type' => 'timestamp', 'nullable' => False, 'default' => 'current_timestamp')

				),
				'pk' => array('history_id'),
				'fk' => array(),
				'ix' => array(),
				'uc' => array()
			)
		);

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.014';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.014';
	function phpgwapi_upgrade0_9_13_014()
	{
		$GLOBALS['phpgw_setup']->db->query("UPDATE phpgw_applications SET app_order=100 WHERE app_order IS NULL");
		$GLOBALS['phpgw_setup']->db->query("SELECT * FROM phpgw_applications");
		while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$app_name[]	= $GLOBALS['phpgw_setup']->oProc->f('app_name');
			$app_title[]	= $GLOBALS['phpgw_setup']->oProc->f('app_title');
			$app_enabled[]	= $GLOBALS['phpgw_setup']->oProc->f('app_enabled');
			$app_order[]	= $GLOBALS['phpgw_setup']->oProc->f('app_order');
			$app_tables[]	= $GLOBALS['phpgw_setup']->oProc->f('app_tables');
			$app_version[]	= $GLOBALS['phpgw_setup']->oProc->f('app_version');
		}

		$GLOBALS['phpgw_setup']->oProc->DropTable('phpgw_applications');

		$GLOBALS['phpgw_setup']->oProc->CreateTable(
			'phpgw_applications', array(
				'fd' => array(
					'app_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => false),
					'app_name' => array('type' => 'varchar', 'precision' => 25, 'nullable' => false),
					'app_title' => array('type' => 'varchar', 'precision' => 50),
					'app_enabled' => array('type' => 'int', 'precision' => 4),
					'app_order' => array('type' => 'int', 'precision' => 4),
					'app_tables' => array('type' => 'varchar', 'precision' => 255),
					'app_version' => array('type' => 'varchar', 'precision' => 20, 'nullable' => false, 'default' => '0.0')
				),
				'pk' => array('app_id'),
				'fk' => array(),
				'ix' => array(),
				'uc' => array('app_name')
			)
		);

		$rec_count = count($app_name);
		for($rec_loop=0;$rec_loop<$rec_count;$rec_loop++)
		{
			$GLOBALS['phpgw_setup']->db->query('INSERT INTO phpgw_applications(app_id,app_name,app_title,app_enabled,app_order,app_tables,app_version) '
				. 'VALUES('.($rec_loop + 1).",'".$app_name[$rec_loop]."','".$app_title[$rec_loop]."',".$app_enabled[$rec_loop].','.$app_order[$rec_loop].",'".$app_tables[$rec_loop]."','".$app_version[$rec_loop]."')");
		}

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.015';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.015';
	function phpgwapi_upgrade0_9_13_015()
	{
		/* Skip this for mysql 3.22.X in php4 at least */
		if(phpversion() >= '4.0.5' && @$GLOBALS['phpgw_setup']->db->Type == 'mysql')
		{
			$_ver_str = @mysql_get_server_info();
			$_ver_arr = explode(".",$_ver_str);
			$_ver = $_ver_arr[1];
			if(intval($_ver) < 23)
			{
				$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.016';
				return $GLOBALS['setup_info']['phpgwapi']['currentver'];
			}
		}

		$GLOBALS['phpgw_setup']->oProc->AlterColumn(
			'lang',
			'message_id',
			array(
				'type' => 'varchar',
				'precision' => 255,
				'nullable' => false,
				'default' => ''
			)
		);

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.016';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.016';
	function phpgwapi_upgrade0_9_13_016()
	{
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('admin','acl_manager','hook_acl_manager.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('admin','add_def_pref','hook_add_def_pref.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('admin','after_navbar','hook_after_navbar.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('admin','deleteaccount','hook_deleteaccount.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('admin','config','hook_config.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('admin','manual','hook_manual.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('admin','view_user','hook_view_user.inc.php')");

		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('preferences','admin_deleteaccount','hook_admin_deleteaccount.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('preferences','config','hook_config.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('preferences','manual','hook_manual.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('preferences','preferences','hook_preferences.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('preferences','settings','hook_settings.inc.php')");

		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('addressbook','about','hook_about.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('addressbook','add_def_pref','hook_add_def_pref.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('addressbook','config_validate','hook_config_validate.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('addressbook','deleteaccount','hook_deleteaccount.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('addressbook','home','hook_home.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('addressbook','manual','hook_manual.inc.php')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_hooks (hook_appname,hook_location,hook_filename) VALUES ('addressbook','notifywindow','hook_notifywindow.inc.php')");

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.017';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.017';
	function phpgwapi_upgrade0_9_13_017()
	{
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_history_log','history_old_value',array('type' => 'text','nullable' => False));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.13.018';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.13.018';
	function phpgwapi_upgrade0_9_13_018()
	{
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.000';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.000';
	function phpgwapi_upgrade0_9_14_000()
	{
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.001';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.001';
	function phpgwapi_upgrade0_9_14_001()
	{
		// Fix bug from update script in 0.9.11.004/5:
		// column config_app was added to table phpgw_config (which places it as last column),
		// but in the tables_current.inc.php it was added as first column.
		// When setup / schemaproc wants to do the AlterColum it recreates the table for pgSql,
		// as pgSql could not change the column-type. This recreation is can not be based on 
		// tables_current, but on running tables_baseline throught all update-scripts.
		// Which gives at the end two different versions of the table on new or updated installs.
		// I fix it now in the (wrong) order of the tables_current, as some apps might depend on!
		
		$confs = array();
		$GLOBALS['phpgw_setup']->db->query("SELECT * FROM phpgw_config");
		while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$confs[] = array(
				'config_app' => $GLOBALS['phpgw_setup']->oProc->f('config_app'),
				'config_name' => $GLOBALS['phpgw_setup']->oProc->f('config_name'),
				'config_value' => $GLOBALS['phpgw_setup']->oProc->f('config_value')
			);
		}
		$GLOBALS['phpgw_setup']->oProc->DropTable('phpgw_config');
		
		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_config',array(
			'fd' => array(
				'config_app' => array('type' => 'varchar', 'precision' => 50),
				'config_name' => array('type' => 'varchar', 'precision' => 255, 'nullable' => false),
				'config_value' => array('type' => 'text')
			),
			'pk' => array(),
			'fk' => array(),
			'ix' => array(),
			'uc' => array('config_name')
		));
		
		foreach($confs as $conf)
		{
			$GLOBALS['phpgw_setup']->db->query(
				"INSERT INTO phpgw_config (config_app,config_name,config_value) VALUES ('".
				$conf['config_app']."','".$conf['config_name']."','".$conf['config_value']."')");
		}
		
		$GLOBALS['phpgw_setup']->db->query("UPDATE languages SET available='Yes' WHERE lang_id='cs'");

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.002';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}
	
	$test[] = '0.9.14.002';
	function phpgwapi_upgrade0_9_14_002()
	{
		// 0.9.14.5xx are the development-versions of the 0.9.16 release (based on the 0.9.14 api)
		// as 0.9.15.xxx are already used in HEAD
		
		// this is the 0.9.15.003 update, needed for the new filemanager and vfs-classes in the api
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_vfs','content', array ('type' => 'text', 'nullable' => True));

		// this is the 0.9.15.004 update, needed for the polish translations
		$GLOBALS['phpgw_setup']->db->query("UPDATE languages set available='Yes' WHERE lang_id='pl'");
		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.500';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.003';
	function phpgwapi_upgrade0_9_14_003()
	{
		// 0.9.14.5xx are the development-versions of the 0.9.16 release (based on the 0.9.14 api)
		// as 0.9.15.xxx are already used in HEAD
		
		// this is the 0.9.15.003 update, needed for the new filemanager and vfs-classes in the api
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_vfs','content', array ('type' => 'text', 'nullable' => True));

		// this is the 0.9.15.004 update, needed for the polish translations
		$GLOBALS['phpgw_setup']->db->query("UPDATE languages set available='Yes' WHERE lang_id='pl'");
		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.500';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.004';
	function phpgwapi_upgrade0_9_14_004()
	{
		// 0.9.14.5xx are the development-versions of the 0.9.16 release (based on the 0.9.14 api)
		// as 0.9.15.xxx are already used in HEAD
		
		// this is the 0.9.15.003 update, needed for the new filemanager and vfs-classes in the api
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_vfs','content', array ('type' => 'text', 'nullable' => True));

		// this is the 0.9.15.004 update, needed for the polish translations
		$GLOBALS['phpgw_setup']->db->query("UPDATE languages set available='Yes' WHERE lang_id='pl'");
		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.500';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.005';
	function phpgwapi_upgrade0_9_14_005()
	{
		// 0.9.14.5xx are the development-versions of the 0.9.16 release (based on the 0.9.14 api)
		// as 0.9.15.xxx are already used in HEAD
		
		// this is the 0.9.15.003 update, needed for the new filemanager and vfs-classes in the api
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_vfs','content', array ('type' => 'text', 'nullable' => True));

		// this is the 0.9.15.004 update, needed for the polish translations
		$GLOBALS['phpgw_setup']->db->query("UPDATE languages set available='Yes' WHERE lang_id='pl'");
		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.500';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.006';
	function phpgwapi_upgrade0_9_14_006()
	{
		// 0.9.14.5xx are the development-versions of the 0.9.16 release (based on the 0.9.14 api)
		// as 0.9.15.xxx are already used in HEAD
		
		// this is the 0.9.15.003 update, needed for the new filemanager and vfs-classes in the api
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_vfs','content', array ('type' => 'text', 'nullable' => True));

		// this is the 0.9.15.004 update, needed for the polish translations
		$GLOBALS['phpgw_setup']->db->query("UPDATE languages set available='Yes' WHERE lang_id='pl'");
		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.500';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.007';
	function phpgwapi_upgrade0_9_14_007()
	{
		// 0.9.14.5xx are the development-versions of the 0.9.16 release (based on the 0.9.14 api)
		// as 0.9.15.xxx are already used in HEAD
		
		// this is the 0.9.15.003 update, needed for the new filemanager and vfs-classes in the api
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_vfs','content', array ('type' => 'text', 'nullable' => True));

		// this is the 0.9.15.004 update, needed for the polish translations
		$GLOBALS['phpgw_setup']->db->query("UPDATE languages set available='Yes' WHERE lang_id='pl'");

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.500';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.500';
	function phpgwapi_upgrade0_9_14_500()
	{
		// this is the 0.9.15.001 update
		$GLOBALS['phpgw_setup']->oProc->RenameTable('lang','phpgw_lang');
		$GLOBALS['phpgw_setup']->oProc->RenameTable('languages','phpgw_languages');

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.501';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.501';
	function phpgwapi_upgrade0_9_14_501()
	{
		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_async',array(
			'fd' => array(
				'id' => array('type' => 'varchar','precision' => '255','nullable' => False),
				'next' => array('type' => 'int','precision' => '4','nullable' => False),
				'times' => array('type' => 'varchar','precision' => '255','nullable' => False),
				'method' => array('type' => 'varchar','precision' => '80','nullable' => False),
				'data' => array('type' => 'text','nullable' => False)
			),
			'pk' => array('id'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->DropColumn('phpgw_applications',array(
			'fd' => array(
				'app_id' => array('type' => 'auto','precision' => '4','nullable' => False),
				'app_name' => array('type' => 'varchar','precision' => '25','nullable' => False),
				'app_enabled' => array('type' => 'int','precision' => '4'),
				'app_order' => array('type' => 'int','precision' => '4'),
				'app_tables' => array('type' => 'text'),
				'app_version' => array('type' => 'varchar','precision' => '20','nullable' => False,'default' => '0.0')
			),
			'pk' => array('app_id'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array('app_name')
		),'app_title');
		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.502';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}


	$test[] = '0.9.14.502';
	function phpgwapi_upgrade0_9_14_502()
	{
		$GLOBALS['phpgw_setup']->oProc->RenameTable('phpgw_preferences','old_preferences');

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_preferences',array(
			'fd' => array(
				'preference_owner' => array('type' => 'int','precision' => '4','nullable' => False),
				'preference_app' => array('type' => 'varchar','precision' => '25','nullable' => False),
				'preference_value' => array('type' => 'text','nullable' => False)
			),
			'pk' => array('preference_owner','preference_app'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array()
		));
		$db2 =& $GLOBALS['phpgw_setup']->db;	// we need a 2. result-set
		$GLOBALS['phpgw_setup']->oProc->query("SELECT * FROM old_preferences");
		while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$owner = intval($GLOBALS['phpgw_setup']->oProc->f('preference_owner'));
			$prefs = unserialize($GLOBALS['phpgw_setup']->oProc->f('preference_value'));
			
			if (is_array($prefs))
			{
				foreach ($prefs as $app => $pref)
				{
					if (!empty($app) && count($pref))
					{
						$app = addslashes($app);
						$pref = serialize($pref);
						$db2->query("INSERT INTO phpgw_preferences".
							" (preference_owner,preference_app,preference_value)".
							" VALUES ($owner,'$app','$pref')");
					}
				}
			}
		}
		$GLOBALS['phpgw_setup']->oProc->DropTable('old_preferences');

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.503';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.503';
	function phpgwapi_upgrade0_9_14_503()
	{
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_addressbook','last_mod',array(
				'type' => 'int',
				'precision' => '4',
				'default' => '0',
				'nullable' => False
			));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.504';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.504';
	function phpgwapi_upgrade0_9_14_504()
	{
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_categories','last_mod',array(
				'type' => 'int',
				'precision' => '4',
				'default' => '0',
				'nullable' => False
			));

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.505';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}


	$test[] = '0.9.14.505';
	function phpgwapi_upgrade0_9_14_505()
	{
		$GLOBALS['phpgw_setup']->oProc->AlterColumn('phpgw_access_log','lo',array(
			'type' => 'int',
			'precision' => '4',
			'nullable' => True,
			'default' => '0'
		));


		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.506';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}


	$test[] = '0.9.14.506';
	function phpgwapi_upgrade0_9_14_506()
	{
		$GLOBALS['phpgw_setup']->oProc->AlterColumn('phpgw_vfs','content',array(
			'type' => 'text',
			'nullable' => True
		));


		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.507';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}


	$test[] = '0.9.14.507';
	function phpgwapi_upgrade0_9_14_507()
	{
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_async','account_id',array(
			'type' => 'int',
			'precision' => '4',
			'nullable' => False,
			'default' => '0'
		));


		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.508';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}


	$test[] = '0.9.14.508';
	function phpgwapi_upgrade0_9_14_508()
	{	
		////global $setup_info,$phpgw_setup;
		//$db1 =& $GLOBALS['phpgw_setup']->db; $db1->auto_stripslashes = False; $db1->Halt_On_Error = 'yes';

		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_accounts','person_id',array(
			'type' => 'int',
			'precision' => '4',
			'nullable' => True
			));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact',array(
			'fd' => array(
				'contact_id' => array('type' => 'auto','precision' => '4','nullable' => False),
				'owner' => array('type' => 'int','precision' => '4','nullable' => False),
				'access' => array('type' => 'varchar','precision' => '7','nullable' => True),
				'cat_id' => array('type' => 'varchar','precision' => '200','nullable' => True),
				'contact_type_id' => array('type' => 'int','precision' => '4','nullable' => False)
			),
			'pk' => array('contact_id'),
			'fk' => array(),
			'ix' => array('owner', 'access', 'contact_type_id', array('contact_id', 'cat_id', 'contact_type_id')),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_person',array(
			'fd' => array(
				'person_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'first_name' => array('type' => 'varchar','precision' => '64','nullable' => False),
				'last_name' => array('type' => 'varchar','precision' => '64','nullable' => False),
				'middle_name' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'prefix' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'suffix' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'birthday' => array('type' => 'varchar','precision' => '32','nullable' => True),
				'pubkey' => array('type' => 'text','nullable' => True),
				'title' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'department' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'initials' => array('type' => 'varchar','precision' => '10','nullable' => True),
				'sound' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'active' => array('type' => 'char','precision' => '1','nullable' => True,'default' => 'Y'),
				'created_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'created_by' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_by' => array('type' => 'int','precision' => '4','nullable' => False)
			),
			'pk' => array(),
			'fk' => array(),
			'ix' => array('person_id'),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_org',array(
			'fd' => array(
				'org_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'name' => array('type' => 'varchar','precision' => '80','nullable' => False),
				'active' => array('type' => 'char','precision' => '1','nullable' => False,'default' => 'Y'),
				'parent' => array('type' => 'int','precision' => '4','nullable' => True),
				'created_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'created_by' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_by' => array('type' => 'int','precision' => '4','nullable' => False)
			),
			'pk' => array(),
			'fk' => array(),
			'ix' => array('org_id', 'active'),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_org_person',array(
			'fd' => array(
				'org_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'person_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'addr_id' => array('type' => 'int','precision' => '4','nullable' => True),
				'preferred' => array('type' => 'char','precision' => '1','nullable' => False,'default' => 'N'),
				'created_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'created_by' => array('type' => 'int','precision' => '4','nullable' => False)
			),
			'pk' => array('org_id','person_id'),
			'fk' => array(),
			'ix' => array('addr_id', 'person_id', 'org_id', 'preferred', array('person_id', 'org_id')),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_addr',array(
			'fd' => array(
				'contact_addr_id' => array('type' => 'auto','nullable' => False),
				'contact_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'addr_type_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'add1' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'add2' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'add3' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'city' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'state' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'postal_code' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'country' => array('type' => 'varchar','precision' => '64','nullable' => True),
				'tz' => array('type' => 'varchar','precision' => '40','nullable' => True),
				'preferred' => array('type' => 'char','precision' => '1','nullable' => False,'default' => 'N'),
				'created_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'created_by' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_by' => array('type' => 'int','precision' => '4','nullable' => False)
			),
			'pk' => array('contact_addr_id'),
			'fk' => array(),
			'ix' => array('contact_id', 'addr_type_id', 'preferred'),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_note',array(
			'fd' => array(
				'contact_note_id' => array('type' => 'auto','nullable' => False),
				'contact_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'note_type_id' => array('type' => 'int','precision' => '4','nullable' => True),
				'note_text' => array('type' => 'text','nullable' => False),
				'created_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'created_by' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_by' => array('type' => 'int','precision' => '4','nullable' => False)
			),
			'pk' => array('contact_note_id'),
			'fk' => array(),
			'ix' => array('contact_id', 'note_type_id'),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_others',array(
			'fd' => array(
				'other_id' => array('type' => 'auto','nullable' => False),
				'contact_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'contact_owner' => array('type' => 'int','precision' => '4','nullable' => False),
				'other_name' => array('type' => 'varchar','precision' => '255','nullable' => False),
				'other_value' => array('type' => 'text','nullable' => False)
			),
			'pk' => array('other_id'),
			'fk' => array(),
			'ix' => array('contact_id','contact_owner','other_name'),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_comm',array(
			'fd' => array(
				'comm_id' => array('type' => 'auto','nullable' => False),
				'contact_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'comm_descr_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'preferred' => array('type' => 'char','precision' => '1','nullable' => False,'default' => 'N'),
				'comm_data' => array('type' => 'varchar','precision' => '255','nullable' => False),
				'created_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'created_by' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_on' => array('type' => 'int','precision' => '4','nullable' => False),
				'modified_by' => array('type' => 'int','precision' => '4','nullable' => False)
			),
			'pk' => array('comm_id'),
			'fk' => array(),
			'ix' => array('comm_data', 'preferred', 'comm_descr_id', 'contact_id', array('comm_id', 'contact_id', 'comm_descr_id')),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_comm_descr',array(
			'fd' => array(
				'comm_descr_id' => array('type' => 'auto','nullable' => False),
				'comm_type_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'descr' => array('type' => 'varchar','precision' => '50','nullable' => True)
			),
			'pk' => array('comm_descr_id'),
			'fk' => array(),
			'ix' => array('descr', 'comm_type_id'),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_comm_type',array(
			'fd' => array(
				'comm_type_id' => array('type' => 'auto','nullable' => False),
				'type' => array('type' => 'varchar','precision' => '50','nullable' => True),
				'active' => array('type' => 'varchar','precision' => '30','nullable' => True),
				'class' => array('type' => 'varchar','precision' => '30','nullable' => True)
			),
			'pk' => array('comm_type_id'),
			'fk' => array(),
			'ix' => array('type', 'active', 'class'),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_types',array(
			'fd' => array(
				'contact_type_id' => array('type' => 'auto','nullable' => False),
				'contact_type_descr' => array('type' => 'varchar','precision' => '50','nullable' => True),
				'contact_type_table' => array('type' => 'varchar','precision' => '50','nullable' => True)
			),
			'pk' => array('contact_type_id'),
			'fk' => array(),
			'ix' => array('contact_type_descr'),
			'uc' => array()
		));


		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_addr_type',array(
			'fd' => array(
				'addr_type_id' => array('type' => 'auto','nullable' => False),
				'description' => array('type' => 'varchar','precision' => '50','nullable' => False)
			),
			'pk' => array('addr_type_id'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_contact_note_type',array(
			'fd' => array(
				'note_type_id' => array('type' => 'auto','nullable' => False),
				'description' => array('type' => 'varchar','precision' => '30','nullable' => False)
			),
			'pk' => array('note_type_id'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_types (contact_type_descr,contact_type_table) VALUES ('Persons','phpgw_contact_person')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_types (contact_type_descr,contact_type_table) VALUES ('Organizations','phpgw_contact_org')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_comm_type (type) VALUES ('email')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_comm_type (type) VALUES ('phone')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_comm_type (type) VALUES ('mobile phone')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_comm_type (type) VALUES ('fax')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_comm_type (type) VALUES ('instant messaging')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_comm_type (type) VALUES ('url')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_comm_type (type) VALUES ('other')");
		

		$GLOBALS['phpgw_setup']->oProc->query("SELECT comm_type_id FROM phpgw_contact_comm_type WHERE type='email'"); 
                while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'home email'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'work email'" 
				.  ")");
                }
		$GLOBALS['phpgw_setup']->oProc->query("SELECT comm_type_id FROM phpgw_contact_comm_type WHERE type='phone'"); 
                while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
                        $GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'home phone'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'work phone'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'voice phone'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'msg phone'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'pager'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'bbs'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'modem'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'isdn'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'video'" 
				.  ")");
                }
		$GLOBALS['phpgw_setup']->oProc->query("SELECT comm_type_id FROM phpgw_contact_comm_type WHERE type='fax'"); 
                while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
                        $GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'home fax'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'work fax'" 
				.  ")");
                }
		$GLOBALS['phpgw_setup']->oProc->query("SELECT comm_type_id FROM phpgw_contact_comm_type WHERE type='mobile phone'"); 
                while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
                        $GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'mobile (cell) phone'" 
				.  ")");
                        $GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'car phone'" 
				.  ")");
                }
		$GLOBALS['phpgw_setup']->oProc->query("SELECT comm_type_id FROM phpgw_contact_comm_type WHERE type='instant messaging'"); 
                while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
                        $GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'msn'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'aim'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'yahoo'" 
				.  ")");
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'icq'" 
				.  ")");
                        $GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'jabber'" 
				.  ")");				
                }
		$GLOBALS['phpgw_setup']->oProc->query("SELECT comm_type_id FROM phpgw_contact_comm_type WHERE type='url'"); 
                while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
                        $GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm_descr (comm_type_id,descr) VALUES (" 
				. $GLOBALS['phpgw_setup']->oProc->f('comm_type_id') 
				. ",'website'" 
				.  ")");
                }
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_addr_type (description) VALUES('work')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_contact_addr_type (description) VALUES('home')");

		// add three columns to ease migration .. delete later
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_contact','ab_id',array(
			'type' => 'int',
			'precision' => '4',
			'nullable' => True
		));
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_contact_person','ab_id',array(
			'type' => 'int',
			'precision' => '4',
			'nullable' => True
		));
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_contact_org','ab_id',array(
			'type' => 'int',
			'precision' => '4',
			'nullable' => True
		));

		$GLOBALS['phpgw_setup']->oProc->query("SELECT contact_type_id FROM phpgw_contact_types WHERE contact_type_table='phpgw_contact_person'");
		$GLOBALS['phpgw_setup']->oProc->next_record();
		$contact_type_person = $GLOBALS['phpgw_setup']->oProc->f('contact_type_id');

		$GLOBALS['phpgw_setup']->oProc->query("SELECT contact_type_id FROM phpgw_contact_types WHERE contact_type_table='phpgw_contact_org'");
                $GLOBALS['phpgw_setup']->oProc->next_record();
		$contact_type_org = $GLOBALS['phpgw_setup']->oProc->f('contact_type_id');

		$GLOBALS['phpgw_setup']->oProc->query("SELECT at.addr_type_id as type_id FROM phpgw_contact_addr_type as at WHERE at.description ='work'");
		$GLOBALS['phpgw_setup']->oProc->next_record();
		$addr_work_type = $GLOBALS['phpgw_setup']->oProc->f('type_id');

		$GLOBALS['phpgw_setup']->oProc->query("SELECT at.addr_type_id as type_id FROM phpgw_contact_addr_type as at WHERE at.description ='home'");
		$GLOBALS['phpgw_setup']->oProc->next_record();
		$addr_home_type = $GLOBALS['phpgw_setup']->oProc->f('type_id');

		$GLOBALS['phpgw_setup']->oProc->query("SELECT comm_descr_id, descr FROM phpgw_contact_comm_descr");
                while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$comm_descr_id[$GLOBALS['phpgw_setup']->oProc->f('descr')] = $GLOBALS['phpgw_setup']->oProc->f('comm_descr_id');
		}

		// IMPORTANT: Probably you ask why i use an array instand of only use $GLOBALS['phpgw_setup']->oProc well, for some reason for upgrades of many 
		// records (more that 18000 in my case) this process is halted, then i have to do of this way.
		
		// IMPORTANT: This problem is with max_execution_time in php.ini and time_out in http.conf, i set this to 3000 and all works fine, but
		// i not change this process because i think this way is beter.

		$GLOBALS['phpgw_setup']->oProc->query("SELECT contact_id, contact_owner, contact_name, contact_value from phpgw_addressbook_extra where contact_name!='' and contact_value!='' and contact_name!='owner' and contact_name!='access' and contact_name!='cat_id'");
		while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$others[$GLOBALS['phpgw_setup']->oProc->f('contact_id')][$GLOBALS['phpgw_setup']->oProc->f('contact_name')] = array(
				'value' => $GLOBALS['phpgw_setup']->oProc->f('contact_value'),
				'owner' => $GLOBALS['phpgw_setup']->oProc->f('contact_owner'));
		}
		
		// migrate existing data to phpgw_contact_person
		$GLOBALS['phpgw_setup']->oProc->query("SELECT id, owner, access, cat_id, n_given, n_family, n_middle, n_prefix, n_suffix, bday, pubkey, title, org_unit, sound, org_name, note, tz, adr_one_street, adr_one_locality, adr_one_region, adr_one_postalcode, adr_one_countryname, adr_two_street, adr_two_locality, adr_two_region, adr_two_postalcode, adr_two_countryname, url, tel_work, tel_home, tel_voice, tel_fax, tel_msg, tel_cell, tel_pager, tel_bbs, tel_modem, tel_car, tel_isdn, tel_video, email, email_home FROM phpgw_addressbook");
		while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$records[$GLOBALS['phpgw_setup']->oProc->f('id')] = array('owner' => $GLOBALS['phpgw_setup']->oProc->f('owner'),
								       'access' => $GLOBALS['phpgw_setup']->oProc->f('access'),
								       'cat_id' => $GLOBALS['phpgw_setup']->oProc->f('cat_id'),
								       'n_given' => $GLOBALS['phpgw_setup']->oProc->f('n_given'),
								       'n_family' => $GLOBALS['phpgw_setup']->oProc->f('n_family'),
								       'n_middle' => $GLOBALS['phpgw_setup']->oProc->f('n_middle'),
								       'n_prefix' => $GLOBALS['phpgw_setup']->oProc->f('n_prefix'),
								       'n_suffix' => $GLOBALS['phpgw_setup']->oProc->f('n_suffix'),
								       'bday' => $GLOBALS['phpgw_setup']->oProc->f('bday'),
								       'pubkey' => $GLOBALS['phpgw_setup']->oProc->f('pubkey'),
								       'title' => $GLOBALS['phpgw_setup']->oProc->f('title'),
								       'org_unit' => $GLOBALS['phpgw_setup']->oProc->f('org_unit'),
								       'sound' => $GLOBALS['phpgw_setup']->oProc->f('sound'),
								       'org_name' => $GLOBALS['phpgw_setup']->oProc->f('org_name'),

								       'note' => $GLOBALS['phpgw_setup']->oProc->f('note'),
								       'tz' => $GLOBALS['phpgw_setup']->oProc->f('tz'),

								       'adr_one_street' => $GLOBALS['phpgw_setup']->oProc->f('adr_one_street'),
								       'adr_one_locality' => $GLOBALS['phpgw_setup']->oProc->f('adr_one_locality'),
								       'adr_one_region' => $GLOBALS['phpgw_setup']->oProc->f('adr_one_region'),
								       'adr_one_postalcode' => $GLOBALS['phpgw_setup']->oProc->f('adr_one_postalcode'),
								       'adr_one_countryname' => $GLOBALS['phpgw_setup']->oProc->f('adr_one_countryname'),
								       'adr_two_street' => $GLOBALS['phpgw_setup']->oProc->f('adr_two_street'),
								       'adr_two_locality' => $GLOBALS['phpgw_setup']->oProc->f('adr_two_locality'),
								       'adr_two_region' => $GLOBALS['phpgw_setup']->oProc->f('adr_two_region'),
								       'adr_two_postalcode' => $GLOBALS['phpgw_setup']->oProc->f('adr_two_postalcode'),
								       'adr_two_countryname' => $GLOBALS['phpgw_setup']->oProc->f('adr_two_countryname'),

								       'url' => $GLOBALS['phpgw_setup']->oProc->f('url'),
								       'tel_work' => $GLOBALS['phpgw_setup']->oProc->f('tel_work'),
								       'tel_home' => $GLOBALS['phpgw_setup']->oProc->f('tel_home'),
								       'tel_voice' => $GLOBALS['phpgw_setup']->oProc->f('tel_voice'),
								       'tel_fax' => $GLOBALS['phpgw_setup']->oProc->f('tel_fax'),
								       'tel_msg' => $GLOBALS['phpgw_setup']->oProc->f('tel_msg'),
								       'tel_cell' => $GLOBALS['phpgw_setup']->oProc->f('tel_cell'),
								       'tel_pager' => $GLOBALS['phpgw_setup']->oProc->f('tel_pager'),
								       'tel_bbs' => $GLOBALS['phpgw_setup']->oProc->f('tel_bbs'),
								       'tel_modem' => $GLOBALS['phpgw_setup']->oProc->f('tel_modem'),
								       'tel_car' => $GLOBALS['phpgw_setup']->oProc->f('tel_car'),
								       'tel_isdn' => $GLOBALS['phpgw_setup']->oProc->f('tel_isdn'),
								       'tel_video' => $GLOBALS['phpgw_setup']->oProc->f('tel_video'),
								       'email' => $GLOBALS['phpgw_setup']->oProc->f('email'),
								       'email_home' => $GLOBALS['phpgw_setup']->oProc->f('email_home'));
		}

		$GLOBALS['phpgw_setup']->oProc->query("SELECT max(contact_id) as contact_id FROM phpgw_contact");
		if($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$contact_id = $GLOBALS['phpgw_setup']->oProc->f('contact_id');
		}
		else
		{
			$contact_id=0;
		}

		if(is_array($records))
		{
			foreach($records as $key => $data)
			{
				$time = time();
				$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact (owner,access,cat_id,contact_type_id,ab_id) VALUES ("
					    . $data['owner']
					    . "," . ($data['access']?"'".$data['access']."'":"null") 
					    . "," . ($data['cat_id']?"'".$data['cat_id']."'":"null")
					    . "," . $contact_type_person
					    . "," . $key 
					    . ')');
				
				$contact_id++;
				$person_id = $contact_id;
				
				$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_person (person_id,first_name,last_name,
				middle_name,prefix,suffix,birthday,pubkey,title,department,
				sound,created_by,modified_by,created_on,modified_on,ab_id) VALUES ("
					    . $person_id
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['n_given']) . "'"
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['n_family']) . "'"
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['n_middle']) . "'"
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['n_prefix']) . "'"
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['n_suffix']) . "'"
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['bday']) . "'" 
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['pubkey']) . "'"
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['title']) . "'"
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['org_unit']) . "'"
					    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['sound']) . "'"
					    . "," . $data['owner'] 
					    . "," . $data['owner'] 
					    . "," . $time
					    . "," . $time
					    . "," . $key 
					    . ')' 
					);

				if($data['org_name'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact (owner,access,cat_id,contact_type_id,ab_id) VALUES ("
						    . $data['owner']
						    . "," . ($data['access']?"'".$data['access']."'":"null") 
						    . "," . ($data['cat_id']?"'".$data['cat_id']."'":"null")
						    . "," . $contact_type_org
						    . "," . $key 
						    . ')');
				
					$contact_id++;
					$org_id = $contact_id;

					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_org (org_id,name,
					created_by,modified_by,created_on,modified_on,ab_id) VALUES ("
						    . $org_id
						    . ",'" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['org_name']) . "'"
						    . "," . $data['owner']
						    . "," . $data['owner'] 
						    . "," . $time
						    . "," . $time
						    . "," . $key 
						    .')');

					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_org_person (org_id,person_id, preferred,
					created_on,created_by) VALUES (" 
						    . $org_id 
						    . ", " . $person_id 
						    . ", 'Y'"	    
						    . ", " . $time
						    . ", " . $time 
						    .  ")");
				}

				if($data['addr_one_stret']!='' || $data['adr_one_locality']!='' || $data['adr_one_region']!='' || $data['adr_one_postalcode']!='' || $data['adr_one_countryname']!='')
				{
					$addr_preferred = 'Y';
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_addr (contact_id,add1,add2,add3,preferred,
					city, state, postal_code, country, tz, addr_type_id,
					created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id 
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_one_street']) ." '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($others[$key]['address2']['value']) ." '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($others[$key]['address3']['value']) ." '"
						    . ", '" . $addr_preferred . " '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_one_locality']) ." '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_one_region']) ." '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_one_postalcode']) ." '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_one_countryname']) ." '"
						    . ", " . intval($data['tz'])
						    . ", " . $addr_work_type
						    . ", " . $time 
						    . ", " . $data['owner'] 
						    . ", " . $time
						    . ", " . $data['owner']
						    .  ")");
				}

				if($data['addr_two_stret']!='' || $data['adr_two_locality']!='' || $data['adr_two_region']!='' || $data['adr_two_postalcode']!='' || $data['adr_two_countryname']!='')
				{
					$addr_preferred = $addr_preferred=='Y'?'N':'Y';					
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_addr (contact_id,add1,preferred,
					city, state, postal_code, country, tz, addr_type_id,
					created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id 
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_two_street']) ." '"
						    . ", '" . $addr_preferred . " '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_two_locality']) ." '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_two_region']) ." '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_two_postalcode']) ." '"
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['adr_two_countryname']) ." '"
						    . ", " . intval($data['tz'])
						    . ", " . $addr_home_type
						    . ", " . $time 
						    . ", " . $data['owner'] 
						    . ", " . $time
						    . ", " . $data['owner']
						    .  ")");
				}
				
				if($data['url'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['website']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['url']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_work'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['work phone']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_work']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_home'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['home phone']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_home']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_voice'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['voice phone']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_voice']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_fax'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['work fax']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_fax']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_msg'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['msg phone']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_msg']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_cell'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['mobile (cell) phone']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_cell']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_pager'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['pager']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_pager']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_bbs'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['bbs']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_bbs']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_modem'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['modem']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_modem']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_car'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['car phone']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_car']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_isdn'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['isdn']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_isdn']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['tel_video'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['video']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['tel_video']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['email'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['work email']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['email']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}
				if($data['email_home'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_comm 
					(contact_id,comm_descr_id,comm_data,created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", "  . $comm_descr_id['home email']
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['email_home']) . "'"
						    . ", "  . $time 
						    . ", "  . $data['owner']
						    . ", "  . $time
						    . ", "  . $data['owner']
						    . ")");
				}

				if($data['note'])
				{
					$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_note (contact_id,note_text, 
					created_on,created_by,modified_on,modified_by) VALUES (" 
						    . $person_id
						    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($data['note']) . "'"
						    . ", " . $time 
						    . ", " . $data['owner'] 
						    . ", " . $time
						    . ", " . $data['owner']
						    .  ")");
				}

				if($others[$key])
				{
					foreach($others[$key] as $name => $value)
					{
						$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_others (contact_id, contact_owner, other_name, other_value) VALUES("
							    . $person_id
							    . ", " . $value['owner']
							    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($name)  . "' "
							    . ", '" . $GLOBALS['phpgw_setup']->db->db_addslashes($value['value']) . "' "
							    .")");
					}
				}
			}
		}
                
		unset($records);
		unset($others);

		//maybe leave these until a future version to catch any data migration problems that are reported
		// when all data migrated, delete phpgw_addressbook and phpgw_addressbook_extra tables
 		//$GLOBALS['phpgw_setup']->oProc->DropTable('phpgw_addressbook');
 		//$GLOBALS['phpgw_setup']->oProc->DropTable('phpgw_addressbook_extra');
		
		// remove temporary ab_id field in phpgw_contact, phpgw_contact_person, and phpgw_contact_org
		//OR NOT! On 512!

		// Paste this below!!!
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.509';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.509';
	//fix some languages to be ISO 639 compliant
	//Source: http://www.geo-guide.de/info/tools/languagecode.html
	function phpgwapi_upgrade0_9_14_509()
	{
		//Indonesian code fix
		$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_languages SET lang_id='id' WHERE lang_id='in'");
		//bn name fix
		$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_languages SET lang_name='Bengali' WHERE lang_id='bn'");
		//English is English not English US - the US didn't invent it!
		$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_languages SET lang_name='English' WHERE lang_id='en'");
		//gd name fix
		$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_languages SET lang_name='Scots Gaelic' WHERE lang_id='gd'");
		//Hebrew code fix
		$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_languages SET lang_id='he' WHERE lang_id='iw'");
		//Yiddish code fix
		$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_languages SET lang_id='yi' WHERE lang_id='ji'");
		//Make Chinese names clearer
		$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_languages SET lang_name='Chinese (Simplified)' WHERE lang_id='zh'");
		$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_languages SET lang_name='Chinese (Traditional)' WHERE lang_id='zt'");
		//Add Missing Languages
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_languages(lang_id, lang_name, available) VALUES('iu', 'Inuktitut', 'No')");
		$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_languages(lang_id, lang_name, available) VALUES('ug', 'Uigur', 'No')");

		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.510';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.510';
	//fix some languages to be ISO 639 compliant
	//Source: http://www.geo-guide.de/info/tools/languagecode.html
	function phpgwapi_upgrade0_9_14_510()
	{
		// Set up the new logging tables	
		$GLOBALS['phpgw_setup']->oProc->DropTable('phpgw_log_msg');
		// just drop and re-create.  We don't need to save it and the structure has changed alot
		$GLOBALS['phpgw_setup']->oProc->DropTable('phpgw_log');
		$GLOBALS['phpgw_setup']->oProc->CreateTable('phpgw_log',array(
			'fd' => array(
				'log_id' => array('type' => 'auto','precision' => '4','nullable' => False),
				'log_date' => array('type' => 'timestamp','nullable' => False),
				'log_account_id' => array('type' => 'int','precision' => '4','nullable' => False),
				'log_account_lid' => array('type' => 'varchar','precision' => '25','nullable' => False),
				'log_app' => array('type' => 'varchar','precision' => '25','nullable' => False),
				'log_severity' => array('type' => 'char','precision' => '1','nullable' => False),
				'log_file' => array('type' => 'varchar','precision' => '255','nullable' => False, 'default' => ''),
				'log_line' => array('type' => 'int','precision' => '4','nullable' => False, 'default' => '0'),
				'log_msg' => array('type' => 'text','nullable' => False)
			),
			'pk' => array('log_id'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array()
		));

		$GLOBALS['phpgw_setup']->oProc->query("SELECT * FROM phpgw_config WHERE config_name = 'log_levels'");
		if (!$GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$GLOBALS['phpgw_setup']->oProc->query("INSERT INTO phpgw_config (config_app, config_name, config_value) 
							VALUES ('phpgwapi','log_levels', '" 
							. serialize(array( 'global_level' => 'E', 'module' => array(), 'user' => array())) ."')");
		}
		else
		{
			$GLOBALS['phpgw_setup']->oProc->query("UPDATE phpgw_config SET config_app='phpgwapi', "
							      ."config_name='log_levels', "
							      ."config_value='". serialize(array('global_level' => 'E', 
												'module' => array(), 
												'user' => array())) ."'");
		}		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.511';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.511';
	function phpgwapi_upgrade0_9_14_511()
	{
		////global $setup_info,$phpgw_setup;
		$db1 =& $GLOBALS['phpgw_setup']->db; 
		$db1->auto_stripslashes = False;
		//$db1->Halt_On_Error = 'report';

		/* Check if addressmaster exist  */
		$GLOBALS['phpgw_setup']->oProc->query("SELECT config_name, config_value FROM phpgw_config WHERE config_name = 'addressmaster'");
                $GLOBALS['phpgw_setup']->oProc->next_record();
		if($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			$addressmaster_id = $GLOBALS['phpgw_setup']->oProc->f('config_value');
		}
		else
		{
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_config (config_app, config_name, config_value) 
				VALUES ('phpgwapi','addressmaster','-3')");
			$addressmaster_id = -3;
		}

		/* Get the contact type id  */
		$GLOBALS['phpgw_setup']->oProc->query("SELECT contact_type_id FROM phpgw_contact_types WHERE contact_type_table='phpgw_contact_person'");
		$GLOBALS['phpgw_setup']->oProc->next_record();
		$contact_type_id = $GLOBALS['phpgw_setup']->oProc->f('contact_type_id');

		/* Get the contact_id  */
		$GLOBALS['phpgw_setup']->oProc->query("SELECT max(contact_id) as contact_id FROM phpgw_contact");
		$GLOBALS['phpgw_setup']->oProc->next_record();
		$contact_id = $GLOBALS['phpgw_setup']->oProc->f('contact_id');

		/* Get all user accounts for create his contact record   */
		$GLOBALS['phpgw_setup']->oProc->query("SELECT account_id, account_lid, account_firstname, account_lastname, person_id FROM phpgw_accounts WHERE account_type='u' AND person_id IS NULL order by account_id");
		while ($GLOBALS['phpgw_setup']->oProc->next_record())
		{
			/* Insert in phpgw_contact  */
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact (owner, access, contact_type_id) VALUES(-3"
							   . ", '".'public'. "', ". $contact_type_id.")");
			
			/* Get the contact_id  */
			$contact_id++;
			
			/* Insert in phpgw_contact_person */
			$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_person (person_id,first_name,last_name,
				prefix,created_by,modified_by,created_on,modified_on) VALUES ("
				. $contact_id
				. ",'" . $db1->db_addslashes($GLOBALS['phpgw_setup']->oProc->f('account_firstname')) . "'"
				. ",'" . $db1->db_addslashes($GLOBALS['phpgw_setup']->oProc->f('account_lastname')) . "'"
				. ",'" . $db1->db_addslashes($GLOBALS['phpgw_setup']->oProc->f('account_lid')) . "'"
				. "," . $addressmaster_id 
				. "," . $addressmaster_id 
				. "," . time()
				. "," . time(). ')');

 			$GLOBALS['phpgw_setup']->db->query("UPDATE phpgw_accounts SET person_id = ". $contact_id .
							   " WHERE account_id = ". $GLOBALS['phpgw_setup']->oProc->f('account_id'));
		}
		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.512';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.512';
	function phpgwapi_upgrade0_9_14_512()
	{
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_note_type (description) VALUES ('general')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_note_type (description) VALUES ('vcard')");
		$GLOBALS['phpgw_setup']->db->query("INSERT INTO phpgw_contact_note_type (description) VALUES ('system')");

		$GLOBALS['phpgw_setup']->oProc->query("SELECT note_type_id FROM phpgw_contact_note_type WHERE description='general'");
		$GLOBALS['phpgw_setup']->oProc->next_record();
		$note_type = $GLOBALS['phpgw_setup']->oProc->f('note_type_id');

		$GLOBALS['phpgw_setup']->db->query("UPDATE phpgw_contact_note SET note_type_id=".$note_type);
		
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.513';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.513';
	function phpgwapi_upgrade0_9_14_513()
	{
		$GLOBALS['phpgw_setup']->oProc->AddColumn('phpgw_accounts','account_quota',array('type' => 'int','precision' => '4','default' => -1,'nullable' => True));
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.14.514';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.14.514';
	function phpgwapi_upgrade0_9_14_514()
	{
		$GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.16.000';
		return $GLOBALS['setup_info']['phpgwapi']['currentver'];
	}

	$test[] = '0.9.16.000';
        function phpgwapi_upgrade0_9_16_000()
        {
                $GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.16.001';
                return $GLOBALS['setup_info']['phpgwapi']['currentver'];
        }

	$test[] = '0.9.16.001';
        function phpgwapi_upgrade0_9_16_001()
        {
                $GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.16.002';
                return $GLOBALS['setup_info']['phpgwapi']['currentver'];
        }

	$test[] = '0.9.16.002';
        function phpgwapi_upgrade0_9_16_002()
        {
                $GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.16.003';
                return $GLOBALS['setup_info']['phpgwapi']['currentver'];
        }

	$test[] = '0.9.16.003';
        function phpgwapi_upgrade0_9_16_003()
        {
                $GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.16.004';
                return $GLOBALS['setup_info']['phpgwapi']['currentver'];
        }

	$test[] = '0.9.16.004';
        function phpgwapi_upgrade0_9_16_004()
        {
                $GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.16.005';
                return $GLOBALS['setup_info']['phpgwapi']['currentver'];
        }

	$test[] = '0.9.16.005';
	function phpgwapi_upgrade0_9_16_005()
	{
		//this was never publicly released!
		return $GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.16.006';
	}

	$test[] = '0.9.16.006';
	function phpgwapi_upgrade0_9_16_006()
	{
		return $GLOBALS['setup_info']['phpgwapi']['currentver'] = '0.9.16.007';
	}

	$test[] = '0.9.16.007';
	function phpgwapi_upgrade0_9_16_007()
	{
		return $GLOBALS['phpgw_info']['phpgwapi']['currentver'] = '0.9.16.008';
	}		
?>
