<?php
	/*************************************************************************\
	* phpGroupWare - Todo list                                                *
	* http://www.phpgroupware.org                                             *
	* This program is part of the GNU project, see http://www.gnu.org/        *
	*                                                                         *
	* Written by Joseph Engo <jengo@phpgroupware.org>                         *
	*            Bettina Gille [ceb@phpgroupware.org]                         *
	* -----------------------------------------------                         *
	* Copyright 2000 - 2003 Free Software Foundation, Inc                     *
	*                                                                         *
	* This program is free software; you can redistribute it and/or modify it *
	* under the terms of the GNU General Public License as published by the   *
	* Free Software Foundation; either version 2 of the License, or (at your  *
	* option) any later version.                                              *
	\*************************************************************************/
	/* $Id: class.so.inc.php,v 1.1.2.8.2.4 2005/05/24 00:18:57 ceb Exp $ */

	class so
	{
		var $db;
		var $grants;
		var $historylog;

		function so()
		{
			$this->db             = $GLOBALS['phpgw']->db;
			$this->db2            = $this->db;
			$this->grants         = $GLOBALS['phpgw']->acl->get_grants('todo');
			$this->owner          = $GLOBALS['phpgw_info']['user']['account_id'];
			$this->historylog     = CreateObject('phpgwapi.historylog','todo');

			// This is so our transactions follow across classes
			$this->historylog->db = $this->db;
		}

		function type($tree)
		{
			switch ($tree)
			{
				case 'mains':	$s = " AND todo_id_parent = '0'"; break;
				case 'subs':	$s = " AND todo_id_parent != '0'"; break;
				default: return False;
			}
			return $s;
		}

		function read_todos($start = 0, $limit = True, $query = '', $filter = '', $order = '', $sort = '', $cat_id = '', $tree = '', $parent = '', $lastmod = -1)
		{
			// cast/addslashes for security
			$start	 = intval($start);
			$cat_id  = intval($cat_id);
			$parent  = intval($parent);
			$lastmod = intval($lastmod);

			$query	= $this->db->db_addslashes($query); 
			$order	= $this->db->db_addslashes($order);
			$sort	= $this->db->db_addslashes($sort);

			$type	= $this->type($tree);

			if ($order)
			{
				$ordermethod = ' ORDER BY ' . $order . ' ' . $sort;
			}
			else
			{
				$ordermethod = ' ORDER BY todo_id_main, todo_id_parent, todo_level, todo_datecreated ASC';
			}

			$filter = strtolower($filter);

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = "( todo_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (todo_access='public' AND todo_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " todo_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod =  " todo_owner='" . $this->owner . "' AND todo_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND todo_cat='$cat_id'";
			}

			if ($query)
			{
				$querymethod = " AND (todo_des like '%$query%' OR todo_title like '%$query%')";
			}

			if ($parent)
			{
				$parentmethod = " AND todo_id_parent='$parent'";
			}
			if ($lastmod >= 0)
			{
				$lastmodmethod = " AND entry_date > $lastmod";
			}

			$sql = "SELECT * FROM phpgw_todo WHERE $filtermethod $querymethod $lastmodmethod $type $parentmethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();

			if ($limit)
			{
				$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);
			}
			else
			{
				$this->db->query($sql . $ordermethod,__LINE__,__FILE__);
			}

			while ($this->db->next_record())
			{
				$todos[] = array
				(
					'id'			=> (int)$this->db->f('todo_id'),
					'main'			=> (int)$this->db->f('todo_id_main'),
					'parent'		=> (int)$this->db->f('todo_id_parent'),
					'level'			=> (int)$this->db->f('todo_level'),
					'owner'			=> $this->db->f('todo_owner'),
					'owner_id'		=> $this->db->f('todo_owner'),
					'access'		=> $this->db->f('todo_access'),
					'cat'			=> (int)$this->db->f('todo_cat'),
					'title'			=> $this->db->f('todo_title'),
					'descr'			=> $this->db->f('todo_des'),
					'pri'			=> (int)$this->db->f('todo_pri'),
					'status'		=> (int)$this->db->f('todo_status'),
					'sdate'			=> $this->db->f('todo_startdate'),
					'edate'			=> $this->db->f('todo_enddate'),
					'grants'		=> (int)$this->grants[$this->db->f('todo_owner')],
					'sdate_epoch'	=> (int)$this->db->f('todo_startdate'),
					'edate_epoch'	=> (int)$this->db->f('todo_enddate'),
					'entry_date'	=> (int)$this->db->f('entry_date')
				);
			}
			return $todos;
		}

		function read_single_todo($todo_id)
		{
			$todo_id = intval($todo_id);
			$this->db->query("select * from phpgw_todo where todo_id=$todo_id",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$todo['id']			= $this->db->f('todo_id');
				$todo['main']		= $this->db->f('todo_id_main');
				$todo['parent']		= $this->db->f('todo_id_parent');
				$todo['level']		= $this->db->f('todo_level');
				$todo['owner']		= $this->db->f('todo_owner');
				$todo['access']		= $this->db->f('todo_access');
				$todo['cat']		= $this->db->f('todo_cat');
				$todo['title']		= $this->db->f('todo_title');
				$todo['descr']		= $this->db->f('todo_des');
				$todo['pri']		= $this->db->f('todo_pri');
				$todo['status']		= $this->db->f('todo_status');
				$todo['sdate']		= $this->db->f('todo_startdate');
				$todo['edate']		= $this->db->f('todo_enddate');
				$todo['entry_date']	= (int)$this->db->f('entry_date');
			}
			return $todo;
		}

		function select_todo_list($selected = '')
		{
			$todos = $this->read_todos($start, False, $query, $filter, $sort, $order, $cat_id, $tree);

			for ($i=0;$i<count($todos);$i++)
			{
				$todo_select .= '<option value="' . $todos[$i]['id'] . '"';
				if ($todos[$i]['id'] == $selected)
				{
					$todo_select .= ' selected';
				}
				if (! $todos[$i]['title'])
				{
					$words = split(' ',$GLOBALS['phpgw']->strip_html($todos[$i]['descr']));
					$title = "$words[0] $words[1] $words[2] $words[3] ...";
					$todo_select .= '>' . $title;
				}
				else
				{
					$todo_select .= '>' . $GLOBALS['phpgw']->strip_html($todos[$i]['title']);
				}
				$todo_select .= '</option>';
			}
			return $todo_select;
		}

		function add_todo($values)
		{
			if (floor(phpversion()) >= 4)
			{
				ob_start();
				print_r($values);
				$contents = ob_get_contents();
				ob_end_clean();
			}

			$GLOBALS['phpgw']->log->message(array
			(
				'text' => 'debug, so add_todo values: %1',
				'p1'   => $contents,
				'line' => __LINE__,
				'file' => __FILE__
			));
			$GLOBALS['phpgw']->log->commit();

			if ($values['parent'] && $values['parent'] != 0)
			{
				$values['main'] = $this->return_value($values['parent']);
				$values['level'] = $this->return_value($values['parent'],'level')+1;
			}

			//cast/slashes for security
			$values['main']		= intval($values['main']);
			$values['parent']	= intval($values['parent']);
			$values['level']	= intval($values['level']);
			$values['access']	= $this->db->db_addslashes($values['access']);
			$values['cat']		= intval($values['cat']);
			$values['title']	= $this->db->db_addslashes($values['title']);
			$values['descr']	= $this->db->db_addslashes($values['descr']);
			$values['pri']		= intval($values['pri']); 
			$values['status']	= intval($values['status']);
			$values['sdate']	= intval($values['sdate']);
			$values['edate']	= intval($values['edate']);

			$this->db->transaction_begin();
			$this->db->query('INSERT INTO phpgw_todo (todo_id_main,todo_id_parent,todo_level,todo_owner,todo_access,todo_cat,'
				. 'todo_des,todo_title,todo_pri,todo_status,todo_datecreated,todo_startdate,todo_enddate, entry_date) '
				. ' VALUES (' . $values['main'] . ',' . $values['parent'] . ',' . $values['level'] . ',' . $this->owner . ",'" 
				. $values['access'] . "'," . $values['cat'] . ",'" . $values['descr'] . "','" . $values['title'] . "'," 
				. $values['pri'] . "," . $values['status'] . "," . time() . "," . $values['sdate'] . "," . $values['edate'] 
				. "," . time() .")",__LINE__,__FILE__);
			$todo_id = $this->db->get_last_insert_id('phpgw_todo','todo_id');

			if (!$values['parent'] || $values[parent] == 0)
			{
				$this->db->query("update phpgw_todo set todo_id_main='" . $todo_id . "' "
					. "where todo_id='" . $todo_id . "'",__LINE__,__FILE__);
			}

			$this->historylog->add('A',$todo_id,' ','');
			$this->db->transaction_commit();
			return $todo_id;
		}

		function find_subs($list_parents='', $list='')
		{
			if ($list_parents == '')
			{
				return $list;
			}
			$query = "SELECT todo_id FROM phpgw_todo WHERE todo_id_parent IN ($list_parents)";
			if ($list <> '')
			{
			 	$query .= " AND todo_id NOT IN ($list)";
			}
			$this->db->query($query,__LINE__,__FILE__);
			$subs = array();
			while ($this->db->next_record())
			{
				$subs[] = $this->db->f('todo_id');
			}
			if (count($subs))
			{
				$list_subs = implode(',', $subs);
				if ($list <> '')
				{
					$list .= ',';
				}
				$list = $this->find_subs($list_subs, $list . $list_subs);
			}
			return $list;
		}

		function delete_todo($todo_id, $sub = False)
		{
			$todo_id = intval($todo_id);
			$this->db->transaction_begin();
			$sub_todos = $this->find_subs($todo_id);
			if ($sub_todos)
			{
				if ($sub)
				{
 					$subdelete = "or todo_id in ($sub_todos)";
				}
				else
				{
					$parent = $this->return_value($todo_id,'parent');
				}
			}

			$this->db->query("DELETE FROM phpgw_todo WHERE todo_id=$todo_id $subdelete AND ((todo_access='public' "
							. "AND todo_owner != " . $this->owner . ") OR (todo_owner=" . $this->owner . "))",__LINE__,__FILE__);

			if (!$sub && $sub_todos)
			{
				$this->db->query('UPDATE phpgw_todo SET todo_id_parent=' . $parent . ' WHERE todo_id_parent=' . $todo_id,__LINE__,__FILE__);
				$this->db->query("UPDATE phpgw_todo SET todo_level=todo_level-1 WHERE todo_id IN ($sub_todos)",__LINE__,__FILE__);
 			}
			$this->historylog->delete($todo_id);
			$this->db->transaction_commit();
		}

		function edit_todo($values)
		{
			if ($values['parent'] && $values['parent'] != 0)
			{
				$values['main'] = $this->return_value($values['parent']);
				$values['level'] = $this->return_value($values['parent'],'level')+1;
			}
			else
			{
				$values['main'] = $values['id'];
				$values['level'] = 0;
			}

			if (! $values['cat'])
			{
				$values['cat'] = 0;
			}

			$old_values = $this->read_single_todo($values['id']);
			if (! $old_values['cat'])
			{
				$old_values['cat'] = 0;
			}

			$this->db->transaction_begin();

			if (($old_values['parent'] || $values['parent']) && ($old_values['parent'] != $values['parent']))
			{
				$this->historylog->add('P',$values['id'],$values['parent'], $old_values['parent']);
			}

			if (($old_values['sdate'] || $values['sdate']) && ($old_values['sdate'] != $values['sdate']))
			{
				$this->historylog->add('S',$values['id'],$values['sdate'], $old_values['sdate']);
			}

			if (($old_values['edate'] || $values['edate']) && ($old_values['edate'] != $values['edate']))
			{
				$this->historylog->add('E',$values['id'],$values['edate'], $old_values['edate']);
			}

			$this->historylog->add('T',$values['id'],$values['title'], $old_values['title']);
			$this->historylog->add('C',$values['id'],$values['cat'], $old_values['cat']);
			$this->historylog->add('D',$values['id'],$values['descr'], $old_values['descr']);
			$this->historylog->add('U',$values['id'],$values['pri'], $old_values['pri']);
			$this->historylog->add('s',$values['id'],$values['status'], $old_values['status']);
			$this->historylog->add('a',$values['id'],$values['access'], $old_values['access']);

			//need to add security shit here
			//cast/slashes for security
			$values['id']		= intval($values['id']);
			$values['main']		= intval($values['main']);
			$values['parent']	= intval($values['parent']);
			$values['level']	= intval($values['level']);
			$values['access']	= $this->db->db_addslashes($values['access']);
			$values['cat']		= intval($values['cat']);
			$values['title']	= $this->db->db_addslashes($values['title']);
			$values['descr']	= $this->db->db_addslashes($values['descr']);
			$values['pri']		= intval($values['pri']); 
			$values['status']	= intval($values['status']);
			$values['sdate']	= intval($values['sdate']);
			$values['edate']	= intval($values['edate']);
			

			$this->db->query("UPDATE phpgw_todo SET todo_des='". $values['descr'] . "', todo_id_parent='" . $values['parent']
				. "', todo_pri='" . $values['pri'] . "', todo_status='" . $values['status'] . "', todo_id_main='" . $values['main']
				. "', todo_access='" . $values['access'] . "', todo_level='" . $values['level']
				. "', todo_startdate='" . $values['sdate'] . "', todo_enddate='" . $values['edate'] . "', todo_title='" . $values['title']
				. "', todo_cat='" . $values['cat'] . "', entry_date = " . time() . " WHERE todo_id='" . $values['id']
				. "'",__LINE__,__FILE__);
			if (($old_values['level'] != $values['level']) || ($old_values['main'] != $values['main']))
 			{
				$sub_todos = $this->find_subs("'$values[id]'");
				if ($sub_todos)
				{
					if ($old_values['main'] != $values['main'])
					{
						$this->db->query("UPDATE phpgw_todo SET todo_id_main='" . $values['main'] . "' WHERE todo_id IN ($sub_todos)",__LINE__,__FILE__);
					}
					if ($old_values['level'] != $values['level'])
					{
						$this->db->query("UPDATE phpgw_todo SET todo_level=todo_level+" . ($values['level'] - $old_values['level'])
							." WHERE todo_id IN ($sub_todos)",__LINE__,__FILE__);
					}
				}
			}
			$this->db->transaction_commit();
		}

		function return_value($todo_id,$action = 'main')
		{
			$todo_id = intval($todo_id);
			switch($action)
			{
				case 'main':	$item = 'todo_id_main'; break;
				case 'level':	$item = 'todo_level'; break;
				case 'parent':	$item = 'todo_id_parent'; break;
			}

			$this->db->query("SELECT $item FROM phpgw_todo WHERE todo_id=$todo_id",__LINE__,__FILE__);
			if ($this->db->next_record())
			{
				return $this->db->f(0);
			}
		}

		function exists($todo_id)
		{
			$todo_id = intval($todo_id);
			$this->db->query("SELECT COUNT(*) FROM phpgw_todo WHERE todo_id_parent = $todo_id",__LINE__,__FILE__);
			$this->db->next_record();

			if ($this->db->f(0))
			{
				return True;
			}
			else
			{
				return False;
			}
		}
	}
?>
