<?php
	/**************************************************************************\
	* phpGroupWare - Administration                                            *
	* http://www.phpgroupware.org                                              *
	* ------------------------------------------------------------------------ *
	* Copyright 2001 - 2003 Free Software Foundation, Inc                      *
	* This program is part of the GNU project, see http://www.gnu.org/         *
	* ------------------------------------------------------------------------ *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: class.uiaclmanager.inc.php,v 1.5.2.2.2.10 2005/12/06 22:59:49 skwashd Exp $ */

	class uiaclmanager
	{
		var $template;
		var $nextmatchs;
		var $public_functions = array
		(
			'list_apps'				=> True,
			'access_form'			=> True,
			'list_addressmasters'	=> True,
			'edit_addressmasters'	=> True,
			'accounts_popup'		=> True
		);

		function uiaclmanager()
		{
			$this->account_id	= (intval($_GET['account_id'])?intval($_GET['account_id']):$GLOBALS['phpgw_info']['user']['account_id']);

			if (!$this->account_id || $GLOBALS['phpgw']->acl->check('account_access',64,'admin'))
			{
				$GLOBALS['phpgw']->redirect_link('/index.php');
			}
			$this->template		= createobject('phpgwapi.Template',PHPGW_APP_TPL);
			$this->nextmatchs	= CreateObject('phpgwapi.nextmatchs');
			$this->boacl		= CreateObject('admin.boaclmanager');
		}

		function common_header()
		{
			$GLOBALS['phpgw_info']['flags']['app_header'] = lang('Admin') . ' - ' . lang('ACL Manager') .
				': ' . $GLOBALS['phpgw']->common->grab_owner_name($this->account_id);
			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();
		}

		function list_apps()
		{
			$this->common_header();

			$GLOBALS['phpgw']->hooks->process('acl_manager',array('preferences'));

			$this->template->set_file(array(
				'app_list'   => 'acl_applist.tpl'
			));
			$this->template->set_block('app_list','list');
			$this->template->set_block('app_list','app_row');
			$this->template->set_block('app_list','app_row_noicon');
			$this->template->set_block('app_list','link_row');
			$this->template->set_block('app_list','spacer_row');

			while (is_array($GLOBALS['acl_manager']) && list($app,$locations) = each($GLOBALS['acl_manager']))
			{
				$icon = $GLOBALS['phpgw']->common->image($app,array('navbar.gif',$app.'.gif'));
				$this->template->set_var('icon_backcolor',$GLOBALS['phpgw_info']['theme']['row_off']);
				$this->template->set_var('link_backcolor',$GLOBALS['phpgw_info']['theme']['row_off']);
				$this->template->set_var('app_name',$GLOBALS['phpgw_info']['apps'][$app]['title']);
				$this->template->set_var('a_name',$appname);
				$this->template->set_var('app_icon',$icon);

				if ($icon)
				{
					$this->template->fp('rows','app_row',True);
				}
				else
				{
					$this->template->fp('rows','app_row_noicon',True);
				}

				while (is_array($locations) && list($loc,$value) = each($locations))
				{
					$link_values = array(
						'menuaction' => 'admin.uiaclmanager.access_form',
						'location'   => urlencode($loc),
						'acl_app'    => $app,
						'account_id' => $this->account_id
					);

					$this->template->set_var('link_location',$GLOBALS['phpgw']->link('/index.php',$link_values));
					$this->template->set_var('lang_location',lang($value['name']));
					$this->template->fp('rows','link_row',True);
				}

				$this->template->parse('rows','spacer_row',True);
			}
			$this->template->set_var(array(
				'cancel_action' => $GLOBALS['phpgw']->link('/index.php','menuaction=admin.uiaccounts.list_users'),
				'lang_cancel'   => lang('Cancel')
			));
			$this->template->pfp('out','list');
		}

		function access_form()
		{
			$location = $_GET['location'];

			if ($_POST['submit'] || $_POST['cancel'])
			{
				if ($_POST['submit'])
				{
					$total_rights = 0;
					while (is_array($_POST['acl_rights']) && list(,$rights) = each($_POST['acl_rights']))
					{
						$total_rights += $rights;
					}

					if ($total_rights)
					{
						$GLOBALS['phpgw']->acl->add_repository($_GET['acl_app'], $location, $this->account_id, $total_rights);
					}
					else	// we dont need to save 0 rights (= no restrictions)
					{
						$GLOBALS['phpgw']->acl->delete_repository($_GET['acl_app'], $location, $this->account_id);
					}
				}
				$this->list_apps();
				return;
			}
			$GLOBALS['phpgw']->hooks->single('acl_manager',$_GET['acl_app']);
			$acl_manager = $GLOBALS['acl_manager'][$_GET['acl_app']][$location];

			$this->common_header();
			$this->template->set_file('form','acl_manager_form.tpl');

			$acc = createobject('phpgwapi.accounts',$this->account_id);
			$acc->read_repository();
			$afn = $GLOBALS['phpgw']->common->display_fullname($acc->data['account_lid'],$acc->data['firstname'],$acc->data['lastname']);

			$this->template->set_var('lang_message',lang('Check items to <b>%1</b> to %2 for %3',lang($acl_manager['name']),$GLOBALS['phpgw_info']['apps'][$_GET['acl_app']]['title'],$afn));
			$link_values = array(
				'menuaction' => 'admin.uiaclmanager.access_form',
				'acl_app'    => $_GET['acl_app'],
				'location'   => urlencode($_GET['location']),
				'account_id' => $this->account_id
			);

			$acl    = createobject('phpgwapi.acl',$this->account_id);
			$acl->read_repository();
			$grants = $acl->get_rights($location,$_GET['acl_app']);

			$this->template->set_var('form_action',$GLOBALS['phpgw']->link('/index.php',$link_values));

			$total = 0;
			while (list($name,$value) = each($acl_manager['rights']))
			{
				$cb .= '<input type="checkbox" name="acl_rights[]" value="'.$value.'"'.($grants & $value ? ' checked' : '').'>&nbsp;'.lang($name)."<br />\n";
			}
			$this->template->set_var('select_values',$cb);
			$this->template->set_var('lang_submit',lang('Save'));
			$this->template->set_var('lang_cancel',lang('Cancel'));

			$this->template->pfp('out','form');
		}

		function list_addressmasters()
		{
			$link_data = array
			(
				'menuaction'	=> 'admin.uiaclmanager.edit_addressmasters',
				'account_id'	=> $GLOBALS['phpgw_info']['user']['account_id']
			);

			if ($_POST['edit'])
			{
				$GLOBALS['phpgw']->redirect_link('/index.php',$link_data);
			}

			if ($_POST['done'])
			{
				$GLOBALS['phpgw']->redirect_link('/admin/index.php');
			}

			$GLOBALS['phpgw_info']['flags']['app_header'] = lang('admin') . ': ' . lang('list addressmasters');
			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$GLOBALS['phpgw']->template->set_file(array('admin_list_t' => 'list_accountmasters.tpl'));
			$GLOBALS['phpgw']->template->set_block('admin_list_t','user_list','list');
			$GLOBALS['phpgw']->template->set_block('admin_list_t','group_list','glist');

			$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);

			$GLOBALS['phpgw']->template->set_var('sort_lid',lang('loginid'));
			$GLOBALS['phpgw']->template->set_var('sort_firstname',lang('firstname'));
			$GLOBALS['phpgw']->template->set_var('sort_lastname',lang('lastname'));
			$GLOBALS['phpgw']->template->set_var('sort_name',lang('name'));
			$GLOBALS['phpgw']->template->set_var('lang_edit',lang('edit'));
			$GLOBALS['phpgw']->template->set_var('lang_done',lang('done'));
			$GLOBALS['phpgw']->template->set_var('lang_users',lang('users'));
			$GLOBALS['phpgw']->template->set_var('lang_groups',lang('groups'));

			$admins = $this->boacl->list_addressmasters();
			
			//_debug_array($admins);

			if(is_array($admins))
			{
				foreach($admins as $admin)
				{
					if ($admin['lastname'] != 'Group')
					{
						$this->nextmatchs->template_alternate_row_color(&$GLOBALS['phpgw']->template);
					
						$GLOBALS['phpgw']->template->set_var(array
										     (
											     'lid'		=> $admin['lid'],
											     'firstname'=> $admin['firstname'],
											     'lastname'	=> $admin['lastname'])
							);

						$GLOBALS['phpgw']->template->fp('list','user_list',True);
					}
					elseif ($admin['lastname'] == 'Group')
					{
						$this->nextmatchs->template_alternate_row_color(&$GLOBALS['phpgw']->template);
					
						$GLOBALS['phpgw']->template->set_var(array
										     (
											     'lid'		=> $admin['lid'],
											     'firstname'=> $admin['firstname'],
											     'lastname'	=> $admin['lastname'])
							);
						$GLOBALS['phpgw']->template->fp('glist','group_list',True);
					}
				}
			}
			$GLOBALS['phpgw']->template->pfp('out','admin_list_t',True);
		}

		function accounts_popup()
		{
			$GLOBALS['phpgw']->accounts->accounts_popup('admin_acl');
		}

		function edit_addressmasters()
		{
			$link_data = array
			(
				'menuaction' 	=> 'admin.uiaclmanager.list_addressmasters',
				'account_id'	=> $GLOBALS['phpgw_info']['user']['account_id']
			);

			if ( isset($_POST['save']) && $_POST['save'] )
			{
				$error = $this->boacl->check_values($_POST['account_addressmaster'],$_POST['group_addressmaster']);
				if(is_array($error))
				{
					$GLOBALS['phpgw']->template->set_var('error_message',$GLOBALS['phpgw']->common->error_list($error));
				}
				else
				{
					$this->boacl->edit_addressmasters($_POST['account_addressmaster'],$_POST['group_addressmaster']);
					$GLOBALS['phpgw']->redirect_link('/index.php',$link_data);
				}
			}

			if ($_POST['cancel'])
			{
				$GLOBALS['phpgw']->redirect_link('/index.php',$link_data);
			}

			$GLOBALS['phpgw_info']['flags']['app_header'] = lang('admin') . ': ' . lang('edit addressmaster list');
			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$GLOBALS['phpgw']->template->set_file(array('admin_add' => 'form_accountmasters.tpl'));
			$GLOBALS['phpgw']->template->set_block('admin_add','select');
			$GLOBALS['phpgw']->template->set_block('admin_add','popwin');

			$GLOBALS['phpgw']->template->set_var('lang_select_addressmasters',lang('Select addressmasters'));
			$GLOBALS['phpgw']->template->set_var('lang_save',lang('save'));
			$GLOBALS['phpgw']->template->set_var('lang_cancel',lang('cancel'));

			$link_data['menuaction'] = 'admin.uiaclmanager.edit_addressmasters';
			$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/index.php',$link_data));

			if ($GLOBALS['phpgw_info']['user']['preferences']['common']['account_selection'] == 'popup')
			{
				$usel = $this->boacl->list_addressmasters();
				$GLOBALS['phpgw']->template->set_var('accounts_link',$GLOBALS['phpgw']->link('/index.php','menuaction=admin.uiaclmanager.accounts_popup'));
				$GLOBALS['phpgw']->template->set_var('lang_open_popup',lang('open popup window'));

				while(is_array($usel) && list(,$acc) = each($usel))
				{
					$user_list .= '<option value="' . $acc['account_id'] . '" selected>'
								. $GLOBALS['phpgw']->common->display_fullname($acc['lid'],$acc['firstname'],$acc['lastname'])
								. '</option>'."\n";
				}
				$account_num = count($sel_accounts);
				$GLOBALS['phpgw']->template->set_var('select_size',($account_num < 7?$account_num:7));
				$GLOBALS['phpgw']->template->set_var('account_list',$user_list);
				$GLOBALS['phpgw']->template->fp('accounts','popwin',True);
			}
			else
			{
				$GLOBALS['phpgw']->template->set_var('lang_select_users',lang('Select users'));
				$GLOBALS['phpgw']->template->set_var('lang_select_groups',lang('Select groups'));

				$app_user = $GLOBALS['phpgw']->acl->get_ids_for_location('run', 1, 'addressbook');

				$add_users = $GLOBALS['phpgw']->accounts->return_members($app_user);
				$add_users['groups'] = $GLOBALS['phpgw']->accounts->get_list('groups');

				$usel = $this->boacl->get_addressmaster_ids();

				//_debug_array($usel);
				for($i=0;$i<count($add_users['users']);$i++)
				{
					$user_list .= '<option value="' . $add_users['users'][$i] . '"';
					if (is_array($usel) && in_array($add_users['users'][$i],$usel))
					{
						$user_list .= ' selected="selected"';
					}
					$user_list .= '>';
					$user_list .= $GLOBALS['phpgw']->common->grab_owner_name($add_users['users'][$i])
							. '</option>' . "\n";
				}

				$add_user_num = count($add_users['users']);
				$GLOBALS['phpgw']->template->set_var('u_select_size',($add_user_num < 7?$add_user_num:7));
				$GLOBALS['phpgw']->template->set_var('user_list',$user_list);

				$group_list = '';

				if ( is_array($add_users['groups']) && count($add_users['groups']) )
				{
					foreach ( $add_users['groups'] as $group )
					{
						$group_list .= '<option value="' . $group['account_id'] . '"';
						if ( is_array($usel) && in_array($group['account_id'], $usel))
						{
							$group_list .= ' selected="selected"';
						}
						$group_list .= '>';
						$group_list .= $GLOBALS['phpgw']->common->grab_owner_name($group['account_id']) . '</option>' . "\n";
					}
				}

				$add_group_num = count($add_users['groups']);
				$GLOBALS['phpgw']->template->set_var('g_select_size', ($add_group_num < 7 ? $add_group_num : 7));
				$GLOBALS['phpgw']->template->set_var('group_list', $group_list);

				$GLOBALS['phpgw']->template->fp('accounts','select',True);
			}

			$GLOBALS['phpgw']->template->set_var('select','');
			$GLOBALS['phpgw']->template->set_var('popwin','');
			$GLOBALS['phpgw']->template->pfp('out','admin_add');
		}
	}
?>
