<?php
/**
 * folders module
 *
 * @author Philipp Kamps <pkamps@probusiness.de>
 * @copyright Copyright (C) 2003 Free Software Foundation http://www.fsf.org/
 * @license http://www.fsf.org/licenses/gpl.html GNU General Public License
 * @package folders
 * @version $Id: class.uifolders.inc.php,v 1.4.2.3 2004/03/16 09:28:44 fipsfuchs Exp $
 */

	/**
	 * This class handles the user interface
	 *
	 * @package folders
	 */
	class uifolders
	{

		/**
		 * Templates object
		 *
		 * @var object $t template object
		 * @see uifolders()
		 */
		var $t;

		/**
		 * contains all public method names
		 *
		 * @var array $public_functions contains all public method names
		 *
		 */
		var $public_functions = array('enablefolders' => true,
																	'disablefolders' => true,
																	'showfolders' => true
																 );

		/**
		 * constructor
		 *
		 */
		function uifolders()
		{
			$this->t = createobject('phpgwapi.Template',PHPGW_TEMPLATE_DIR);
		}

		/**
		 * set session var 'mode' and reloads the page
		 *
		 */
		function enableFolders()
		{
			$GLOBALS['phpgw']->session->appsession('mode', 'folders', 'enabled');
			Header('Location: '.$GLOBALS['phpgw']->session->appsession('link', 'folders'));
		}

		/**
		 * set session var 'mode' and reloads the page
		 *
		 */
		function disableFolders()
		{
			$GLOBALS['phpgw']->session->appsession('mode', 'folders', 'disabled');
			Header('Location: '.$GLOBALS['phpgw']->session->appsession('link', 'folders'));
		}

		/**
		 * parse the folders and print it on screen
		 *
		 */
		function showFolders()
		{
			$this->t->set_root(PHPGW_SERVER_ROOT . '/folders/templates/default/'); // hardcoded path :-(
			$this->t->set_file(array('folders_t' => 'folders.tpl'));

			$this->bofolders = CreateObject('folders.bofolders');
			$this->bofolders->buildFolders('menuname');

			$this->t->set_var('folders', $this->bofolders->parseFolders('menuname'));
			$this->t->set_var('wwwRoot', $GLOBALS['phpgw_info']['server']['webserver_url'] );

			$this->t->pparse('out','folders_t');
		}

		/**
		 * returns a HTML iframe to show folders inside this iframe
		 *
		 * @return string parsed HTML iframe
		 */
		function get_iframe ()
		{
			$this->t->set_root(PHPGW_SERVER_ROOT . '/folders/templates/default/');
			$this->t->set_file(array('helpers_t' => 'helpers.tpl'));
			$this->t->set_block('helpers_t','iframe');
			$var['source'] = $GLOBALS['phpgw']->link('/index.php','menuaction=folders.uifolders.showfolders');
			$this->t->set_var($var);
			$this->t->fp('out','iframe');

			return $this->t->get_var('out');
		}

		/**
		 * returns a HTML button to switch between folders and the application bar
		 *
		 * @return string parsed HTML button based on the actual folders mode
		 */
		function get_switchlink()
		{
			/* workaround: IE doesn't set the PHP referer variable */
			if ($GLOBALS['SSL_VERSION_LIBRARY'])
			{
				$httpMode = 'https://';
			}
			else
			{
				$httpMode = 'http://';
			}
			$GLOBALS['phpgw']->session->appsession('link', 'folders', $httpMode.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']); 
			/* end of workaround */
			
			$this->t->set_root(PHPGW_SERVER_ROOT . '/folders/templates/default/'); // hardcoded path :-(
			$this->t->set_file(array('helpers_t' => 'helpers.tpl'));
			$this->t->set_block('helpers_t','link');
			
			if (substr($GLOBALS['phpgw']->session->appsession('mode', 'folders'),0,7) == 'enabled')
			{
				$var['linkvalue'] = $GLOBALS['phpgw']->link('/index.php','menuaction=folders.uifolders.disablefolders');
				$var['linkname']  = lang('modules');
			}
			else
			{
				$var['linkvalue'] = $GLOBALS['phpgw']->link('/index.php','menuaction=folders.uifolders.enablefolders');
				$var['linkname']  = lang('folders');
			}
			$this->t->set_var($var);
			$this->t->fp('out','link');

			return $this->t->get_var('out');
		}

		/**
		 * returns the actual folder mode
		 *
		 * @return string is 'enabled' or 'disabled'
		 */
		function get_folderMode()
		{
			if ( substr($GLOBALS['phpgw']->session->appsession('mode', 'folders'),0,7) == 'enabled' )
			{
				return 'enabled';
			}
			else
			{
				return 'disabled';
			}
		}
	}
