<?

/**************************************************************************
 * Database connectivity functions.   Basically just a wrapper around
 * mysql_query, with connection and error-checking.
 *
 * To use the functions in this file, you must have the following variables
 * defined somewhere global:
 *
 * DB_HOST - the host to connect to.
 *
 * DB_PORT - the port to connect to (optional).
 *
 * DB_UID - the user ID to connect with.
 *
 * DB_PASS - the password for the user ID.
 *
 * DB_DATABASE - the name of the database to connect to.
 *
 * ADMIN_MAIL - the e-mail address of someone who can sort out problems with
 * the database server, or possibly the admin of this program.
 * 
 *
 * Copyright (C) 2001, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id: db.inc,v 1.4 2002/07/12 08:54:35 mjp16 Exp $


require_once("phtml/misc.inc");

/* Connects to the database given in the config variables with the given
 * parameters, and submits the specified query to that database.  Returns
 * the MySQL result identifier, as returned from mysql_query, or FALSE if
 * there was an error of some type.  In the case of an error, the error
 * message will be printed with a suggestion to contact the admin to report
 * the problem.
 */
function db_query($query)
{
	global $DB_HOST, $DB_UID, $DB_PASS, $DB_DATABASE, $DB_PORT;
	
	if (!$DB_PORT) {
		$DB_PORT = 3306;
	}
	debug("db_query: Sending query: [$query]");
	
	$conn = mysql_connect($DB_HOST.":".$DB_PORT, $DB_UID, $DB_PASS);
	
	if (!$conn) {
		db_error();
		return FALSE;
	}
	
	if (!mysql_select_db($DB_DATABASE)) {
		db_error();
		return FALSE;
	}

	$result = mysql_query($query);
	if (!$result) {
		db_error();
		return FALSE;
	}
	
	return $result;
}

/* Print a database error message along with a request to tell the
 * powers-that-be about the stuff-up.
 */
function db_error()
{
	global $ADMIN_MAIL;
	
	echo "<p><b>Fatal Database error: ".mysql_error()."</b>\n";
	echo "<p>Please inform the administrator (<a href=\"mailto:$ADMIN_MAIL\">$ADMIN_MAIL</a>) of this problem.\n";
	exit;
}

?>
