#!/usr/bin/python

import sys
import os
import string
import picax.config

# Standard parameters for CDs.  We could allow some of these to be
# controlled by module parameters at some point.

cd_size_650 = 681574400
mkisofs_std_args = "-R -J -V -T -joliet-long"

options = {}

def get_options():
    return options

def get_part_size():
    return cd_size_650

def create_image(index, boot_image_path):
    conf = picax.config.get_config()
    data_path = "%s/bin%d" % (conf["base_path"], index)
    if not os.path.isdir(data_path):
        raise RuntimeError, "couldn't locate CD image source path"

    # If an image is provided, identify its type.

    boot_args = ""
    if boot_image_path is not None:
        if not os.path.exists(data_path + "/" + boot_image_path):
            raise RuntimeError, "could not find boot image"
        boot_args = "-b " + boot_image_path
        if boot_image_path[-12:] == "isolinux.bin" or \
           boot_image_path[-18:] == "isolinux-debug.bin":
            isolinux_path = os.path.dirname(boot_image_path)
            boot_args = boot_args + " -no-emul-boot -boot-load-size 4 -boot-info-table"
            boot_args = boot_args + " -c %s/boot.cat" % (isolinux_path,)
        else:
            image_size = os.stat(data_path + "/" + boot_image_path).st_size
            if image_size not in (1228800, 1474560, 2949120):
                raise RuntimeError, "boot image not a floppy or ISOLINUX image"
            boot_args = boot_args + " -c boot.cat"

    if os.system("mkisofs -o %s/img-bin%d.iso %s %s %s" \
                 % (conf["base_path"], index, mkisofs_std_args, boot_args,
                    data_path)):
        raise RuntimeError, "CD image generation failed"
