import unittest
import events

class TestEmiter(unittest.TestCase):
    def test_events(self):
        e = events.Emitter("foo", "bar")
        self.assertEquals(e.events, ("bar", "foo"))
        
    def test_emit_and_bound(self):
        e = events.Emitter("foo")
        
        e.bound_connect("foo", self.on_event_launched)
        assert not hasattr(self, "args")
        assert not hasattr(self, "kwargs")
        
        e.emit("foo")
        self.assertEquals(self.args, ())
        self.assertEquals(self.kwargs, {})

        e.emit("foo", 1, 2, a=3)
        self.assertEquals(self.args, (1, 2))
        self.assertEquals(self.kwargs, {'a': 3})

    def test_ref(self):
        e = events.Emitter("foo")
        assert not hasattr(self, "args")
        assert not hasattr(self, "kwargs")
        
        e.emit("foo")
        assert not hasattr(self, "args")
        assert not hasattr(self, "kwargs")

        ref = e.connect("foo", self.on_event_launched)
        e.emit("foo")
        self.assertEquals(self.args, ())
        self.assertEquals(self.kwargs, {})

        del self.args
        del self.kwargs
        del ref
        e.emit("foo")
        assert not hasattr(self, "args")
        assert not hasattr(self, "kwargs")
       

    def on_event_launched(self, *args, **kwargs):
        self.args = args
        self.kwargs = kwargs
        
    
if __name__ == '__main__':
    unittest.main()
