/*
 * Copyright © 2017 Miklós Máté
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/** Paragraph 5 of the Errors section:
 *
 * The error INVALID_OPERATION is generated by PassTexCoordATI or
 * SampleMapATI if two shader passes have already been specified, or if
 * the same <dst> register is specified twice in the same pass.
 */

#include "piglit-util-gl.h"

static struct piglit_gl_test_config *piglit_config;

PIGLIT_GL_TEST_CONFIG_BEGIN

	piglit_config = &config;
	config.supports_gl_compat_version = 10;
	config.window_visual = PIGLIT_GL_VISUAL_DOUBLE | PIGLIT_GL_VISUAL_RGBA;

PIGLIT_GL_TEST_CONFIG_END

enum piglit_result
piglit_display(void)
{
	/* UNREACHED */
	return PIGLIT_FAIL;
}

static enum piglit_result
too_many_passes(void *data)
{
	bool pass = true;

	glBeginFragmentShaderATI();
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_1_ATI, GL_NONE, GL_NONE);
	glPassTexCoordATI(GL_REG_0_ATI, GL_REG_0_ATI, GL_SWIZZLE_STR_ATI);
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_1_ATI, GL_NONE, GL_NONE);
	pass &= piglit_check_gl_error(GL_NO_ERROR);
	glPassTexCoordATI(GL_REG_0_ATI, GL_REG_0_ATI, GL_SWIZZLE_STR_ATI);
	pass &= piglit_check_gl_error(GL_INVALID_OPERATION);
	glEndFragmentShaderATI();

	glBeginFragmentShaderATI();
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_1_ATI, GL_NONE, GL_NONE);
	glPassTexCoordATI(GL_REG_0_ATI, GL_REG_0_ATI, GL_SWIZZLE_STR_ATI);
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_1_ATI, GL_NONE, GL_NONE);
	pass &= piglit_check_gl_error(GL_NO_ERROR);
	glSampleMapATI(GL_REG_0_ATI, GL_TEXTURE0_ARB, GL_SWIZZLE_STR_ATI);
	pass &= piglit_check_gl_error(GL_INVALID_OPERATION);
	glEndFragmentShaderATI();

	return pass ? PIGLIT_PASS : PIGLIT_FAIL;
}

static enum piglit_result
same_reg_written_twice(void *data)
{
	bool pass = true;

	glBeginFragmentShaderATI();
	glPassTexCoordATI(GL_REG_0_ATI, GL_TEXTURE0_ARB, GL_SWIZZLE_STR_ATI);
	pass &= piglit_check_gl_error(GL_NO_ERROR);
	glPassTexCoordATI(GL_REG_0_ATI, GL_TEXTURE1_ARB, GL_SWIZZLE_STR_ATI);
	pass &= piglit_check_gl_error(GL_INVALID_OPERATION);
	/* note: Mesa requires at least 1 arith instruction,
	 * but this is not in the spec */
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_1_ATI, GL_NONE, GL_NONE);
	glEndFragmentShaderATI();

	glBeginFragmentShaderATI();
	glPassTexCoordATI(GL_REG_0_ATI, GL_TEXTURE0_ARB, GL_SWIZZLE_STR_ATI);
	pass &= piglit_check_gl_error(GL_NO_ERROR);
	glSampleMapATI(GL_REG_0_ATI, GL_TEXTURE1_ARB, GL_SWIZZLE_STR_ATI);
	pass &= piglit_check_gl_error(GL_INVALID_OPERATION);
	/* note: Mesa requires at least 1 arith instruction,
	 * but this is not in the spec */
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_1_ATI, GL_NONE, GL_NONE);
	glEndFragmentShaderATI();

	return pass ? PIGLIT_PASS : PIGLIT_FAIL;
}

static const struct piglit_subtest subtests[] = {
	{
		"Too many passes",
		"too-many-passes",
		too_many_passes,
		NULL
	},
	{
		"Same reg written twice",
		"same-reg-written-twice",
		same_reg_written_twice,
		NULL
	},
	{
		NULL,
		NULL,
		NULL,
		NULL
	}
};

void
piglit_init(int argc, char **argv)
{
	piglit_require_extension("GL_ATI_fragment_shader");

	piglit_report_result(piglit_run_selected_subtests(subtests,
				piglit_config->selected_subtests,
				piglit_config->num_selected_subtests,
				PIGLIT_SKIP));
}
