/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment media rendering library
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author(s): Loïc Molinari <loic@fluendo.com>
 *            Julien Moutte <julien@fluendo.com>
 *            Guillaume Emont <guillaume@fluendo.com>
 */

#ifndef __PGM_VIEWPORT_FACTORY_H__
#define __PGM_VIEWPORT_FACTORY_H__

/* pgmviewportfactory.h and pgmviewport.h include eachother */
typedef struct _PgmViewportFactory      PgmViewportFactory;
typedef struct _PgmViewportFactoryClass PgmViewportFactoryClass;

#include <gst/gst.h>
#include <gmodule.h>
#include "pgmcommon.h"
#include "pgmplugin.h"
#include "pgmviewport.h"
#include "pgmmodule.h"

G_BEGIN_DECLS

#define PGM_TYPE_VIEWPORT_FACTORY (pgm_viewport_factory_get_type ())
#define PGM_VIEWPORT_FACTORY(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_VIEWPORT_FACTORY, PgmViewportFactory))
#define PGM_VIEWPORT_FACTORY_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_VIEWPORT_FACTORY, PgmViewportFactoryClass))
#define PGM_IS_VIEWPORT_FACTORY(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_VIEWPORT_FACTORY))
#define PGM_IS_VIEWPORT_FACTORY_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_VIEWPORT_FACTORY))
#define PGM_VIEWPORT_FACTORY_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_VIEWPORT_FACTORY, PgmViewportFactoryClass))

/**
 * PgmViewportFactory:
 * @module: the dynamically loaded plugin.
 * @plugin_desc: the viewport plugin description.
 *
 * The #PgmViewportFactory opaque structure.
 */
struct _PgmViewportFactory {
  /*< private >*/
  GstObject parent;

  PgmModule *module;

  /* Padding */
  gpointer _pgm_reserved[PGM_PADDING];
};

struct _PgmViewportFactoryClass {
  GstObjectClass parent_class;

  /*< private >*/
  gpointer _pgm_reserved[PGM_PADDING];
};

GType     pgm_viewport_factory_get_type        (void);

PgmViewportFactory *pgm_viewport_factory_new   (const gchar *name);

PgmError  pgm_viewport_factory_get_description (PgmViewportFactory *factory,
                                                gchar **description);

PgmError  pgm_viewport_factory_get_license     (PgmViewportFactory *factory,
                                                gchar **license);

PgmError  pgm_viewport_factory_get_origin      (PgmViewportFactory *factory,
                                                gchar **origin);

PgmError  pgm_viewport_factory_get_author      (PgmViewportFactory *factory,
                                                gchar **author);

PgmError  pgm_viewport_factory_create          (PgmViewportFactory *factory,
                                                PgmViewport **viewport);

PgmError  pgm_viewport_factory_make            (const gchar *name,
                                                PgmViewport **viewport);

G_END_DECLS

#endif /* __PGM_VIEWPORT_FACTORY_H__ */
