# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import pgm
from pypgmtools.graph.text import Text

class Console(Text):

    def __init__(self):
        Text.__init__(self)

        self._lines = [""]
        self._current_line = 0
        self._visible_lines = 5

        # default style
        self.wrap = pgm.TEXT_WRAP_CHAR
        self.font_height = self.height / self._visible_lines * 0.7
        self.size = (2.0, 1.0)
        self.fg_color = (200, 200, 200, 255)
        self.bg_color = (50, 50, 50, 255)

    def append_to_current_line(self, text):
        self._lines[self._current_line] += text
        self._refresh()

    def delete_previous_character(self):
        pass

    def next_line(self):
        self._current_line += 1
        self._lines.append("")
        self._refresh()

    def clear(self):
        pass

    def clear_current_line(self):
        pass

    def set_visible_lines(self, lines):
        self.font_height = self.height / lines
        self._visible_lines = lines
        self._refresh()

    def _refresh(self):
        buffer = ""
        for line in self._lines[-self._visible_lines:]:
            buffer += line
            buffer += "\n"
        self.label = buffer

if __name__ == "__main__":
    import pgm
    import gobject

    def on_key_press(viewport, event, gl, widget):
        if event.type == pgm.KEY_PRESS:
            if event.keyval == pgm.keysyms.Escape:
                pgm.main_quit()

            elif event.keyval == pgm.keysyms.Return:
                widget.next_line()

            else:
                widget.append_to_current_line(unichr(event.keyval))


    def on_delete(viewport, event):
        pgm.main_quit()


    # OpenGL viewport creation
    factory = pgm.ViewportFactory('opengl')
    gl = factory.create()
    gl.title = 'Console widget test'

    # Canvas and image drawable creation
    canvas = pgm.Canvas()

    # Bind the canvas to the OpenGL viewport
    gl.set_canvas(canvas)
    gl.show()

    console_widget = Console()
    console_widget.position = (0.2, 0.5, 0.0)
    console_widget.visible = True

    canvas.add(pgm.DRAWABLE_MIDDLE, console_widget)

    # Let's start a mainloop
    gl.connect('key-press-event',
               on_key_press,
               gl,
               console_widget)
    gl.connect('delete-event', on_delete)
    gobject.timeout_add(10, gl.update)
    pgm.main()
