# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Mirco Müller <macslow@bangang.de>

import pgm, os
from pypgmtools.graph.image import Image
from list import List

class ImageList(List):

    def __init__(self,
                 canvas,
                 layer,
                 font_family       = "Sans",
                 font_height       = 0.1,
                 fg_color          = (255, 255, 255, 255),
                 bg_color          = (0, 0, 0, 0),
                 width             = 1.0,
                 height            = 2.0,
                 visible_items     = 7,
                 selected_item     = 0,
                 selector_file     = None,
                 selector_offset   = (0.0, 0.0, 0.0),
                 selector_size     = (1.0, 1.0)):
        List.__init__(self,
                      canvas,
                      layer,
                      width,
                      height,
                      visible_items,
                      selected_item)

        self._font_family      = font_family
        self._font_height      = font_height
        self._fg_color         = fg_color
        self._bg_color         = bg_color

    def font_family__get(self):
        return self._font_family

    def font_family__set(self, font_family):
        self._font_family = font_family
        self._layout()
        self._update()

    def font_height__get(self):
        return self._font_height

    def font_height__set(self, font_height):
        self._font_height = font_height
        for widget in self.widgets:
            widget.height = font_height

        self._layout()
        self._update()

    def _cache_values(self):
        pass

    def _layout(self):
        pass

    def _update(self):
        pass

    def fg_color__set(self, color):
        self._fg_color = color
        self._layout()
        self._update()

    def bg_color__set(self, color):
        self._bg_color = color
        self._layout()
        self._update()

    def insert(self, index, image_path):
        img=Image()
        fd = os.open(image_path, os.O_RDONLY)
        img.set_from_fd(fd)
        img.visible = True
        img.alignment = pgm.IMAGE_BOTTOM
        img.bg_a = 0
        img.opacity = 0

        List.insert(self, index, img)

# this is a simple example, showing off how the widget looks and behaves
if __name__ == "__main__":
    import pgm, gobject
    from pypgmtools.timing.implicit import AnimatedObject

    def on_delete(viewport, event):
        pgm.main_quit()

    def on_key_press(viewport,
                     event,
                     gl,
                     widget):

        if event.type == pgm.KEY_PRESS:
            if event.keyval == pgm.KEY_q or event.keyval == pgm.KEY_ESCAPE:
                pgm.main_quit()
            elif event.keyval == pgm.KEY_w:
                widget.y -= step_size
            elif event.keyval == pgm.KEY_s:
                widget.y += step_size
            elif event.keyval == pgm.KEY_a:
                widget.x -= step_size
            elif event.keyval == pgm.KEY_d:
                widget.x += step_size
            elif event.keyval == pgm.KEY_DOWN:
                widget.selected_item += 1
            elif event.keyval == pgm.KEY_UP:
                widget.selected_item -= 1
            elif event.keyval == pgm.KEY_SPACE:
                widget.insert(2, "Kekse")
            elif event.keyval == pgm.KEY_RETURN:
                widget.pop(widget.selected_item)

    # OpenGL viewport creation
    factory = pgm.ViewportFactory('opengl')
    gl = factory.create()
    gl.title = 'ImageList widget-test'

    # Canvas and image drawable creation
    canvas = pgm.Canvas()

    # Bind the canvas to the OpenGL viewport
    gl.set_canvas(canvas)

    img_widget = ImageList(canvas,
                           pgm.DRAWABLE_MIDDLE)
    img_widget.position = (0.2, 0.2, 0.0)
    img_widget.font_family = "Bitstream DejaVu"
    img_widget.font_height = 0.225
    img_widget.fg_color = (255, 255, 255, 255)
    img_widget.bg_color = (0, 0, 0, 0)
    img_widget.width = 1.5
    img_widget.height = 2.5

    for i in range(5):
        img_widget.append("examples/pictures/fluendo.png")

    img_widget.visible_items =5
    img_widget.selected_item = 2
    img_widget.visible = True

    # Let's start a mainloop
    gl.connect('key-press-event',
               on_key_press,
               gl,
               img_widget)
    gl.connect('delete-event', on_delete)
    gobject.timeout_add(15, gl.update)
    pgm.main()
