# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import pgm
from pypgmtools.graph.text import Text
from pypgmtools.widgets.dock import Dock

class VolumeOsd(Dock):

    def __init__(self, canvas, layer, template,
                 width, height, background_image):

        Dock.__init__(self, canvas, layer, width, height, background_image)

        self._template = template
        self._volume_value = 0
        
        inner_width = width * 0.95
        inner_height = height * 0.45
        inner_x = (width - inner_width) / 2.0
        inner_y = (height - inner_height) / 2.0

        self._volume = Text()
        self._volume.label = ""
        self._volume.ellipsize = pgm.TEXT_ELLIPSIZE_END
        self._volume.fg_color = (220, 220, 220, 255)
        self._volume.bg_color = (0, 0, 0, 0)
        self.add(self._volume)
        self._volume.position = (inner_x, inner_y, 0.0)
        self._volume.size = (inner_width, inner_height)
        self._volume.font_height = self._volume.height
        
        self._volume.visible = True
        
    def volume__set(self, value):
        self._volume_value = value
        self._volume.label = self._template % int(value)

    def volume__get(self):
        return self._volume_value
