%{?!python:%define python python}
%{?!pybasever:%{expand:%%define pybasever %(%{__python} -c "import sys ; print sys.version[:3]")}}
%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

%{!?majorminor: %define         majorminor      0.3}
%{!?gstreamer:  %define         gstreamer       gstreamer}

Name:           pigment
Version:        0.3.2
Release:        1
Summary:        Pigment media rendering library

Group:          Applications/Multimedia
License:        LGPL
URL:            https://code.fluendo.com/pigment/trac
Source:         http://www.fluendo.com/elisa/downloads/pigment/%{name}-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Requires:       glib2 >= 2.8.0
Requires:       pango >= 1.8
Requires:       pangocairo >= 1.8
Requires:       %{gstreamer} >= 0.10.0

BuildRequires:  glib2-devel >= 2.8.0
BuildRequires:  pango-devel >= 1.8
BuildRequires:  pangocairo-devel >= 1.8
BuildRequires:  python-devel
BuildRequires:  pygobject2-devel
BuildRequires:  libX11-devel
BuildRequires:  %{gstreamer}-devel >= 0.10.0
BuildRequires:  %{gstreamer}-plugins-base-devel >= 0.10.0
BuildRequires:  python-devel
BuildRequires:  mesa-libGLU-devel
BuildRequires:  gtk-doc

# for gdk-pixbuf
BuildRequires:  gtk2-devel

%description
Pigment media rendering library for writing Media Center software.

%package devel
Summary:        Libraries/include files for Pigment
Group:          Development/Libraries

Requires:       %{name} = %{version}-%{release}
Requires:       glib2-devel >= 2.8.0

%description devel
Pigment media rendering library for writing Media Center software.

This package contains the libraries and includes files necessary to develop
applications and plugins using Pigment.

%prep
%setup -q -n %{name}-%{version}

%build
%configure --enable-gtk-doc
make

%install
rm -rf $RPM_BUILD_ROOT

# Install doc temporarily in order to be included later by rpm
%makeinstall docdir="`pwd`/installed-doc"

# Do not package .la files
find $RPM_BUILD_ROOT%{_libdir} -name "*.la" -exec rm {} \;

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root, -)
%doc AUTHORS COPYING FAQ README LICENSE NEWS TODO ChangeLog
%{_libdir}/libpigment-%{majorminor}.so.*
%{_libdir}/pigment-%{majorminor}/*.so
%{_libdir}/pigment-%{majorminor}/gstreamer/libgstpgmimagesink.so
%{_libdir}/python%{pybasever}/site-packages/*.so
%{python_sitelib}/pgm
%{python_sitelib}/pypgmtools

%files devel
%defattr(-, root, root, -)
%{_includedir}/pigment-%{majorminor}/pgm/*.h
%{_libdir}/libpigment-%{majorminor}.so
%{_libdir}/pkgconfig/pigment-%{majorminor}.pc
%{_datadir}/gtk-doc/html/pigment

%changelog
* Thu Aug 2 2007 Loïc Molinari <loic@fluendo.com>
- adapted to branch 0.3

* Tue Mar 13 2007 Loïc Molinari <loic@fluendo.com>
- adapted to library namespace change
- changed description

* Fri Feb 16 2007 Loïc Molinari <loic@fluendo.com>
- added libX11-devel and libXrandr-devel build requirements

* Thu Feb 01 2007 Loïc Molinari <loic@fluendo.com>
- removed the pygtk2-devel build requirement
- removed the libSDL requirement

* Thu Jan 04 2007 Thomas Vander Stichele <thomas at apestaart dot org>
- fix requires
- fix URL's
- add plugins-base BR
- pull in either pygobject2-devel or pygtk2-devel depending on version

* Thu Nov 09 2006 Loïc Molinari <loic@fluendo.com>
- changed the license

* Thu Nov 09 2006 Thomas Vander Stichele <thomas at apestaart dot org>
- cleaned up
- fixed for 64-bit systems
- get versions from configure.ac

* Wed Nov 08 2006 Loïc Molinari <loic@fluendo.com>
- added the GStreamer video sink plugin

* Thu Oct 31 2006 Christian Schaller <christian@fluendo.com>
- first draft of spec file
