/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <pgm/pgm.h>
#include "pgmglviewport.h"

GST_DEBUG_CATEGORY (pgm_gl_debug);
#define GST_CAT_DEFAULT pgm_gl_debug

/* Private functions */

static gboolean
pgm_gl_init (void)
{
  GST_DEBUG_CATEGORY_INIT (pgm_gl_debug, "gl", 0, "opengl viewport");
  return TRUE;
}

/* Pigment plugin entry point */

PGM_PLUGIN_DEFINE
(
  (PgmPluginInitFunc) pgm_gl_init, NULL,
  (PgmPluginCreateFunc) pgm_gl_viewport_new,
  "opengl", "An OpenGL viewport", "LGPL",
  "https://code.fluendo.com/pigment/trac",
  "Loïc Molinari <loic@fluendo.com>"
)
