/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GL_DEFS_H__
#define __PGM_GL_DEFS_H__

#if defined(G_OS_WIN32)
#include <stddef.h>
#define PGM_GL_API_ATTRIBUTE __stdcall
#elif defined(G_OS_UNIX)
#define PGM_GL_API_ATTRIBUTE
#endif /* defined(G_OS_WIN32) */

G_BEGIN_DECLS

/* OpenGL feature flags */

#define PGM_GL_FEAT_TEXTURE_RECTANGLE        (1L << 0)
#define PGM_GL_FEAT_TEXTURE_NON_POWER_OF_TWO (1L << 1)
#define PGM_GL_FEAT_TEXTURE_MIRRORED_REPEAT  (1L << 2)
#define PGM_GL_FEAT_TEXTURE_BORDER_CLAMP     (1L << 3)
#define PGM_GL_FEAT_MULTISAMPLE              (1L << 4)
#define PGM_GL_FEAT_MULTISAMPLE_FILTER_HINT  (1L << 5)
#define PGM_GL_FEAT_MULTITEXTURE             (1L << 6)
#define PGM_GL_FEAT_TEXTURE_ENV_COMBINE      (1L << 7)
#define PGM_GL_FEAT_TEXTURE_ENV_DOT3         (1L << 8)
#define PGM_GL_FEAT_FRAGMENT_PROGRAM         (1L << 9)
#define PGM_GL_FEAT_VERTEX_BUFFER_OBJECT     (1L << 10)
#define PGM_GL_FEAT_PIXEL_BUFFER_OBJECT      (1L << 11)
#define PGM_GL_FEAT_PER_PLANE_YCBCR_PROGRAM  (1L << 12)
#define PGM_GL_FEAT_BLEND_COLOR              (1L << 13)
#define PGM_GL_FEAT_PACKED_PIXELS            (1L << 14)
#define PGM_GL_FEAT_MULTI_DRAW_ARRAYS        (1L << 15)
#define PGM_GL_FEAT_FRAMEBUFFER_OBJECT       (1L << 16)
#define PGM_GL_FEAT_COPY_SUB_BUFFER          (1L << 17)

/* OpenGL constant definitions */

#define PGM_GL_FALSE 0x0
#define PGM_GL_TRUE  0x1

#define PGM_GL_NO_ERROR          0x0
#define PGM_GL_INVALID_OPERATION 0x0502

#define PGM_GL_VENDOR     0x1F00
#define PGM_GL_RENDERER   0x1F01
#define PGM_GL_VERSION    0x1F02
#define PGM_GL_EXTENSIONS 0x1F03

#define PGM_GL_UNSIGNED_BYTE 0x1401

#define PGM_GL_MODELVIEW  0x1700
#define PGM_GL_PROJECTION 0x1701

#define PGM_GL_SHORT  0x1402
#define PGM_GL_INT    0x1404
#define PGM_GL_FLOAT  0x1406
#define PGM_GL_DOUBLE 0x140A

#define PGM_GL_POINTS         0x0000
#define PGM_GL_LINES          0x0001
#define PGM_GL_LINE_LOOP      0x0002
#define PGM_GL_LINE_STRIP     0x0003
#define PGM_GL_TRIANGLES      0x0004
#define PGM_GL_TRIANGLE_STRIP 0x0005
#define PGM_GL_TRIANGLE_FAN   0x0006
#define PGM_GL_QUADS          0x0007
#define PGM_GL_QUAD_STRIP     0x0008
#define PGM_GL_POLYGON        0x0009

#define PGM_GL_VERTEX_ARRAY        0x8074
#define PGM_GL_TEXTURE_COORD_ARRAY 0x8078

#define PGM_GL_FILL      0x1B02
#define PGM_GL_FRONT     0x0404
#define PGM_GL_BACK      0x0405
#define PGM_GL_CULL_FACE 0x0B44

#define PGM_GL_POINT_SMOOTH   0x0B10
#define PGM_GL_LINE_SMOOTH    0x0B20
#define PGM_GL_POLYGON_SMOOTH 0x0B41

#define PGM_GL_SCISSOR_TEST 0x0C11

#define PGM_GL_MAX_TEXTURE_SIZE  0x0D33
#define PGM_GL_MAX_VIEWPORT_DIMS 0x0D3A

#define PGM_GL_TEXTURE_WIDTH        0x1000
#define PGM_GL_TEXTURE_HEIGHT       0x1001
#define PGM_GL_TEXTURE_BORDER_COLOR 0x1004

#define PGM_GL_TEXTURE_BINDING_2D        0x8069
#define PGM_GL_TEXTURE_BINDING_RECTANGLE 0x84F6

#define PGM_GL_TEXTURE_ENV        0x2300
#define PGM_GL_TEXTURE_ENV_MODE   0x2200
#define PGM_GL_TEXTURE_2D         0x0DE1
#define PGM_GL_PROXY_TEXTURE_2D   0x8064
#define PGM_GL_TEXTURE_WRAP_S     0x2802
#define PGM_GL_TEXTURE_WRAP_T     0x2803
#define PGM_GL_TEXTURE_MAG_FILTER 0x2800
#define PGM_GL_TEXTURE_MIN_FILTER 0x2801
#define PGM_GL_TEXTURE_ENV_COLOR  0x2201
#define PGM_GL_TEXTURE_GEN_S      0x0C60
#define PGM_GL_TEXTURE_GEN_T      0x0C61
#define PGM_GL_TEXTURE_GEN_MODE   0x2500
#define PGM_GL_EYE_LINEAR         0x2400
#define PGM_GL_EYE_PLANE          0x2502
#define PGM_GL_S                  0x2000
#define PGM_GL_T                  0x2001

#define PGM_GL_MODULATE           0x2100
#define PGM_GL_NEAREST            0x2600
#define PGM_GL_LINEAR             0x2601
#define PGM_GL_CLAMP              0x2900
#define PGM_GL_REPEAT             0x2901
#define PGM_GL_CLAMP_TO_EDGE      0x812F
#define PGM_GL_CLAMP_TO_BORDER    0x812D
#define PGM_GL_TEXTURE_RED_SIZE   0x805C
#define PGM_GL_TEXTURE_GREEN_SIZE 0x805D
#define PGM_GL_TEXTURE_BLUE_SIZE  0x805E
#define PGM_GL_TEXTURE_ALPHA_SIZE 0x805F

#define PGM_GL_NEAREST_MIPMAP_NEAREST 0x2700
#define PGM_GL_LINEAR_MIPMAP_NEAREST  0x2701
#define PGM_GL_NEAREST_MIPMAP_LINEAR  0x2702
#define PGM_GL_LINEAR_MIPMAP_LINEAR   0x2703

#define PGM_GL_TEXTURE   0x1702
#define PGM_GL_SRC_COLOR 0x0300

#define PGM_GL_COMBINE        0x8570
#define PGM_GL_COMBINE_RGB    0x8571
#define PGM_GL_COMBINE_ALPHA  0x8572
#define PGM_GL_SOURCE0_RGB    0x8580
#define PGM_GL_SOURCE1_RGB    0x8581
#define PGM_GL_SOURCE2_RGB    0x8582
#define PGM_GL_SOURCE0_ALPHA  0x8588
#define PGM_GL_SOURCE1_ALPHA  0x8589
#define PGM_GL_SOURCE2_ALPHA  0x858A
#define PGM_GL_OPERAND0_RGB   0x8590
#define PGM_GL_OPERAND1_RGB   0x8591
#define PGM_GL_OPERAND2_RGB   0x8592
#define PGM_GL_OPERAND0_ALPHA 0x8598
#define PGM_GL_OPERAND1_ALPHA 0x8599
#define PGM_GL_OPERAND2_ALPHA 0x859A
#define PGM_GL_RGB_SCALE      0x8573
#define PGM_GL_ADD_SIGNED     0x8574
#define PGM_GL_INTERPOLATE    0x8575
#define PGM_GL_SUBTRACT       0x84E7
#define PGM_GL_CONSTANT       0x8576
#define PGM_GL_PRIMARY_COLOR  0x8577
#define PGM_GL_PREVIOUS       0x8578
#define PGM_GL_DOT3_RGB       0x86AE
#define PGM_GL_DOT3_RGBA      0x86AF

#define PGM_GL_STENCIL_TEST 0x0B90
#define PGM_GL_KEEP         0x1E00
#define PGM_GL_REPLACE      0x1E01
#define PGM_GL_INCR         0x1E02
#define PGM_GL_DECR         0x1E03

#define PGM_GL_LESS       0x0201
#define PGM_GL_EQUAL      0x0202
#define PGM_GL_LEQUAL     0x0203
#define PGM_GL_ALWAYS     0x0207
#define PGM_GL_DEPTH_TEST 0x0B71

#define PGM_GL_DEPTH_BUFFER_BIT   0x00000100
#define PGM_GL_STENCIL_BUFFER_BIT 0x00000400
#define PGM_GL_VIEWPORT_BIT       0x00000800
#define PGM_GL_TRANSFORM_BIT      0x00001000
#define PGM_GL_COLOR_BUFFER_BIT   0x00004000
#define PGM_GL_LIST_BIT           0x00020000

#define PGM_GL_STENCIL_INDEX   0x1901
#define PGM_GL_DEPTH_COMPONENT 0x1902

#define PGM_GL_ALPHA           0x1906
#define PGM_GL_RGB             0x1907
#define PGM_GL_LUMINANCE       0x1909
#define PGM_GL_LUMINANCE_ALPHA 0x190A
#define PGM_GL_COLOR           0x1800
#define PGM_GL_DITHER          0x0BD0
#define PGM_GL_RGBA            0x1908
#define PGM_GL_BGR             0x80E0
#define PGM_GL_BGRA            0x80E1

#define PGM_GL_MODELVIEW_MATRIX  0x0BA6
#define PGM_GL_PROJECTION_MATRIX 0x0BA7

#define PGM_GL_FRONT_AND_BACK 0x0408
#define PGM_GL_FLAT           0x1D00
#define PGM_GL_SMOOTH         0x1D01

#define PGM_GL_BLEND               0x0BE2
#define PGM_GL_ZERO                0x0000
#define PGM_GL_ONE                 0x0001
#define PGM_GL_ONE_MINUS_SRC_COLOR 0x0301
#define PGM_GL_SRC_ALPHA           0x0302
#define PGM_GL_ONE_MINUS_SRC_ALPHA 0x0303
#define PGM_GL_DST_ALPHA           0x0304
#define PGM_GL_ONE_MINUS_DST_ALPHA 0x0305
#define PGM_GL_SRC_ALPHA_SATURATE  0x0308
#define PGM_GL_CONSTANT_COLOR      0x8001

#define PGM_GL_PACK_ALIGNMENT     0x0D05
#define PGM_GL_PACK_LSB_FIRST     0x0D01
#define PGM_GL_PACK_ROW_LENGTH    0x0D02
#define PGM_GL_PACK_SKIP_PIXELS   0x0D04
#define PGM_GL_PACK_SKIP_ROWS     0x0D03
#define PGM_GL_UNPACK_ALIGNMENT   0x0CF5
#define PGM_GL_UNPACK_LSB_FIRST   0x0CF1
#define PGM_GL_UNPACK_ROW_LENGTH  0x0CF2
#define PGM_GL_UNPACK_SKIP_PIXELS 0x0CF4
#define PGM_GL_UNPACK_SKIP_ROWS   0x0CF3

#define PGM_GL_PERSPECTIVE_CORRECTION_HINT 0x0C50
#define PGM_GL_FASTEST                     0x1101
#define PGM_GL_NICEST                      0x1102

#define PGM_GL_COMPILE 0x1300

#define PGM_GL_TEXTURE_RECTANGLE          0x84F5
#define PGM_GL_PROXY_TEXTURE_RECTANGLE    0x84F7
#define PGM_GL_MAX_RECTANGLE_TEXTURE_SIZE 0x84F8

#define PGM_GL_MIRRORED_REPEAT 0x8370

#define PGM_GL_TEXTURE0          0x84C0
#define PGM_GL_TEXTURE1          0x84C1
#define PGM_GL_TEXTURE2          0x84C2
#define PGM_GL_ACTIVE_TEXTURE    0x84E0
#define PGM_GL_MAX_TEXTURE_UNITS 0x84E2

#define PGM_GL_MULTISAMPLE 0x809D

#define PGM_GL_MULTISAMPLE_FILTER_HINT 0x8534

#define PGM_GL_FRAGMENT_PROGRAM                    0x8804
#define PGM_GL_PROGRAM_STRING                      0x8628
#define PGM_GL_PROGRAM_FORMAT_ASCII                0x8875
#define PGM_GL_PROGRAM_ERROR_POSITION              0x864B
#define PGM_GL_MAX_PROGRAM_LOCAL_PARAMETERS        0x88B4
#define PGM_GL_PROGRAM_INSTRUCTIONS                0x88A0
#define PGM_GL_MAX_PROGRAM_INSTRUCTIONS            0x88A1
#define PGM_GL_PROGRAM_NATIVE_INSTRUCTIONS         0x88A2
#define PGM_GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS     0x88A3
#define PGM_GL_PROGRAM_PARAMETERS                  0x88A8
#define PGM_GL_MAX_PROGRAM_PARAMETERS              0x88A9
#define PGM_GL_PROGRAM_NATIVE_PARAMETERS           0x88AA
#define PGM_GL_MAX_PROGRAM_NATIVE_PARAMETERS       0x88AB
#define PGM_GL_PROGRAM_UNDER_NATIVE_LIMITS         0x88B6
#define PGM_GL_PROGRAM_ALU_INSTRUCTIONS            0x8805
#define PGM_GL_PROGRAM_TEX_INSTRUCTIONS            0x8806
#define PGM_GL_PROGRAM_TEX_INDIRECTIONS            0x8807
#define PGM_GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS     0x8808
#define PGM_GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS     0x8809
#define PGM_GL_PROGRAM_NATIVE_TEX_INDIRECTIONS     0x880A
#define PGM_GL_MAX_PROGRAM_ALU_INSTRUCTIONS        0x880B
#define PGM_GL_MAX_PROGRAM_TEX_INSTRUCTIONS        0x880C
#define PGM_GL_MAX_PROGRAM_TEX_INDIRECTIONS        0x880D
#define PGM_GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS 0x880E
#define PGM_GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS 0x880F
#define PGM_GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS 0x8810

#define PGM_GL_MAX_TEXTURE_IMAGE_UNITS 0x8872
#define PGM_GL_FRAGMENT_SHADER         0x8B30
#define PGM_GL_VERTEX_SHADER           0x8B31
#define PGM_GL_OBJECT_INFO_LOG_LENGTH  0x8B84
#define PGM_GL_PROGRAM_OBJECT          0x8B40
#define PGM_GL_OBJECT_DELETE_STATUS    0x8B80
#define PGM_GL_OBJECT_COMPILE_STATUS   0x8B81
#define PGM_GL_OBJECT_LINK_STATUS      0x8B82
#define PGM_GL_OBJECT_VALIDATE_STATUS  0x8B83

#define PGM_GL_ARRAY_BUFFER        0x8892
#define PGM_GL_PIXEL_PACK_BUFFER   0x88EB
#define PGM_GL_PIXEL_UNPACK_BUFFER 0x88EC

#define PGM_GL_STREAM_DRAW  0x88E0
#define PGM_GL_STREAM_READ  0x88E1
#define PGM_GL_STREAM_COPY  0x88E2
#define PGM_GL_STATIC_DRAW  0x88E4
#define PGM_GL_STATIC_READ  0x88E5
#define PGM_GL_STATIC_COPY  0x88E6
#define PGM_GL_DYNAMIC_DRAW 0x88E8
#define PGM_GL_DYNAMIC_READ 0x88E9
#define PGM_GL_DYNAMIC_COPY 0x88EA

#define PGM_GL_READ_ONLY  0x88B8
#define PGM_GL_WRITE_ONLY 0x88B9
#define PGM_GL_READ_WRITE 0x88BA

#define PGM_GL_FRAMEBUFFER  0x8D40
#define PGM_GL_RENDERBUFFER 0x8D41

#define PGM_GL_COLOR_ATTACHMENT0  0x8CE0
#define PGM_GL_COLOR_ATTACHMENT1  0x8CE1
#define PGM_GL_DEPTH_ATTACHMENT   0x8D00
#define PGM_GL_STENCIL_ATTACHMENT 0x8D20

#define PGM_GL_FRAMEBUFFER_COMPLETE                        0x8CD5
#define PGM_GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT           0x8CD6
#define PGM_GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT   0x8CD7
#define PGM_GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT 0x8CD8
#define PGM_GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS           0x8CD9
#define PGM_GL_FRAMEBUFFER_INCOMPLETE_FORMATS              0x8CDA
#define PGM_GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER          0x8CDB
#define PGM_GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER          0x8CDC
#define PGM_GL_FRAMEBUFFER_UNSUPPORTED                     0x8CDD
#define PGM_GL_FRAMEBUFFER_STATUS_ERROR                    0x8CDE

#define PGM_GL_RENDERBUFFER_RED_SIZE     0x8D50
#define PGM_GL_RENDERBUFFER_GREEN_SIZE   0x8D51
#define PGM_GL_RENDERBUFFER_BLUE_SIZE    0x8D52
#define PGM_GL_RENDERBUFFER_ALPHA_SIZE   0x8D53
#define PGM_GL_RENDERBUFFER_DEPTH_SIZE   0x8D54
#define PGM_GL_RENDERBUFFER_STENCIL_SIZE 0x8D55

/* OpenGL type definitions */

typedef unsigned int   PgmGlEnum;
typedef unsigned char  PgmGlBoolean;
typedef char           PgmGlChar;
typedef unsigned int   PgmGlHandle;
typedef void           PgmGlVoid;
typedef int            PgmGlInt;
typedef unsigned int   PgmGlUint;
typedef int            PgmGlSizei;
typedef double         PgmGlDouble;
typedef float          PgmGlFloat;
typedef unsigned short PgmGlUshort;
typedef short          PgmGlShort;
typedef unsigned int   PgmGlBitfield;
typedef double         PgmGlClampd;
typedef float          PgmGlClampf;
typedef unsigned char  PgmGlUbyte;
typedef ptrdiff_t      PgmGlIntptr;
typedef ptrdiff_t      PgmGlSizeiptr;

/* OpenGL function definitions */

typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_enable) (PgmGlEnum cap);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_disable) (PgmGlEnum cap);
typedef PgmGlEnum (PGM_GL_API_ATTRIBUTE * pgm_gl_get_error) (PgmGlVoid);
typedef PgmGlUbyte *(PGM_GL_API_ATTRIBUTE * pgm_gl_get_string)
  (PgmGlEnum name);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_begin) (PgmGlEnum mode);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_end) (PgmGlVoid);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_vertex_3f)
  (PgmGlFloat x, PgmGlFloat y, PgmGlFloat z);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_coord_2f)
  (PgmGlFloat s, PgmGlFloat t);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_enable_client_state)
  (PgmGlEnum cap);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_disable_client_state)
  (PgmGlEnum cap);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_vertex_pointer)
  (PgmGlInt size, PgmGlEnum type, PgmGlSizei stride, const PgmGlVoid *ptr);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_coord_pointer)
  (PgmGlInt size, PgmGlEnum type, PgmGlSizei stride, const PgmGlVoid *ptr);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_draw_arrays)
  (PgmGlEnum mode, PgmGlInt first, PgmGlSizei count);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_multi_draw_arrays)
  (PgmGlEnum mode, PgmGlInt *first, PgmGlSizei *count, PgmGlSizei primcount);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_env_f)
  (PgmGlEnum target, PgmGlEnum pname, PgmGlFloat param);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_env_fv)
  (PgmGlEnum target, PgmGlEnum pname, const PgmGlFloat *params);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_gen_i)
  (PgmGlEnum coord, PgmGlEnum pname, PgmGlInt param);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_gen_fv)
  (PgmGlEnum coord, PgmGlEnum pname, const PgmGlFloat *params);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_scissor)
  (PgmGlInt x, PgmGlInt y, PgmGlSizei width, PgmGlSizei height);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_color_4f)
  (PgmGlUshort red, PgmGlUshort green, PgmGlUshort blue, PgmGlUshort alpha);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_color_4fv)
  (const PgmGlFloat *v);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_depth_func)
  (PgmGlEnum function);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_blend_func)
  (PgmGlEnum sfactor, PgmGlEnum dfactor);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_blend_color)
  (PgmGlClampf red, PgmGlClampf green, PgmGlClampf blue, PgmGlClampf alpha);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_line_width)
  (PgmGlFloat width);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_clear) (PgmGlBitfield mask);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_clear_color)
  (PgmGlClampf red, PgmGlClampf green, PgmGlClampf blue, PgmGlClampf alpha);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_clear_stencil) (PgmGlInt s);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_stencil_func)
  (PgmGlEnum func, PgmGlInt ref, PgmGlUint mask);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_stencil_op)
  (PgmGlEnum fail, PgmGlEnum zfail, PgmGlEnum zpass);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_push_attrib)
  (PgmGlBitfield mask);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_pop_attrib) (PgmGlVoid);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_matrix_mode) (PgmGlEnum mode);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_push_matrix) (PgmGlVoid);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_pop_matrix) (PgmGlVoid);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_load_identity) (PgmGlVoid);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_load_matrix_f)
  (const PgmGlFloat *m);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_depth_range)
  (PgmGlClampd near_val, PgmGlClampd far_val);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_viewport)
  (PgmGlInt x, PgmGlInt y, PgmGlSizei width, PgmGlSizei height);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_raster_pos_2f)
  (PgmGlFloat x, PgmGlFloat y);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_bitmap)
  (PgmGlSizei width, PgmGlSizei height, PgmGlFloat xorig, PgmGlFloat yorig,
   PgmGlFloat xmove, PgmGlFloat ymove, const PgmGlUbyte *bitmap);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_read_buffer) (PgmGlEnum mode);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_draw_buffer) (PgmGlEnum mode);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_copy_pixels)
  (PgmGlInt x, PgmGlInt y, PgmGlSizei width, PgmGlSizei height,
   PgmGlEnum type);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_flush) (PgmGlVoid);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_finish) (PgmGlVoid);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_pixel_store_i)
  (PgmGlEnum pname, PgmGlInt param);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_frustum)
  (PgmGlDouble left, PgmGlDouble right, PgmGlDouble bottom, PgmGlDouble top,
   PgmGlDouble near_val, PgmGlDouble far_val);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_ortho)
  (PgmGlDouble left, PgmGlDouble right, PgmGlDouble bottom, PgmGlDouble top,
   PgmGlDouble near_val, PgmGlDouble far_val);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_scale_f)
  (PgmGlFloat x, PgmGlFloat y, PgmGlFloat z);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_translate_f)
  (PgmGlFloat x, PgmGlFloat y, PgmGlFloat z);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_rotate_f)
  (PgmGlFloat angle, PgmGlFloat x, PgmGlFloat y, PgmGlFloat z);
typedef PgmGlBoolean (PGM_GL_API_ATTRIBUTE * pgm_gl_is_list) (PgmGlUint list);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_delete_lists)
  (PgmGlUint list, PgmGlSizei range);
typedef PgmGlUint (PGM_GL_API_ATTRIBUTE * pgm_gl_gen_lists) (PgmGlSizei range);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_new_list)
  (PgmGlUint list, PgmGlEnum mode);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_end_list) (PgmGlVoid);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_call_list) (PgmGlUint list);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_call_lists)
  (PgmGlSizei n, PgmGlEnum type, const PgmGlVoid *lists);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_list_base) (PgmGlUint base);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_hint)
  (PgmGlEnum target, PgmGlEnum mode);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_depth_mask)
  (PgmGlBoolean flag);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_polygon_mode)
  (PgmGlEnum face, PgmGlEnum mode);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_shade_model) (PgmGlEnum mode);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_color_mask)
  (PgmGlBoolean red, PgmGlBoolean green, PgmGlBoolean blue,
   PgmGlBoolean alpha);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_read_pixels)
  (PgmGlInt x, PgmGlInt y, PgmGlSizei width, PgmGlSizei height,
   PgmGlEnum format, PgmGlEnum type, PgmGlVoid *pixels);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_get_tex_image)
  (PgmGlEnum target, PgmGlInt level, PgmGlEnum format, PgmGlEnum type,
   PgmGlVoid *pixels);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_sub_image_2d)
  (PgmGlEnum target, PgmGlInt level, PgmGlInt xoffset, PgmGlInt yoffset,
   PgmGlSizei width, PgmGlSizei height, PgmGlEnum format, PgmGlEnum type,
   const PgmGlVoid *pixels);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_gen_textures)
  (PgmGlSizei n, PgmGlUint *textures);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_delete_textures)
  (PgmGlSizei n, const PgmGlUint *textures);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_bind_texture)
  (PgmGlEnum target, PgmGlUint texture);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_image_2d)
  (PgmGlEnum target, PgmGlInt level, PgmGlInt internal_format,
   PgmGlSizei width, PgmGlSizei height, PgmGlInt border, PgmGlEnum format,
   PgmGlEnum type, const PgmGlVoid *pixels);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_tex_parameter_i)
  (PgmGlEnum target, PgmGlEnum pname, PgmGlInt param);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_copy_tex_sub_image_2d)
  (PgmGlEnum target, PgmGlInt level, PgmGlInt xoffset, PgmGlInt yoffset,
   PgmGlInt x, PgmGlInt y, PgmGlSizei width, PgmGlSizei height);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_get_integer_v)
  (PgmGlEnum pname, PgmGlInt *params);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_get_float_v)
  (PgmGlEnum pname, PgmGlFloat *params);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_get_pointer_v)
  (PgmGlEnum pname, PgmGlVoid **params);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_active_texture) (PgmGlEnum);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_client_active_texture)
  (PgmGlEnum);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_gen_programs)
  (PgmGlSizei, PgmGlUint *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_delete_programs)
  (PgmGlSizei, const PgmGlUint *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_program_string)
  (PgmGlEnum, PgmGlEnum, PgmGlSizei, const PgmGlVoid *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_bind_program)
  (PgmGlEnum, PgmGlUint);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_program_local_param_4fv)
  (PgmGlEnum, PgmGlUint, const PgmGlFloat *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_get_program_iv)
  (PgmGlEnum, PgmGlEnum, PgmGlInt *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_gen_buffers)
  (PgmGlSizei, PgmGlUint *buffers);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_delete_buffers)
  (PgmGlSizei, const PgmGlUint *buffers);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_bind_buffer)
  (PgmGlEnum, PgmGlUint buffer);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_buffer_data)
  (PgmGlEnum, PgmGlSizeiptr, const PgmGlVoid *, PgmGlEnum);
typedef PgmGlVoid *(PGM_GL_API_ATTRIBUTE * pgm_gl_buffer_sub_data)
  (PgmGlEnum, PgmGlIntptr, PgmGlSizeiptr, const PgmGlVoid *);
typedef PgmGlVoid *(PGM_GL_API_ATTRIBUTE * pgm_gl_get_buffer_sub_data)
  (PgmGlEnum, PgmGlIntptr, PgmGlSizeiptr, PgmGlVoid *);
typedef PgmGlVoid *(PGM_GL_API_ATTRIBUTE * pgm_gl_map_buffer)
  (PgmGlEnum, PgmGlEnum);
typedef PgmGlBoolean (PGM_GL_API_ATTRIBUTE * pgm_gl_unmap_buffer)
  (PgmGlEnum);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_gen_framebuffers)
  (PgmGlSizei, PgmGlUint *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_delete_framebuffers)
  (PgmGlSizei, const PgmGlUint *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_bind_framebuffer)
  (PgmGlEnum, PgmGlUint);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_framebuffer_renderbuffer)
  (PgmGlEnum, PgmGlEnum, PgmGlEnum, PgmGlUint);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_framebuffer_texture_2d)
  (PgmGlEnum, PgmGlEnum, PgmGlEnum, PgmGlUint, PgmGlInt);
typedef PgmGlEnum (PGM_GL_API_ATTRIBUTE * pgm_gl_check_framebuffer_status)
  (PgmGlEnum);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_gen_renderbuffers)
  (PgmGlSizei, PgmGlUint *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_delete_renderbuffers)
  (PgmGlSizei, const PgmGlUint *);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_bind_renderbuffer)
  (PgmGlEnum, PgmGlUint);
typedef PgmGlVoid (PGM_GL_API_ATTRIBUTE * pgm_gl_renderbuffer_storage)
  (PgmGlEnum, PgmGlEnum, PgmGlSizei, PgmGlSizei);
typedef PgmGlVoid
(PGM_GL_API_ATTRIBUTE * pgm_gl_get_renderbuffer_parameter_iv)
  (PgmGlEnum, PgmGlEnum, PgmGlInt *);

G_BEGIN_DECLS

#endif /* __PGM_GL_DEFS_H__ */
