/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GL_VIEWPORT_H__
#define __PGM_GL_VIEWPORT_H__

/* pgmglviewport.h and pgmcontext.h/pgmgldrawable.h include eachother */
typedef struct _PgmGlViewport      PgmGlViewport;
typedef struct _PgmGlViewportClass PgmGlViewportClass;

#include "pgmcontext.h"
#include "pgmgldrawable.h"

G_BEGIN_DECLS

#define PGM_TYPE_GL_VIEWPORT (pgm_gl_viewport_get_type())
#define PGM_GL_VIEWPORT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GL_VIEWPORT, PgmGlViewport))
#define PGM_GL_VIEWPORT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GL_VIEWPORT, PgmGlViewportClass))
#define PGM_IS_GL_VIEWPORT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GL_VIEWPORT))
#define PGM_IS_GL_VIEWPORT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GL_VIEWPORT))
#define PGM_GL_VIEWPORT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GL_VIEWPORT, PgmGlViewportClass))

/* FIXME: Hardly maintainable */
#define PROPERTY_CHANGED_COUNT 31

typedef void (*PgmGlDrawableChangedFunc) (PgmGlDrawable *gldrawable);

struct _PgmGlViewport {
  PgmViewport parent;

  /* Canvas bound */
  PgmCanvas *canvas;

  /* Signal handler IDs */
  gulong add_handler;
  gulong remove_handler;
  gulong reorder_handler;
  gulong regenerated_handler;

  /* PgmGlDrawable layer lists */
  GList  *far;
  GList  *middle;
  GList  *near;
  GMutex *layer_lock;

  /* PgmDrawable/PgmGlDrawable lookup hash */
  GHashTable *drawable_hash;

  /* OpenGL context */
  PgmContext *context;

  /* Update task queue */
  GSList *update_queue;
  GMutex *update_lock;
};

struct _PgmGlViewportClass {
  PgmViewportClass parent_class;

  /* Drawable changed function pointers */
  PgmGlDrawableChangedFunc changed_func[PROPERTY_CHANGED_COUNT];
};

GType        pgm_gl_viewport_get_type                   (void) G_GNUC_CONST;

PgmViewport *pgm_gl_viewport_new                        (void);

void         pgm_gl_viewport_flush_update_queue         (PgmGlViewport *glviewport);

void         pgm_gl_viewport_update_drawable_projection (PgmGlViewport *glviewport);

G_END_DECLS

#endif /* __PGM_GL_VIEWPORT_H__ */
