/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLX_BACKEND_H__
#define __PGM_GLX_BACKEND_H__

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <GL/glx.h>
#include "pgmbackend.h"

G_BEGIN_DECLS

#define PGM_TYPE_GLX_BACKEND (pgm_glx_backend_get_type ())
#define PGM_GLX_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLX_BACKEND, PgmGlxBackend))
#define PGM_GLX_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLX_BACKEND, PgmGlxBackendClass))
#define PGM_IS_GLX_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLX_BACKEND))
#define PGM_IS_GLX_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLX_BACKEND))
#define PGM_GLX_BACKEND_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLX_BACKEND, PgmGlxBackendClass))

/* GLX feature flags */
#define PGM_GLX_FEAT_FBCONFIG          (1 << 0)
#define PGM_GLX_FEAT_VIDEO_SYNC        (1 << 1)
#define PGM_GLX_FEAT_SWAP_CONTROL      (1 << 2)
#define PGM_GLX_FEAT_DIRECT_RENDERING  (1 << 3)

typedef struct _PgmGlxBackend            PgmGlxBackend;
typedef struct _PgmGlxBackendClass       PgmGlxBackendClass;
typedef struct _PgmGlxBackendSource      PgmGlxBackendSource;
typedef struct _PgmGlxBackendProcAddress PgmGlxBackendProcAddress;

typedef enum {
  PGM_VBLANK_NONE,
  PGM_VBLANK_SWAP_CONTROL,
  PGM_VBLANK_VIDEO_SYNC
} PgmGlxBackendVBlank;

struct _PgmGlxBackend {
  PgmBackend parent;

  /* X connection and window management */
  Display     *dpy;
  XVisualInfo *vi;
  Window       win;
  gint         screen;
  gint         root;
  XSetWindowAttributes attr;

  /* OpenGL context handling */
  GLXContext   ctx;
  GLXFBConfig *fbconfig;
  gint         nbconfigs;

  /* GLX informations */
  const gchar *vendor;
  const gchar *extensions;
  gfloat       version;

  /* GLX features */
  gint feature_mask;

  /* GLX function pointers */
  PgmGlxBackendProcAddress *glx;

  /* Event handling thread */
  GThread      *event_thread;
  GMainContext *event_context;
  GMainLoop    *event_loop;
  guint         event_id;

  /* Display lists to rasterize X fonts (for debugging purpose) */
  guint text_lists;

  /* None cursor */
  Cursor none_cursor;

  /* Screen informations */
  gint resolution_width;
  gint resolution_height;
  gint size_mm_width;
  gint size_mm_height;

  /* Backed up window size */
  gint windowed_width;
  gint windowed_height;

  /* Vertical blanking mode */
  PgmGlxBackendVBlank vblank_mode;

  /* Whether window and context are created */
  gboolean created;

  /* Fullscreen state */
  gboolean fullscreen;
};

struct _PgmGlxBackendClass {
  PgmBackendClass parent_class;
};

/* Event source */
struct _PgmGlxBackendSource {
  GSource source;
  GPollFD poll_fd;

  /* Keep track of the backend */
  PgmGlxBackend *glxbackend;
};

/* GLX function pointers definitions */
typedef GLXFBConfig* (*pgm_glx_choose_fbconfig)          (Display *dpy,
                                                          gint screen,
                                                         const gint *attrib_list,
                                                          gint *nelements);
typedef GLXFBConfig* (*pgm_glx_get_fbconfigs)            (Display *dpy,
                                                          gint screen,
                                                          gint *nelements);
typedef gint         (*pgm_glx_get_fbconfig_attrib)      (Display *dpy,
                                                          GLXFBConfig config,
                                                          gint attribute,
                                                          gint *value);
typedef XVisualInfo* (*pgm_glx_get_visual_from_fbconfig) (Display *dpy,
                                                          GLXFBConfig config);
typedef GLXContext   (*pgm_glx_create_new_context)       (Display *dpy,
                                                          GLXFBConfig config,
                                                          gint render_type,
                                                          GLXContext share_list,
                                                          gboolean direct);
typedef gint         (*pgm_glx_get_video_sync)           (guint *count);
typedef gint         (*pgm_glx_wait_video_sync)          (gint divisor,
                                                          gint remainder,
                                                          guint *count);
typedef gint         (*pgm_glx_swap_interval)            (gint interval);

/* GLX function pointers used for extensions loading */
struct _PgmGlxBackendProcAddress {
  pgm_glx_choose_fbconfig          choose_fbconfig;
  pgm_glx_get_fbconfigs            get_fbconfigs;
  pgm_glx_get_fbconfig_attrib      get_fbconfig_attrib;
  pgm_glx_get_visual_from_fbconfig get_visual_from_fbconfig;
  pgm_glx_create_new_context       create_new_context;
  pgm_glx_get_video_sync           get_video_sync;
  pgm_glx_wait_video_sync          wait_video_sync;
  pgm_glx_swap_interval            swap_interval;
};

GType       pgm_glx_backend_get_type (void) G_GNUC_CONST;

PgmBackend *pgm_glx_backend_new      (PgmContext *context);

G_END_DECLS

#endif /* __PGM_GLX_BACKEND_H__ */
