# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import unittest
import gst
import gc

class PgmTestCase(unittest.TestCase):

    _types = [gst.Object, gst.MiniObject]

    def gccollect(self):
        # run the garbage collector
        ret = 0
        gst.debug('garbage collecting')
        while True:
            c = gc.collect()
            ret += c
            if c == 0: break
        gst.debug('done garbage collecting, %d objects' % ret)
        return ret

    def gctrack(self):
        # store all gst objects in the gc in a tracking dict
        # call before doing any allocation in your test, from setUp
        gst.debug('tracking gc GstObjects for types %r' % self._types)
        self.gccollect()
        self._tracked = {}
        for c in self._types:
            self._tracked[c] = [o for o in gc.get_objects() if isinstance(o, c)]

    def gcverify(self):
        # verify no new gst objects got added to the gc
        # call after doing all cleanup in your test, from tearDown
        gst.debug('verifying gc GstObjects for types %r' % self._types)
        new = []
        for c in self._types:
            objs = [o for o in gc.get_objects() if isinstance(o, c)]
            new.extend([o for o in objs if o not in self._tracked[c]])

        self.failIf(new, "unref-ed objects: %s" % str(new))
        #self.failIf(new, ["%r:%d" % (type(o), id(o)) for o in new])
        del self._tracked

    def setUp(self):
        """
        Override me by chaining up to me at the start of your setUp.
        """
        self.gctrack()

    def tearDown(self):
        """
        Override me by chaining up to me at the end of your tearDown.
        """
        self.gccollect()
        self.gcverify()
