# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import sys
from pgm_test_case import PgmTestCase

class TestPgm(PgmTestCase):

    def test_import(self):
        """ check pgm import wont't fail """
        self.failUnless(__import__('pgm'))

    def test_pgm_version(self):
        """ test version informations retrieval
        """
        import pgm

        version = pgm.version()
        self.failUnless(version)
        self.failUnless(isinstance(version, tuple))
        self.assertEquals(len(version), 4)

        major, minor, micro, nano = version
        self.failUnless(isinstance(major, int))
        self.failUnless(isinstance(minor, int))
        self.failUnless(isinstance(micro, int))
        self.failUnless(isinstance(nano, int))

        version_string = pgm.version_string()
        self.failUnless(version_string)
        self.failUnless(isinstance(version_string, basestring))

        # TODO: test version values ?

##     def test_pgm_viewport_factory(self):
##         """ test viewport creation functions
##         """
##         import pgm

##         viewport = pgm.viewport_factory_make("boilerplate")
##         self.failUnless(isinstance(viewport, pgm.Viewport))

##         del viewport

