  len=instrbuf.s.len/sizeof(p_instr);
  instructions=(p_instr *)instrbuf.s.str;
  instrbuf.s.str=0;
  fifo_len=0;
  init_bytecode();

  for(eye=0;eye<len || fifo_len;)
  {
    INT32 current_line;
    struct pike_string *current_file;

#ifdef PIKE_DEBUG
    if(a_flag>6) {
      int e;
      fprintf(stderr, "#%ld,%d:",
              DO_NOT_WARN((long)eye),
              fifo_len);
      for(e=0;e<4;e++) {
        fprintf(stderr," ");
        dump_instr(instr(e));
      }
      fprintf(stderr,"\n");
    }
#endif

    switch(opcode(0))
    {
    case F_LFUN:
      /* LFUN MARK_X [$2a>0] : MARK_X($2a-1) LFUN($1a) */
      if(F_MARK_X==opcode(1) && argument(1)>0)
      {
        do_optimization(2,
                        2,F_MARK_X,(argument(1)-1), 
                        2,F_LFUN,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_MARK:
      switch(opcode(1))
      {
      case F_STRING:
        /* MARK STRING : MARK_AND_STRING($2a) */
        {
          do_optimization(2,
                          2,F_MARK_AND_STRING,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_LOCAL:
        /* MARK LOCAL [ $3o != F_SIZEOF && $3o != F_INDEX ]: MARK_AND_LOCAL ($2a) */
        if( opcode(2) != F_SIZEOF && opcode(2) != F_INDEX )
        {
          do_optimization(2,
                          2,F_MARK_AND_LOCAL,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_APPLY:
        /* MARK APPLY : MARK_APPLY($2a) */
        {
          do_optimization(2,
                          2,F_MARK_APPLY,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_POP_MARK:
        /* MARK POP_MARK: */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      case F_MARK:
        /* MARK MARK: MARK2 */
        {
          do_optimization(2,
                          1,F_MARK2,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_CALL_LFUN_AND_RETURN:
      /* CALL_LFUN_AND_RETURN !LABEL : CALL_LFUN_AND_RETURN($1a) */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        2,F_CALL_LFUN_AND_RETURN,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_EQ:
      switch(opcode(1))
      {
      case F_NOT:
        /* EQ NOT: NE */
        {
          do_optimization(2,
                          1,F_NE,
                          0);
          continue;
        }
        break;

      case F_LAND:
        /* EQ LAND: EQ_AND ($2a) */
        {
          do_optimization(2,
                          2,F_EQ_AND,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_LOR:
        /* EQ LOR: EQ_OR ($2a) */
        {
          do_optimization(2,
                          2,F_EQ_OR,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* EQ BRANCH_WHEN_ZERO: BRANCH_WHEN_NE ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_NE,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* EQ BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_EQ ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_EQ,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_LTOSVAL2:
      switch(opcode(1))
      {
      case F_ADD_FLOATS:
        /* LTOSVAL2 ADD_FLOATS ASSIGN_AND_POP : ADD_TO_AND_POP */
        if(F_ASSIGN_AND_POP==opcode(2))
        {
          do_optimization(3,
                          1,F_ADD_TO_AND_POP,
                          0);
          continue;
        }
        break;

      case F_ADD_INTS:
        /* LTOSVAL2 ADD_INTS ASSIGN_AND_POP : ADD_TO_AND_POP */
        if(F_ASSIGN_AND_POP==opcode(2))
        {
          do_optimization(3,
                          1,F_ADD_TO_AND_POP,
                          0);
          continue;
        }
        break;

      case F_ADD:
        /* LTOSVAL2 ADD ASSIGN_AND_POP : ADD_TO_AND_POP */
        if(F_ASSIGN_AND_POP==opcode(2))
        {
          do_optimization(3,
                          1,F_ADD_TO_AND_POP,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_STRING:
      switch(opcode(1))
      {
      case F_POP_VALUE:
        /* STRING POP_VALUE : */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      case F_MARK_X:
        /* STRING MARK_X [$2a>0] : MARK_X($2a-1) STRING($1a) */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          2,F_STRING,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_CLEAR_STRING_SUBTYPE:
        /* STRING CLEAR_STRING_SUBTYPE: STRING ($1a) */
        {
          do_optimization(2,
                          2,F_STRING,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_INDEX:
        /* STRING INDEX: STRING_INDEX ($1a) */
        {
          do_optimization(2,
                          2,F_STRING_INDEX,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_LOCAL_ARROW:
      switch(opcode(3))
      {
      case F_ARROW:
        switch(opcode(6))
        {
        case F_LOCAL_ARROW:
          /* LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) ARROW($4a) BRANCH_WHEN_ZERO MARK LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) ARROW($4a) : LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) ARROW($4a) BRANCH_AND_POP_WHEN_ZERO ( $5a ) MARK_X(1)  */
          if(F_ARROW==opcode(1) && F_ARROW==opcode(2) && F_BRANCH_WHEN_ZERO==opcode(4) && F_MARK==opcode(5) && (argument(0))==argument(6) && (argument2(0))==argument2(6) && F_ARROW==opcode(7) && (argument(1))==argument(7) && F_ARROW==opcode(8) && (argument(2))==argument(8) && F_ARROW==opcode(9) && (argument(3))==argument(9))
          {
            do_optimization(10,
                            3,F_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                            2,F_ARROW,(argument(1)), 
                            2,F_ARROW,(argument(2)), 
                            2,F_ARROW,(argument(3)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(4)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        case F_ARROW:
          /* LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) ARROW($4a) BRANCH_WHEN_ZERO LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) ARROW($4a) : LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) ARROW($4a) BRANCH_AND_POP_WHEN_ZERO ( $5a )  */
          if(F_ARROW==opcode(1) && F_ARROW==opcode(2) && F_BRANCH_WHEN_ZERO==opcode(4) && F_LOCAL_ARROW==opcode(5) && (argument(0))==argument(5) && (argument2(0))==argument2(5) && (argument(1))==argument(6) && F_ARROW==opcode(7) && (argument(2))==argument(7) && F_ARROW==opcode(8) && (argument(3))==argument(8))
          {
            do_optimization(9,
                            3,F_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                            2,F_ARROW,(argument(1)), 
                            2,F_ARROW,(argument(2)), 
                            2,F_ARROW,(argument(3)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(4)), 
                            0);
            continue;
          }
          break;

        }
        break;

      case F_BRANCH_WHEN_ZERO:
        switch(opcode(5))
        {
        case F_LOCAL_ARROW:
          /* LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) BRANCH_WHEN_ZERO MARK LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) : LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) BRANCH_AND_POP_WHEN_ZERO ( $4a ) MARK_X(1)  */
          if(F_ARROW==opcode(1) && F_ARROW==opcode(2) && F_MARK==opcode(4) && (argument(0))==argument(5) && (argument2(0))==argument2(5) && F_ARROW==opcode(6) && (argument(1))==argument(6) && F_ARROW==opcode(7) && (argument(2))==argument(7))
          {
            do_optimization(8,
                            3,F_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                            2,F_ARROW,(argument(1)), 
                            2,F_ARROW,(argument(2)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(3)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        case F_ARROW:
          /* LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) BRANCH_WHEN_ZERO LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) : LOCAL_ARROW($1a, $1b) ARROW($2a) ARROW($3a) BRANCH_AND_POP_WHEN_ZERO ( $4a )  */
          if(F_ARROW==opcode(1) && F_ARROW==opcode(2) && F_LOCAL_ARROW==opcode(4) && (argument(0))==argument(4) && (argument2(0))==argument2(4) && (argument(1))==argument(5) && F_ARROW==opcode(6) && (argument(2))==argument(6))
          {
            do_optimization(7,
                            3,F_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                            2,F_ARROW,(argument(1)), 
                            2,F_ARROW,(argument(2)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(3)), 
                            0);
            continue;
          }
          break;

        }
        break;

      case F_MARK:
        /* LOCAL_ARROW($1a, $1b) ARROW($2a) BRANCH_WHEN_ZERO MARK LOCAL_ARROW($1a, $1b) ARROW($2a) : LOCAL_ARROW($1a, $1b) ARROW($2a) BRANCH_AND_POP_WHEN_ZERO ( $3a ) MARK_X(1)  */
        if(F_ARROW==opcode(1) && F_BRANCH_WHEN_ZERO==opcode(2) && F_LOCAL_ARROW==opcode(4) && (argument(0))==argument(4) && (argument2(0))==argument2(4) && F_ARROW==opcode(5) && (argument(1))==argument(5))
        {
          do_optimization(6,
                          3,F_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                          2,F_ARROW,(argument(1)), 
                          2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(2)), 
                          2,F_MARK_X,(1), 
                          0);
          continue;
        }
        break;

      case F_LOCAL_ARROW:
        switch(opcode(2))
        {
        case F_BRANCH_WHEN_ZERO:
          /* LOCAL_ARROW($1a, $1b) ARROW($2a) BRANCH_WHEN_ZERO LOCAL_ARROW($1a, $1b) ARROW($2a) : LOCAL_ARROW($1a, $1b) ARROW($2a) BRANCH_AND_POP_WHEN_ZERO ( $3a )  */
          if(F_ARROW==opcode(1) && (argument(0))==argument(3) && (argument2(0))==argument2(3) && F_ARROW==opcode(4) && (argument(1))==argument(4))
          {
            do_optimization(5,
                            3,F_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                            2,F_ARROW,(argument(1)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(2)), 
                            0);
            continue;
          }
          break;

        case F_MARK:
          /* LOCAL_ARROW($1a, $1b) BRANCH_WHEN_ZERO MARK LOCAL_ARROW($1a, $1b) : LOCAL_ARROW($1a, $1b) BRANCH_AND_POP_WHEN_ZERO ( $2a ) MARK_X(1)  */
          if(F_BRANCH_WHEN_ZERO==opcode(1) && (argument(0))==argument(3) && (argument2(0))==argument2(3))
          {
            do_optimization(4,
                            3,F_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        }
        break;

      }
      /* LOCAL_ARROW($1a, $1b) BRANCH_WHEN_ZERO LOCAL_ARROW($1a, $1b) : LOCAL_ARROW($1a, $1b) BRANCH_AND_POP_WHEN_ZERO ( $2a )  */
      if(F_BRANCH_WHEN_ZERO==opcode(1) && F_LOCAL_ARROW==opcode(2) && (argument(0))==argument(2) && (argument2(0))==argument2(2))
      {
        do_optimization(3,
                        3,F_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                        2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                        0);
        continue;
      }
      /* LOCAL_ARROW BRANCH_WHEN_ZERO: BRANCH_IF_NOT_LOCAL_ARROW($1a,$1b) POINTER($2a) */
      if(F_BRANCH_WHEN_ZERO==opcode(1))
      {
        do_optimization(2,
                        3,F_BRANCH_IF_NOT_LOCAL_ARROW,(argument(0)), (argument2(0)), 
                        2,F_POINTER,(argument(1)), 
                        0);
        continue;
      }
      break;

    case F_2_LOCALS:
      /* 2_LOCALS MARK_X [$2a>0] : LOCAL($1a) MARK_X($2a-1) LOCAL($1b) */
      if(F_MARK_X==opcode(1) && argument(1)>0)
      {
        do_optimization(2,
                        2,F_LOCAL,(argument(0)), 
                        2,F_MARK_X,(argument(1)-1), 
                        2,F_LOCAL,(argument2(0)), 
                        0);
        continue;
      }
      break;

    case F_CONST0:
      switch(opcode(1))
      {
      case F_MARK_X:
        /* CONST0 MARK_X [$2a>0] : MARK_X($2a-1) CONST0 */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          1,F_CONST0,
                          0);
          continue;
        }
        break;

      case F_ADD_INTS:
        /* CONST0 ADD_INTS: ADD_INT (0) */
        {
          do_optimization(2,
                          2,F_ADD_INT,(0), 
                          0);
          continue;
        }
        break;

      case F_NEGATE:
        /* CONST0 NEGATE : CONST0 */
        {
          do_optimization(2,
                          1,F_CONST0,
                          0);
          continue;
        }
        break;

      case F_CLEAR_STRING_SUBTYPE:
        /* CONST0 CLEAR_STRING_SUBTYPE: CONST0 */
        {
          do_optimization(2,
                          1,F_CONST0,
                          0);
          continue;
        }
        break;

      case F_ADD:
        /* CONST0 ADD: ADD_INT (0) */
        {
          do_optimization(2,
                          2,F_ADD_INT,(0), 
                          0);
          continue;
        }
        break;

      case F_INDEX:
        /* CONST0 INDEX: POS_INT_INDEX (0) */
        {
          do_optimization(2,
                          2,F_POS_INT_INDEX,(0), 
                          0);
          continue;
        }
        break;

      case F_RETURN:
        /* CONST0 RETURN: RETURN_0 */
        {
          do_optimization(2,
                          1,F_RETURN_0,
                          0);
          continue;
        }
        break;

      case F_ASSIGN_LOCAL_AND_POP:
        /* CONST0 ASSIGN_LOCAL_AND_POP : CLEAR_LOCAL($2a) */
        {
          do_optimization(2,
                          2,F_CLEAR_LOCAL,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_SUBTRACT:
        /* CONST0 SUBTRACT: */
        {
          do_optimization(2,
                          0);
          continue;
        }
        /* CONST0 SUBTRACT: ADD_INT (0) */
        {
          do_optimization(2,
                          2,F_ADD_INT,(0), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* CONST0 BRANCH_WHEN_NON_ZERO:  */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* CONST0 BRANCH_WHEN_ZERO: BRANCH($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_XOR:
        /* CONST0 XOR: */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_POST_INC_LOCAL:
      /* POST_INC_LOCAL POP_VALUE : INC_LOCAL_AND_POP ($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        2,F_INC_LOCAL_AND_POP,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_TRAMPOLINE:
      /* TRAMPOLINE POP_VALUE : */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        0);
        continue;
      }
      break;

    case F_NUMBER:
      switch(opcode(1))
      {
      case F_MARK_X:
        /* NUMBER MARK_X [$2a>0] : MARK_X($2a-1) NUMBER($1a) */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          2,F_NUMBER,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_ADD_INTS:
        /* NUMBER [$1a >= 0] ADD_INTS : ADD_INT ($1a) */
        if(argument(0) >= 0)
        {
          do_optimization(2,
                          2,F_ADD_INT,(argument(0)), 
                          0);
          continue;
        }
        /* NUMBER [$1a < 0 && ($1a != -$1a)] ADD_INTS : ADD_NEG_INT (-$1a) */
        if(argument(0) < 0 && (argument(0) != -argument(0)))
        {
          do_optimization(2,
                          2,F_ADD_NEG_INT,(-argument(0)), 
                          0);
          continue;
        }
        break;

      case F_NEGATE:
        /* NUMBER NEGATE : NEG_NUMBER($1a) */
        {
          do_optimization(2,
                          2,F_NEG_NUMBER,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_ADD_INT:
        /* NUMBER ADD_INT [ !INT_TYPE_ADD_OVERFLOW($1a, $2a) ] : NUMBER($1a+$2a) */
        if( !INT_TYPE_ADD_OVERFLOW(argument(0), argument(1)) )
        {
          do_optimization(2,
                          2,F_NUMBER,(argument(0)+argument(1)), 
                          0);
          continue;
        }
        break;

      case F_CLEAR_STRING_SUBTYPE:
        /* NUMBER CLEAR_STRING_SUBTYPE: NUMBER($1a) */
        {
          do_optimization(2,
                          2,F_NUMBER,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_ADD:
        /* NUMBER [$1a >= 0] ADD : ADD_INT ($1a) */
        if(argument(0) >= 0)
        {
          do_optimization(2,
                          2,F_ADD_INT,(argument(0)), 
                          0);
          continue;
        }
        /* NUMBER [$1a < 0 && ($1a != -$1a) ] ADD : ADD_NEG_INT (-$1a) */
        if(argument(0) < 0 && (argument(0) != -argument(0)) )
        {
          do_optimization(2,
                          2,F_ADD_NEG_INT,(-argument(0)), 
                          0);
          continue;
        }
        break;

      case F_INDEX:
        /* NUMBER [$1a < 0 && ($1a != -$1a)] INDEX: NEG_INT_INDEX (-$1a) */
        if(argument(0) < 0 && (argument(0) != -argument(0)))
        {
          do_optimization(2,
                          2,F_NEG_INT_INDEX,(-argument(0)), 
                          0);
          continue;
        }
        /* NUMBER [$1a >= 0] INDEX: POS_INT_INDEX ($1a) */
        if(argument(0) >= 0)
        {
          do_optimization(2,
                          2,F_POS_INT_INDEX,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_ADD_NEG_INT:
        /* NUMBER ADD_NEG_INT [ !INT_TYPE_SUB_OVERFLOW($1a, $2a) ]: NUMBER($1a-$2a) */
        if( !INT_TYPE_SUB_OVERFLOW(argument(0), argument(1)) )
        {
          do_optimization(2,
                          2,F_NUMBER,(argument(0)-argument(1)), 
                          0);
          continue;
        }
        break;

      case F_SUBTRACT:
        /* NUMBER [$1a >= 0] SUBTRACT : ADD_NEG_INT ($1a) */
        if(argument(0) >= 0)
        {
          do_optimization(2,
                          2,F_ADD_NEG_INT,(argument(0)), 
                          0);
          continue;
        }
        /* NUMBER [$1a < 0 && ($1a != -$1a)] SUBTRACT : ADD_INT (-$1a) */
        if(argument(0) < 0 && (argument(0) != -argument(0)))
        {
          do_optimization(2,
                          2,F_ADD_INT,(-argument(0)), 
                          0);
          continue;
        }
        break;

      case F_POP_VALUE:
        /* NUMBER POP_VALUE : */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      }
      switch(argument(0))
      {
      case -1:
        /* NUMBER(-1) : CONST_1 */
        {
          do_optimization(1,
                          1,F_CONST_1,
                          0);
          continue;
        }
        break;

      case 1:
        /* NUMBER(1) : CONST1 */
        {
          do_optimization(1,
                          1,F_CONST1,
                          0);
          continue;
        }
        break;

      case 0:
        /* NUMBER(0) : CONST0 */
        {
          do_optimization(1,
                          1,F_CONST0,
                          0);
          continue;
        }
        break;

      }
      /* NUMBER (0x7fffffff) : BIGNUM */
      if((0x7fffffff)==argument(0))
      {
        do_optimization(1,
                        1,F_BIGNUM,
                        0);
        continue;
      }
      /* NUMBER [$1a < 0 && (-$1a)>0] : NEG_NUMBER (-$1a) */
      if(argument(0) < 0 && (-argument(0))>0)
      {
        do_optimization(1,
                        2,F_NEG_NUMBER,(-argument(0)), 
                        0);
        continue;
      }
      break;

    case F_INC_LOCAL_AND_POP:
      switch(opcode(1))
      {
      case F_MARK_AND_LOCAL:
        /* INC_LOCAL_AND_POP MARK_AND_LOCAL ($1a) : MARK INC_LOCAL ($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_MARK,
                          2,F_INC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_GLOBAL:
        /* INC_LOCAL_AND_POP GLOBAL LOCAL ($1a) : GLOBAL($2a) INC_LOCAL ($1a)  */
        if(F_LOCAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_GLOBAL,(argument(1)), 
                          2,F_INC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_LOCAL:
        /* INC_LOCAL_AND_POP LOCAL ($1a) : INC_LOCAL ($1a)  */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          2,F_INC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        /* INC_LOCAL_AND_POP LOCAL LOCAL ($1a) : LOCAL($2a) INC_LOCAL ($1a)  */
        if(F_LOCAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_LOCAL,(argument(1)), 
                          2,F_INC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_INDEX:
      /* INDEX SWITCH: SWITCH_ON_INDEX($2a) */
      if(F_SWITCH==opcode(1))
      {
        do_optimization(2,
                        2,F_SWITCH_ON_INDEX,(argument(1)), 
                        0);
        continue;
      }
      break;

    case F_LOCAL_LOCAL_INDEX:
      switch(opcode(2))
      {
      case F_MARK:
        /* LOCAL_LOCAL_INDEX($1a, $1b) BRANCH_WHEN_ZERO MARK LOCAL_LOCAL_INDEX($1a, $1b) : LOCAL_LOCAL_INDEX($1a, $1b) BRANCH_AND_POP_WHEN_ZERO ( $2a ) MARK_X(1)  */
        if(F_BRANCH_WHEN_ZERO==opcode(1) && F_LOCAL_LOCAL_INDEX==opcode(3) && (argument(0))==argument(3) && (argument2(0))==argument2(3))
        {
          do_optimization(4,
                          3,F_LOCAL_LOCAL_INDEX,(argument(0)), (argument2(0)), 
                          2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                          2,F_MARK_X,(1), 
                          0);
          continue;
        }
        break;

      case F_LOCAL_LOCAL_INDEX:
        /* LOCAL_LOCAL_INDEX($1a, $1b) BRANCH_WHEN_ZERO LOCAL_LOCAL_INDEX($1a, $1b) : LOCAL_LOCAL_INDEX($1a, $1b) BRANCH_AND_POP_WHEN_ZERO ( $2a )  */
        if(F_BRANCH_WHEN_ZERO==opcode(1) && (argument(0))==argument(2) && (argument2(0))==argument2(2))
        {
          do_optimization(3,
                          3,F_LOCAL_LOCAL_INDEX,(argument(0)), (argument2(0)), 
                          2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_INC_LOCAL:
      /* INC_LOCAL POP_VALUE : INC_LOCAL_AND_POP ($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        2,F_INC_LOCAL_AND_POP,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_BRANCH_WHEN_NON_ZERO:
      switch(opcode(1))
      {
      case F_LABEL:
        /* BRANCH_WHEN_NON_ZERO LABEL($1a) : POP_VALUE LABEL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_POP_VALUE,
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH:
        /* BRANCH_WHEN_NON_ZERO BRANCH LABEL ($1a): BRANCH_WHEN_ZERO($2a) LABEL($1a) */
        if(F_LABEL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_BRANCH_WHEN_ZERO,(argument(1)), 
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_POP_N_ELEMS:
      switch(opcode(1))
      {
      case F_RETURN_1:
        /* POP_N_ELEMS RETURN_1: RETURN_1 */
        {
          do_optimization(2,
                          1,F_RETURN_1,
                          0);
          continue;
        }
        break;

      case F_RETURN_0:
        /* POP_N_ELEMS RETURN_0: RETURN_0 */
        {
          do_optimization(2,
                          1,F_RETURN_0,
                          0);
          continue;
        }
        break;

      case F_POP_TO_MARK:
        /* POP_N_ELEMS POP_TO_MARK : POP_TO_MARK */
        {
          do_optimization(2,
                          1,F_POP_TO_MARK,
                          0);
          continue;
        }
        break;

      case F_POP_N_ELEMS:
        /* POP_N_ELEMS POP_N_ELEMS : POP_N_ELEMS ($1a + $2a) */
        {
          do_optimization(2,
                          2,F_POP_N_ELEMS,(argument(0) + argument(1)), 
                          0);
          continue;
        }
        break;

      case F_POP_VALUE:
        /* POP_N_ELEMS POP_VALUE : POP_N_ELEMS ($1a + 1) */
        {
          do_optimization(2,
                          2,F_POP_N_ELEMS,(argument(0) + 1), 
                          0);
          continue;
        }
        break;

      }
      switch(argument(0))
      {
      case 1:
        /* POP_N_ELEMS(1) : POP_VALUE */
        {
          do_optimization(1,
                          1,F_POP_VALUE,
                          0);
          continue;
        }
        break;

      case 0:
        /* POP_N_ELEMS (0) :  */
        {
          do_optimization(1,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_BRANCH_IF_NOT_LOCAL_ARROW:
      /* BRANCH_IF_NOT_LOCAL_ARROW POINTER LABEL ($2a) : LABEL($2a) */
      if(F_POINTER==opcode(1) && F_LABEL==opcode(2) && (argument(1))==argument(2))
      {
        do_optimization(3,
                        2,F_LABEL,(argument(1)), 
                        0);
        continue;
      }
      break;

    case F_CLEAR_2_LOCAL:
      /* CLEAR_2_LOCAL CLEAR_2_LOCAL($1a+2) : CLEAR_4_LOCAL($1a) */
      if(F_CLEAR_2_LOCAL==opcode(1) && (argument(0)+2)==argument(1))
      {
        do_optimization(2,
                        2,F_CLEAR_4_LOCAL,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_NE:
      switch(opcode(1))
      {
      case F_NOT:
        /* NE NOT: EQ */
        {
          do_optimization(2,
                          1,F_EQ,
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* NE BRANCH_WHEN_ZERO: BRANCH_WHEN_EQ ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_EQ,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* NE BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_NE ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_NE,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_POST_INC:
      /* POST_INC POP_VALUE: INC_AND_POP */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        1,F_INC_AND_POP,
                        0);
        continue;
      }
      break;

    case F_RECUR:
      /* RECUR RETURN [check_tailrecursion()]: TAIL_RECUR ($1a) */
      if(F_RETURN==opcode(1) && check_tailrecursion())
      {
        do_optimization(2,
                        2,F_TAIL_RECUR,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_LT:
      switch(opcode(1))
      {
      case F_NOT:
        /* LT NOT: GE */
        {
          do_optimization(2,
                          1,F_GE,
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* LT BRANCH_WHEN_ZERO: BRANCH_WHEN_GE ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_GE,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* LT BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_LT ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_LT,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_INC:
      /* INC POP_VALUE: INC_AND_POP */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        1,F_INC_AND_POP,
                        0);
        continue;
      }
      break;

    case F_NOT:
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        /* NOT BRANCH_WHEN_ZERO: BRANCH_WHEN_NON_ZERO($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_NON_ZERO,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* NOT BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_ZERO($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_ZERO,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_GLOBAL_LVALUE:
      switch(opcode(1))
      {
      case F_DEC_AND_POP:
        /* GLOBAL_LVALUE DEC_AND_POP GLOBAL($1a): GLOBAL_LVALUE($1a) DEC */
        if(F_GLOBAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_GLOBAL_LVALUE,(argument(0)), 
                          1,F_DEC,
                          0);
          continue;
        }
        break;

      case F_INC_AND_POP:
        /* GLOBAL_LVALUE INC_AND_POP GLOBAL($1a): GLOBAL_LVALUE($1a) INC */
        if(F_GLOBAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_GLOBAL_LVALUE,(argument(0)), 
                          1,F_INC,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_GT:
      switch(opcode(1))
      {
      case F_NOT:
        /* GT NOT: LE */
        {
          do_optimization(2,
                          1,F_LE,
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* GT BRANCH_WHEN_ZERO: BRANCH_WHEN_LE ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_LE,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* GT BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_GT ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_GT,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_POST_DEC:
      /* POST_DEC POP_VALUE: DEC_AND_POP */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        1,F_DEC_AND_POP,
                        0);
        continue;
      }
      break;

    case F_LE:
      switch(opcode(1))
      {
      case F_NOT:
        /* LE NOT: GT */
        {
          do_optimization(2,
                          1,F_GT,
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* LE BRANCH_WHEN_ZERO: BRANCH_WHEN_GT ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_GT,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* LE BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_LE ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_LE,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_SIZEOF:
      switch(opcode(2))
      {
      case F_BRANCH_WHEN_LE:
        /* SIZEOF CONST0 BRANCH_WHEN_LE : SIZEOF BRANCH_WHEN_ZERO ($3a) */
        if(F_CONST0==opcode(1))
        {
          do_optimization(3,
                          1,F_SIZEOF,
                          2,F_BRANCH_WHEN_ZERO,(argument(2)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_LT:
        /* SIZEOF CONST1 BRANCH_WHEN_LT : SIZEOF BRANCH_WHEN_ZERO ($3a) */
        if(F_CONST1==opcode(1))
        {
          do_optimization(3,
                          1,F_SIZEOF,
                          2,F_BRANCH_WHEN_ZERO,(argument(2)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_BRANCH_WHEN_ZERO:
      switch(opcode(1))
      {
      case F_LABEL:
        /* BRANCH_WHEN_ZERO LABEL($1a) : POP_VALUE LABEL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_POP_VALUE,
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH:
        /* BRANCH_WHEN_ZERO BRANCH LABEL ($1a): BRANCH_WHEN_NON_ZERO($2a) LABEL($1a) */
        if(F_LABEL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_BRANCH_WHEN_NON_ZERO,(argument(1)), 
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_DEC:
      /* DEC POP_VALUE: DEC_AND_POP */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        1,F_DEC_AND_POP,
                        0);
        continue;
      }
      break;

    case F_GE:
      switch(opcode(1))
      {
      case F_NOT:
        /* GE NOT: LT */
        {
          do_optimization(2,
                          1,F_LT,
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* GE BRANCH_WHEN_ZERO: BRANCH_WHEN_LT ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_LT,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* GE BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_GE ($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_WHEN_GE,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_ASSIGN_LOCAL:
      switch(opcode(3))
      {
      case F_BRANCH_WHEN_NE:
        /* ASSIGN_LOCAL BRANCH_WHEN_ZERO 2_LOCALS(,$1a) BRANCH_WHEN_NE : ASSIGN_LOCAL($1a) BRANCH_AND_POP_WHEN_ZERO($2a) LOCAL($3a) BRANCH_WHEN_NE($4a) */
        if(F_BRANCH_WHEN_ZERO==opcode(1) && F_2_LOCALS==opcode(2) && (argument(0))==argument2(2))
        {
          do_optimization(4,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                          2,F_LOCAL,(argument(2)), 
                          2,F_BRANCH_WHEN_NE,(argument(3)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_EQ:
        /* ASSIGN_LOCAL BRANCH_WHEN_ZERO 2_LOCALS(,$1a) BRANCH_WHEN_EQ : ASSIGN_LOCAL($1a) BRANCH_AND_POP_WHEN_ZERO($2a) LOCAL($3a) BRANCH_WHEN_EQ($4a) */
        if(F_BRANCH_WHEN_ZERO==opcode(1) && F_2_LOCALS==opcode(2) && (argument(0))==argument2(2))
        {
          do_optimization(4,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                          2,F_LOCAL,(argument(2)), 
                          2,F_BRANCH_WHEN_EQ,(argument(3)), 
                          0);
          continue;
        }
        break;

      case F_LOCAL:
        switch(opcode(1))
        {
        case F_BRANCH_WHEN_ZERO:
          /* ASSIGN_LOCAL BRANCH_WHEN_ZERO MARK LOCAL ($1a) : ASSIGN_LOCAL ($1a) BRANCH_AND_POP_WHEN_ZERO ($2a) MARK_X(1)  */
          if(F_MARK==opcode(2) && (argument(0))==argument(3))
          {
            do_optimization(4,
                            2,F_ASSIGN_LOCAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        case F_BRANCH_WHEN_NON_ZERO:
          /* ASSIGN_LOCAL BRANCH_WHEN_NON_ZERO MARK LOCAL ($1a) : ASSIGN_LOCAL ($1a) BRANCH_AND_POP_WHEN_NON_ZERO ($2a) MARK_X(1)  */
          if(F_MARK==opcode(2) && (argument(0))==argument(3))
          {
            do_optimization(4,
                            2,F_ASSIGN_LOCAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_NON_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        }
        break;

      case F_RETURN:
        /* ASSIGN_LOCAL BRANCH_WHEN_ZERO LOCAL($1a) RETURN LABEL($2a): ASSIGN_LOCAL($1a) RETURN_IF_TRUE LABEL($2a) */
        if(F_BRANCH_WHEN_ZERO==opcode(1) && F_LOCAL==opcode(2) && (argument(0))==argument(2) && F_LABEL==opcode(4) && (argument(1))==argument(4))
        {
          do_optimization(5,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          1,F_RETURN_IF_TRUE,
                          2,F_LABEL,(argument(1)), 
                          0);
          continue;
        }
        /* ASSIGN_LOCAL BRANCH_WHEN_ZERO LOCAL($1a) RETURN LABEL($2a) [!(Pike_compiler->compiler_frame->lexical_scope & SCOPE_SCOPED)] : RETURN_IF_TRUE ASSIGN_LOCAL($1a) LABEL($2a) */
        if(F_BRANCH_WHEN_ZERO==opcode(1) && F_LOCAL==opcode(2) && (argument(0))==argument(2) && F_LABEL==opcode(4) && (argument(1))==argument(4) && !(Pike_compiler->compiler_frame->lexical_scope & SCOPE_SCOPED))
        {
          do_optimization(5,
                          1,F_RETURN_IF_TRUE,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          2,F_LABEL,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        /* ASSIGN_LOCAL BRANCH_WHEN_ZERO LOCAL ($1a) : ASSIGN_LOCAL ($1a) BRANCH_AND_POP_WHEN_ZERO ($2a)  */
        if(F_LOCAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* ASSIGN_LOCAL BRANCH_WHEN_NON_ZERO LOCAL ($1a) : ASSIGN_LOCAL ($1a) BRANCH_AND_POP_WHEN_NON_ZERO ($2a)  */
        if(F_LOCAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          2,F_BRANCH_AND_POP_WHEN_NON_ZERO,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_ASSIGN_LOCAL:
        /* ASSIGN_LOCAL ASSIGN_LOCAL($1a) : ASSIGN_LOCAL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_POP_VALUE:
        /* ASSIGN_LOCAL POP_VALUE : ASSIGN_LOCAL_AND_POP($1a) */
        {
          do_optimization(2,
                          2,F_ASSIGN_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_NEGATE:
      switch(opcode(1))
      {
      case F_CONST1:
        /* NEGATE CONST1 SUBTRACT : COMPL */
        if(F_SUBTRACT==opcode(2))
        {
          do_optimization(3,
                          1,F_COMPL,
                          0);
          continue;
        }
        break;

      case F_CONST_1:
        /* NEGATE CONST_1 ADD_INTS : COMPL */
        if(F_ADD_INTS==opcode(2))
        {
          do_optimization(3,
                          1,F_COMPL,
                          0);
          continue;
        }
        break;

      case F_NEGATE:
        /* NEGATE NEGATE : */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_LOCAL_LVALUE:
      switch(opcode(1))
      {
      case F_MARK_X:
        /* LOCAL_LVALUE MARK_X [$2a>1] : MARK_X($2a-2) LOCAL_LVALUE($1a) */
        if(argument(1)>1)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-2), 
                          2,F_LOCAL_LVALUE,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_DEC:
        /* LOCAL_LVALUE DEC : DEC_LOCAL ($1a) */
        {
          do_optimization(2,
                          2,F_DEC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_DEC_AND_POP:
        /* LOCAL_LVALUE DEC_AND_POP : DEC_LOCAL_AND_POP ($1a) */
        {
          do_optimization(2,
                          2,F_DEC_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_POST_DEC:
        /* LOCAL_LVALUE POST_DEC : POST_DEC_LOCAL ($1a) */
        {
          do_optimization(2,
                          2,F_POST_DEC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_INC_AND_POP:
        /* LOCAL_LVALUE INC_AND_POP : INC_LOCAL_AND_POP ($1a) */
        {
          do_optimization(2,
                          2,F_INC_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_POST_INC:
        /* LOCAL_LVALUE POST_INC : POST_INC_LOCAL ($1a) */
        {
          do_optimization(2,
                          2,F_POST_INC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_INC:
        /* LOCAL_LVALUE INC : INC_LOCAL ($1a) */
        {
          do_optimization(2,
                          2,F_INC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_MARK_APPLY:
      switch(opcode(1))
      {
      case F_MARK_X:
        /* MARK_APPLY MARK_X [$2a>0] : MARK_X($2a-1) MARK_APPLY($1a) */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          2,F_MARK_APPLY,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_POP_VALUE:
        /* MARK_APPLY POP_VALUE : MARK_APPLY_POP($1a) */
        {
          do_optimization(2,
                          2,F_MARK_APPLY_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_COMPL:
      /* COMPL COMPL : */
      if(F_COMPL==opcode(1))
      {
        do_optimization(2,
                        0);
        continue;
      }
      break;

    case F_CALL_FUNCTION_AND_RETURN:
      /* CALL_FUNCTION_AND_RETURN !LABEL : CALL_FUNCTION_AND_RETURN($1a) */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        2,F_CALL_FUNCTION_AND_RETURN,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_RETURN_0:
      /* RETURN_0 !LABEL : RETURN_0 */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        1,F_RETURN_0,
                        0);
        continue;
      }
      break;

    case F_BRANCH:
      /* BRANCH !LABEL : BRANCH($1a) */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        2,F_BRANCH,(argument(0)), 
                        0);
        continue;
      }
      /* BRANCH LABEL($1a) : LABEL($1a) */
      if(F_LABEL==opcode(1) && (argument(0))==argument(1))
      {
        do_optimization(2,
                        2,F_LABEL,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_RETURN_LOCAL:
      /* RETURN_LOCAL !LABEL : RETURN_LOCAL($1a) */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        2,F_RETURN_LOCAL,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_CLEAR_LOCAL:
      switch(opcode(1))
      {
      case F_MARK:
        /* CLEAR_LOCAL MARK LOCAL [ $1a != $3a ] : MARK LOCAL($3a) CLEAR_LOCAL($1a) */
        if(F_LOCAL==opcode(2) &&  argument(0) != argument(2) )
        {
          do_optimization(3,
                          1,F_MARK,
                          2,F_LOCAL,(argument(2)), 
                          2,F_CLEAR_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        /* CLEAR_LOCAL MARK LOCAL($1a) : MARK CLEAR_LOCAL($1a) CONST0 */
        if(F_LOCAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          1,F_MARK,
                          2,F_CLEAR_LOCAL,(argument(0)), 
                          1,F_CONST0,
                          0);
          continue;
        }
        break;

      case F_INC_LOCAL_AND_POP:
        /* CLEAR_LOCAL INC_LOCAL_AND_POP($1a) : CONST1 ASSIGN_LOCAL_AND_POP($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_CONST1,
                          2,F_ASSIGN_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_DEC_LOCAL_AND_POP:
        /* CLEAR_LOCAL DEC_LOCAL_AND_POP($1a) : CONST_1 ASSIGN_LOCAL_AND_POP($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_CONST_1,
                          2,F_ASSIGN_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_NUMBER:
        /* CLEAR_LOCAL NUMBER(0) ASSIGN_LOCAL_AND_POP ($1a) : CLEAR_LOCAL($1a) */
        if((0)==argument(1) && F_ASSIGN_LOCAL_AND_POP==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_CLEAR_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        /* CLEAR_LOCAL NUMBER(0) ASSIGN_LOCAL_AND_POP ($1a+1) : CLEAR_2_LOCAL($1a) */
        if((0)==argument(1) && F_ASSIGN_LOCAL_AND_POP==opcode(2) && (argument(0)+1)==argument(2))
        {
          do_optimization(3,
                          2,F_CLEAR_2_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_CONST1:
      switch(opcode(1))
      {
      case F_MARK_X:
        /* CONST1 MARK_X [$2a>0] : MARK_X($2a-1) CONST1 */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          1,F_CONST1,
                          0);
          continue;
        }
        break;

      case F_ADD_INTS:
        /* CONST1 ADD_INTS: ADD_INT (1) */
        {
          do_optimization(2,
                          2,F_ADD_INT,(1), 
                          0);
          continue;
        }
        break;

      case F_NEGATE:
        /* CONST1 NEGATE : CONST_1 */
        {
          do_optimization(2,
                          1,F_CONST_1,
                          0);
          continue;
        }
        break;

      case F_CLEAR_STRING_SUBTYPE:
        /* CONST1 CLEAR_STRING_SUBTYPE: CONST1 */
        {
          do_optimization(2,
                          1,F_CONST1,
                          0);
          continue;
        }
        break;

      case F_ADD:
        /* CONST1 ADD: ADD_INT (1) */
        {
          do_optimization(2,
                          2,F_ADD_INT,(1), 
                          0);
          continue;
        }
        break;

      case F_INDEX:
        /* CONST1 INDEX: POS_INT_INDEX (1) */
        {
          do_optimization(2,
                          2,F_POS_INT_INDEX,(1), 
                          0);
          continue;
        }
        break;

      case F_RETURN:
        /* CONST1 RETURN: RETURN_1 */
        {
          do_optimization(2,
                          1,F_RETURN_1,
                          0);
          continue;
        }
        break;

      case F_SUBTRACT:
        /* CONST1 SUBTRACT: ADD_NEG_INT (-1) */
        {
          do_optimization(2,
                          2,F_ADD_NEG_INT,(-1), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* CONST1 BRANCH_WHEN_NON_ZERO: BRANCH($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* CONST1 BRANCH_WHEN_ZERO: */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_POST_DEC_LOCAL:
      /* POST_DEC_LOCAL POP_VALUE : DEC_LOCAL_AND_POP ($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        2,F_DEC_LOCAL_AND_POP,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_CALL_LFUN:
      switch(opcode(1))
      {
      case F_RETURN:
        /* CALL_LFUN [check_tailrecursion()] RETURN : CALL_LFUN_AND_RETURN($1a) */
        if(check_tailrecursion())
        {
          do_optimization(2,
                          2,F_CALL_LFUN_AND_RETURN,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_POP_VALUE:
        /* CALL_LFUN POP_VALUE : CALL_LFUN_AND_POP($1a) */
        {
          do_optimization(2,
                          2,F_CALL_LFUN_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_APPLY_ASSIGN_LOCAL_AND_POP:
      switch(opcode(1))
      {
      case F_MARK_AND_LOCAL:
        /* APPLY_ASSIGN_LOCAL_AND_POP MARK_AND_LOCAL ($1b) : APPLY_ASSIGN_LOCAL($1a,$1b) MARK_X(1)  */
        if((argument2(0))==argument(1))
        {
          do_optimization(2,
                          3,F_APPLY_ASSIGN_LOCAL,(argument(0)), (argument2(0)), 
                          2,F_MARK_X,(1), 
                          0);
          continue;
        }
        break;

      case F_LOCAL:
        /* APPLY_ASSIGN_LOCAL_AND_POP LOCAL ($1b) : APPLY_ASSIGN_LOCAL($1a,$1b) */
        if((argument2(0))==argument(1))
        {
          do_optimization(2,
                          3,F_APPLY_ASSIGN_LOCAL,(argument(0)), (argument2(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_BRANCH_WHEN_NE:
      switch(opcode(1))
      {
      case F_LABEL:
        /* BRANCH_WHEN_NE LABEL($1a) : POP_VALUE POP_VALUE LABEL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_POP_VALUE,
                          1,F_POP_VALUE,
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH:
        /* BRANCH_WHEN_NE BRANCH LABEL ($1a) : BRANCH_WHEN_EQ($2a) LABEL($1a) */
        if(F_LABEL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_BRANCH_WHEN_EQ,(argument(1)), 
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_APPLY_AND_RETURN:
      /* APPLY_AND_RETURN !LABEL : APPLY_AND_RETURN($1a) */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        2,F_APPLY_AND_RETURN,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_CALL_FUNCTION:
      /* CALL_FUNCTION [check_tailrecursion()] RETURN : CALL_FUNCTION_AND_RETURN */
      if(check_tailrecursion() && F_RETURN==opcode(1))
      {
        do_optimization(2,
                        1,F_CALL_FUNCTION_AND_RETURN,
                        0);
        continue;
      }
      break;

    case F_BRANCH_WHEN_LT:
      switch(opcode(1))
      {
      case F_LABEL:
        /* BRANCH_WHEN_LT LABEL($1a) : POP_VALUE POP_VALUE LABEL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_POP_VALUE,
                          1,F_POP_VALUE,
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH:
        /* BRANCH_WHEN_LT BRANCH LABEL ($1a) : BRANCH_WHEN_GE($2a) LABEL($1a) */
        if(F_LABEL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_BRANCH_WHEN_GE,(argument(1)), 
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_RETURN:
      /* RETURN !LABEL : RETURN */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        1,F_RETURN,
                        0);
        continue;
      }
      break;

    case F_BRANCH_WHEN_GE:
      switch(opcode(1))
      {
      case F_LABEL:
        /* BRANCH_WHEN_GE LABEL($1a) : POP_VALUE POP_VALUE LABEL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_POP_VALUE,
                          1,F_POP_VALUE,
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH:
        /* BRANCH_WHEN_GE BRANCH LABEL ($1a) : BRANCH_WHEN_LT($2a) LABEL($1a) */
        if(F_LABEL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_BRANCH_WHEN_LT,(argument(1)), 
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_RETURN_1:
      /* RETURN_1 !LABEL : RETURN_1 */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        1,F_RETURN_1,
                        0);
        continue;
      }
      break;

    case F_DEC_LOCAL:
      /* DEC_LOCAL POP_VALUE : DEC_LOCAL_AND_POP ($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        2,F_DEC_LOCAL_AND_POP,(argument(0)), 
                        0);
        continue;
      }
      break;

    case F_BRANCH_IF_LOCAL:
      /* BRANCH_IF_LOCAL POINTER LABEL($2a) : LABEL($2a) */
      if(F_POINTER==opcode(1) && F_LABEL==opcode(2) && (argument(1))==argument(2))
      {
        do_optimization(3,
                        2,F_LABEL,(argument(1)), 
                        0);
        continue;
      }
      break;

    case F_BRANCH_WHEN_LE:
      switch(opcode(1))
      {
      case F_LABEL:
        /* BRANCH_WHEN_LE LABEL($1a) : POP_VALUE POP_VALUE LABEL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_POP_VALUE,
                          1,F_POP_VALUE,
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH:
        /* BRANCH_WHEN_LE BRANCH LABEL ($1a) : BRANCH_WHEN_GT($2a) LABEL($1a) */
        if(F_LABEL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_BRANCH_WHEN_GT,(argument(1)), 
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_ASSIGN_GLOBAL:
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        switch(opcode(2))
        {
        case F_GLOBAL:
          /* ASSIGN_GLOBAL BRANCH_WHEN_ZERO GLOBAL($1a) RETURN LABEL($2a): ASSIGN_GLOBAL($1a) RETURN_IF_TRUE LABEL($2a) */
          if((argument(0))==argument(2) && F_RETURN==opcode(3) && F_LABEL==opcode(4) && (argument(1))==argument(4))
          {
            do_optimization(5,
                            2,F_ASSIGN_GLOBAL,(argument(0)), 
                            1,F_RETURN_IF_TRUE,
                            2,F_LABEL,(argument(1)), 
                            0);
            continue;
          }
          /* ASSIGN_GLOBAL BRANCH_WHEN_ZERO GLOBAL ($1a) : ASSIGN_GLOBAL ($1a) BRANCH_AND_POP_WHEN_ZERO ($2a)  */
          if((argument(0))==argument(2))
          {
            do_optimization(3,
                            2,F_ASSIGN_GLOBAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                            0);
            continue;
          }
          break;

        case F_MARK:
          /* ASSIGN_GLOBAL BRANCH_WHEN_ZERO MARK GLOBAL ($1a) : ASSIGN_GLOBAL ($1a) BRANCH_AND_POP_WHEN_ZERO ($2a) MARK_X(1)  */
          if(F_GLOBAL==opcode(3) && (argument(0))==argument(3))
          {
            do_optimization(4,
                            2,F_ASSIGN_GLOBAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        switch(opcode(2))
        {
        case F_GLOBAL:
          /* ASSIGN_GLOBAL BRANCH_WHEN_NON_ZERO GLOBAL ($1a) : ASSIGN_GLOBAL ($1a) BRANCH_AND_POP_WHEN_NON_ZERO ($2a)  */
          if((argument(0))==argument(2))
          {
            do_optimization(3,
                            2,F_ASSIGN_GLOBAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_NON_ZERO,(argument(1)), 
                            0);
            continue;
          }
          break;

        case F_MARK:
          /* ASSIGN_GLOBAL BRANCH_WHEN_NON_ZERO MARK GLOBAL ($1a) : ASSIGN_GLOBAL ($1a) BRANCH_AND_POP_WHEN_NON_ZERO ($2a) MARK_X(1)  */
          if(F_GLOBAL==opcode(3) && (argument(0))==argument(3))
          {
            do_optimization(4,
                            2,F_ASSIGN_GLOBAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_NON_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        }
        break;

      case F_POP_VALUE:
        /* ASSIGN_GLOBAL POP_VALUE : ASSIGN_GLOBAL_AND_POP($1a) */
        {
          do_optimization(2,
                          2,F_ASSIGN_GLOBAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_BRANCH_WHEN_GT:
      switch(opcode(1))
      {
      case F_LABEL:
        /* BRANCH_WHEN_GT LABEL($1a) : POP_VALUE POP_VALUE LABEL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_POP_VALUE,
                          1,F_POP_VALUE,
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH:
        /* BRANCH_WHEN_GT BRANCH LABEL ($1a) : BRANCH_WHEN_LE($2a) LABEL($1a) */
        if(F_LABEL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_BRANCH_WHEN_LE,(argument(1)), 
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_BYTE:
      switch(opcode(2))
      {
      case F_CLEAR_4_LOCAL:
        /* BYTE START_FUNCTION CLEAR_4_LOCAL [$1a <= $3a] : BYTE($1a) START_FUNCTION */
        if(F_START_FUNCTION==opcode(1) && argument(0) <= argument(2))
        {
          do_optimization(3,
                          2,F_BYTE,(argument(0)), 
                          1,F_START_FUNCTION,
                          0);
          continue;
        }
        break;

      case F_CLEAR_2_LOCAL:
        /* BYTE START_FUNCTION CLEAR_2_LOCAL [$1a <= $3a] : BYTE($1a) START_FUNCTION */
        if(F_START_FUNCTION==opcode(1) && argument(0) <= argument(2))
        {
          do_optimization(3,
                          2,F_BYTE,(argument(0)), 
                          1,F_START_FUNCTION,
                          0);
          continue;
        }
        break;

      case F_CLEAR_LOCAL:
        /* BYTE START_FUNCTION CLEAR_LOCAL [$1a <= $3a] : BYTE($1a) START_FUNCTION */
        if(F_START_FUNCTION==opcode(1) && argument(0) <= argument(2))
        {
          do_optimization(3,
                          2,F_BYTE,(argument(0)), 
                          1,F_START_FUNCTION,
                          0);
          continue;
        }
        break;

      case F_LABEL:
        switch(opcode(3))
        {
        case F_CLEAR_4_LOCAL:
          /* BYTE START_FUNCTION LABEL(0) CLEAR_4_LOCAL [$1a <= $4a] : BYTE($1a) START_FUNCTION LABEL(0) */
          if(F_START_FUNCTION==opcode(1) && (0)==argument(2) && argument(0) <= argument(3))
          {
            do_optimization(4,
                            2,F_BYTE,(argument(0)), 
                            1,F_START_FUNCTION,
                            2,F_LABEL,(0), 
                            0);
            continue;
          }
          break;

        case F_CLEAR_2_LOCAL:
          /* BYTE START_FUNCTION LABEL(0) CLEAR_2_LOCAL [$1a <= $4a] : BYTE($1a) START_FUNCTION LABEL(0) */
          if(F_START_FUNCTION==opcode(1) && (0)==argument(2) && argument(0) <= argument(3))
          {
            do_optimization(4,
                            2,F_BYTE,(argument(0)), 
                            1,F_START_FUNCTION,
                            2,F_LABEL,(0), 
                            0);
            continue;
          }
          break;

        case F_CLEAR_LOCAL:
          /* BYTE START_FUNCTION LABEL(0) CLEAR_LOCAL [$1a <= $4a] : BYTE($1a) START_FUNCTION LABEL(0) */
          if(F_START_FUNCTION==opcode(1) && (0)==argument(2) && argument(0) <= argument(3))
          {
            do_optimization(4,
                            2,F_BYTE,(argument(0)), 
                            1,F_START_FUNCTION,
                            2,F_LABEL,(0), 
                            0);
            continue;
          }
          break;

        }
        break;

      }
      break;

    case F_MARK_X:
      /* MARK_X(0) : MARK */
      if((0)==argument(0))
      {
        do_optimization(1,
                        1,F_MARK,
                        0);
        continue;
      }
      break;

    case F_SIZEOF_LOCAL:
      switch(opcode(2))
      {
      case F_BRANCH_WHEN_LE:
        /* SIZEOF_LOCAL CONST0 BRANCH_WHEN_LE : SIZEOF_LOCAL($1a) BRANCH_WHEN_ZERO ($3a) */
        if(F_CONST0==opcode(1))
        {
          do_optimization(3,
                          2,F_SIZEOF_LOCAL,(argument(0)), 
                          2,F_BRANCH_WHEN_ZERO,(argument(2)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_LT:
        /* SIZEOF_LOCAL CONST1 BRANCH_WHEN_LT : SIZEOF_LOCAL($1a) BRANCH_WHEN_ZERO ($3a) */
        if(F_CONST1==opcode(1))
        {
          do_optimization(3,
                          2,F_SIZEOF_LOCAL,(argument(0)), 
                          2,F_BRANCH_WHEN_ZERO,(argument(2)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_GLOBAL_LOCAL_INDEX:
      switch(opcode(2))
      {
      case F_MARK:
        /* GLOBAL_LOCAL_INDEX($1a, $1b) BRANCH_WHEN_ZERO MARK GLOBAL_LOCAL_INDEX($1a, $1b) : GLOBAL_LOCAL_INDEX($1a, $1b) BRANCH_AND_POP_WHEN_ZERO ( $2a ) MARK_X(1)  */
        if(F_BRANCH_WHEN_ZERO==opcode(1) && F_GLOBAL_LOCAL_INDEX==opcode(3) && (argument(0))==argument(3) && (argument2(0))==argument2(3))
        {
          do_optimization(4,
                          3,F_GLOBAL_LOCAL_INDEX,(argument(0)), (argument2(0)), 
                          2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                          2,F_MARK_X,(1), 
                          0);
          continue;
        }
        break;

      case F_GLOBAL_LOCAL_INDEX:
        /* GLOBAL_LOCAL_INDEX($1a, $1b) BRANCH_WHEN_ZERO GLOBAL_LOCAL_INDEX($1a, $1b) : GLOBAL_LOCAL_INDEX($1a, $1b) BRANCH_AND_POP_WHEN_ZERO ( $2a )  */
        if(F_BRANCH_WHEN_ZERO==opcode(1) && (argument(0))==argument(2) && (argument2(0))==argument2(2))
        {
          do_optimization(3,
                          3,F_GLOBAL_LOCAL_INDEX,(argument(0)), (argument2(0)), 
                          2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_LTOSVAL:
      switch(opcode(1))
      {
      case F_MARK_X:
        /* LTOSVAL MARK_X [$2a>0] : MARK_X($2a-1) LTOSVAL */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          1,F_LTOSVAL,
                          0);
          continue;
        }
        break;

      case F_ADD_FLOATS:
        /* LTOSVAL ADD_FLOATS ASSIGN_AND_POP : ADD_TO_AND_POP */
        if(F_ASSIGN_AND_POP==opcode(2))
        {
          do_optimization(3,
                          1,F_ADD_TO_AND_POP,
                          0);
          continue;
        }
        break;

      case F_ADD_INTS:
        /* LTOSVAL ADD_INTS ASSIGN_AND_POP : ADD_TO_AND_POP */
        if(F_ASSIGN_AND_POP==opcode(2))
        {
          do_optimization(3,
                          1,F_ADD_TO_AND_POP,
                          0);
          continue;
        }
        break;

      case F_ADD:
        /* LTOSVAL ADD ASSIGN_AND_POP : ADD_TO_AND_POP */
        if(F_ASSIGN_AND_POP==opcode(2))
        {
          do_optimization(3,
                          1,F_ADD_TO_AND_POP,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_LOCAL_2_LOCAL:
      /* LOCAL_2_LOCAL [$1a == $1b] : */
      if(argument(0) == argument2(0))
      {
        do_optimization(1,
                        0);
        continue;
      }
      break;

    case F_NEG_NUMBER:
      switch(opcode(1))
      {
      case F_MARK_X:
        /* NEG_NUMBER MARK_X [$2a>0] : MARK_X($2a-1) NEG_NUMBER($1a) */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          2,F_NEG_NUMBER,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_ADD_NEG_INT:
        /* NEG_NUMBER ADD_NEG_INT [ !INT_TYPE_SUB_OVERFLOW(-$1a, $2a) ]: NUMBER(-$1a-$2a) */
        if( !INT_TYPE_SUB_OVERFLOW(-argument(0), argument(1)) )
        {
          do_optimization(2,
                          2,F_NUMBER,(-argument(0)-argument(1)), 
                          0);
          continue;
        }
        break;

      case F_ADD_INT:
        /* NEG_NUMBER ADD_INT [ !INT_TYPE_ADD_OVERFLOW(-$1a, $2a) ]: NUMBER(-$1a+$2a) */
        if( !INT_TYPE_ADD_OVERFLOW(-argument(0), argument(1)) )
        {
          do_optimization(2,
                          2,F_NUMBER,(-argument(0)+argument(1)), 
                          0);
          continue;
        }
        break;

      case F_INDEX:
        /* NEG_NUMBER [$1a >= 0] INDEX: NEG_INT_INDEX ($1a) */
        if(argument(0) >= 0)
        {
          do_optimization(2,
                          2,F_NEG_INT_INDEX,(argument(0)), 
                          0);
          continue;
        }
        /* NEG_NUMBER [$1a < 0 && ($1a != -$1a)] INDEX: POS_INT_INDEX (-$1a) */
        if(argument(0) < 0 && (argument(0) != -argument(0)))
        {
          do_optimization(2,
                          2,F_POS_INT_INDEX,(-argument(0)), 
                          0);
          continue;
        }
        break;

      case F_CLEAR_STRING_SUBTYPE:
        /* NEG_NUMBER CLEAR_STRING_SUBTYPE: NEG_NUMBER($1a) */
        {
          do_optimization(2,
                          2,F_NEG_NUMBER,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_NEGATE:
        /* NEG_NUMBER NEGATE : NUMBER ($1a) */
        {
          do_optimization(2,
                          2,F_NUMBER,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_NOP:
      /* NOP : */
      {
        do_optimization(1,
                        0);
        continue;
      }
      break;

    case F_NOTREACHED:
      /* NOTREACHED !LABEL : NOTREACHED */
      if(F_LABEL != opcode(1) && opcode(1) !=-1)
      {
        do_optimization(2,
                        1,F_NOTREACHED,
                        0);
        continue;
      }
      break;

    case F_CONSTANT:
      switch(opcode(1))
      {
      case F_POP_VALUE:
        /* CONSTANT POP_VALUE : */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      case F_MARK_X:
        /* CONSTANT MARK_X [$2a>0] : MARK_X($2a-1) CONSTANT($1a) */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          2,F_CONSTANT,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_DEC_LOCAL_AND_POP:
      switch(opcode(1))
      {
      case F_MARK_AND_LOCAL:
        /* DEC_LOCAL_AND_POP MARK_AND_LOCAL ($1a) : MARK DEC_LOCAL ($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_MARK,
                          2,F_DEC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_GLOBAL:
        /* DEC_LOCAL_AND_POP GLOBAL LOCAL ($1a) : GLOBAL($2a) DEC_LOCAL ($1a)  */
        if(F_LOCAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_GLOBAL,(argument(1)), 
                          2,F_DEC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_LOCAL:
        /* DEC_LOCAL_AND_POP LOCAL ($1a) : DEC_LOCAL ($1a)  */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          2,F_DEC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        /* DEC_LOCAL_AND_POP LOCAL LOCAL ($1a) : LOCAL($2a) DEC_LOCAL ($1a)  */
        if(F_LOCAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_LOCAL,(argument(1)), 
                          2,F_DEC_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_BRANCH_IF_NOT_LOCAL:
      /* BRANCH_IF_NOT_LOCAL POINTER LABEL($2a) : LABEL($2a) */
      if(F_POINTER==opcode(1) && F_LABEL==opcode(2) && (argument(1))==argument(2))
      {
        do_optimization(3,
                        2,F_LABEL,(argument(1)), 
                        0);
        continue;
      }
      break;

    case F_APPLY:
      switch(opcode(1))
      {
      case F_ASSIGN_LOCAL_AND_POP:
        /* APPLY ASSIGN_LOCAL_AND_POP : APPLY_ASSIGN_LOCAL_AND_POP($1a,$2a) */
        {
          do_optimization(2,
                          3,F_APPLY_ASSIGN_LOCAL_AND_POP,(argument(0)), (argument(1)), 
                          0);
          continue;
        }
        break;

      case F_RETURN:
        /* APPLY [check_tailrecursion()] RETURN : APPLY_AND_RETURN($1a) */
        if(check_tailrecursion())
        {
          do_optimization(2,
                          2,F_APPLY_AND_RETURN,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_POP_VALUE:
        /* APPLY POP_VALUE : APPLY_AND_POP($1a) */
        {
          do_optimization(2,
                          2,F_APPLY_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_IDENTIFIER:
      /* IDENTIFIER POP_VALUE : */
      if(F_POP_VALUE==opcode(1))
      {
        do_optimization(2,
                        0);
        continue;
      }
      break;

    case F_GLOBAL:
      switch(opcode(1))
      {
      case F_LOCAL_INDEX:
        /* GLOBAL LOCAL_INDEX : GLOBAL_LOCAL_INDEX($1a,$2a) */
        {
          do_optimization(2,
                          3,F_GLOBAL_LOCAL_INDEX,(argument(0)), (argument(1)), 
                          0);
          continue;
        }
        break;

      case F_ASSIGN_LOCAL_AND_POP:
        /* GLOBAL ASSIGN_LOCAL_AND_POP : GLOBAL_2_LOCAL($1a,$2a) */
        {
          do_optimization(2,
                          3,F_GLOBAL_2_LOCAL,(argument(0)), (argument(1)), 
                          0);
          continue;
        }
        break;

      case F_ARROW:
        switch(opcode(4))
        {
        case F_GLOBAL:
          /* GLOBAL($1a) ARROW ($2a) BRANCH_WHEN_ZERO MARK GLOBAL($1a) ARROW ($2a) : GLOBAL($1a) ARROW ($2a) BRANCH_AND_POP_WHEN_ZERO ( $3a ) MARK_X(1)  */
          if(F_BRANCH_WHEN_ZERO==opcode(2) && F_MARK==opcode(3) && (argument(0))==argument(4) && F_ARROW==opcode(5) && (argument(1))==argument(5))
          {
            do_optimization(6,
                            2,F_GLOBAL,(argument(0)), 
                            2,F_ARROW,(argument(1)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(2)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        case F_ARROW:
          /* GLOBAL($1a) ARROW ($2a) BRANCH_WHEN_ZERO GLOBAL($1a) ARROW ($2a) : GLOBAL($1a) ARROW ($2a) BRANCH_AND_POP_WHEN_ZERO ( $3a )  */
          if(F_BRANCH_WHEN_ZERO==opcode(2) && F_GLOBAL==opcode(3) && (argument(0))==argument(3) && (argument(1))==argument(4))
          {
            do_optimization(5,
                            2,F_GLOBAL,(argument(0)), 
                            2,F_ARROW,(argument(1)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(2)), 
                            0);
            continue;
          }
          break;

        }
        break;

      case F_BRANCH_WHEN_ZERO:
        switch(opcode(2))
        {
        case F_GLOBAL:
          /* GLOBAL BRANCH_WHEN_ZERO GLOBAL ($1a) : GLOBAL ($1a) BRANCH_AND_POP_WHEN_ZERO ($2a)  */
          if((argument(0))==argument(2))
          {
            do_optimization(3,
                            2,F_GLOBAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                            0);
            continue;
          }
          break;

        case F_MARK:
          /* GLOBAL BRANCH_WHEN_ZERO MARK GLOBAL ($1a) : GLOBAL ($1a) BRANCH_AND_POP_WHEN_ZERO ($2a) MARK_X(1)  */
          if(F_GLOBAL==opcode(3) && (argument(0))==argument(3))
          {
            do_optimization(4,
                            2,F_GLOBAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        switch(opcode(2))
        {
        case F_GLOBAL:
          /* GLOBAL BRANCH_WHEN_NON_ZERO GLOBAL ($1a) : GLOBAL ($1a) BRANCH_AND_POP_WHEN_NON_ZERO ($2a)  */
          if((argument(0))==argument(2))
          {
            do_optimization(3,
                            2,F_GLOBAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_NON_ZERO,(argument(1)), 
                            0);
            continue;
          }
          break;

        case F_MARK:
          /* GLOBAL BRANCH_WHEN_NON_ZERO MARK GLOBAL ($1a) : GLOBAL ($1a) BRANCH_AND_POP_WHEN_NON_ZERO ($2a) MARK_X(1)  */
          if(F_GLOBAL==opcode(3) && (argument(0))==argument(3))
          {
            do_optimization(4,
                            2,F_GLOBAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_NON_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        }
        break;

      case F_MARK_X:
        /* GLOBAL MARK_X [$2a>0] : MARK_X($2a-1) GLOBAL($1a) */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          2,F_GLOBAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_ASSIGN_GLOBAL_AND_POP:
      switch(opcode(1))
      {
      case F_MARK:
        /* ASSIGN_GLOBAL_AND_POP MARK GLOBAL($1a) : MARK_X(1) ASSIGN_GLOBAL($1a) */
        if(F_GLOBAL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_MARK_X,(1), 
                          2,F_ASSIGN_GLOBAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_GLOBAL:
        /* ASSIGN_GLOBAL_AND_POP GLOBAL($1a) : ASSIGN_GLOBAL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          2,F_ASSIGN_GLOBAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_LOCAL:
      switch(opcode(1))
      {
      case F_SIZEOF:
        /* LOCAL SIZEOF: SIZEOF_LOCAL ($1a) */
        {
          do_optimization(2,
                          2,F_SIZEOF_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_ASSIGN_GLOBAL_AND_POP:
        /* LOCAL ASSIGN_GLOBAL_AND_POP : LOCAL_2_GLOBAL($2a,$1a) */
        {
          do_optimization(2,
                          3,F_LOCAL_2_GLOBAL,(argument(1)), (argument(0)), 
                          0);
          continue;
        }
        break;

      case F_INDEX:
        /* LOCAL INDEX: LOCAL_INDEX ($1a) */
        {
          do_optimization(2,
                          2,F_LOCAL_INDEX,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_LOCAL:
        switch(opcode(2))
        {
        case F_CLEAR_STRING_SUBTYPE:
          /* LOCAL LOCAL CLEAR_STRING_SUBTYPE INDEX: LOCAL_LOCAL_INDEX($2a,$1a) */
          if(F_INDEX==opcode(3))
          {
            do_optimization(4,
                            3,F_LOCAL_LOCAL_INDEX,(argument(1)), (argument(0)), 
                            0);
            continue;
          }
          break;

        case F_INDEX:
          /* LOCAL LOCAL INDEX: LOCAL_LOCAL_INDEX($2a,$1a) */
          {
            do_optimization(3,
                            3,F_LOCAL_LOCAL_INDEX,(argument(1)), (argument(0)), 
                            0);
            continue;
          }
          break;

        }
        /* LOCAL LOCAL [$3o != F_SIZEOF && $3o != F_INDEX ]: 2_LOCALS ($1a,$2a) */
        if(opcode(2) != F_SIZEOF && opcode(2) != F_INDEX )
        {
          do_optimization(2,
                          3,F_2_LOCALS,(argument(0)), (argument(1)), 
                          0);
          continue;
        }
        break;

      case F_POP_VALUE:
        /* LOCAL POP_VALUE : */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      case F_RETURN:
        /* LOCAL RETURN : RETURN_LOCAL($1a) */
        {
          do_optimization(2,
                          2,F_RETURN_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_CONST1:
        /* LOCAL CONST1 ADD_TO_AND_POP : INC_LOCAL_AND_POP($1a) */
        if(F_ADD_TO_AND_POP==opcode(2))
        {
          do_optimization(3,
                          2,F_INC_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        switch(opcode(2))
        {
        case F_LOCAL:
          /* LOCAL BRANCH_WHEN_ZERO LOCAL ($1a) : LOCAL ($1a) BRANCH_AND_POP_WHEN_ZERO ($2a)  */
          if((argument(0))==argument(2))
          {
            do_optimization(3,
                            2,F_LOCAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                            0);
            continue;
          }
          break;

        case F_MARK:
          /* LOCAL BRANCH_WHEN_ZERO MARK LOCAL ($1a) : LOCAL ($1a) BRANCH_AND_POP_WHEN_ZERO ($2a) MARK_X(1)  */
          if(F_LOCAL==opcode(3) && (argument(0))==argument(3))
          {
            do_optimization(4,
                            2,F_LOCAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        }
        /* LOCAL BRANCH_WHEN_ZERO : BRANCH_IF_NOT_LOCAL($1a) POINTER($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_IF_NOT_LOCAL,(argument(0)), 
                          2,F_POINTER,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_ASSIGN_LOCAL_AND_POP:
        /* LOCAL ASSIGN_LOCAL_AND_POP : LOCAL_2_LOCAL($2a,$1a) */
        {
          do_optimization(2,
                          3,F_LOCAL_2_LOCAL,(argument(1)), (argument(0)), 
                          0);
          continue;
        }
        break;

      case F_ARROW:
        /* LOCAL ARROW : LOCAL_ARROW($2a,$1a) */
        {
          do_optimization(2,
                          3,F_LOCAL_ARROW,(argument(1)), (argument(0)), 
                          0);
          continue;
        }
        break;

      case F_SWITCH:
        /* LOCAL SWITCH: SWITCH_ON_LOCAL($1a,$2a) */
        {
          do_optimization(2,
                          3,F_SWITCH_ON_LOCAL,(argument(0)), (argument(1)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        switch(opcode(2))
        {
        case F_LOCAL:
          /* LOCAL BRANCH_WHEN_NON_ZERO LOCAL ($1a) : LOCAL ($1a) BRANCH_AND_POP_WHEN_NON_ZERO ($2a)  */
          if((argument(0))==argument(2))
          {
            do_optimization(3,
                            2,F_LOCAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_NON_ZERO,(argument(1)), 
                            0);
            continue;
          }
          break;

        case F_MARK:
          /* LOCAL BRANCH_WHEN_NON_ZERO MARK LOCAL ($1a) : LOCAL ($1a) BRANCH_AND_POP_WHEN_NON_ZERO ($2a) MARK_X(1)  */
          if(F_LOCAL==opcode(3) && (argument(0))==argument(3))
          {
            do_optimization(4,
                            2,F_LOCAL,(argument(0)), 
                            2,F_BRANCH_AND_POP_WHEN_NON_ZERO,(argument(1)), 
                            2,F_MARK_X,(1), 
                            0);
            continue;
          }
          break;

        }
        /* LOCAL BRANCH_WHEN_NON_ZERO : BRANCH_IF_LOCAL($1a) POINTER($2a) */
        {
          do_optimization(2,
                          2,F_BRANCH_IF_LOCAL,(argument(0)), 
                          2,F_POINTER,(argument(1)), 
                          0);
          continue;
        }
        break;

      case F_CONST_1:
        /* LOCAL CONST_1 ADD_TO_AND_POP : DEC_LOCAL_AND_POP($1a) */
        if(F_ADD_TO_AND_POP==opcode(2))
        {
          do_optimization(3,
                          2,F_DEC_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_MARK_X:
        /* LOCAL MARK_X [$2a>0] : MARK_X($2a-1) LOCAL($1a) */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          2,F_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_CLEAR_STRING_SUBTYPE:
        /* LOCAL CLEAR_STRING_SUBTYPE INDEX: LOCAL_INDEX ($1a) */
        if(F_INDEX==opcode(2))
        {
          do_optimization(3,
                          2,F_LOCAL_INDEX,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_CONST_1:
      switch(opcode(1))
      {
      case F_MARK_X:
        /* CONST_1 MARK_X [$2a>0] : MARK_X($2a-1) CONST_1 */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          1,F_CONST_1,
                          0);
          continue;
        }
        break;

      case F_ADD_INTS:
        /* CONST_1 ADD_INTS: ADD_NEG_INT (1) */
        {
          do_optimization(2,
                          2,F_ADD_NEG_INT,(1), 
                          0);
          continue;
        }
        break;

      case F_NEGATE:
        /* CONST_1 NEGATE : CONST1 */
        {
          do_optimization(2,
                          1,F_CONST1,
                          0);
          continue;
        }
        break;

      case F_CLEAR_STRING_SUBTYPE:
        /* CONST_1 CLEAR_STRING_SUBTYPE: CONST_1 */
        {
          do_optimization(2,
                          1,F_CONST_1,
                          0);
          continue;
        }
        break;

      case F_ADD:
        /* CONST_1 ADD: ADD_NEG_INT (1) */
        {
          do_optimization(2,
                          2,F_ADD_NEG_INT,(1), 
                          0);
          continue;
        }
        break;

      case F_INDEX:
        /* CONST_1 INDEX: NEG_INT_INDEX (1) */
        {
          do_optimization(2,
                          2,F_NEG_INT_INDEX,(1), 
                          0);
          continue;
        }
        break;

      case F_SUBTRACT:
        /* CONST_1 SUBTRACT: ADD_INT (1) */
        {
          do_optimization(2,
                          2,F_ADD_INT,(1), 
                          0);
          continue;
        }
        break;

      case F_XOR:
        /* CONST_1 XOR: COMPL */
        {
          do_optimization(2,
                          1,F_COMPL,
                          0);
          continue;
        }
        break;

      }
      break;

    case F_ASSIGN_LOCAL_AND_POP:
      switch(opcode(1))
      {
      case F_MARK_AND_LOCAL:
        /* ASSIGN_LOCAL_AND_POP MARK_AND_LOCAL($1a) : MARK_X(1) ASSIGN_LOCAL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          2,F_MARK_X,(1), 
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_LOCAL:
        /* ASSIGN_LOCAL_AND_POP LOCAL ($1a) RETURN: ASSIGN_LOCAL($1a) RETURN */
        if((argument(0))==argument(1) && F_RETURN==opcode(2))
        {
          do_optimization(3,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          1,F_RETURN,
                          0);
          continue;
        }
        /* ASSIGN_LOCAL_AND_POP LOCAL ($1a) RETURN [!(Pike_compiler->compiler_frame->lexical_scope & SCOPE_SCOPED)]: RETURN */
        if((argument(0))==argument(1) && F_RETURN==opcode(2) && !(Pike_compiler->compiler_frame->lexical_scope & SCOPE_SCOPED))
        {
          do_optimization(3,
                          1,F_RETURN,
                          0);
          continue;
        }
        /* ASSIGN_LOCAL_AND_POP LOCAL($1a) : ASSIGN_LOCAL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          2,F_ASSIGN_LOCAL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_DEC_LOCAL_AND_POP:
        /* ASSIGN_LOCAL_AND_POP DEC_LOCAL_AND_POP($1a) : ADD_NEG_INT(1) ASSIGN_LOCAL_AND_POP($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          2,F_ADD_NEG_INT,(1), 
                          2,F_ASSIGN_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_INC_LOCAL_AND_POP:
        /* ASSIGN_LOCAL_AND_POP INC_LOCAL_AND_POP($1a) : ADD_INT(1) ASSIGN_LOCAL_AND_POP($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          2,F_ADD_INT,(1), 
                          2,F_ASSIGN_LOCAL_AND_POP,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_POP_VALUE:
      switch(opcode(1))
      {
      case F_RETURN_1:
        /* POP_VALUE RETURN_1: RETURN_1 */
        {
          do_optimization(2,
                          1,F_RETURN_1,
                          0);
          continue;
        }
        break;

      case F_RETURN_0:
        /* POP_VALUE RETURN_0: RETURN_0 */
        {
          do_optimization(2,
                          1,F_RETURN_0,
                          0);
          continue;
        }
        break;

      case F_POP_TO_MARK:
        /* POP_VALUE POP_TO_MARK : POP_TO_MARK */
        {
          do_optimization(2,
                          1,F_POP_TO_MARK,
                          0);
          continue;
        }
        break;

      case F_POP_N_ELEMS:
        /* POP_VALUE POP_N_ELEMS : POP_N_ELEMS ($2a + 1) */
        {
          do_optimization(2,
                          2,F_POP_N_ELEMS,(argument(1) + 1), 
                          0);
          continue;
        }
        break;

      case F_POP_VALUE:
        /* POP_VALUE POP_VALUE : POP_N_ELEMS (2) */
        {
          do_optimization(2,
                          2,F_POP_N_ELEMS,(2), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_FLOAT:
      switch(opcode(1))
      {
      case F_POP_VALUE:
        /* FLOAT POP_VALUE : */
        {
          do_optimization(2,
                          0);
          continue;
        }
        break;

      case F_MARK_X:
        /* FLOAT MARK_X [$2a>0] : MARK_X($2a-1) FLOAT($1a) */
        if(argument(1)>0)
        {
          do_optimization(2,
                          2,F_MARK_X,(argument(1)-1), 
                          2,F_FLOAT,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    case F_BRANCH_WHEN_EQ:
      switch(opcode(1))
      {
      case F_LABEL:
        /* BRANCH_WHEN_EQ LABEL($1a) : POP_VALUE POP_VALUE LABEL($1a) */
        if((argument(0))==argument(1))
        {
          do_optimization(2,
                          1,F_POP_VALUE,
                          1,F_POP_VALUE,
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      case F_BRANCH:
        /* BRANCH_WHEN_EQ BRANCH LABEL ($1a) : BRANCH_WHEN_NE($2a) LABEL($1a) */
        if(F_LABEL==opcode(2) && (argument(0))==argument(2))
        {
          do_optimization(3,
                          2,F_BRANCH_WHEN_NE,(argument(1)), 
                          2,F_LABEL,(argument(0)), 
                          0);
          continue;
        }
        break;

      }
      break;

    }
    advance();
  }
  for(eye=0;eye<len;eye++) free_string(instructions[eye].file);
  free((char *)instructions);
