#line 1 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: circular_list.cmod,v 1.14 2003/11/29 15:39:51 grubba Exp $
*/

#include "global.h"

#include "object.h"
#include "svalue.h"
#include "array.h"
#include "pike_error.h"
#include "interpret.h"
#include "stralloc.h"
#include "program.h"

#include "program_id.h"

#include "module_support.h"
#include "sequence.h"
#include "circular_list.h"




/*! @module ADT
 */


/*! @class CircularList
 *! This is an circular list implemented by an array. It has a constant time 
 *! complexity for pop and push. It has a limited max size but it can be 
 *! increased with the method allocate.
 *! 
 */


#undef class_CircularList_defined
#define class_CircularList_defined
struct program *CircularList_program=NULL;
static int CircularList_program_fun_num=-1;

#undef var_pos_CircularList_defined
#define var_pos_CircularList_defined

#undef var_a_CircularList_defined
#define var_a_CircularList_defined

#undef var_size_CircularList_defined
#define var_size_CircularList_defined

#undef THIS
#define THIS ((struct CircularList_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_CIRCULARLIST
#define THIS_CIRCULARLIST ((struct CircularList_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_CIRCULARLIST
#define OBJ2_CIRCULARLIST(o) ((struct CircularList_struct *)(o->storage+CircularList_storage_offset))

#undef GET_CIRCULARLIST_STORAGE
#define GET_CIRCULARLIST_STORAGE ((struct CircularList_struct *)(o->storage+CircularList_storage_offset)
static ptrdiff_t CircularList_storage_offset;
struct CircularList_struct {

#ifdef var_pos_CircularList_defined
#line 43 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
int pos;
#endif /* var_pos_CircularList_defined */

#ifdef var_a_CircularList_defined
#line 44 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct array *a;
#endif /* var_a_CircularList_defined */

#ifdef var_size_CircularList_defined
#line 45 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
int size;
#endif /* var_size_CircularList_defined */
};
/*if there is more than one reference to this array copy it. */

  static inline void should_copy()
  {
    if (THIS->a->refs > 1)
    {
      free_array(THIS->a);
      THIS->a = copy_array(THIS->a);
    }
  }  
   
  
  /*convert an index in the circular list to the index in the underlaying array */
  /*add the pos and take modulo of the size */
  inline int circ2array(int index)
    {
      return (index+THIS->pos)%THIS->a->size;
    }
  
  /*convert an index in the underlaying array to the array in the circular list */
  inline int array2circ(int index)
    {
      return (index-THIS->pos)%THIS->a->size;
    }


  
/*! @decl mixed `[](int index)
 *! Index operator
 *! 
 *! @param index
 *!   The index to get the value for, could be negative to index from the end.
 *!
 *! @returns
 *!   The value at the index @[index]
 *!
 *! @throws 
 *!   An error if the index is out of range.
 */

  #define f_CircularList_cq__backtick_5B_5D_defined
ptrdiff_t f_CircularList_cq__backtick_5B_5D_fun_num = 0;
void f_CircularList_cq__backtick_5B_5D(INT32 args) {
#line 88 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
INT_TYPE index;
#line 88 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 88 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`[]",1,"int");
index=Pike_sp[0-1].u.integer;
#line 88 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
    struct svalue ind;
    FIX_AND_CHECK_INDEX(index, THIS->size, 0);
    ind.u.integer = circ2array(index);
    ind.type = T_INT;
    simple_array_index_no_free(Pike_sp, THIS->a, &ind);
    Pike_sp++;
  }
  

}
/*! @decl mixed `[]=(int index, mixed value)
 *! Index assign operator.
 *! Set the value at the index @[index] to be @[value]
 *! 
 *! @param index 
 *!   The index to set
 *!
 *! @param value
 *!   The new value
 *!
 *! @returns
 *!   The new value at the index @[index]
 *!
 *! @throws 
 *!   An error if the index is out of range.
 */
  
  #define f_CircularList_cq__backtick_5B_5D_eq_defined
ptrdiff_t f_CircularList_cq__backtick_5B_5D_eq_fun_num = 0;
void f_CircularList_cq__backtick_5B_5D_eq(INT32 args) {
#line 115 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
INT_TYPE index;
#line 115 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * value;
#line 115 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 2) wrong_number_of_args_error("`[]=",args,2);
#line 115 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`[]=",1,"int");
index=Pike_sp[0-2].u.integer;
#line 115 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
value=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
#line 115 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
    struct svalue ind;
    FIX_AND_CHECK_INDEX(index, THIS->size, 0);
    ind.u.integer = circ2array(index);
    ind.type = T_INT;
    should_copy();  	
    simple_set_index(THIS->a, &ind, value);
    pop_n_elems(args);
  } 

 
}
/*! @decl CircularList `+(CircularList coll)
 *! Addition operator
 *! Append the content of this CircularList and @[coll] and return the results 
 *! as a new @[CircularList].
 *! 
 *! @param coll 
 *!   The list to append to his list
 *!
 *! @returns
 *!   The result of the append as a new @[CircularList]. 
 */


  #define f_CircularList_cq__backtick_add_defined
ptrdiff_t f_CircularList_cq__backtick_add_fun_num = 0;
void f_CircularList_cq__backtick_add(INT32 args) {
#line 139 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct object * coll;
#line 139 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 139 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("`+",1,"object");
#line 139 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
debug_malloc_pass(coll=Pike_sp[0-1].u.object);
{
    struct array *a;
    struct CircularList_struct *tmpList;
    struct CircularList_struct *l;
    int start=0;
    int end;
    int tmp;
    int n;
    /*Should work  om collection classes too */
    if (coll->prog == CircularList_program)
    {
      l = OBJ2_CIRCULARLIST(coll);

      a=allocate_array_no_init(THIS->a->size+l->a->size, 0);
      a->type_field = THIS->a->type_field | l->a->type_field;
      tmpList=THIS;
      
      for(n=0; n<2; n++)
      {
	end = circ2array(tmpList->size);
	
	if (end < tmpList->pos)
	{
	  /*if the list pass the end of the array do it in two parts */
	  tmp = tmpList->a->size - tmpList->pos;
	  
	  assign_svalues_no_free(ITEM(a)+start, 
				 ITEM(tmpList->a) + tmpList->pos, 
				 tmp, 
				 tmpList->a->type_field);
	  
	  assign_svalues_no_free(ITEM(a)+(tmp+start), 
				 ITEM(tmpList->a), 
				 tmpList->size-tmp, 
				 tmpList->a->type_field);
	}
	else
	{
	  /*just do it direct */
	  
	  assign_svalues_no_free(ITEM(a)+start, 
				 ITEM(tmpList->a) + tmpList->pos, 
				 tmpList->size, 
				 tmpList->a->type_field);
	}
	 
	start = tmpList->size;
	tmpList =l;
      }
          
      /*put the added array in a CircularList and return it */
      push_array(a);
      {
	struct object *o=clone_object(CircularList_program, 1);
	OBJ2_CIRCULARLIST(o)->size = THIS->size+l->size;
      
	push_object(o);
      }
    }
    else
    {
      SIMPLE_BAD_ARG_ERROR("`+",1,"ADT.CircularList");
    }
    
  }

  
  }
/*! @decl int(0..1) _equal(mixed coll)
   *!
   *! @returns
   *!   Returns @tt{true@} if the object @[coll] is a @[CircularList]
   *!   and contains the same values in the same order.
   */
  

  #define f_CircularList_cq__equal_defined
ptrdiff_t f_CircularList_cq__equal_fun_num = 0;
void f_CircularList_cq__equal(INT32 args) {
#line 215 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * coll;
#line 215 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("_equal",args,1);
#line 215 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
coll=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    if (coll->type == T_OBJECT && 
	coll->u.object->prog == CircularList_program)
    {
      struct CircularList_struct *list = OBJ2_CIRCULARLIST(coll->u.object);
      struct processing curr;
      INT32 e;
      INT32 a_pos = THIS->pos;
      INT32 b_pos = list->pos;
      struct array *a = THIS->a;
      struct array *b = list->a;

      if(a == b) do { INT_TYPE ret_=(1); pop_stack(); push_int(ret_); return; }while(0);
#line 229 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(THIS->size != list->size) do { INT_TYPE ret_=(0); pop_stack(); push_int(ret_); return; }while(0);
#line 230 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(!THIS->size) do { INT_TYPE ret_=(1); pop_stack(); push_int(ret_); return; }while(0);
#line 232 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
#ifdef PIKE_DEBUG
      if(d_flag > 1)
	{
	  array_check_type_field(a);
	  array_check_type_field(b);
	}
     #endif
      
      /* This could be done much better if I KNEW that
       * the type fields didn't contain types that
       * really aren't in the array
       */
      if(!(a->type_field & b->type_field) &&
     !( (a->type_field | b->type_field) & BIT_OBJECT ))
	do { INT_TYPE ret_=(0); pop_stack(); push_int(ret_); return; }while(0);
#line 248 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
curr.pointer_a = a;
      curr.pointer_b = b;
      curr.next = 0;
       
      
      for(e=0; e<THIS->size; e++)
      {
	if (a_pos >= a->size)
	{
	  a_pos=0;
	}
	if (b_pos >= b->size)
	{
	  b_pos=0;
	}
	if(!low_is_equal(ITEM(a)+a_pos, ITEM(b)+b_pos, &curr))
	  do { INT_TYPE ret_=(0); pop_stack(); push_int(ret_); return; }while(0);
#line 265 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
a_pos++;
	b_pos++;
      }
      do { INT_TYPE ret_=(1); pop_stack(); push_int(ret_); return; }while(0);
#line 269 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
    do { INT_TYPE ret_=(0); pop_stack(); push_int(ret_); return; }while(0);
#line 271 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

  }
/*! @decl array _indices()
   *!
   *! @returns
   *!   The indices in this list as an array.
   */

  #define f_CircularList_cq__indices_defined
ptrdiff_t f_CircularList_cq__indices_fun_num = 0;
void f_CircularList_cq__indices(INT32 args) {
#line 279 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("_indices",args,0);
{
    ptrdiff_t size = THIS->size;
    struct array *a;
    
    a=allocate_array_no_init(size,0);
    while(--size>=0)
    {
      ITEM(a)[size].u.integer = DO_NOT_WARN((INT_TYPE)size);
    }
    a->type_field = BIT_INT;
    do { struct array * ret_=(a);  push_array(ret_); return; }while(0);
#line 291 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

}
/*! @decl void _insert_element(int index, mixed value)
 *! Insert an element in the list at the position @[index], the value
 *! at the position @[index] and all above will have thier index increased 
 *! with one.
 *! 
 *! @param index 
 *!   The index to insert the value at.
 *!
 *! @param value
 *!   The new value.
 *!
 *! @throws 
 *!   An error if the index is out of range.
 *!
 */

  #define f_CircularList_cq__insert_element_defined
ptrdiff_t f_CircularList_cq__insert_element_fun_num = 0;
void f_CircularList_cq__insert_element(INT32 args) {
#line 309 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
INT_TYPE index;
#line 309 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * value;
#line 309 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 2) wrong_number_of_args_error("_insert_element",args,2);
#line 309 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_insert_element",1,"int");
index=Pike_sp[0-2].u.integer;
#line 309 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
value=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
{
    FIX_AND_CHECK_INDEX(index, THIS->size, 0);
    should_copy();
    index = circ2array(index);
    THIS->a = array_insert(THIS->a, value, index);
    THIS->size++;
    
  }

}
/*! @decl mixed _remove_element(int index)
 *!  Remove the values at index @[index] from the list.
 *! 
 *! @param index 
 *!   The index to remove.
 *!
 *! @returns
 *!   The removed value.
 *!
 *! @throws 
 *!   An error if the index is out of range.
 */

  #define f_CircularList_cq__remove_element_defined
ptrdiff_t f_CircularList_cq__remove_element_fun_num = 0;
void f_CircularList_cq__remove_element(INT32 args) {
#line 332 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
INT_TYPE index;
#line 332 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("_remove_element",args,1);
#line 332 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_remove_element",1,"int");
index=Pike_sp[0-1].u.integer;
#line 333 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
    struct svalue s;

    FIX_AND_CHECK_INDEX(index, THIS->size, 0);

    index = circ2array(index);
    s = *(THIS->a->item + index);    
    should_copy();
    THIS->a = array_remove(THIS->a, index);
    THIS->size--;
    push_svalue(&s);
  }


}
/*! @decl int _search(mixed value, void|int start)
 *!   Search the list for a specific value. Return the index of the first 
 *!   value that is equal to @[value]. If no value was found @expr{UNDEFINED@} 
 *!   is returned instead
 *! 
 *! @param value
 *!   The value to find
 *!
 *! @param start
 *!   If a start value is supplied it will start searching at the index 
 *!   @[start].
 *!
 *! @returns
 *!   Returns the index of the found value or @expr{UNDEFINED@}.
 *!
 *! @throws 
 *!   An error if the start is out of range.
 */

  #define f_CircularList_cq__search_defined
ptrdiff_t f_CircularList_cq__search_fun_num = 0;
void f_CircularList_cq__search(INT32 args) {
#line 366 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * value;
#line 366 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * start;
#line 366 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args < 1) wrong_number_of_args_error("_search",args,1);
#line 366 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args > 2) wrong_number_of_args_error("_search",args,2);
#line 366 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
value=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
if (args > 1) {
#line 366 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_search",2,"void|int");
#line 366 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
start=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else start=0;
#line 367 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
    int s;
    int retval;
    if(args == 2)
    { 
      if (start->type != PIKE_T_INT)
      { 
	SIMPLE_BAD_ARG_ERROR("_search",2,"int");
      }
      if(start->u.integer <0 || start->u.integer>=THIS->size) {
	if (THIS->a->size) {
	  Pike_error("Start %"PRINTPIKEINT"d is out of array range 0 - %d.\n",
		     start->u.integer, 
		   THIS->size-1);
	} else {
	  Pike_error("Attempt to index the empty array with %"PRINTPIKEINT"d.\n",
		     start->u.integer);
	}
      }
      s = circ2array(start->u.integer);
      retval = array2circ(array_search(THIS->a, value, s));
    }
    else 
    {
      retval = array2circ(array_search(THIS->a,value,0));
    }
    if (retval >= THIS->size || retval < 0)
    {
      retval = -1;
    }
    do { INT_TYPE ret_=(retval); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 399 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
  
}
/*! @decl int _sizeof()
 *!
 *! @returns
 *!   The number of elements in this list.
 */

  #define f_CircularList_cq__sizeof_defined
ptrdiff_t f_CircularList_cq__sizeof_fun_num = 0;
void f_CircularList_cq__sizeof(INT32 args) {
#line 407 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
{
    do { INT_TYPE ret_=(THIS->size);  push_int(ret_); return; }while(0);
#line 410 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

  }
/*! @decl array _values()
   *!
   *! @returns
   *!   The values in this list as an array.
   */
  
  #define f_CircularList_cq__values_defined
ptrdiff_t f_CircularList_cq__values_fun_num = 0;
void f_CircularList_cq__values(INT32 args) {
#line 418 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("_values",args,0);
{
    struct array *a;
    int end;
    int tmp;
    
    a=allocate_array_no_init(THIS->size, 0);
    a->type_field = THIS->a->type_field;
    end = circ2array(THIS->size);
    
    if (end <= THIS->pos && THIS->size > 0)
    {
      /*if the list pass the end of the array do it in two parts */
      tmp = THIS->a->size - THIS->pos;
      
      assign_svalues_no_free(ITEM(a), ITEM(THIS->a) + THIS->pos, 
			     tmp, THIS->a->type_field);
      
      assign_svalues_no_free(ITEM(a)+tmp, ITEM(THIS->a), 
			     THIS->size-tmp, THIS->a->type_field);
    }
    else
    {
      /*just do it direct */
      
      assign_svalues_no_free(ITEM(a), ITEM(THIS->a) + THIS->pos, 
			     THIS->size, THIS->a->type_field);
    }
    do { struct array * ret_=(a);  push_array(ret_); return; }while(0);
#line 447 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

  
}
/*! @decl void add(mixed value)
 *!   Add a value at the front of the list
 *!
 *! @param value
 *!   The value to add.
 *!
 *! @throws 
 *!   An error if the list is full.
 */

  #define f_CircularList_add_defined
ptrdiff_t f_CircularList_add_fun_num = 0;
void f_CircularList_add(INT32 args) {
#line 460 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * value;
#line 460 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("add",args,1);
#line 460 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
value=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    struct svalue ind;
    if (THIS->size == THIS->a->size)
    {
      Pike_error("The list is full, could not add value, please allocate more space.\n");
    }
    should_copy();
    THIS->pos--;
    if (THIS->pos < 0)
    {
      THIS->pos=THIS->a->size-1;
    }
    ind.u.integer = THIS->pos;
    ind.type = T_INT;
    simple_set_index(THIS->a, &ind, value);
    THIS->size++;
    pop_n_elems(args);
  }

  }
/*! @decl void allocate(int elements)
   *! Increase the maxsize of the CircularlList.
   *!
   *! @param elements
   *!       Add this number of new elements to the list.
   */

  #define f_CircularList_allocate_defined
ptrdiff_t f_CircularList_allocate_fun_num = 0;
void f_CircularList_allocate(INT32 args) {
#line 487 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
INT_TYPE elements;
#line 487 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("allocate",args,1);
#line 487 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("allocate",1,"int");
elements=Pike_sp[0-1].u.integer;
#line 488 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
    INT32 size = THIS->a->size+elements;
    INT32 endpos = THIS->a->size - THIS->pos; /*distanse of pos from the end */
    if (elements <= 0)
    {
      Pike_error("Allocate expects an value bigger than zero\n");
    }
    if(THIS->a->refs <= 1 && THIS->a->malloced_size >= size)
    {
      for(;THIS->a->size < size; THIS->a->size++)
      {
	ITEM(THIS->a)[THIS->a->size].type=T_INT;
	ITEM(THIS->a)[THIS->a->size].subtype=NUMBER_NUMBER;
	ITEM(THIS->a)[THIS->a->size].u.integer=0;
      }
      THIS->a->type_field |= BIT_INT;
      if (THIS->size > 0)
      {
	MEMMOVE((char *)(ITEM(THIS->a)+(size-endpos)),
		(char *)(ITEM(THIS->a)+(THIS->pos)),
		(endpos) * sizeof(struct svalue));
	THIS->pos = size-endpos;
      }
    }
    else
    {
      struct array *a;
      a=allocate_array_no_init(size,  (THIS->a->size >> 1) + 4);
      a->type_field = THIS->a->type_field;
      if (THIS->size >0)
      {
	/*copy from pos to end */
	assign_svalues_no_free(ITEM(a), 
			       ITEM(THIS->a)+(THIS->pos), 
			       endpos, 
			       THIS->a->type_field);
	/*copy from start to size */
	assign_svalues_no_free(ITEM(a)+endpos, 
			       ITEM(THIS->a), 
			       THIS->size-endpos, 
			       THIS->a->type_field);
      }
      free_array(THIS->a);
      THIS->a=a;
      THIS->pos=0;
    }
    pop_n_elems(args);
  }

}
/*! @decl mixed cast(string type)
 *! Cast operator.
 *!
 *! @param type
 *!   Casts to this type.
 *!
 *!   Casts to the following types are supported:
 *!   @string
 *!     @value "array"
 *!       Cast the content of this list to an array.
 *!   @endstring
 *!
 *! @returns
 *!   An array with the contents of this list.
 */

  #define f_CircularList_cast_defined
ptrdiff_t f_CircularList_cast_fun_num = 0;
void f_CircularList_cast(INT32 args) {
#line 553 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct pike_string * type;
#line 553 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 553 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("cast",1,"string");
#line 553 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
debug_malloc_pass(type=Pike_sp[0-1].u.string);
{
    struct pike_string *array_t;
    MAKE_CONST_STRING( array_t, "array" );
    
    if (type == array_t)
    {
      struct array *a;
      int end;
      int tmp;
    
      a=allocate_array_no_init(THIS->size, 0);
      a->type_field = THIS->a->type_field;
      end = circ2array(THIS->size);
      
      if (end < THIS->pos)
      {
	/*if the list pass the end of the array do it in two parts */
	tmp = THIS->a->size - THIS->pos;
	
	assign_svalues_no_free(ITEM(a), ITEM(THIS->a) + THIS->pos, 
			       tmp, THIS->a->type_field);
	
	assign_svalues_no_free(ITEM(a)+tmp, ITEM(THIS->a), 
			       THIS->size-tmp, THIS->a->type_field);
      }
      else
      {
	/*just do it direct */
	
	assign_svalues_no_free(ITEM(a), ITEM(THIS->a) + THIS->pos, 
			     THIS->size, THIS->a->type_field);
      }
      push_array(a);

    }
    else
    {
      Pike_error("Cannot cast to %s\n", type->str );
    }
  }

  }
/*! @decl void clear()
   *!   Clear the contents of the list.
   *!
   */

  #define f_CircularList_clear_defined
ptrdiff_t f_CircularList_clear_fun_num = 0;
void f_CircularList_clear(INT32 args) {
#line 600 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("clear",args,0);
{
    int oldsize;
    should_copy();
    oldsize = THIS->a->size;
    THIS->a = resize_array(THIS->a, 0);
    THIS->a = resize_array(THIS->a, oldsize);
    THIS->size =0;
    THIS->pos  =0;
  }   

  }
/*! @decl int delete_value(mixed value)
   *!   Remove the first occurrence of the value @[value] from the list.
   *!
   *! @param value
   *!   The value to remove from the list.
   *!
   *! @returns
   *!   The index of the removed element or -1 if there was no value to 
   *!   remove.
   */
  
  #define f_CircularList_delete_value_defined
ptrdiff_t f_CircularList_delete_value_fun_num = 0;
void f_CircularList_delete_value(INT32 args) {
#line 622 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * value;
#line 622 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("delete_value",args,1);
#line 622 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
value=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    INT32 index = array_search(THIS->a, value, THIS->pos);
    INT32 pos = array2circ(index);
    if (pos < THIS->size && index > -1)
    {
      should_copy();
      THIS->a = array_remove(THIS->a, index);
      THIS->size--;
      do { INT_TYPE ret_=(pos); pop_stack(); push_int(ret_); return; }while(0);
#line 632 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
    else
    {
      do { INT_TYPE ret_=(-1); pop_stack(); push_int(ret_); return; }while(0);
#line 636 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
  }

  }
/*! @decl int(0..1) is_empty()
   *!
   *! @returns
   *!   Returns @expr{1@} if the list is empty otherwise @expr{0@}. 
   */

  #define f_CircularList_is_empty_defined
ptrdiff_t f_CircularList_is_empty_fun_num = 0;
void f_CircularList_is_empty(INT32 args) {
#line 645 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("is_empty",args,0);
{
    do { INT_TYPE ret_=(!(THIS->size));  push_int(ret_); return; }while(0);
#line 648 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

  }
/*! @decl int max_size()
   *!
   *! @returns
   *!   Returns the maximal size of this list.
   */

  #define f_CircularList_max_size_defined
ptrdiff_t f_CircularList_max_size_fun_num = 0;
void f_CircularList_max_size(INT32 args) {
#line 656 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("max_size",args,0);
{
    do { INT_TYPE ret_=(THIS->a->size);  push_int(ret_); return; }while(0);
#line 659 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

  }
/*! @decl mixed peek_back()
   *!
   *! @returns
   *!    The value at the back of the list but do not remove it from the list.
   */

 #define f_CircularList_peek_back_defined
ptrdiff_t f_CircularList_peek_back_fun_num = 0;
void f_CircularList_peek_back(INT32 args) {
#line 667 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("peek_back",args,0);
{
    struct svalue ind;
    if (THIS->size <= 0)
    {
      Pike_error("Can not peek an empty list.\n");
    }
    ind.u.integer=circ2array(THIS->size-1);
    ind.type =T_INT;
    simple_array_index_no_free(Pike_sp, THIS->a, &ind);
    Pike_sp++;
  }

  }
/*! @decl mixed peek_front()
   *!
   *! @returns
   *!    The value at the front of the list but do not remove it from the list.
   */

  #define f_CircularList_peek_front_defined
ptrdiff_t f_CircularList_peek_front_fun_num = 0;
void f_CircularList_peek_front(INT32 args) {
#line 686 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("peek_front",args,0);
{
    struct svalue ind;
    if (THIS->size == 0)
    {
      Pike_error("Can not peek an empty list.\n");
    }
    ind.u.integer=THIS->pos;
    ind.type =T_INT;
    simple_array_index_no_free(Pike_sp, THIS->a, &ind);
    Pike_sp++;
  }
  
  }
/*! @decl mixed pop_back()
   *! 
   *! Remove the value at the back of the list and return it.
   *!
   *! @returns
   *!    The value at the back of the list.
   */

  #define f_CircularList_pop_back_defined
ptrdiff_t f_CircularList_pop_back_fun_num = 0;
void f_CircularList_pop_back(INT32 args) {
#line 707 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("pop_back",args,0);
{
    struct svalue ind;
    struct svalue zero;
    if (THIS->size <= 0)
    {
      Pike_error("Can not pop an empty list.\n");
    }
    
    should_copy();
    THIS->size--;
    ind.u.integer=circ2array(THIS->size);
    ind.type =T_INT;
    zero.u.integer=0;
    zero.type =T_INT;
    simple_array_index_no_free(Pike_sp, THIS->a, &ind);
    simple_set_index(THIS->a, &ind, &zero);
    Pike_sp++;
  }

  
  }
/*! @decl mixed pop_front()
   *! 
   *! Remove the value at the front of the list and return it.
   *!
   *! @returns
   *!    The value at the front of the list.
   */

  #define f_CircularList_pop_front_defined
ptrdiff_t f_CircularList_pop_front_fun_num = 0;
void f_CircularList_pop_front(INT32 args) {
#line 736 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("pop_front",args,0);
{
    struct svalue ind;
    struct svalue zero;
    if (THIS->size == 0)
    {
      Pike_error("Can not pop an empty list.\n");
    }
    
    should_copy();
    ind.u.integer=THIS->pos;
    ind.type =T_INT;
    zero.u.integer=0;
    zero.type =T_INT;
    if (++THIS->pos >= THIS->a->size)
    {
      THIS->pos = 0;
    }
    THIS->size--;
    simple_array_index_no_free(Pike_sp, THIS->a, &ind);
    simple_set_index(THIS->a, &ind, &zero);
    Pike_sp++;
  }
  
  
  }
/*! @decl void push_back(mixed value)
   *! 
   *! Add a new value at the end of the list.
   *!
   *! @param value
   *!    The value to add.
   */

  #define f_CircularList_push_back_defined
ptrdiff_t f_CircularList_push_back_fun_num = 0;
void f_CircularList_push_back(INT32 args) {
#line 769 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * value;
#line 769 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("push_back",args,1);
#line 769 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
value=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    struct svalue ind;
    should_copy();
    if (THIS->size == THIS->a->size)
    {
      Pike_error("The list is full, could not add value, please allocate more memory.\n");
    }
    
    ind.u.integer=circ2array(THIS->size);
    ind.type =T_INT;
    THIS->size++;
    simple_set_index(THIS->a, &ind, value);
  }

  
  }
/*! @decl void push_front(mixed value)
   *! 
   *! Add a new value at the end of the list.
   *!
   *! @param value
   *!    The value to add.
   */

  #define f_CircularList_push_front_defined
ptrdiff_t f_CircularList_push_front_fun_num = 0;
void f_CircularList_push_front(INT32 args) {
#line 793 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * value;
#line 793 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("push_front",args,1);
#line 793 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
value=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    struct svalue ind;
    if (THIS->size == THIS->a->size)
    {
      Pike_error("The list is full, could not add value, please allocate more space.\n");
    }
    should_copy();
    THIS->pos--;
    if (THIS->pos < 0)
    {
      THIS->pos=THIS->a->size-1;
    }
    ind.u.integer = THIS->pos;
    ind.type = T_INT;
    simple_set_index(THIS->a, &ind, value);
    THIS->size++;
    pop_n_elems(args);
  }


  }
/*! @decl void create(array|int arg)
   *!   Creates a new @[CircularList] around the array arg or a new
   *!   @[CircularList] with the maximum size of arg.
   */

  #define f_CircularList_create_defined
ptrdiff_t f_CircularList_create_fun_num = 0;
void f_CircularList_create(INT32 args) {
#line 819 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * arg;
#line 819 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("create",args,1);
#line 819 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
arg=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    if (arg->type == T_INT)
    {
      THIS->a =allocate_array_no_init(arg->u.integer, 0);
      THIS->a->type_field = BIT_INT;
    }
    else if (arg->type == T_ARRAY)
    {
      add_ref(THIS->a=arg->u.array);
      THIS->size=THIS->a->size;
    }
      
    pop_n_elems(args);
  }
  
  }
/*! @decl CircularListIterator _get_iterator(void|int ind)
   *!   Create and initiate a new CircularListIterator that could be used
   *!   to iterate over this list.
   *!
   *! @param ind
   *!   If an @[ind] value is supplied the iterator will be positioned at
   *!   that index.
   *!
   *! @returns
   *!   An iterator.
   */


  
  /*! @decl CircularListIterator first()
   *!   Create and initiate a new CircularListIterator that could be used
   *!   to iterate over this list.
   *!
   *! @returns
   *!   An iterator positioned at the first element in the list.
   */

  
  /*! @decl CircularListIterator last()
   *!   Create and initiate a new CircularListIterator that could be used
   *!   to iterate over this list.
   *!
   *! @returns
   *!   An iterator positioned after the last element in the list.
   */


  
#undef internal_init_CircularList_defined
#define internal_init_CircularList_defined

#undef CircularList_event_handler_defined
#define CircularList_event_handler_defined
static void init_CircularList_struct(void)
#line 868 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
    THIS->a=0;
    THIS->pos=0;
    THIS->size=0;
  }

  
#undef internal_exit_CircularList_defined
#define internal_exit_CircularList_defined

#undef CircularList_event_handler_defined
#define CircularList_event_handler_defined
static void exit_CircularList_struct(void)
#line 875 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
    free_array(THIS->a);
  }

   

  /*! @class CircularListIterator
   *!    This is the iterator for the CircularList. It implements the 
   *!    IndexIterator and the OutputIterator.
   */  
  
  
#undef class_CircularList_CircularListIterator_defined
#define class_CircularList_CircularListIterator_defined
struct program *CircularList_CircularListIterator_program=NULL;
static int CircularList_CircularListIterator_program_fun_num=-1;

#undef var_pos_CircularList_CircularListIterator_defined
#define var_pos_CircularList_CircularListIterator_defined

#undef var_list_CircularList_CircularListIterator_defined
#define var_list_CircularList_CircularListIterator_defined

#undef var_obj_CircularList_CircularListIterator_defined
#define var_obj_CircularList_CircularListIterator_defined

#undef THIS
#define THIS ((struct CircularList_CircularListIterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_CIRCULARLIST_CIRCULARLISTITERATOR
#define THIS_CIRCULARLIST_CIRCULARLISTITERATOR ((struct CircularList_CircularListIterator_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_CIRCULARLIST_CIRCULARLISTITERATOR
#define OBJ2_CIRCULARLIST_CIRCULARLISTITERATOR(o) ((struct CircularList_CircularListIterator_struct *)(o->storage+CircularList_CircularListIterator_storage_offset))

#undef GET_CIRCULARLIST_CIRCULARLISTITERATOR_STORAGE
#define GET_CIRCULARLIST_CIRCULARLISTITERATOR_STORAGE ((struct CircularList_CircularListIterator_struct *)(o->storage+CircularList_CircularListIterator_storage_offset)
static ptrdiff_t CircularList_CircularListIterator_storage_offset;
struct CircularList_CircularListIterator_struct {

#ifdef var_pos_CircularList_CircularListIterator_defined
#line 888 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
int pos;
#endif /* var_pos_CircularList_CircularListIterator_defined */

#ifdef var_list_CircularList_CircularListIterator_defined
#line 889 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct CircularList_struct *list;
#endif /* var_list_CircularList_CircularListIterator_defined */

#ifdef var_obj_CircularList_CircularListIterator_defined
#line 890 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct object *obj;
#endif /* var_obj_CircularList_CircularListIterator_defined */
};
/*! @decl void create(object list, void|int start)
   *!   Creates a new iterator for the CircularList @[list]. If @[start] is
   *!   supplied it will try to position the iterator at @[start].
   *! 
   */

    #define f_CircularList_CircularListIterator_create_defined
ptrdiff_t f_CircularList_CircularListIterator_create_fun_num = 0;
void f_CircularList_CircularListIterator_create(INT32 args) {
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct object * list;
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * start;
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args < 1) wrong_number_of_args_error("create",args,1);
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-args].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("create",1,"object");
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
debug_malloc_pass(list=Pike_sp[0-args].u.object);
if (args > 1) {
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",2,"void|int");
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
start=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else start=0;
#line 900 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
      
      if (list->prog != CircularList_program)
      {
	SIMPLE_BAD_ARG_ERROR("create",1,"ADT.CircularList");
      
      }
      else
      {
	THIS->list = OBJ2_CIRCULARLIST(list);
	add_ref(THIS->obj = list);
	if (args == 2) /* if there was an start index supplied */
	{
	  THIS->pos=start->u.integer;
	  if (THIS->list->a && ((THIS->pos > THIS->list->size) 
				   || (THIS->pos < 0)))
	  {
	      Pike_error("Index %d is out of array range 0 - %d.\n", 
			 THIS->pos, 
			 THIS->list->size);
	  }
	}
	else
	{
	  THIS->pos = 0;
	}
      }
      pop_n_elems(args);
    }
    
    }
/*! @decl int index()
     *!   
     *! @returns
     *!    The index at the current position.
     */

    #define f_CircularList_CircularListIterator_index_defined
ptrdiff_t f_CircularList_CircularListIterator_index_fun_num = 0;
void f_CircularList_CircularListIterator_index(INT32 args) {
#line 936 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("index",args,0);
{
      if(!THIS->list || 
	 !THIS->list->a || 
	 THIS->pos >= THIS->list->size) 
      {
	push_int(0);
	Pike_sp[-1].subtype=NUMBER_UNDEFINED;
      }
      else
      {
      	do { INT_TYPE ret_=(THIS->pos);  push_int(ret_); return; }while(0);
#line 948 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
    }
    
    
    }
/*! @decl mixed value()
     *!   
     *! @returns
     *!    The value at the current position.
     */

    #define f_CircularList_CircularListIterator_value_defined
ptrdiff_t f_CircularList_CircularListIterator_value_fun_num = 0;
void f_CircularList_CircularListIterator_value(INT32 args) {
#line 958 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("value",args,0);
{
      if(!THIS->list || 
	 !THIS->list->a || 
	 THIS->pos >= THIS->list->size) 
      {
	push_int(0);
	Pike_sp[-1].subtype=NUMBER_UNDEFINED;
      }
      else
      {
	push_svalue(THIS->list->a->item + 
		    (THIS->pos+THIS->list->pos)%THIS->list->a->size);
      }
    }


    }
/*! @decl CircularListIterator `+(int steps)
     *!   Move the iterator @[steps] steps forward (negative value on @[steps]
     *!   will cause the iterator to move backwards) and return the result
     *!   as a new iterator.
     *! @returns
     *!    A new iterator positioned @[steps] steps forward.
     */    

    #define f_CircularList_CircularListIterator_cq__backtick_add_defined
ptrdiff_t f_CircularList_CircularListIterator_cq__backtick_add_fun_num = 0;
void f_CircularList_CircularListIterator_cq__backtick_add(INT32 args) {
#line 983 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
INT_TYPE steps;
#line 983 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 983 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 984 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
      struct object *o=low_clone(CircularList_CircularListIterator_program);
      struct CircularList_CircularListIterator_struct *new;
      new = OBJ2_CIRCULARLIST_CIRCULARLISTITERATOR(o);
      new[0]=*THIS;
      add_ref(THIS->obj);
      new->pos+=steps;
      if (new->pos < 0) 
      { 
	new->pos = 0;
      }
      else if (new->pos > new->list->size) 
      { 
	new->pos = new->list->size; 
      }
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 1000 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}    

    }
/*! @decl CircularListIterator `+=(int steps)
     *!   Move this iterator @[steps] steps forward (negative value on @[steps]
     *!   will cause the iterator to move backwards) and return the result.
     *!
     *! @returns
     *!    This iterator positioned @[steps] steps forward.
     */    


    #define f_CircularList_CircularListIterator_cq__backtick_add_eq_defined
ptrdiff_t f_CircularList_CircularListIterator_cq__backtick_add_eq_fun_num = 0;
void f_CircularList_CircularListIterator_cq__backtick_add_eq(INT32 args) {
#line 1011 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
INT_TYPE steps;
#line 1011 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 1011 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`+=",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 1012 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
      THIS->pos+=steps;
      if (THIS->pos < 0) 
      { 
	THIS->pos = 0;
      }
      else if (THIS->pos > THIS->list->size) 
      { 
	THIS->pos = THIS->list->size; 
      }
      
      do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 1024 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

    

    }
/*! @decl CircularListIterator `-(int steps)
     *!   Move the iterator @[steps] steps backwards (negative value on 
     *!   @[steps] will cause the iterator to move forwards) and return 
     *!   the result as a new iterator.
     *! @returns
     *!    A new iterator positioned @[steps] steps backwards.
     */    

    #define f_CircularList_CircularListIterator_cq__backtick_2D_defined
ptrdiff_t f_CircularList_CircularListIterator_cq__backtick_2D_fun_num = 0;
void f_CircularList_CircularListIterator_cq__backtick_2D(INT32 args) {
#line 1036 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
INT_TYPE steps;
#line 1036 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("`-",args,1);
#line 1036 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`-",1,"int");
steps=Pike_sp[0-1].u.integer;
#line 1037 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
      struct object *o=low_clone(CircularList_CircularListIterator_program);
      struct CircularList_CircularListIterator_struct *new;
      new = OBJ2_CIRCULARLIST_CIRCULARLISTITERATOR(o);
      new[0]=*THIS;
      add_ref(THIS->obj);
      new->pos-=steps;
      if (new->pos < 0) 
      { 
	new->pos = 0;
      }
      else if (new->pos > new->list->size) 
      { 
	new->pos = new->list->size; 
      }
      do { struct object * ret_=(o); pop_stack(); push_object(ret_); return; }while(0);
#line 1053 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

    
    }
/*! @decl int(0..1) has_next(void|int steps)
     *! @returns
     *!    Returns @tt{true@} if it is possible to move @[steps] steps
     *!    forwards, if @[steps] weren't supplied it check if it is
     *!    possible to move one step forward.
     */    

    #define f_CircularList_CircularListIterator_has_next_defined
ptrdiff_t f_CircularList_CircularListIterator_has_next_fun_num = 0;
void f_CircularList_CircularListIterator_has_next(INT32 args) {
#line 1063 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * steps;
#line 1063 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args > 1) wrong_number_of_args_error("has_next",args,1);
if (args > 0) {
#line 1063 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("has_next",1,"void|int");
#line 1063 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
steps=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else steps=0;
#line 1064 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
      if (args==0)
      {
	do { INT_TYPE ret_=((THIS->list && 
		(THIS->pos + 1) <= THIS->list->size)); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1069 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
      else
      {	
	do { INT_TYPE ret_=((THIS->list && 
		(THIS->pos + steps->u.integer) >= 0 &&
		(THIS->pos + steps->u.integer) <= THIS->list->size)); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1075 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
    }
    
    
    }
/*! @decl int(0..1) has_previous(void|int steps)
     *! @returns
     *!    Returns @tt{true@} if it is possible to move @[steps] steps
     *!    backwards, if @[steps] weren't supplied it check if it is
     *!    possible to move one step backward.
     */  

    #define f_CircularList_CircularListIterator_has_previous_defined
ptrdiff_t f_CircularList_CircularListIterator_has_previous_fun_num = 0;
void f_CircularList_CircularListIterator_has_previous(INT32 args) {
#line 1086 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * steps;
#line 1086 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args > 1) wrong_number_of_args_error("has_previous",args,1);
if (args > 0) {
#line 1086 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("has_previous",1,"void|int");
#line 1086 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
steps=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else steps=0;
#line 1087 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
      if (args==0)
      {
	do { INT_TYPE ret_=((THIS->list && 
		(THIS->pos) > 0)); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1092 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
      else
      {
	do { INT_TYPE ret_=((THIS->list && 
		(THIS->pos - steps->u.integer) >= 0 &&
		(THIS->pos - steps->u.integer) <= THIS->list->size)); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1098 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
    }

    
    }
/*! @decl int(0..1) `!()
     *! @returns
     *!    Returns @tt{false@} if the iterator has reached the end.
     */  

    #define f_CircularList_CircularListIterator_cq__backtick_21_defined
ptrdiff_t f_CircularList_CircularListIterator_cq__backtick_21_fun_num = 0;
void f_CircularList_CircularListIterator_cq__backtick_21(INT32 args) {
#line 1107 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
{
      do { INT_TYPE ret_=((THIS->list && 
	      THIS->pos  == THIS->list->size));  push_int(ret_); return; }while(0);
#line 1111 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

    
    }
/*! @decl int(0..1) _equal(mixed iter)
     *!    Compare this iterator with another iterator.
     *! 
     *! @param iter
     *!    The iterator to compare with
     *! @returns
     *!    Returns @tt{true@} if both iterators iterates over the same
     *!    objects and are positioned at the same spot.
     */  

    #define f_CircularList_CircularListIterator_cq__equal_defined
ptrdiff_t f_CircularList_CircularListIterator_cq__equal_fun_num = 0;
void f_CircularList_CircularListIterator_cq__equal(INT32 args) {
#line 1124 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * iter;
#line 1124 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("_equal",args,1);
#line 1124 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
iter=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
      if (iter->type == T_OBJECT && 
	  iter->u.object->prog == CircularList_CircularListIterator_program)
      {
	struct CircularList_CircularListIterator_struct *i = 
	  OBJ2_CIRCULARLIST_CIRCULARLISTITERATOR(iter->u.object);
	do { INT_TYPE ret_=((THIS->list == i->list && THIS->pos == i->pos)); pop_stack(); push_int(ret_); return; }while(0);
#line 1132 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
      else
      {
	do { INT_TYPE ret_=(0); pop_stack(); push_int(ret_); return; }while(0);
#line 1136 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
    }
	
    
    }
/*! @decl int(0..1) `<(mixed iter)
     *!    Less then operator
     *!
     *! @returns
     *!    Returns @tt{true@} if this iterator has a lower index
     *!    then @[iter].
     */

    #define f_CircularList_CircularListIterator_cq__backtick_3C_defined
ptrdiff_t f_CircularList_CircularListIterator_cq__backtick_3C_fun_num = 0;
void f_CircularList_CircularListIterator_cq__backtick_3C(INT32 args) {
#line 1148 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * iter;
#line 1148 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("`<",args,1);
#line 1148 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
iter=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
      if (iter->type == T_OBJECT &&
	  iter->u.object->prog == CircularList_CircularListIterator_program)
      {
	struct CircularList_CircularListIterator_struct *i = 
	  OBJ2_CIRCULARLIST_CIRCULARLISTITERATOR(iter->u.object);
	do { INT_TYPE ret_=((THIS->pos < i->pos)); pop_stack(); push_int(ret_); return; }while(0);
#line 1156 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
      else
      {
	SIMPLE_BAD_ARG_ERROR("`<",1,"ADT.CircularList.CircularListIterator");
      }
    }


    }
/*! @decl int(0..1) `>(mixed iter)
     *!    Greater then operator
     *!
     *! @returns
     *!    Returns @tt{true@} if this iterator has a higher index
     *!    then @[iter].
     */


    #define f_CircularList_CircularListIterator_cq__backtick_3E_defined
ptrdiff_t f_CircularList_CircularListIterator_cq__backtick_3E_fun_num = 0;
void f_CircularList_CircularListIterator_cq__backtick_3E(INT32 args) {
#line 1173 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * iter;
#line 1173 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("`>",args,1);
#line 1173 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
iter=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
      if (iter->type == T_OBJECT &&
	  iter->u.object->prog == CircularList_CircularListIterator_program)
      {
	struct CircularList_CircularListIterator_struct *i = 
	  OBJ2_CIRCULARLIST_CIRCULARLISTITERATOR(iter->u.object);
	do { INT_TYPE ret_=((THIS->pos > i->pos)); pop_stack(); push_int(ret_); return; }while(0);
#line 1181 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
      else
      {
	SIMPLE_BAD_ARG_ERROR("`>",1,"ADT.CircularList.CircularListIterator");
      }
    }
    
    }
/*! @decl int distance(object iter)
     *!
     *! @param iter
     *!    The iterator to measure the distance to.
     *! @returns
     *!    Returns distance between this iterator and @[iter].
     *! @throws
     *!    An error if the two iterator could not be compared.
     */  

    #define f_CircularList_CircularListIterator_distance_defined
ptrdiff_t f_CircularList_CircularListIterator_distance_fun_num = 0;
void f_CircularList_CircularListIterator_distance(INT32 args) {
#line 1198 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct object * iter;
#line 1198 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("distance",args,1);
#line 1198 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("distance",1,"object");
#line 1198 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
debug_malloc_pass(iter=Pike_sp[0-1].u.object);
{
      if (iter->prog == CircularList_CircularListIterator_program)
      {
	
	struct CircularList_CircularListIterator_struct *i = 
	  OBJ2_CIRCULARLIST_CIRCULARLISTITERATOR(iter);
	do { INT_TYPE ret_=((i->pos - THIS->pos)); pop_stack(); push_int(ret_); return; }while(0);
#line 1206 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}
      else
      {
	SIMPLE_BAD_ARG_ERROR("`-",1,"ADT.CircularList.CircularListIterator");
      }
    }

    }
/*! @decl CircularList get_collection()
     *!
     *! @returns
     *!    Returns the CircularList this iterator currently iterates over.
     */  


    #define f_CircularList_CircularListIterator_get_collection_defined
ptrdiff_t f_CircularList_CircularListIterator_get_collection_fun_num = 0;
void f_CircularList_CircularListIterator_get_collection(INT32 args) {
#line 1220 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("get_collection",args,0);
{
      do { struct object * ret_=(THIS->obj); add_ref(ret_);  push_object(ret_); return; }while(0);
#line 1223 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
}

    
    }
/*! @decl mixed set_value(mixed val)
     *!    Set the value at the current position.
     *!
     *! @param val
     *!    The new value
     *! @returns
     *!    Returns the old value
     */  


    #define f_CircularList_CircularListIterator_set_value_defined
ptrdiff_t f_CircularList_CircularListIterator_set_value_fun_num = 0;
void f_CircularList_CircularListIterator_set_value(INT32 args) {
#line 1236 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * val;
#line 1236 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 1) wrong_number_of_args_error("set_value",args,1);
#line 1236 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
val=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
      if (THIS->list && 
	  THIS->pos < THIS->list->size)
      {
	struct svalue ind;
	struct svalue retval;

	/*if there is someone else using the array but the list */
	if (THIS->list->a->refs > 1)
	{
	  /*copy it */
	  free_array(THIS->list->a);
	  THIS->list->a = copy_array(THIS->list->a);
	}

	ind.u.integer =  (THIS->pos+THIS->list->pos)%THIS->list->a->size;
	ind.type = T_INT;
	simple_array_index_no_free(&retval, THIS->list->a, &ind);
	simple_set_index(THIS->list->a, &ind, val);
	push_svalue(&retval);
      }
      else
      {
	push_int(0);
	Pike_sp[-1].subtype=NUMBER_UNDEFINED;
      }
    }
    
    }

#undef internal_init_CircularList_CircularListIterator_defined
#define internal_init_CircularList_CircularListIterator_defined

#undef CircularList_CircularListIterator_event_handler_defined
#define CircularList_CircularListIterator_event_handler_defined
static void init_CircularList_CircularListIterator_struct(void)
#line 1266 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
      THIS->list=0;
      THIS->pos=0;
    }

    
#undef internal_exit_CircularList_CircularListIterator_defined
#define internal_exit_CircularList_CircularListIterator_defined

#undef CircularList_CircularListIterator_event_handler_defined
#define CircularList_CircularListIterator_event_handler_defined
static void exit_CircularList_CircularListIterator_struct(void)
#line 1272 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
      free_object(THIS->obj);
    }
    
  
#ifdef CircularList_CircularListIterator_event_handler_defined
static void CircularList_CircularListIterator_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_CircularList_CircularListIterator_defined
  case PROG_EVENT_INIT: init_CircularList_CircularListIterator_struct(); break;

#endif /* internal_init_CircularList_CircularListIterator_defined */

#ifdef internal_exit_CircularList_CircularListIterator_defined
  case PROG_EVENT_EXIT: exit_CircularList_CircularListIterator_struct(); break;

#endif /* internal_exit_CircularList_CircularListIterator_defined */
  default: break; 
  }
}

#endif /* CircularList_CircularListIterator_event_handler_defined */
/*End CircularListIterator */
  /*! @endclass
  */
  
  #define f_CircularList_cq__get_iterator_defined
ptrdiff_t f_CircularList_cq__get_iterator_fun_num = 0;
void f_CircularList_cq__get_iterator(INT32 args) {
#line 1282 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
struct svalue * ind;
#line 1282 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args > 1) wrong_number_of_args_error("_get_iterator",args,1);
if (args > 0) {
#line 1282 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_get_iterator",1,"void|int");
#line 1282 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
ind=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else ind=0;
#line 1283 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
{
    ref_push_object(Pike_fp->current_object);
    if (args > 0)
    {
      push_svalue(ind);
    }
    push_object(clone_object(CircularList_CircularListIterator_program,
			     args+1));
  }

  

  }
#define f_CircularList_first_defined
ptrdiff_t f_CircularList_first_fun_num = 0;
void f_CircularList_first(INT32 args) {
#line 1295 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("first",args,0);
{
    ref_push_object(Pike_fp->current_object);
    push_object(clone_object(CircularList_CircularListIterator_program, 1));
  }



  }
#define f_CircularList_last_defined
ptrdiff_t f_CircularList_last_fun_num = 0;
void f_CircularList_last(INT32 args) {
#line 1303 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
if(args != 0) wrong_number_of_args_error("last",args,0);
{
    struct svalue ind;
    ind.u.integer=THIS_CIRCULARLIST->size;
    ind.type=T_INT;
    ref_push_object(Pike_fp->current_object);
    push_svalue(&ind);
    push_object(clone_object(CircularList_CircularListIterator_program, 2));
  }

  
}

#ifdef CircularList_event_handler_defined
static void CircularList_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_CircularList_defined
  case PROG_EVENT_INIT: init_CircularList_struct(); break;

#endif /* internal_init_CircularList_defined */

#ifdef internal_exit_CircularList_defined
  case PROG_EVENT_EXIT: exit_CircularList_struct(); break;

#endif /* internal_exit_CircularList_defined */
  default: break; 
  }
}

#endif /* CircularList_event_handler_defined */
/*End of CircularList */
/*! @endclass    
  */

/*! @endmodule
 */


#line 1325 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
void pike_init_CircularList_module(void)
{
  
#ifdef class_CircularList_defined

#ifdef PROG_CIRCULARLIST_ID
#line 40 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
  START_NEW_PROGRAM_ID(CIRCULARLIST);
#else
#line 40 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
  start_new_program();

#endif /* PROG_CIRCULARLIST_ID */

#ifndef tObjImpl_CIRCULARLIST

#undef tObjImpl_CIRCULARLIST
#define tObjImpl_CIRCULARLIST tObj

#endif /* tObjImpl_CIRCULARLIST */

#ifdef THIS_CIRCULARLIST

  CircularList_storage_offset=ADD_STORAGE(struct CircularList_struct);

#endif /* THIS_CIRCULARLIST */

#ifdef class_CircularList_CircularListIterator_defined

#ifdef PROG_CIRCULARLIST_CIRCULARLISTITERATOR_ID
#line 886 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
  START_NEW_PROGRAM_ID(CIRCULARLIST_CIRCULARLISTITERATOR);
#else
#line 886 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
  start_new_program();

#endif /* PROG_CIRCULARLIST_CIRCULARLISTITERATOR_ID */

#ifndef tObjImpl_CIRCULARLIST_CIRCULARLISTITERATOR

#undef tObjImpl_CIRCULARLIST_CIRCULARLISTITERATOR
#define tObjImpl_CIRCULARLIST_CIRCULARLISTITERATOR tObj

#endif /* tObjImpl_CIRCULARLIST_CIRCULARLISTITERATOR */

#ifdef THIS_CIRCULARLIST_CIRCULARLISTITERATOR

  CircularList_CircularListIterator_storage_offset=ADD_STORAGE(struct CircularList_CircularListIterator_struct);

#endif /* THIS_CIRCULARLIST_CIRCULARLISTITERATOR */

#ifdef CircularList_CircularListIterator_event_handler_defined
  pike_set_prog_event_callback(CircularList_CircularListIterator_event_handler);

#endif /* CircularList_CircularListIterator_event_handler_defined */

#ifdef f_CircularList_CircularListIterator_create_defined
  f_CircularList_CircularListIterator_create_fun_num =
#line 899 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("create", f_CircularList_CircularListIterator_create, tFunc(tObj tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_create_defined */

#ifdef f_CircularList_CircularListIterator_index_defined
  f_CircularList_CircularListIterator_index_fun_num =
#line 936 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("index", f_CircularList_CircularListIterator_index, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_index_defined */

#ifdef f_CircularList_CircularListIterator_value_defined
  f_CircularList_CircularListIterator_value_fun_num =
#line 958 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("value", f_CircularList_CircularListIterator_value, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_value_defined */

#ifdef f_CircularList_CircularListIterator_cq__backtick_add_defined
  f_CircularList_CircularListIterator_cq__backtick_add_fun_num =
#line 983 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`+", f_CircularList_CircularListIterator_cq__backtick_add, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_cq__backtick_add_defined */

#ifdef f_CircularList_CircularListIterator_cq__backtick_add_eq_defined
  f_CircularList_CircularListIterator_cq__backtick_add_eq_fun_num =
#line 1011 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`+=", f_CircularList_CircularListIterator_cq__backtick_add_eq, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_cq__backtick_add_eq_defined */

#ifdef f_CircularList_CircularListIterator_cq__backtick_2D_defined
  f_CircularList_CircularListIterator_cq__backtick_2D_fun_num =
#line 1036 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`-", f_CircularList_CircularListIterator_cq__backtick_2D, tFunc("\10\200\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_cq__backtick_2D_defined */

#ifdef f_CircularList_CircularListIterator_has_next_defined
  f_CircularList_CircularListIterator_has_next_fun_num =
#line 1063 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("has_next", f_CircularList_CircularListIterator_has_next, tFunc(tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_has_next_defined */

#ifdef f_CircularList_CircularListIterator_has_previous_defined
  f_CircularList_CircularListIterator_has_previous_fun_num =
#line 1086 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("has_previous", f_CircularList_CircularListIterator_has_previous, tFunc(tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_has_previous_defined */

#ifdef f_CircularList_CircularListIterator_cq__backtick_21_defined
  f_CircularList_CircularListIterator_cq__backtick_21_fun_num =
#line 1107 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`!", f_CircularList_CircularListIterator_cq__backtick_21, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_cq__backtick_21_defined */

#ifdef f_CircularList_CircularListIterator_cq__equal_defined
  f_CircularList_CircularListIterator_cq__equal_fun_num =
#line 1124 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_equal", f_CircularList_CircularListIterator_cq__equal, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_cq__equal_defined */

#ifdef f_CircularList_CircularListIterator_cq__backtick_3C_defined
  f_CircularList_CircularListIterator_cq__backtick_3C_fun_num =
#line 1148 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`<", f_CircularList_CircularListIterator_cq__backtick_3C, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_cq__backtick_3C_defined */

#ifdef f_CircularList_CircularListIterator_cq__backtick_3E_defined
  f_CircularList_CircularListIterator_cq__backtick_3E_fun_num =
#line 1173 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`>", f_CircularList_CircularListIterator_cq__backtick_3E, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_cq__backtick_3E_defined */

#ifdef f_CircularList_CircularListIterator_distance_defined
  f_CircularList_CircularListIterator_distance_fun_num =
#line 1198 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("distance", f_CircularList_CircularListIterator_distance, tFunc(tObj,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_distance_defined */

#ifdef f_CircularList_CircularListIterator_get_collection_defined
  f_CircularList_CircularListIterator_get_collection_fun_num =
#line 1220 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("get_collection", f_CircularList_CircularListIterator_get_collection, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_get_collection_defined */

#ifdef f_CircularList_CircularListIterator_set_value_defined
  f_CircularList_CircularListIterator_set_value_fun_num =
#line 1236 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("set_value", f_CircularList_CircularListIterator_set_value, tFunc(tMix,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_CircularListIterator_set_value_defined */
#line 886 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
  CircularList_CircularListIterator_program=end_program();
#line 886 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
  CircularList_CircularListIterator_program_fun_num=add_program_constant("CircularListIterator",CircularList_CircularListIterator_program,0);

#endif /* class_CircularList_CircularListIterator_defined */

#ifdef CircularList_event_handler_defined
  pike_set_prog_event_callback(CircularList_event_handler);

#endif /* CircularList_event_handler_defined */

#ifdef f_CircularList_cq__backtick_5B_5D_defined
  f_CircularList_cq__backtick_5B_5D_fun_num =
#line 88 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`[]", f_CircularList_cq__backtick_5B_5D, tFunc("\10\200\0\0\0\177\377\377\377",tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__backtick_5B_5D_defined */

#ifdef f_CircularList_cq__backtick_5B_5D_eq_defined
  f_CircularList_cq__backtick_5B_5D_eq_fun_num =
#line 115 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`[]=", f_CircularList_cq__backtick_5B_5D_eq, tFunc("\10\200\0\0\0\177\377\377\377" tMix,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__backtick_5B_5D_eq_defined */

#ifdef f_CircularList_cq__backtick_add_defined
  f_CircularList_cq__backtick_add_fun_num =
#line 139 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("`+", f_CircularList_cq__backtick_add, tFunc(tObj,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__backtick_add_defined */

#ifdef f_CircularList_cq__equal_defined
  f_CircularList_cq__equal_fun_num =
#line 215 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_equal", f_CircularList_cq__equal, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__equal_defined */

#ifdef f_CircularList_cq__indices_defined
  f_CircularList_cq__indices_fun_num =
#line 279 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_indices", f_CircularList_cq__indices, tFunc(tNone,tArray), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__indices_defined */

#ifdef f_CircularList_cq__insert_element_defined
  f_CircularList_cq__insert_element_fun_num =
#line 309 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_insert_element", f_CircularList_cq__insert_element, tFunc("\10\200\0\0\0\177\377\377\377" tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__insert_element_defined */

#ifdef f_CircularList_cq__remove_element_defined
  f_CircularList_cq__remove_element_fun_num =
#line 332 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_remove_element", f_CircularList_cq__remove_element, tFunc("\10\200\0\0\0\177\377\377\377",tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__remove_element_defined */

#ifdef f_CircularList_cq__search_defined
  f_CircularList_cq__search_fun_num =
#line 366 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_search", f_CircularList_cq__search, tFunc(tMix tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__search_defined */

#ifdef f_CircularList_cq__sizeof_defined
  f_CircularList_cq__sizeof_fun_num =
#line 407 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_sizeof", f_CircularList_cq__sizeof, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__sizeof_defined */

#ifdef f_CircularList_cq__values_defined
  f_CircularList_cq__values_fun_num =
#line 418 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_values", f_CircularList_cq__values, tFunc(tNone,tArray), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__values_defined */

#ifdef f_CircularList_add_defined
  f_CircularList_add_fun_num =
#line 460 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("add", f_CircularList_add, tFunc(tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_add_defined */

#ifdef f_CircularList_allocate_defined
  f_CircularList_allocate_fun_num =
#line 487 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("allocate", f_CircularList_allocate, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_allocate_defined */

#ifdef f_CircularList_cast_defined
  f_CircularList_cast_fun_num =
#line 553 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("cast", f_CircularList_cast, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cast_defined */

#ifdef f_CircularList_clear_defined
  f_CircularList_clear_fun_num =
#line 600 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("clear", f_CircularList_clear, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_clear_defined */

#ifdef f_CircularList_delete_value_defined
  f_CircularList_delete_value_fun_num =
#line 622 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("delete_value", f_CircularList_delete_value, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_delete_value_defined */

#ifdef f_CircularList_is_empty_defined
  f_CircularList_is_empty_fun_num =
#line 645 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("is_empty", f_CircularList_is_empty, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_is_empty_defined */

#ifdef f_CircularList_max_size_defined
  f_CircularList_max_size_fun_num =
#line 656 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("max_size", f_CircularList_max_size, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_max_size_defined */

#ifdef f_CircularList_peek_back_defined
  f_CircularList_peek_back_fun_num =
#line 667 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("peek_back", f_CircularList_peek_back, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_peek_back_defined */

#ifdef f_CircularList_peek_front_defined
  f_CircularList_peek_front_fun_num =
#line 686 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("peek_front", f_CircularList_peek_front, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_peek_front_defined */

#ifdef f_CircularList_pop_back_defined
  f_CircularList_pop_back_fun_num =
#line 707 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("pop_back", f_CircularList_pop_back, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_pop_back_defined */

#ifdef f_CircularList_pop_front_defined
  f_CircularList_pop_front_fun_num =
#line 736 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("pop_front", f_CircularList_pop_front, tFunc(tNone,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_pop_front_defined */

#ifdef f_CircularList_push_back_defined
  f_CircularList_push_back_fun_num =
#line 769 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("push_back", f_CircularList_push_back, tFunc(tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_push_back_defined */

#ifdef f_CircularList_push_front_defined
  f_CircularList_push_front_fun_num =
#line 793 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("push_front", f_CircularList_push_front, tFunc(tMix,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_push_front_defined */

#ifdef f_CircularList_create_defined
  f_CircularList_create_fun_num =
#line 819 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("create", f_CircularList_create, tFunc(tOr(tArray,"\10\200\0\0\0\177\377\377\377"),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_create_defined */

#ifdef f_CircularList_cq__get_iterator_defined
  f_CircularList_cq__get_iterator_fun_num =
#line 1282 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("_get_iterator", f_CircularList_cq__get_iterator, tFunc(tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_cq__get_iterator_defined */

#ifdef f_CircularList_first_defined
  f_CircularList_first_fun_num =
#line 1295 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("first", f_CircularList_first, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_first_defined */

#ifdef f_CircularList_last_defined
  f_CircularList_last_fun_num =
#line 1303 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    ADD_FUNCTION2("last", f_CircularList_last, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_CircularList_last_defined */
#line 40 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
  CircularList_program=end_program();
#line 40 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
  CircularList_program_fun_num=add_program_constant("CircularList",CircularList_program,0);

#endif /* class_CircularList_defined */
#line 1327 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
;
}

void pike_exit_CircularList_module(void)
{
  
#ifdef class_CircularList_defined

#ifdef class_CircularList_CircularListIterator_defined
  if(CircularList_CircularListIterator_program) {
#line 886 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    free_program(CircularList_CircularListIterator_program);
    CircularList_CircularListIterator_program=0;
  }

#endif /* class_CircularList_CircularListIterator_defined */
  if(CircularList_program) {
#line 40 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
    free_program(CircularList_program);
    CircularList_program=0;
  }

#endif /* class_CircularList_defined */
#line 1333 "/tmp/pikedeb.e36d41b008/7.6/src/post_modules/_ADT/circular_list.cmod"
} 

    

