/***************************************************************************
 *            bridge.h
 *
 *  Tue Dec 13 11:41:30 2005
 *  Copyright  2005-2006  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
 
#ifndef _BRIDGE_H
#define _BRIDGE_H

/** @addtogroup QOF
    @{
*/
/** @addtogroup pilot

pilot-qof was designed and built around pilot-link 0.12 and
libpisock9 but the release has been considerably delayed. These
definitions reimplement libpisock9 functions in libpisock8
prototypes. In addition, three functions from libpisock9
backported to work with libpisock8 are included here.

\note It is important that the workaround definitions are 
\b above the include directives.

@{
*/
/** @file pilot-qof.h
  @brief Workarounds for pilot-link 0.11.8 and libpisock8
  @author Copyright (c) 2005 Neil Williams <linux@codehelp.co.uk>
*/

/* 0.11.8 workarounds

These definitions are not intended to be 
portable to other pilot-link applications! 
*/
#include "config.h"
#ifndef COMPATIBILITY_MODE
#include "pi-buffer.h"
#include "pi-error.h"
#else

#define PILOT_LINK_SUPPORT "0.11.8"

#define Appointment_t struct Appointment
#define AppointmentAppInfo_t struct AppointmentAppInfo
#define pack_Appointment(o, b, x) pack_Appointment(o, b->data, b->used)
#define unpack_Appointment(o, b, x) unpack_Appointment(o, b->data, b->used)
typedef enum { datebook_v1, } datebookType;
#define Expense_t struct Expense
#define ExpenseAppInfo_t struct ExpenseAppInfo
#define ToDo_t struct ToDo
#define unpack_ToDo(o,b,x) unpack_ToDo(o, b->data, b->used)
#define pack_ToDo(o,b,x) pack_ToDo(o, b->data, b->used)
#define ToDoAppInfo_t struct ToDoAppInfo
#define Address_t struct Address
typedef enum { address_v1, } addressType;
#define pack_Address(o,b,x) pack_Address(o, b->data, b->used)
#define unpack_Address(o,b,x) unpack_Address(o, b->data, b->used)
#define AddressAppInfo_t struct AddressAppInfo
#define plu_connect(p,q) pilot_connect(p)
#define dlp_ReadAppBlock(s,d,o,a,b) dlp_ReadAppBlock(s,d,o,b,b->used)
#define dlp_ReadRecordByIndex(s,d,i,b,p,a,c) \
		dlp_ReadRecordByIndex(s,d,i,b->data,p,p,a,c)
#define CategoryAppInfo_t struct CategoryAppInfo

/* 'quiet' is not supported by 0.11.8
	so leave the definition empty */
#define ENABLE_QUIET_MODE 

#endif /* COMPATIBILITY_MODE */

/** backported from 0.12 */
typedef enum {
	PLU_CAT_NOFLAGS = 0,
	PLU_CAT_CASE_INSENSITIVE = 0x0001,
	PLU_CAT_DEFAULT_UNFILED = 0x0002,
	PLU_CAT_MATCH_NUMBERS = 0x0004,
	PLU_CAT_WARN_UNKNOWN = 0x0008
} plu_findcategory_flags_t;

#include "pi-appinfo.h"

  /** @brief Variable buffer structure */
  typedef struct pi_buffer_t {
    unsigned char *data;    /**< Pointer to the data */
    size_t allocated;   /**< Number of bytes allocated */
    size_t used;      /**< Number of allocated bytes actually used */
  } pi_buffer_t;

/** backported from 0.12 */
pi_buffer_t* pi_buffer_new (size_t capacity);

/** backported from 0.12 */
void pi_buffer_free (pi_buffer_t* buf);

/** backported from 0.12 */
int plu_findcategory(const struct CategoryAppInfo *info, const char *name, int flags);

#ifndef COMPATIBILITY_MODE
/** \brief pilot-qof specific version.

Customised to handle lack of a working quiet mode in 0.11.8 */
int plu_connect(char* plu_port, int plu_quiet);
#endif

/** @} */
/** @} */

#endif /* _BRIDGE_H */
