<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:qof-qsf="http://qof.sourceforge.net/" xmlns:dlume="http://dlume.sourceforge.net/" xmlns:str="http://xsltsl.org/string" version="1.1">
  <xsl:import href="string.xsl"/>
  <!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
  <xsl:param name="input"/>
<!-- Representing QSF XML address data in dlume

  This stylesheet converts the output from pilot-qof -d pilot_address
  into a dlume XML file. Dlume uses a single XML file so a script is
  needed to append the new XML onto an existing file.
  
-->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->

  <xsl:template match="/">
   <dlume:data>
     <xsl:attribute name="records">
       <xsl:number value="position()" format="1"/>
     </xsl:attribute>
    <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_address']">
    <!-- Replace with a pattern match for only 0-9 or whitespace
      in XSLT 2.0 when supported by xsltproc -->
      <dlume:record>
      <xsl:variable name="phone_test">
        <xsl:choose>
          <xsl:when test="qof-qsf:string[@type='entryPhone1'] = ''">
            <xsl:call-template name="str:subst">
              <xsl:with-param name="text" select="qof-qsf:string[@type='entryPhone2']"/>
              <xsl:with-param name="replace">
                <xsl:text> </xsl:text>
              </xsl:with-param>
              <xsl:with-param name="with"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="str:subst">
              <xsl:with-param name="text" select="qof-qsf:string[@type='entryPhone1']"/>
              <xsl:with-param name="replace">
                <xsl:text> </xsl:text>
              </xsl:with-param>
              <xsl:with-param name="with"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <dlume:first_name>
        <xsl:value-of select="qof-qsf:string[@type='entryFirstname']"/>
      </dlume:first_name>
      <dlume:last_name>      
        <xsl:value-of select="qof-qsf:string[@type='entryLastname']"/>
      </dlume:last_name>
      <dlume:address>
        <xsl:value-of select="qof-qsf:string[@type='entryAddress']"/>
      </dlume:address>
      <dlume:post_code>
        <xsl:value-of select="qof-qsf:string[@type='entryZip']"/>
      </dlume:post_code>
      <dlume:city>
        <xsl:value-of select="qof-qsf:string[@type='entryCity']"/>
      </dlume:city>
      <dlume:state>
        <xsl:value-of select="qof-qsf:string[@type='entryState']"/>
      </dlume:state>
      <dlume:country>
        <xsl:value-of select="qof-qsf:string[@type='entryCountry']"/>
      </dlume:country>
      <dlume:home_phone_1>
        <xsl:value-of select="qof-qsf:string[@type='entryPhone1']"/>
      </dlume:home_phone_1>
      <dlume:cell_phone_1>
        <xsl:value-of select="qof-qsf:string[@type='entryPhone2']"/>
      </dlume:cell_phone_1>
      <dlume:email_1>
        <xsl:value-of select="qof-qsf:string[@type='entryPhone3']"/>
      </dlume:email_1>
      <dlume:notes>
        <xsl:value-of select="qof-qsf:string[@type='entryNote']"/>
      </dlume:notes>
    </dlume:record>
    </xsl:for-each>
      <xsl:copy-of select="document($input)/data/record"/>
  </dlume:data>
  </xsl:template>
</xsl:stylesheet>
