<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:gtodo="http://cms.qballcow.nl/" xmlns:dt="http://xsltsl.org/date-time" xmlns:qof-qsf="http://qof.sourceforge.net/" version="1.1">
  <xsl:import href="string.xsl"/>
<!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
<!-- Converting Palm todo data for gtodo

  This stylesheet converts the output from pilot-qof -d pilot_todo
  into another XML file, suitable for import into gtodo. 

  Note that gtodo and pilot_todo have quite different methods of storing
  data. Some data handled by gtodo is simply not present in the pilot database.
  This stylesheet converts sufficient data for gtodo to load the summary, notes
  and completion status. For a more complete conversion, a Perl script is necessary. 
  Missing data includes: enddate, endtime and lastedited. start_date cannot be
  supported by XSLT because the date of creation does not exist in the pilot
  database nor can XSLT calculate the current time without help from an external
  script. Once an external script becomes necessary, the script might as well do
  the rest of the work too.
  
  This stylesheet will therefore remain incomplete - it serves as a starter only.
-->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->

  <xsl:template match="/">
    <xsl:message>.</xsl:message>
    <xsl:message>NOTICE: Not all GTodo data is available from Palm ToDo via XSLT.</xsl:message>
    <xsl:message>Please see the datafreedom-perl package.</xsl:message>
    <xsl:message>This stylesheet is part of pilot-qof.</xsl:message>
    <xsl:message>pilot-qof is free software (GPL) and comes with NO WARRANTY.</xsl:message>
    <xsl:message>See 'COPYING' in the pilot-qof source for more information.</xsl:message>
    <gtodo:gtodo>
    <xsl:apply-templates select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_todo']"/>
    </gtodo:gtodo>
  </xsl:template>

  <xsl:template name="calculate-julian-day">
    <xsl:param name="year"/>
    <xsl:param name="month"/>
    <xsl:param name="day"/>
    <xsl:variable name="monthday">    
    
    <xsl:choose>
    <xsl:when test="$month = 1">
      <xsl:value-of select="0"/>
    </xsl:when>
    <xsl:otherwise>
    <xsl:choose>
      <xsl:when test="$month = 2">
        <xsl:value-of select="31"/>
      </xsl:when>
      <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="$month = 3">
          <xsl:value-of select="59"/>
        </xsl:when>
        <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$month = 4">
           <xsl:value-of select="90"/>
          </xsl:when>
          <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="$month = 5">
            <xsl:value-of select="120"/>
           </xsl:when>
          <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="$month = 6">
            <xsl:value-of select="151"/>
           </xsl:when>
          <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="$month = 7">
            <xsl:value-of select="181"/>
           </xsl:when>
          <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="$month = 8">
            <xsl:value-of select="212"/>
           </xsl:when>
          <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="$month = 9">
            <xsl:value-of select="243"/>
           </xsl:when>
          <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="$month = 10">
            <xsl:value-of select="273"/>
           </xsl:when>
          <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="$month = 11">
            <xsl:value-of select="304"/>
           </xsl:when>
          <xsl:otherwise>
          <xsl:choose>
           <xsl:when test="$month = 12">
            <xsl:value-of select="334"/>
           </xsl:when>
          </xsl:choose>
         </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
        </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    </xsl:otherwise>
    </xsl:choose>
    </xsl:variable>
    <xsl:variable name="leap" select="($year -1) * 365 + floor($year div 4) - floor($year div 100) + floor($year div 400)"/>
    <xsl:value-of select="$day + $monthday + $leap"/>
    </xsl:template>

  <xsl:template match="/*/qof-qsf:book/qof-qsf:object[@type='pilot_todo']">
      <gtodo:category>
        <!-- uses julian dates, number of days -->
        <xsl:variable name="year">
        <xsl:call-template name='dt:get-xsd-datetime-year'>
          <xsl:with-param name="xsd-date-time" select="qof-qsf:time[@type='date_due']"/>
        </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="month">
        <xsl:call-template name='dt:get-xsd-datetime-month'>
          <xsl:with-param name="xsd-date-time" select="qof-qsf:time[@type='date_due']"/>
        </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="day">
        <xsl:call-template name='dt:get-xsd-datetime-day'>
          <xsl:with-param name="xsd-date-time" select="qof-qsf:time[@type='date_due']"/>
        </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="julian">
        <xsl:call-template name="calculate-julian-day">
          <xsl:with-param name="year" select="$year"/>
          <xsl:with-param name="month" select="$month"/>
          <xsl:with-param name="day" select="$day"/>
        </xsl:call-template>
        </xsl:variable>
      <xsl:attribute name="title">
        <xsl:value-of select="qof-qsf:string[@type='category']"/>
      </xsl:attribute>
      <xsl:attribute name="place">
        <xsl:number/>
      </xsl:attribute>
      <gtodo:item>
      <gtodo:attribute>
        <xsl:attribute name="id">
        <xsl:variable name="startjulian">
        <xsl:call-template name="calculate-julian-day">
          <xsl:with-param name="year" select="$year - 1970"/>
          <xsl:with-param name="month" select="$month"/>
          <xsl:with-param name="day" select="$day"/>
        </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="day2sec">
          <xsl:value-of select="$startjulian * 86400"/>
        </xsl:variable>
        <xsl:variable name="todo_hr">
          <xsl:call-template name="dt:format-date-time">
          <xsl:with-param name="xsd-date-time" select="qof-qsf:time[@type='date_due']"/>
          <xsl:with-param name="format" select="'%H'"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$day2sec + ($todo_hr * 3600)"/>
        <!-- actually need time(now) as id string. -->
        </xsl:attribute>
        <xsl:attribute name="priority">
          <xsl:value-of select="qof-qsf:gint32[@type='todo_priority']"/>
        </xsl:attribute>
        <xsl:attribute name="done">
          <xsl:value-of select="qof-qsf:gint32[@type='todo_complete']"/>
        </xsl:attribute>
        <xsl:attribute name="start_date">
          <xsl:value-of select="$julian"/>
        </xsl:attribute>
        <xsl:attribute name="completed_date">
          <xsl:choose>
          <xsl:when test="qof-qsf:gint32[@type='todo_complete'] = 1">
          <xsl:value-of select="$julian"/>
          </xsl:when>
          <xsl:otherwise>
          <xsl:value-of select="-60"/>
          </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <!-- enddate not stored in Palm -->
        <xsl:attribute name="enddate"/>
        <!-- notify not stored in Palm -->
        <xsl:attribute name="notify"/>
        <!-- enddate not stored in Palm -->
        <xsl:attribute name="endtime"/>
        <!-- lastedited not stored in Palm -->
        <xsl:attribute name="last_edited"/>
      </gtodo:attribute>
      <gtodo:summary>
        <xsl:value-of select="qof-qsf:string[@type='todo_description']"/>
      </gtodo:summary>
      <gtodo:comment>
        <xsl:value-of select="qof-qsf:string[@type='todo_note']"/>
      </gtodo:comment>
      </gtodo:item>
     </gtodo:category>
  </xsl:template>
</xsl:stylesheet>
