<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:qof-qsf="http://qof.sourceforge.net/" xmlns:html="http://www.w3.org/1999/xhtml" xmlns:dt="http://xsltsl.org/date-time" xmlns:str="http://xsltsl.org/string" xmlns:date="http://exslt.org/dates-and-times" version="1.0" exclude-result-prefixes="qof-qsf html date dt str">
  <xsl:import href="date-time.xsl"/>
  <xsl:import href="string.xsl"/>
  <xsl:import href="date.difference.xsl"/>
<!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
<!--This stylesheet converts the output from pilot-qof invoice-city
  or invoice-vendor options into an HTML invoice. The invoice uses
  CSS in the invoice.css file. See 'man 5 pilot-qof' for usage. -->
<!--This is only a working prototype - it needs cleaning up -->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->
  <xsl:output method="html" encoding="utf-8"/>
<!-- user configuration -->
  <xsl:param name="mileage-rate">0.3</xsl:param>
  <xsl:param name="hourly-rate">20</xsl:param>
<!-- Edit to change your currency symbol -->
  <xsl:param name="currency-symbol">&#xA3;</xsl:param>
<!-- Translation support via external parameters -->
  <xsl:param name="invoice">Invoice</xsl:param>
  <xsl:param name="date">Date</xsl:param>
  <xsl:param name="description">Description</xsl:param>
  <xsl:param name="amount">Amount</xsl:param>
  <xsl:param name="miles">miles</xsl:param>
  <xsl:param name="per_mile">per mile</xsl:param>
  <xsl:param name="total">Total</xsl:param>
  <xsl:param name="hours">hours</xsl:param>
  <xsl:param name="minutes">minutes</xsl:param>
  <xsl:param name="per_hour">per hour</xsl:param>
<!-- end configuration -->
  <xsl:template match="/">
    <xsl:message>.</xsl:message>
    <xsl:message>This stylesheet is part of pilot-qof.</xsl:message>
    <xsl:message>pilot-qof is free software (GPL) and comes with NO WARRANTY.</xsl:message>
    <xsl:message>See 'COPYING' in the pilot-qof source for more information.</xsl:message>
    <xsl:message>Parameters are mileage-rate and hourly-rate.</xsl:message>
    <xsl:message>Writing pilot-qof data to HTML invoice:</xsl:message>
<!-- chunking support -->
    <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_address']">
      <xsl:variable name="contactName">
        <xsl:value-of select="qof-qsf:string[@type='entryFirstname']"/>
        <xsl:value-of select="qof-qsf:string[@type='entryLastname']"/>
      </xsl:variable>
      <xsl:variable name="chunk_title">
        <xsl:call-template name="get_chunk_name">
          <xsl:with-param name="entryCompany" select="qof-qsf:string[@type='entryCompany']"/>
          <xsl:with-param name="entryName" select="$contactName"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="chunk_date">
        <xsl:call-template name="date_title">
          <xsl:with-param name="date_value" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='start_time']"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:message>
        <xsl:text>.    </xsl:text>
        <xsl:value-of select="$chunk_title"/>
        <xsl:text>_</xsl:text>
        <xsl:value-of select="$chunk_date"/>
        <xsl:text>.html . . . </xsl:text>
      </xsl:message>
      <xsl:document href="{$chunk_title}_{$chunk_date}.html" method="html" doctype-public="-//W3C//DTD HTML 4.01//EN" encoding="{$encoding}" indent="yes">
        <html>
          <xsl:attribute name="lang">
            <xsl:value-of select="$html_lang"/>
          </xsl:attribute>
          <head>
            <title>
              <xsl:value-of select="$invoice"/>
              <xsl:text> </xsl:text>
              <xsl:call-template name="dt:format-date-time">
                <xsl:with-param name="xsd-date-time" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='start_time']"/>
                <xsl:with-param name="format" select="'%A, %d %B %Y'"/>
              </xsl:call-template>
            </title>
            <link rel="stylesheet" href="invoice.css" type="text/css"/>
          </head>
          <body>
            <xsl:call-template name="prepare_address_div">
              <xsl:with-param name="address_object" select="."/>
            </xsl:call-template>
            <h1>
              <xsl:value-of select="$invoice"/>
              <xsl:text> : </xsl:text>
              <xsl:value-of select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:string[@type='description']"/>
            </h1>
            <h2>
              <xsl:call-template name="dt:format-date-time">
                <xsl:with-param name="xsd-date-time" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='start_time']"/>
                <xsl:with-param name="format" select="'%A, %d %B %Y'"/>
              </xsl:call-template>
            </h2>
            <table class="entry_table" border="1">
              <colgroup>
                <col width="8%"/>
                <col/>
                <col width="25%"/>
              </colgroup>
              <tr>
                <th>
                  <xsl:value-of select="$date"/>
                </th>
                <th>
                  <xsl:value-of select="$description"/>
                </th>
                <th>
                  <xsl:value-of select="$amount"/>
                </th>
              </tr>
              <xsl:variable name="diff_string">
                <xsl:call-template name="date:difference">
                  <xsl:with-param name="start" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='start_time']"/>
                  <xsl:with-param name="end" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='end_time']"/>
                </xsl:call-template>
              </xsl:variable>
              <xsl:variable name="diff_secs" select="date:seconds($diff_string)"/>
              <tr>
                <td>
                  <xsl:call-template name="dt:format-date-time">
                    <xsl:with-param name="xsd-date-time" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='start_time']"/>
                    <xsl:with-param name="format" select="'%e/%m/%Y'"/>
                  </xsl:call-template>
                </td>
                <td>
                  <xsl:value-of select="floor($diff_secs div 3600)"/>
                  <xsl:text> </xsl:text>
                  <xsl:value-of select="$hours"/>
                  <xsl:text> </xsl:text>
                  <xsl:value-of select="($diff_secs mod 3600) div 60"/>
                  <xsl:text> </xsl:text>
                  <xsl:value-of select="$minutes"/>
                  <xsl:text> @ </xsl:text>
                  <xsl:value-of select="$currency-symbol"/>
                  <xsl:value-of select="format-number($hourly-rate, '##,###.##')"/>
                  <xsl:text> </xsl:text>
                  <xsl:value-of select="$per_hour"/>
                </td>
                <td>
                  <b>
                    <xsl:variable name="value">
                      <xsl:value-of select="number($diff_secs div 3600 * $hourly-rate)"/>
                    </xsl:variable>
                    <xsl:value-of select="$currency-symbol"/>
                    <xsl:value-of select="format-number(($value), '#,###.##')"/>
                    <xsl:text>&#10;</xsl:text>
                  </b>
                </td>
              </tr>
              <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_expenses']">
                <tr>
                  <td>
                    <xsl:call-template name="dt:format-date-time">
                      <xsl:with-param name="xsd-date-time" select="qof-qsf:time[@type='expense_date']"/>
                      <xsl:with-param name="format" select="'%e/%m/%Y'"/>
                    </xsl:call-template>
                  </td>
                  <xsl:variable name="numeric">
                    <xsl:call-template name="numeric_to_double">
                      <xsl:with-param name="numeric_string" select="qof-qsf:numeric"/>
                    </xsl:call-template>
                  </xsl:variable>
                  <xsl:variable name="type" select="qof-qsf:string[@type='type_of_expense']"/>
                  <xsl:choose>
                    <xsl:when test="$type='Mileage'">
                      <xsl:variable name="miles-num" select="number($numeric)"/>
                      <xsl:variable name="value" select="(number($miles-num * $mileage-rate))"/>
                      <xsl:variable name="total" select="$value"/>
                      <td>
                        <xsl:value-of select="format-number(($miles-num), '#####.#')"/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="$miles"/>
                        <xsl:text> @ </xsl:text>
                        <xsl:value-of select="$currency-symbol"/>
                        <xsl:value-of select="format-number($mileage-rate, '#.##')"/>
                        <xsl:value-of select="$per_mile"/>
                      </td>
                      <td>
                        <b>
                          <xsl:value-of select="$currency-symbol"/>
                          <xsl:value-of select="format-number(($value), '#####.##')"/>
                        </b>
                      </td>
                    </xsl:when>
                    <xsl:otherwise>
                      <td>
                        <xsl:value-of select="$type"/>
                      </td>
                      <td>
                        <xsl:variable name="value" select="(number($numeric))"/>
                        <xsl:variable name="total" select="$value"/>
                        <b>
                          <xsl:value-of select="$currency-symbol"/>
                          <xsl:value-of select="format-number(($value), '#####.##')"/>
                        </b>
                      </td>
                    </xsl:otherwise>
                  </xsl:choose>
                </tr>
              </xsl:for-each>
              <tr>
                <td>
                  <xsl:text> </xsl:text>
                </td>
                <td>
                  <b>
                    <xsl:value-of select="$total"/>
                  </b>
                </td>
                <td>
                  <xsl:variable name="date_total">
                    <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']">
                      <xsl:call-template name="calc_date"/>
                    </xsl:for-each>
                  </xsl:variable>
                  <xsl:variable name="expense_total">
                    <xsl:variable name="check_value">
                      <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_expenses']">
                        <xsl:call-template name="calc_expense"/>
                      </xsl:for-each>
                    </xsl:variable>
                    <xsl:choose>
                      <xsl:when test="$check_value &gt; 0">
                        <xsl:value-of select="number($check_value)"/>
                      </xsl:when>
                      <xsl:otherwise>0</xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <xsl:variable name="mileage_total">
                    <xsl:variable name="check_value">
                      <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_expenses']">
                        <xsl:call-template name="calc_mileage"/>
                      </xsl:for-each>
                    </xsl:variable>
                    <xsl:choose>
                      <xsl:when test="$check_value &gt; 0">
                        <xsl:value-of select="number($check_value)"/>
                      </xsl:when>
                      <xsl:otherwise>0</xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <xsl:variable name="total">
                    <xsl:value-of select="$expense_total + $date_total + $mileage_total"/>
                  </xsl:variable>
                  <xsl:text>&#10;</xsl:text>
                  <b>
                    <xsl:value-of select="$currency-symbol"/>
                    <xsl:value-of select="format-number($total, '#,##.##')"/>
                  </b>
                  <xsl:text>&#10;</xsl:text>
                </td>
              </tr>
            </table>
          </body>
        </html>
      </xsl:document>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="*|@*|node()"/>
  <xsl:template name="calc_date">
    <xsl:variable name="diff_string">
      <xsl:call-template name="date:difference">
        <xsl:with-param name="start" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='start_time']"/>
        <xsl:with-param name="end" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='end_time']"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="diff_secs" select="date:seconds($diff_string)"/>
    <xsl:choose>
      <xsl:when test="$diff_secs &gt; 0">
        <xsl:value-of select="number($diff_secs div 3600 * $hourly-rate)"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="calc_mileage">
    <xsl:variable name="numeric">
      <xsl:call-template name="numeric_to_double">
        <xsl:with-param name="numeric_string" select="qof-qsf:numeric"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="type" select="qof-qsf:string[@type='type_of_expense']"/>
    <xsl:choose>
      <xsl:when test="$type='Mileage'">
        <xsl:variable name="miles" select="number($numeric)"/>
        <xsl:choose>
          <xsl:when test="$miles &gt; 0">
            <xsl:variable name="subtotal" select="number($miles * $mileage-rate)"/>
            <xsl:value-of select="$subtotal"/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="calc_expense">
    <xsl:variable name="numeric">
      <xsl:call-template name="numeric_to_double">
        <xsl:with-param name="numeric_string" select="qof-qsf:numeric"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="type" select="qof-qsf:string[@type='type_of_expense']"/>
    <xsl:choose>
      <xsl:when test="$type='Mileage'">0</xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$numeric &gt; 0">
            <xsl:value-of select="number($numeric)"/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
