dnl @synopsis TYPE_SOCKLEN_T
dnl
dnl Check whether sys/socket.h defines type socklen_t. Please note
dnl that some systems require sys/types.h to be included before
dnl sys/socket.h can be compiled.
dnl
dnl Modified by Roland Clobus <rclobus@rclobus.nl> for ws2tcpip
dnl
dnl @version $Id: type_socklen_t.m4 1625 2011-01-26 09:53:10Z rclobus $
dnl @author Lars Brinkhoff <lars@nocrew.org>
dnl
AC_DEFUN([TYPE_SOCKLEN_T],
[AC_CACHE_CHECK([for socklen_t], ac_cv_type_socklen_t,
[
  AC_TRY_COMPILE(
   [#ifdef HAVE_WS2TCPIP_H
   #include <ws2tcpip.h>
   #else
   #include <sys/types.h>
   #include <sys/socket.h>
   #endif],
  [socklen_t len = 42; return 0;],
  ac_cv_type_socklen_t=yes,
  ac_cv_type_socklen_t=no)
])
  if test $ac_cv_type_socklen_t != yes; then
    AC_DEFINE(socklen_t, int, [Substitute for socklen_t])
  fi
])
