/* Copyright (c) 2001-2010, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.test;

import com.pixelmed.dose.*;

import junit.framework.*;

import com.pixelmed.dicom.ContentItem;

public class TestDeviceParticipant extends TestCase {
	
	// constructor to support adding tests to suite ...
	
	public TestDeviceParticipant(String name) {
		super(name);
	}
	
	// add tests to suite manually, rather than depending on default of all test...() methods
	// in order to allow adding TestDeviceParticipant.suite() in AllTests.suite()
	// see Johannes Link. Unit Testing in Java pp36-47
	
	public static Test suite() {
		TestSuite suite = new TestSuite("TestDeviceParticipant");
		
		suite.addTest(new TestDeviceParticipant("TestDeviceParticipant_WithAllParameters"));
		
		return suite;
	}
	
	protected void setUp() {
	}
	
	protected void tearDown() {
	}
	
	public void TestDeviceParticipant_WithAllParameters() throws Exception {
		String manufacturer = "Acme";
		String modelName = "Scanner";
		String serialNumber = "72349236741";
		
		DeviceParticipant dp = new DeviceParticipant(manufacturer,modelName,serialNumber);

		assertEquals("Checking manufacturer",manufacturer,dp.getManufacturer());
		assertEquals("Checking modelName",modelName,dp.getModelName());
		assertEquals("Checking serialNumber",serialNumber,dp.getSerialNumber());
		
		ContentItem dpRoot = dp.getStructuredReportFragment();
		assertEquals("Checking SR fragment","CONTAINS: CODE: Device Role in Procedure = Irradiating Device",dpRoot.toString());
		assertEquals("Checking SR fragment","HAS PROPERTIES: TEXT: Device Manufacturer = "+manufacturer,dpRoot.getNamedChild("DCM","113878").toString());
		assertEquals("Checking SR fragment","HAS PROPERTIES: TEXT: Device Model Name = "+modelName,dpRoot.getNamedChild("DCM","113879").toString());
		assertEquals("Checking SR fragment","HAS PROPERTIES: TEXT: Device Serial Number = "+serialNumber,dpRoot.getNamedChild("DCM","113880").toString());
	}
	
}

