#include "aniplayer.h"
#include <qapplication.h>
#include <qpainter.h>
#include <kglobal.h>
#include <kconfig.h>

#include <stdlib.h>

KIFAniPlayer:: KIFAniPlayer(const QString &filename, QWidget *parent,
                            const char *name)
    : QWidget(parent, name, WType_Popup | WDestructiveClose)
{
    KConfig *config = KGlobal::config();
    config->setGroup("UISettings");

    gc = XCreateGC(x11Display(), RootWindow(x11Display(), x11Screen()), 0, 0);
    c = config->readColorEntry("FullScreenColor", &Qt::white);
    XSetForeground(x11Display(), gc, c.pixel());

    setBackgroundMode(NoBackground);
    qWarning("Playing %s", filename.latin1());
    move(0, 0);
    resize(QApplication::desktop()->size());
    movie = new QMovie(filename);
    movie->setBackgroundColor(c);
    movie->connectUpdate(this, SLOT(slotUpdate()));
    show();
}

KIFAniPlayer::~KIFAniPlayer()
{
    qWarning("In AniPlayer close event");
    delete movie;
    XFreeGC(x11Display(), gc);
}

void KIFAniPlayer::slotUpdate()
{
    repaint(false);
}

void KIFAniPlayer::paintEvent(QPaintEvent *ev)
{
    QPixmap pix = movie->framePixmap();
    if(pix.isNull()){
        XFillRectangle(x11Display(), winId(),  gc, 0, 0, width(), height());
        return;
    }
    QRect pixRect(0, 0, pix.width(), pix.height());
    QRect drawRect(ev->rect());
    if(pix.width() < width()){
        pixRect.setLeft(((width()-pix.width())/2)-1);
        pixRect.setWidth(pix.width()); // need to reset
    }
    if(pix.height() < height()){
        pixRect.setTop(((height()-pix.height())/2)-1);
        pixRect.setHeight(pix.height());
    }
    pixRect = pixRect.intersect(drawRect);
    if(pix.mask())
        XFillRectangle(x11Display(), winId(), gc, pixRect.x(),
                       pixRect.y(), drawRect.width(), drawRect.height());
    bitBlt(this, pixRect.topLeft(), &pix, drawRect, Qt::CopyROP);
    // fill in the edges
    int rects = 0;
    XRectangle rectangles[4];
    if(drawRect.top() < pixRect.top()){
        rectangles[rects].x = drawRect.x();
        rectangles[rects].y = drawRect.x();
        rectangles[rects].width = drawRect.width();
        rectangles[rects].height =  pixRect.top()-drawRect.top();
        ++rects;
    }
    if(drawRect.left() < pixRect.left()){
        rectangles[rects].x = drawRect.x();
        rectangles[rects].y = pixRect.top()-drawRect.top();
        rectangles[rects].width = pixRect.left()-drawRect.left();
        rectangles[rects].height = drawRect.height()-pixRect.top();
        ++rects;
    }
    if(drawRect.right() > pixRect.right()){
        rectangles[rects].x = pixRect.right()+1;
        rectangles[rects].y = pixRect.top()-drawRect.top();
        rectangles[rects].width = drawRect.right()-pixRect.right();
        rectangles[rects].height = drawRect.height()-pixRect.top();
        ++rects;
    }
    if(drawRect.bottom() > pixRect.bottom()){
        rectangles[rects].x = pixRect.left();
        rectangles[rects].y = pixRect.bottom()+1;
        rectangles[rects].width = pixRect.width();
        rectangles[rects].height = drawRect.bottom()-pixRect.bottom();
        ++rects;
    }
    if(rects)
        XFillRectangles(x11Display(), winId(), gc, rectangles, rects);

}

void KIFAniPlayer::mousePressEvent(QMouseEvent *ev)
{
    if(ev->button() == LeftButton)
        close();
}


