#ifndef __KIF_BATCHEFFECTS_H
#define __KIF_BATCHEFFECTS_H

#include <qdialog.h>
#include <qcheckbox.h>
#include <qscrollview.h>
#include <kfontdialog.h>
#include <kcolorbutton.h>
#include <knuminput.h>
#include "border.h"

// ImageMagick redefines off_t to long long
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#undef off_t
#define off_t long long
extern "C"{
#include <api.h>
};

class KProgress;
class QLabel;
class UIManager;
class QButtonGroup;
class QScrollView;
class PixieBrowser;

enum EffectType{Grayscale=0, Invert, FlipH, FlipV, Rot90, Rot180, Rot270,
    AddText, Scale, Border, Blur, Normalize, Equalize, Despeckle,
    AddNoise, Edge, Implode, OilPaint, ReduceNoise, Shade, Sharpen, Solarize,
    Spread, Swirl, Wave, Emboss, IncContrast, DecContrast, Charcoal, Sample,
    Threshold};

enum TextPosition{UpperLeftText=0, BottomLeftText, UpperRightText, BottomRightText,
CenterText};

void createTextLabel(const QString &text, const QColor &color,
                     const QFont &font, QImage &destImage);
bool applyTextLabel(TextPosition pos, QImage &textImage, QImage &destImage);

bool getRadiusAndDeviation(const QString &caption, double &radius,
                           double &stdDeviation, QWidget *parent=0);

class KIFTextDialog : public QDialog
{
    Q_OBJECT
public:
    KIFTextDialog(QWidget *parent=0, const char *name=0);
    QString text(){return(fontChooser->sampleText());}
    QFont font(){return(fontChooser->font());}
    QColor color(){return(colorBtn->color());}
    int opacity(){return(numInput->value());}
    TextPosition pos();
protected slots:
    void accept();
protected:
    KFontChooser *fontChooser;
    KColorButton *colorBtn;
    KIntNumInput *numInput;
    QButtonGroup *alignBtns;
};

class KIFSineWaveDialog : public QDialog
{ 
public:
    KIFSineWaveDialog(QWidget *parent=0, const char *name=0);
    double amplitude(){return(aInput->value());}
    double frequency(){return(fInput->value());}
protected:
    KDoubleNumInput *aInput, *fInput;
};

class KIFShadeDialog : public QDialog
{
public:
    KIFShadeDialog(QWidget *parent=0, const char *name=0);
    double azimuth(){return(aInput->value());}
    double elevation(){return(eInput->value());}
    bool colorShading(){return(colorCB->isChecked());}
protected:
    KDoubleNumInput *aInput, *eInput;
    QCheckBox *colorCB;
};


class KIFGet2DoubleDialog : public QDialog
{
public:
    KIFGet2DoubleDialog(const QString &captionStr,
                        const QString &input1Str,
                        double input1Upper, double input1Lower,
                        double input1Step, double input1Val,
                        const QString &input2Str,
                        double input2Upper, double input2Lower,
                        double input2Step, double input2Val,
                        QWidget *parent=0, const char *name=0);
    double value1(){return(spinBox1->value());}
    double value2(){return(spinBox2->value());}
protected:
    KDoubleSpinBox *spinBox1, *spinBox2;
};

class BatchEffect;

class KIFBatchProgressWidget : public QWidget
{
public:
    KIFBatchProgressWidget(BatchEffect *effectMgr, QWidget *parent=0,
                           const char *name=0);
    void setTitle(const QString &titleStr);
    KProgress* progressBar();
    QLabel* progressLabel();
protected:
    KProgress *progress;
    QLabel *lbl, *captionLbl;
};

class KIFBatchPixmapView : public QScrollView
{
public:
    KIFBatchPixmapView(QWidget *parent=0, const char *name=0);
    ~KIFBatchPixmapView();
    void setImage(QImage &img);
protected:
    void drawContents(QPainter *p, int x, int y, int w, int h);
    QPixmap *pix;
};


class KIFBatchPreviewWidget : public QWidget
{
    Q_OBJECT
public:
    KIFBatchPreviewWidget(BatchEffect *effectMgr, QWidget *parent=0,
                          const char *name=0);
    void setTitle(const QString &titleStr);
    void setPreviewImage(QImage &img);

    KProgress* progressBar();
    QLabel* progressLabel();
    void disable();
signals:
    void windowClosed();
protected:
    void closeEvent(QCloseEvent *ev);
    KIFBatchPixmapView *preview;
    KProgress *progress;
    QLabel *lbl, *captionLbl;
    QPushButton *acceptBtn, *skipBtn, *cancelBtn;
};

class BatchEffect : public QObject
{
    Q_OBJECT
public:
    BatchEffect(UIManager *manager, PixieBrowser *browser,
                QStringList &files, int effectType);
    ~BatchEffect();
    bool apply();
signals:
    void setProgress(int);
    void setProgressText(const QString &);

public slots:
    void slotCancel();
    void slotAcceptPreview();
    void slotRejectPreview();
protected:
    bool getParameters();
    bool applyQtEffect(const QString &filename,
                       KIFBatchPreviewWidget *preview=0);
    bool applyMagickEffect(const QString &filename,
                           KIFBatchPreviewWidget *preview=0);
    UIManager *mgr;
    PixieBrowser *view;

    bool useQt;
    bool cancel, acceptPreview, rejectPreview;
    QImage *textImage;
    QStringList fileList;

    // parameters for various effects
    int type;
    BorderType borderType;
    NoiseType noiseType;
    TextPosition textPos;
    int borderWidth, newW, newH;
    double weight, a, f, e;
    double radius, sigma;
    QColor fg, bg;
    bool useColor;
};


#endif

