#ifndef __KIF_BROWSERSORT_H
#define __KIF_BROWSERSORT_H

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

class PixieBrowser;

struct dirinfo
{
    PixieBrowser *browser;
    char *name;
    struct stat status;
    bool isImage;
    bool extensionChecked;
    struct dirinfo *next;
};

struct inodeinfo
{
    long inode;
    struct inodeinfo *next;
};

int sortDateAscending(const void *a, const void *b);
int sortDateDescending(const void *a, const void *b);
int sortSizeAscending(const void *a, const void *b);
int sortSizeDescending(const void *a, const void *b);
int sortSizeAscendingSameFirst(const void *a, const void *b);
int sortNameAscending(const void *a, const void *b);
int sortNameDescending(const void *a, const void *b);

#endif

