#include "dndlistbox.h"
#include <qdragobject.h>


void KIFDndListBox::dragEnterEvent(QDragEnterEvent *ev)
{
    ev->accept(QUriDrag::canDecode(ev));
}

void KIFDndListBox::dropEvent(QDropEvent *ev)
{
    QStrList fileList;
    if(QUriDrag::decode(ev, fileList)){
        QStrListIterator it(fileList);
        for(;it.current(); ++it){
            qWarning("In dropEvent for %s", it.current());
            emit urlDropped(it.current());
        }
        emit dropFinished();
    }
}


