#ifndef __KIF_FILELIST_H
#define __KIF_FILELIST_H

#include "dndlistbox.h"
#include <qdir.h>

class KIFFileList : public KIFDndListBox
{
    Q_OBJECT
public:
    KIFFileList(QWidget *parent=0, const char *name=0);
    KIFFileList& operator=(const KIFFileList &src);
public slots:
    void slotAppend(const QString &filename);
    void slotAppendAndSet(const QString &filename);

    void slotNextInList();
    void slotPrevInList();
signals:
    void editImage(const QString &filename);
    void save();
protected slots:
    void slotRightButton(QListBoxItem *i, const QPoint &);
protected:
    void paintCell(QPainter *p, int r, int c);
    void mousePressEvent(QMouseEvent *ev);
    void dragEnterEvent(QDragEnterEvent *ev);
    void dropEvent(QDropEvent *ev);
};


#endif
