#ifndef __KIF_HTMLEXPORT_H
#define __KIF_HTMLEXPORT_H

#include <qobject.h>
#include <qstringlist.h>
#include <qcolor.h>
#include <qtextstream.h>

// we throw all the config data here to be better organized and to save us
// having config->readEntry calls all over the place ;-) There is a ton of
// config data and it's hard to keep track of all the keys :P
struct htmldata
{
    int rows, cols;
    int thumbWidth, thumbHeight;

    int borderStyle;
    QColor frameFg, frameBg, frameFill;
    int frameWidth;

    int style;
    int htmlBorderWidth;
    bool includeFilename;

    QColor htmlBgColor, htmlTextColor, htmlLinkColor, htmlFollowedLinkColor;

    bool useHome, useHomeImage, useNextImage, useBackImage;
    QString homeURL, homeImageURL, nextImageURL, backImageURL;
    QString homeBtnText, nextBtnText, backBtnText;

    bool useBannerAd;
    QString bannerURL, bannerImageURL;
    int bannerHeight;

    QString title;

    QString filenamePrefix;
};

class HTMLExportBase : public QObject
{
    Q_OBJECT
public:
    HTMLExportBase(QObject *parent=0, const char *name=0);
    ~HTMLExportBase(){qWarning("Deleting HTML exporter");}
    void run(const QString &path, const QStringList &fileList);
    QString filename(int page);
    void writeGrid(QTextStream &stream, bool newwindow);
    void writePlainFrame(const QString &path, const QStringList &fileList);
    void writeThumbnailFrame(const QString &path, const QStringList &fileList);
    void writeHeader(QTextStream &stream);
    void writeFooter(QTextStream &stream);
    void writePageIndex(int page, QTextStream &stream);
    void createThumbnail(const QString &path, const QString &fileName);
signals:
    void updateProgress(int val);
    void setStatusBarText(const QString &text);
protected:
    void loadSettings();

    struct htmldata data;
    int pages;
    int imagesPerPage;
    QStringList::ConstIterator it;
    QStringList::ConstIterator end;
};

#endif



