#ifndef __KIF_HTMLEXPORT_WIZARD_H
#define __KIF_HTMLEXPORT_WIZARD_H

#include <kwizard.h>
#include <knuminput.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <kcolorbutton.h>
#include <qlineedit.h>
#include <qlabel.h>

class QComboBox;

enum HTMLExportStyle{Grid=0, GridNewWindow, FrameThumbnail, FrameList};

class HTMLExportWizard : public KWizard
{
    Q_OBJECT
public:
    HTMLExportWizard(const QStringList &fileList,
                     QWidget *parent=0, const char *name=0);
    // thumbnail generation options
    int rows(){return(rowInput->value());}
    int cols(){return(colInput->value());}
    int thumbnailWidth(){return(wInput->value());}
    int thumbnailHeight(){return(hInput->value());}
    // thumbnail style options
    int thumbnailFrameWidth(){return(thumbFrameWidthInput->value());}
    QColor thumbnailFrameFg(){return(frameFgBtn->color());}
    QColor thumbnailFrameBg(){return(frameBgBtn->color());}
    // HTML style options
    HTMLExportStyle style(){return((HTMLExportStyle)styleGrp->id(styleGrp->selected()));}
    int tableBorder(){return(tableBorderInput->value());}
    bool useImageNames(){return(imageNameCB->isChecked());}
    // color and background options
    QColor bgColor(){return(bgBtn->color());}
    bool useBgImage(){return(bgImageCB->isChecked());}
    QString bgImageURL(){return(bgImageEdit->text());}
    QColor textColor(){return(textBtn->color());}
    QColor linkColor(){return(linkBtn->color());}
    QColor followedLinkColor(){return(followedLinkBtn->color());}
    // output options

protected slots:
    void slotStyleChanged(int type);
    void slotThumbSizeChanged(int val);
    void slotStdSizeCombo(int id);

    void slotUseNextImageCB(bool val);
    void slotUseBackImageCB(bool val);
    void slotUseHomeImageCB(bool val);
    void slotUseHomeCB(bool val);
    void slotUseBannerCB(bool val);

    void slotBorderType(int type);
    void slotBorderWidth(int w);
    void slotBorderColorChanged(const QColor &c);

    void accept();
private:
    void updateBorderPreview();
    void writeSettings();


    KIntNumInput *rowInput, *colInput, *wInput, *hInput, *tableBorderInput,
        *thumbFrameWidthInput, *bannerHInput;
    QCheckBox *bgImageCB, *imageNameCB;
    QCheckBox *useHomeCB, *useNextImageCB, *useBackImageCB, *useHomeImageCB,
        *useBannerCB;
    QButtonGroup *styleGrp, *frameGrp;
    KColorButton *bgBtn, *textBtn, *linkBtn, *followedLinkBtn,
        *frameFgBtn, *frameBgBtn, *frameFillBtn;
    QLineEdit *outputEdit, *bgImageEdit, *headerTextEdit;
    QLineEdit *homeURLText, *nextURLText, *backURLText;
    QLineEdit *homeURLEdit, *nextImageEdit, *backImageEdit, *homeImageEdit,
        *bannerURLEdit, *bannerImageEdit;
    QLabel *fgLbl, *bgLbl, *fillLbl, *preview;

    QComboBox *stdSizeCombo;
    int count;
};






#endif
