#ifndef __KIF_APPLICATION_H
#define __KIF_APPLICATION_H

#include <kapplication.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qasciidict.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
// ImageMagick redefines off_t to long long
#undef off_t
#define off_t long long
extern "C"{
#include <api.h>
};

class KIFFileList;
class KIFImage;
class QListBoxItem;
class CatagoryManager;
class PixieGlobal;
class KProgress;
class QLabel;

void qimageio_readXCF(QImageIO *io);

class KIFApplication : public KApplication
{
    Q_OBJECT
public:
    KIFApplication(int argc, char **argv);
    ~KIFApplication();
    CatagoryManager* catagoryManager();
    void hideWindows();
    void showWindows();
    void runInitialFileList(KIFFileList *fileList);
    void setBrowserAfterList(bool en){browserAfterList = en;}
    void loadBrowser(KIFFileList *fileList); // run only once!
    void loadEditor(const QString &fileStr);

    bool x11EventFilter(XEvent *ev);
    PixieGlobal* globals();
    void setMPlayerWindow(int playerid, int frameid);
    void setMagickMessageWidgets(KProgress *progress=0, QLabel *label=0);
    QLabel* magickMessageLabel();
    KProgress* magickMessageProgress();
signals:
    void hideAllWindows();
    void showAllWindows();
protected slots:
    void slotFileListFinished();
    void slotFileListSelected(QListBoxItem *i);
protected:

    KIFFileList *list;
    KIFImage *imageBuffer;
    QWidget *viewer;
    CatagoryManager *catMgr;
    bool browserAfterList;

    PixieGlobal *globalData;
    int mplayerWindow, mplayerFrameWindow;

    KProgress *magickProgress;
    QLabel *magickLbl;
};

KIFApplication* kifapp();

#endif

