#ifndef __KIF_UIMANAGER_H
#define __KIF_UIMANAGER_H

#include <qlistbox.h>
#include <qpopupmenu.h>
#include <kmainwindow.h>
#include <qtoolbar.h>
#include <qlabel.h>
#include <kcombobox.h>
#include <kdockwidget.h>
#include "dirtree.h"
#include "browser.h"
#include "completion.h"
#include <ktoolbarbutton.h>

//class KIFImageWindow;
class KIFImage;
class KIFImagePreview;
class KIFScaledTopLevel;
class KIFScrollTopLevel;
class KIFFullScreen;
class KIFDndListBox;
class QTabWidget;
class KProgress;
class KIFFileList;
class EditMenu;

class UIManager : public KDockMainWindow
{
    Q_OBJECT
public:
    friend class KIFBatchEffect;
    friend class PixieBrowser;

    UIManager(KIFFileList *list, const char *name=0);
    ~UIManager();
    QString currentPath(){return(pathStr);}
    void resetImageBuffer();
    bool isBackDirEnabled(){return(backDirBtn->isEnabled());}
    bool isForwardDirEnabled(){return(forwardDirBtn->isEnabled());}
    bool isUpDirEnabled(){return(upDirBtn->isEnabled());}
    QStringList* kioThumbnailTypes();
    bool useMPlayerVideo();

    void blockUI(bool blocked);

    KProgress* progressBar();
    QLabel* progressLabel();
    PixieBrowser* browser(){return(mainWidget);}
    bool usePixieThumbs(){return(internalImagePreview);}
    bool useEmbeddedJPEGPreview(){return(useEmbeddedJPEG);}
    bool useEmbeddedTIFFPreview(){return(useEmbeddedJPEG);}
public slots:
    void slotHotListClicked(const QString &path);
    void slotAddAndSetURL(const QString &path);
    void slotAddURL(const QString &path);
    void slotURLSelected(QListBoxItem *i);
    void slotSetTopItem();
    void slotNewFolder();
    void slotOpen();
    void slotPrint();
    void slotCopy();
    void slotPaste();
    void slotReload();
    void slotUpDir();
    void slotBackDir();
    void slotForwardDir();
    void slotGrab();
    void slotSlideShow();
    void slotPageLayout();
    void slotExportHTML();
    void slotEditCatagories();
    void slotUpdateView();
protected slots:
    void slotDirectoryTree(const QString &);
    void slotSizeMenu(int);
    void slotSortMenu(int);
    void slotPreviewMenu(int);
    void slotImageMenu(int);
    void slotVideoMenu(int);
    void slotViewMenu(int);
    void slotNewWindow();
    // thumbnail slots
    void slotPathEdit(const QString &);
    void slotHomeClicked();
    void slotUpdateClicked();
    void slotStopClicked();
    void slotThumbClicked(Thumbnail *i);
    void slotThumbDblClicked(Thumbnail *i);
    void slotEnableStopBtn(bool en);
    void slotSetStatus(const QString &);

    void slotEnableBackDir(bool);
    void slotEnableForwardDir(bool);
    void slotEnableUpDir(bool);

    void slotOpenFileList();
    void slotSaveFileList();
    void slotSaveFileListAs();

    void slotNextInDir();
    void slotPrevInDir();

    void slotLoadEditor();
    void slotLoadEditorFile(const QString &fileName);

    void slotHideAll();
    void slotShowAll();

    void slotAbout();
    void slotDocumentation();

    void slotCompareImages();

    void slotConvertThumbsToKonq();
    void slotConvertThumbsToPixie();

    void slotAboutToShowCatagoryMenu();
    void slotCatagoryShowMenuActivated(int id);
protected:
    int findURLIndex(const QString &url);
    bool imageShown();
    void createMenu(KMainWindow *parent);
    void createToolbar(KMainWindow *parent);
    void loadAllSettings();
    int sizeToPixels(int iSize);

    PixieDirTree *dirTree;
    //KIFImageWindow *imageWindow;
    KIFImage *imageBuffer;
    KIFImagePreview *imagePreview;
    KIFScaledTopLevel *scaledTopLevel;
    KIFScrollTopLevel *scrollTopLevel;
    KIFFullScreen *fullScreenTopLevel;

    QTabWidget *treeTabWidget;
    KIFFileList *fileList;

    QString fileListName;

    // thumbnail stuff
    PixieBrowser *mainWidget;
    //KComboBox *pathEdit;
    KHistoryCombo *pathEdit;
    PixieComp *fileComp;
    QString pathStr;
    int sorting;
    bool dupFirst;
    int showOnlyCatagory;
    QStringList historyList;
    QStringList::Iterator historyIt;

    bool catagoriesFirst, imageOnly, autoPreview, imagesOnTop;

    bool internalImagePreview, lowQualityPreview, useEmbeddedJPEG,
        useEmbeddedTIFF, previewText, previewClipart, previewPSPDF,
        previewKOffice, previewOffice, previewArchive, previewHTML,
        previewSound;

    bool previewVideo, videoKDE, videoMPlayer;

    bool linkView;
    int viewMode;
    int iconSize;
    KToolBar *thumbTb, *fileTb;
    KToolBarButton *stopBtn, *upDirBtn, *backDirBtn, *forwardDirBtn;
    KProgress *progress;
    int editImageMnuId;
    QPopupMenu *fileMnu, *editMnu;
    QPopupMenu *sortMenu, *sizeMenu, *previewMenu, *viewMenu, *imageMenu,
        *catagoryShowMenu, *videoMenu;
    QLabel *statusLbl;

    bool visible, cachedBackEnabled, cachedForwardEnabled, cachedUpEnabled;
    bool isBlocked;
    QStringList kioThumbList;
};


#endif
