
#line 3 "analyseur.lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 45
#define YY_END_OF_BUFFER 46
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[156] =
    {   0,
        0,    0,   46,   42,   44,   43,   45,   40,   41,   42,
       42,   38,   37,   35,   36,   32,   39,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       33,   34,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   29,    7,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   18,   20,   38,   38,   38,   19,   38,    5,
       38,   38,   38,   38,   38,   13,   38,   12,   23,   38,
       38,   21,   38,   38,   38,   38,   38,   38,   38,   38,

       22,   38,   38,   38,   38,   38,   10,   38,   38,   38,
       26,   38,   38,   38,    6,   38,   38,   38,   11,   17,
       38,   38,    8,   30,   27,   38,   38,   38,   38,    3,
       38,   38,   38,   38,   31,   28,   25,   38,   16,   24,
        4,   38,   14,   38,    9,    0,    0,   38,    2,    0,
        0,    1,   15,    1,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    1,    5,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    7,    1,    8,    9,

       10,   11,   12,   13,   14,    1,    1,   15,   16,   17,
       18,   19,    1,   20,   21,   22,   23,    1,   24,   25,
        1,    1,   26,    1,   27,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[28] =
    {   0,
        1,    2,    2,    2,    3,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,    3
    } ;

static yyconst flex_int16_t yy_base[160] =
    {   0,
        0,   26,  184,  180,  185,  185,   53,  185,  185,  179,
      185,    0,  185,  185,  185,  185,  175,    0,  170,    0,
      161,  168,  167,    2,    0,    2,  166,   12,   22,  168,
      185,  185,    0,  153,  157,    4,  163,  151,  148,  151,
      151,  160,  156,    0,  144,  143,  141,  149,  150,  152,
      152,  133,  135,  134,  135,  144,  137,  138,  131,    0,
      132,  129,  126,  137,  137,  138,  129,  133,   21,  121,
      127,  130,  129,  116,   18,  115,  121,    0,  118,    0,
      124,  116,  122,  111,  120,    0,  109,    0,    0,  105,
      102,    0,  119,  111,  106,  103,  102,  107,   98,   84,

        0,   94,   89,   85,   91,   89,    0,   88,   84,   88,
        0,   84,   78,   77,    0,   83,   74,   84,    0,    0,
       34,   28,    0,    0,   28,   40,   36,   35,   32,   22,
       24,   23,   19,   25,    0,    0,    0,   79,    0,    0,
        0,    8,    0,    4,    0,   82,   82,    2,    0,   83,
       84,  185,    0,   85,  185,  112,  115,    0,  117
    } ;

static yyconst flex_int16_t yy_def[160] =
    {   0,
      156,  156,  155,  157,  155,  155,  155,  155,  155,  157,
      155,  158,  155,  155,  155,  155,  155,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      155,  155,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,

      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  155,  159,  158,  158,  159,
      159,  155,  158,  159,    0,  155,  155,  155,  155
    } ;

static yyconst flex_int16_t yy_nxt[213] =
    {   0,
       33,    5,    6,    5,    7,  155,   34,   67,   68,   45,
       43,  153,  149,   46,   58,  148,   37,   35,   44,   38,
       47,   50,   59,   48,   39,    8,    9,    5,    6,    5,
        7,   52,   92,   51,   99,   53,  145,  100,  144,  143,
      142,   93,  141,  140,  139,  138,   54,  137,  136,  135,
      134,    8,    9,   12,   13,   14,   15,   16,   17,   12,
       18,   19,   20,   21,   22,   23,   24,   12,   25,   12,
       26,   12,   27,   28,   29,   12,   30,   12,   31,   32,
      146,  146,  146,  146,  146,  146,  151,  151,  151,  151,
      133,  132,  131,  130,  129,  128,  127,  126,  125,  124,

      123,  122,  121,  120,  147,  119,  118,  147,  152,  152,
      154,  152,    4,    4,    4,   10,   10,  150,  150,  150,
      117,  116,  115,  114,  113,  112,  111,  110,  109,  108,
      107,  106,  105,  104,  103,  102,  101,   98,   97,   96,
       95,   94,   91,   90,   89,   88,   87,   86,   85,   84,
       83,   82,   81,   80,   79,   78,   77,   76,   75,   74,
       73,   72,   71,   70,   69,   66,   65,   64,   63,   62,
       61,   60,   57,   56,   55,   49,   42,   41,   40,   36,
       17,   11,   11,  155,    3,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,

      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155
    } ;

static yyconst flex_int16_t yy_chk[213] =
    {   0,
      158,    1,    1,    1,    1,    0,   18,   44,   44,   25,
       24,  148,  144,   25,   36,  142,   20,   18,   24,   20,
       26,   28,   36,   26,   20,    1,    1,    2,    2,    2,
        2,   29,   69,   28,   75,   29,  134,   75,  133,  132,
      131,   69,  130,  129,  128,  127,   29,  126,  125,  122,
      121,    2,    2,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
      138,  138,  138,  146,  146,  146,  147,  150,  151,  154,
      118,  117,  116,  114,  113,  112,  110,  109,  108,  106,

      105,  104,  103,  102,  138,  100,   99,  146,  147,  150,
      151,  154,  156,  156,  156,  157,  157,  159,  159,  159,
       98,   97,   96,   95,   94,   93,   91,   90,   87,   85,
       84,   83,   82,   81,   79,   77,   76,   74,   73,   72,
       71,   70,   68,   67,   66,   65,   64,   63,   62,   61,
       59,   58,   57,   56,   55,   54,   53,   52,   51,   50,
       49,   48,   47,   46,   45,   43,   42,   41,   40,   39,
       38,   37,   35,   34,   30,   27,   23,   22,   21,   19,
       17,   10,    4,    3,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,

      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#line 21 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
#include <src/global/global.h>

#include <src/donnees/general/general.h>
#include <src/donnees/commandes/localisationfichier.h>

#include <src/problemes/verbeux/verbeux.h>

#include <src/donnees/environnement/environnement.h>

#include <src/analyseur/donnees/filenomfichier.h>

#include <src/analyseur/donnees/pilechaine.h>
#include <src/analyseur/donnees/pileentier.h>

#include <src/analyseur/analyseur/analyseur.syn.h>

/* Nom de la variable d'environnement
 * indiquant le fichier inclus par
 * #standard.
 */
#define VARENVPLANFACILE	"PLANFACILE"

/* Chemin vers le fichier standard
 * de l'utilisateur courant, inclus
 * par #standard.
 */
#define UTILISATEURPLANFACILE	"~/.planfacile/standard.plf"

/* Chemin vers le fichier standard
 * du systme, inclus par #standard.
 */
#include <src/analyseur/analyseur/standard.h>

/* Numro de la premire ligne d'un fichier
 */
#define PREMIERE_LIGNE_FICHIER	1


extern STOCKAGE(General) general;
extern STOCKAGE_SCALAIRE(Entier) niveauimbricationmacro;
extern Resultat analyseur_verificationcopielocalisation(TRAVAIL(Environnement) environnement , REFERENCE_SCALAIRE(Booleen) copielocalisation);

Resultat analyseur_verificationcheminabsolu(TRAVAIL(Environnement) environnement , REFERENCE_SCALAIRE(Booleen) cheminabsolu)
{
	/* Sert  dterminer si le chemin  afficher pour les problmes lors des inclusions de fichiers
	 * est le chemin absolu (depuis la racine du FS) ou le chemin donn par l'utilisateur.
	 * Renvoie RESULTAT_ERREUR si environnement vaut NULL.
	 */
	TRAVAIL(Options) options;
	DEBUTZONESECURISEE
	if(S_T(environnement)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(environnement_lecture_options(environnement,R_T(options)));
	SECURISE(options_lecture_localisationabsolue(options,cheminabsolu));
	FINZONESECURISEE
	return RESULTAT_OK;
}

/* Pile de buffers pour les changements d'entre
 */
typedef struct pilebuffer CONTENEUR(PileBuffer);

struct pilebuffer
{
	STOCKAGE_SCALAIRE(YY_BUFFER_STATE) buffer;
	STOCKAGE(PileBuffer) suivant;
};

static STOCKAGE(PileBuffer) pile=NULL;

Resultat buffer_empile()
{
	STOCKAGE(PileBuffer) nouveau;
	if((nouveau=(STOCKAGE(PileBuffer))(malloc(SIZEOF(CONTENEUR(PileBuffer)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	CHAMP_STOCKAGE(nouveau , buffer)=YY_CURRENT_BUFFER;
	CHAMP_STOCKAGE(nouveau , suivant)=pile;
	pile=nouveau;
	return RESULTAT_OK;
}

Resultat buffer_depile()
{
	STOCKAGE(PileBuffer) ancien;
	if(pile==NULL)
		return RESULTAT_ERREUR;
	ancien=pile;
	yy_delete_buffer(T_S_(YY_CURRENT_BUFFER));
	yy_switch_to_buffer(T_S_(CHAMP_STOCKAGE(ancien , buffer)));
	pile=CHAMP_STOCKAGE(ancien , suivant);
	free(ancien);
	return RESULTAT_OK;
}


/* Fonction utilise pour la gestion de #include et #standard
 */

Resultat analyseur_inclusion_fichier(TRAVAIL(General) general , TRAVAIL_SCALAIRE(NomFichier) nomfichierinclusion , TRAVAIL_SCALAIRE(Probleme) problemechemininvalide , TRAVAIL_SCALAIRE(Probleme) problemerecursivite , TRAVAIL_SCALAIRE(Probleme) problemeinexistant , TRAVAIL_SCALAIRE(Probleme) problemetypeincorrect , TRAVAIL_SCALAIRE(Probleme) problemeentree , REFERENCE_SCALAIRE(Booleen) inclusion)
{
	/* Effectue les oprations ncssaires pour la lecture d'un fichier  inclure
	 * dans le fichier courant.
	 * Permet de spcifier le probleme   lever lors d'un echec d'ouverture de fichier.
	 * Retourne RESULTAT_ERREUR si general vaut NULL.
	 * Retourne RESULTAT_ERREUR si nomfichierinclusion vaut NULL.
	 */
	TRAVAIL_SCALAIRE(NomFichier) nomfichierabsolu;
	TRAVAIL_SCALAIRE(Booleen) chemin_valide;
	TRAVAIL_SCALAIRE(Booleen) bouclage;
	TRAVAIL_SCALAIRE(DescripteurFichier) fichierinclus;
	TRAVAIL_SCALAIRE(Booleen) copielocalisation;
	TRAVAIL_SCALAIRE(Booleen) localisationcheminabsolu;
	STOCKAGE_SCALAIRE(struct stat) infosfichier;
	DEBUTZONESECURISEE
	if((S_T(general)==NULL)||(S_T_(nomfichierinclusion)==NULL))
		return RESULTAT_ERREUR;
	SECURISE(verbeux_verbeux(general,T_S_(VERBEUX_ANALYSE_INCLUSION),nomfichierinclusion));
	SECURISE(environnement_ajout_repertoirefichier(CHAMP_TRAVAIL(general , environnement),nomfichierinclusion,R_T_(nomfichierabsolu),R_T_(chemin_valide)));
	/* Ajout du rpertoire courant sur la pile des repertoires et
	 * dplacement dans le repertoire du fichier  inclure.
	 */
	if(chemin_valide==T_S_(FAUX))
	{
		/* Le chemin vers le fichier  inclure n'est pas valide.
		 */
		inclusion=T_S_(FAUX);
		SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(probleme_probleme(general,problemechemininvalide,CHAMP_TRAVAIL(general , localisation),nomfichierinclusion));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,problemechemininvalide,T_S(localisationnulle),nomfichierinclusion));
		}
		return RESULTAT_OK;
	}
	SECURISE(localisationfichier_test_fichier(CHAMP_TRAVAIL(general , localisation),nomfichierabsolu,R_T_(bouclage)));
	if(bouclage==T_S_(VRAI))
	{
		/* Bouclage d'inclusion dtect.
		 */
		T_R_(inclusion)=T_S_(FAUX);
		free(S_T_(nomfichierabsolu));
		SECURISE(environnement_retrait_repertoirefichier(CHAMP_TRAVAIL(general , environnement)));
		/* Retour dans le repertoire prcdent avec retrait du dernier rpertoire
		 * de la pile des rpertoires.
		 */
		SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(probleme_probleme(general,problemerecursivite,CHAMP_TRAVAIL(general , localisation),nomfichierinclusion));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,problemerecursivite,T_S(localisationnulle),nomfichierinclusion));
		}
		return RESULTAT_OK;
	}
	if((stat((char*)(nomfichierabsolu),C_S_(infosfichier))!=T_S_(0)))
	{
		/* Le fichier n'existe pas.
		 */
		inclusion=T_S_(FAUX);
		free(S_T_(nomfichierabsolu));
		SECURISE(environnement_retrait_repertoirefichier(CHAMP_TRAVAIL(general , environnement)));
		/* Retour dans le repertoire prcdent avec retrait du dernier rpertoire
		 * de la pile des rpertoires.
		 */
		SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(probleme_probleme(general,problemeinexistant,CHAMP_TRAVAIL(general , localisation),nomfichierinclusion));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,problemeinexistant,T_S(localisationnulle),nomfichierinclusion));
		}
		return RESULTAT_OK;
	}
	if((S_ISDIR(CHAMP_STOCKAGE_(infosfichier , st_mode)))||(S_ISBLK(CHAMP_STOCKAGE_(infosfichier , st_mode))))
	{
		/* Le nom de fichier dsigne un rpertoire ou un fichier de type block.
		 */
		inclusion=T_S_(FAUX);
		free(S_T_(nomfichierabsolu));
		SECURISE(environnement_retrait_repertoirefichier(CHAMP_TRAVAIL(general , environnement)));
		/* Retour dans le repertoire prcdent avec retrait du dernier rpertoire
		 * de la pile des rpertoires.
		 */
		SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(probleme_probleme(general,problemetypeincorrect,CHAMP_TRAVAIL(general , localisation),nomfichierinclusion));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,problemetypeincorrect,T_S(localisationnulle),nomfichierinclusion));
		}
		return RESULTAT_OK;
	}
	if((S_T_(fichierinclus)=(STOCKAGE_SCALAIRE(DescripteurFichier))(fopen((char*)(nomfichierabsolu),T_S_("r"))))==NULL)
	{
		/* Le fichier  inclure n'a pu tre ouvert en lecture.
		 */
		T_R_(inclusion)=T_S_(FAUX);
		free(S_T_(nomfichierabsolu));
		SECURISE(environnement_retrait_repertoirefichier(CHAMP_TRAVAIL(general , environnement)));
		/* Retour dans le repertoire prcdent avec retrait du dernier rpertoire
		 * de la pile des rpertoires.
		 */
		SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(probleme_probleme(general,problemeentree,CHAMP_TRAVAIL(general , localisation),nomfichierinclusion));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,problemeentree,T_S(localisationnulle),nomfichierinclusion));
		}
		return RESULTAT_OK;
	}
	SECURISE(analyseur_verificationcheminabsolu(CHAMP_TRAVAIL(general , environnement),R_T_(localisationcheminabsolu)));
	if(localisationcheminabsolu==T_S_(VRAI))
	{
		SECURISE(localisationfichier_ajout(CHAMP_TRAVAIL(general , localisation),nomfichierabsolu,nomfichierabsolu,fichierinclus,T_S_(PREMIERE_LIGNE_FICHIER)));
	}
	else
	{
		SECURISE(localisationfichier_ajout(CHAMP_TRAVAIL(general , localisation),nomfichierinclusion,nomfichierabsolu,fichierinclus,T_S_(PREMIERE_LIGNE_FICHIER)));
	}
	/* Le fichier a t ouvert en lecture, ajout de sa localisation.
	 */
	SECURISE(buffer_empile());
	/* Mise sur la pile du buffer de lecture de lex du fichier courant.
	 */
	T_S_(yyin)=fichierinclus;
	yy_switch_to_buffer(yy_create_buffer(T_S_(yyin),T_S_(YY_BUF_SIZE)));
	/* Cration et utilisation du buffer d'entre de lex pour le fichier inclus.
	 */
	T_R_(inclusion)=T_S_(VRAI);
	free(S_T_(nomfichierabsolu));
	FINZONESECURISEE
	return RESULTAT_OK;
}


/* Fonctions utiles pour grer la commande #include
 */

static Resultat analyseur_obtenirnomfichierinclude(TRAVAIL_SCALAIRE(Chaine) chainetoken , REFERENCE_SCALAIRE(NomFichier) nomfichier)
{
	/* Extrait de la chaine reconnue par lex le nom de fichier
	 * entre par l'utilisateur.
	 * Retourne RESULTAT_ERREUR si chainetoken vaut NULL.
	 * Retourne RESULTAT_ERREUR_MEMOIRE si une allocation echoue.
	 */
	STOCKAGE_SCALAIRE(Chaine) copiechainetoken;
	REFERENCE_SCALAIRE(Caractere) debut;
	REFERENCE_SCALAIRE(Caractere) parcours;
	STOCKAGE_SCALAIRE(Entier) decalage;
	if(S_T_(chainetoken)==NULL)
		return RESULTAT_ERREUR;
	if((copiechainetoken=(STOCKAGE_SCALAIRE(Chaine))(strdup((char*)(chainetoken))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	debut=((REFERENCE_SCALAIRE(Caractere))(copiechainetoken))+8;/* on saute le '#include'	*/
	/* on "mange" les blancs entre le #include et le debut de parametre { 			*/
	while((T_R_(debut)==T_S_(' '))||(T_R_(debut)==T_S_('\t'))||(T_R_(debut)==T_S_('\n')))
		debut++;
	debut++;/* on "mange" le debut de parametre { */
	decalage=0;
	for(parcours=debut ; (T_R_(parcours+decalage))!=T_S_('\0') ; parcours++)
	{
		if(((T_R_(parcours+decalage))==T_S_('#'))&&((T_R_(parcours+decalage+1))==T_S_('}')))
		{
			decalage=S_T_(T_S_(decalage)+T_S_(1));
			T_R_(parcours)=T_S_('}');
		}
		else
			T_R_(parcours)=T_R_(parcours+decalage);
	}
	/* on rduit tous les #} en }
	 */
	T_R_(parcours-1)=T_S_('\0');
	/* on marque la fin de la chaine en ecrasant la fin de parametre }
	 */
	if((T_R_(nomfichier)=T_S_((STOCKAGE_SCALAIRE(NomFichier))(strdup((char*)(T_S_((STOCKAGE_SCALAIRE(Chaine))(debut)))))))==T_S_(NULL))
		return RESULTAT_ERREUR_MEMOIRE;
	free(copiechainetoken);
	return RESULTAT_OK;
}

static Resultat analyseur_traitementinclude(TRAVAIL(General) general , TRAVAIL_SCALAIRE(Chaine) chainetokeninclude)
{
	/* Traite une inclusion demande par la commande #include.
	 * Retourne RESULTAT_ERREUR si general vaut NULL.
	 * Retourne RESULTAT_ERREUR si chainetokeninclude vaut NULL.
	 */
	TRAVAIL_SCALAIRE(NomFichier) nomfichierinclude;
	TRAVAIL_SCALAIRE(Booleen) inclusion_ok;
	TRAVAIL_SCALAIRE(Booleen) copielocalisation;
	DEBUTZONESECURISEE
	if((S_T(general)==NULL)||(S_T_(chainetokeninclude)==NULL))
		return RESULTAT_ERREUR;
	SECURISE(analyseur_obtenirnomfichierinclude(chainetokeninclude,R_T_(nomfichierinclude)));
	if(strlen(nomfichierinclude)!=0)
	{
		/* Un nom de fichier non vide a t lu.
		 */
		SECURISE(analyseur_inclusion_fichier(general,nomfichierinclude,T_S_(PROBLEME_OUVERTURE_CHEMIN_INVALIDE),T_S_(PROBLEME_RECURSIVITE_FICHIER),T_S_(PROBLEME_OUVERTURE_INEXISTANT),T_S_(PROBLEME_OUVERTURE_TYPE_INCORRECT),T_S_(PROBLEME_OUVERTURE_ENTREE),R_T_(inclusion_ok)));
	}
	else
	{
		SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_ENTREE_VIDE),CHAMP_TRAVAIL(general , localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_ENTREE_VIDE),T_S(localisationnulle)));
		}
	}
	free(S_T_(nomfichierinclude));
	FINZONESECURISEE
	return RESULTAT_OK;
}


/* Fonction pour la gestion de #standard
 */

static Resultat analyseur_traitementstandard(TRAVAIL(General) general)
{
	/* Traite une inclusion demande par la commande #standard.
	 * La priorit d'inclusion est:
	 *	1) le fichier indiqu par la variable d'environnement PLANFACILE
	 *	   si elle existe.
	 *	2) le fichier defini par UTILISATEURPLANFACILE.
	 *	3) le fichier defini par SYSTEMEPLANFACILE.
	 * Si une inclusion choue, le fichier de priorit infrieure est utilis.
	 * Renvoie RESULTAT_ERREUR si general vaut NULL.
	 */
	TRAVAIL_SCALAIRE(NomFichier) nomfichier;
	STOCKAGE_SCALAIRE(Booleen) inclusion_ok;
	TRAVAIL_SCALAIRE(Booleen) copielocalisation;
	DEBUTZONESECURISEE
	if(S_T(general)==NULL)
		return RESULTAT_ERREUR;
	inclusion_ok=T_S_(FAUX);
	if((S_T_(nomfichier)=(STOCKAGE_SCALAIRE(NomFichier))(getenv(T_S_(VARENVPLANFACILE))))!=NULL)
	{
		/* La variable d'environnement de planfacile existe.
		 */
		if(strlen(nomfichier)!=0)
		{
			SECURISE(analyseur_inclusion_fichier(general,nomfichier,T_S_(PROBLEME_OUVERTURE_CHEMIN_INVALIDE_STANDARD),T_S_(PROBLEME_RECURSIVITE_FICHIER_STANDARD),T_S_(PROBLEME_OUVERTURE_INEXISTANT_STANDARD),T_S_(PROBLEME_OUVERTURE_TYPE_INCORRECT_STANDARD),T_S_(PROBLEME_OUVERTURE_ENTREE_STANDARD),C_S_(inclusion_ok)));
			/* Traitement de l'inclusion du fichier dsign par la variable
			 * d'environnement de planfacile.
			 */
		}
		else
		{	/* La variable d'environnement est vide.
			 */
			inclusion_ok=FAUX;
		}
		if(inclusion_ok==FAUX)
		{
			/* L'inclusion du fichier a choue, on appelle le problme relatif au passage au fichier
			 * de priorit infrieure.
			 */
			SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
			if(copielocalisation==T_S_(VRAI))
			{
				SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_STANDARD_SUIVANTE),CHAMP_TRAVAIL(general , localisation),T_S_(UTILISATEURPLANFACILE)));
			}
			else
			{
				STOCKAGE(LocalisationFichier) localisationnulle;
				localisationnulle=NULL;
				SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_STANDARD_SUIVANTE),T_S(localisationnulle),T_S_(UTILISATEURPLANFACILE)));
			}
		}
	}
	if(inclusion_ok==FAUX)
	{
		/* Aucun fichier n'a encore t inclus, on essaie d'inclure le fichier standard utilisateur.
		 */
		nomfichier=T_S_(UTILISATEURPLANFACILE);
		SECURISE(analyseur_inclusion_fichier(general,nomfichier,T_S_(PROBLEME_OUVERTURE_CHEMIN_INVALIDE_STANDARD),T_S_(PROBLEME_RECURSIVITE_FICHIER_STANDARD),T_S_(PROBLEME_OUVERTURE_INEXISTANT_STANDARD),T_S_(PROBLEME_OUVERTURE_TYPE_INCORRECT_STANDARD),T_S_(PROBLEME_OUVERTURE_ENTREE_STANDARD),C_S_(inclusion_ok)));
	}
	if(inclusion_ok==FAUX)
	{
		/* L'inclusion du fichier a choue...
		 */
		nomfichier=T_S_(SYSTEMEPLANFACILE);
		SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_STANDARD_SUIVANTE),CHAMP_TRAVAIL(general , localisation),T_S_(SYSTEMEPLANFACILE)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_STANDARD_SUIVANTE),T_S(localisationnulle),T_S_(SYSTEMEPLANFACILE)));
		}
		SECURISE(analyseur_inclusion_fichier(general,nomfichier,T_S_(PROBLEME_OUVERTURE_CHEMIN_INVALIDE_STANDARD),T_S_(PROBLEME_RECURSIVITE_FICHIER_STANDARD),T_S_(PROBLEME_OUVERTURE_INEXISTANT_STANDARD),T_S_(PROBLEME_OUVERTURE_TYPE_INCORRECT_STANDARD),T_S_(PROBLEME_OUVERTURE_ENTREE_STANDARD),C_S_(inclusion_ok)));
	}
	if(inclusion_ok==FAUX)
	{
		/* Aucun fichier n'a pu tre inclus.
		 */
		SECURISE(analyseur_verificationcopielocalisation(CHAMP_TRAVAIL(general , environnement),R_T_(copielocalisation)));
		if(copielocalisation==T_S_(VRAI))
		{
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_STANDARD),CHAMP_TRAVAIL(general , localisation)));
		}
		else
		{
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_STANDARD),T_S(localisationnulle)));
		}
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}


/* Fonctions pour la mise  jour de la position de la localisation de fichier
 */

static Resultat analyseur_modificationposition(TRAVAIL(General) general , TRAVAIL_SCALAIRE(Entier) increment)
{
	/* Ajoute (increment)  la position de genral->localisation.
	 * Retourne RESULTAT_ERREUR si general est NULL.
	 */
	TRAVAIL_SCALAIRE(PositionFichier) position;
	DEBUTZONESECURISEE
	if(S_T(general)==NULL)
		return RESULTAT_ERREUR;
	if(increment==T_S_(0))
		return RESULTAT_OK;
	SECURISE(localisationfichier_lecture_position(CHAMP_TRAVAIL(general , localisation),R_T_(position)));
	position+=increment;
	SECURISE(localisationfichier_modification(CHAMP_TRAVAIL(general , localisation),position));
	/* Sans commentaires... ^_^
	 */
	FINZONESECURISEE
	return RESULTAT_OK;
}
static TRAVAIL_SCALAIRE(Entier) analyseur_nombreretourchariot(TRAVAIL_SCALAIRE(Chaine) chaine)
{
	/* Retourne le nombre de retours charlots (^_^) prsents dans la chaine.
	 * Retourne 0 si la chaine vaut NULL.
	 */
	TRAVAIL_SCALAIRE(Entier) nb_retourchariot;
	REFERENCE_SCALAIRE(Caractere) curseur;
	nb_retourchariot=T_S_(0);
	if(chaine!=T_S_(NULL))
		for(curseur=((REFERENCE_SCALAIRE(Caractere))(chaine)) ; T_R_(curseur)!=T_S_('\0') ; curseur++)
		{
			if(T_R_(curseur)==T_S_('\n'))
				nb_retourchariot++;
		}
	return nb_retourchariot;
}

static Resultat analyseur_modificationerreursyntaxe(TRAVAIL(General) general , TRAVAIL_SCALAIRE(Chaine) chainetokenerreur)
{
	/* Fait pointer general->erreursyntaxe sur une copie de la chaine
	 * passe en paramtre, pour connaitre la derniere chaine lue si
	 * une erreur de syntaxe est dtecte.
	 * Libre la chaine prcdement alloue si besoin est.
	 * Renvoie RESULTAT_ERREUR si general vaut NULL.
	 * Renvoie RESULTAT_ERREUR si chainetokenerreur vaut NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si l'allocation echoue.
	 */
	if((S_T(general)==NULL)||(S_T_(chainetokenerreur)==NULL))
		return RESULTAT_ERREUR;
	if(CHAMP(general , erreursyntaxe)!=NULL)
		free(CHAMP(general , erreursyntaxe));
	if((CHAMP(general , erreursyntaxe)=(STOCKAGE_SCALAIRE(Chaine))(strdup((char*)(chainetokenerreur))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	return RESULTAT_OK;
}

#line 1068 "analyseur.lex.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 525 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"


#line 1222 "analyseur.lex.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 156 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 185 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 527 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#include"))));
						SECURISE(analyseur_traitementinclude(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))(yytext))));
						SECURISE(analyseur_modificationposition(T_S(general),analyseur_nombreretourchariot(T_S_((STOCKAGE_SCALAIRE(Chaine))(yytext)))));
						FINZONESECURISEE
						return TOKEN_INCLUDE;
					}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 536 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#standard"))));
						SECURISE(analyseur_traitementstandard(T_S(general)));
						FINZONESECURISEE
						return TOKEN_STANDARD;
					}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 545 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#option"))));
						FINZONESECURISEE
						return TOKEN_OPTION;
					}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 552 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#options"))));
						FINZONESECURISEE
						return TOKEN_OPTIONS;
					}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 559 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#case"))));
						FINZONESECURISEE
						return TOKEN_CASE;
					}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 566 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#other"))));
						FINZONESECURISEE
						return TOKEN_OTHER;
					}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 573 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#end"))));
						FINZONESECURISEE
						return TOKEN_END;
					}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 581 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#define"))));
						FINZONESECURISEE
						return TOKEN_DEFINE;
					}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 589 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#warning"))));
						FINZONESECURISEE
						return TOKEN_WARNING;
					}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 596 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#error"))));
						FINZONESECURISEE
						return TOKEN_ERROR;
					}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 604 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#start"))));
						FINZONESECURISEE
						return TOKEN_START;
					}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 611 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#head"))));
						FINZONESECURISEE
						return TOKEN_HEAD;
					}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 618 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#foot"))));
						FINZONESECURISEE
						return TOKEN_FOOT;
					}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 625 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#section"))));
						FINZONESECURISEE
						return TOKEN_SECTION;
					}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 632 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#reference"))));
						FINZONESECURISEE
						return TOKEN_REFERENCE;
					}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 639 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#message"))));
						FINZONESECURISEE
						return TOKEN_MESSAGE;
					}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 647 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#title"))));
						FINZONESECURISEE
						return TOKEN_TITLE;
					}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 654 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#ref"))));
						FINZONESECURISEE
						return TOKEN_REF;
					}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 661 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#txt"))));
						FINZONESECURISEE
						return TOKEN_TXT;
					}	
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 668 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_(STOCKAGE_SCALAIRE(Chaine))(("#sec"))));
						FINZONESECURISEE
						return TOKEN_SEC;
					}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 675 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#mesg"))));
						FINZONESECURISEE
						return TOKEN_MESG;
					}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 682 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#text"))));
						FINZONESECURISEE
						return TOKEN_TEXT;
					}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 690 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#idea"))));
						FINZONESECURISEE
						return TOKEN_IDEA;
					}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 697 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#missing"))));
						FINZONESECURISEE
						return TOKEN_MISSING;
					}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 704 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#generic"))));
						FINZONESECURISEE
						return TOKEN_GENERIC;
					}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 712 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#index"))));
						FINZONESECURISEE
						return TOKEN_INDEX;
					}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 719 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#extref"))));
						FINZONESECURISEE
						return TOKEN_EXTREF;
					}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 726 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#extrefs"))));
						FINZONESECURISEE
						return TOKEN_EXTREFS;
					}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 734 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#dep"))));
						FINZONESECURISEE
						return TOKEN_DEP;
					}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 741 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#depref"))));
						FINZONESECURISEE
						return TOKEN_DEPREF;
					}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 749 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#comment"))));
						FINZONESECURISEE
						return TOKEN_COMMENT;
					}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 757 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("##"))));
						FINZONESECURISEE
						return TOKEN_ECHAP_COMMANDE;
					}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 764 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#{"))));
						FINZONESECURISEE
						return TOKEN_ECHAP_PARAM_DEBUT;
					}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 771 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#}"))));
						FINZONESECURISEE
						return TOKEN_ECHAP_PARAM_FIN;
					}
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 778 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#\\n"))));
						SECURISE(analyseur_modificationposition(T_S(general),T_S_(1)));
						FINZONESECURISEE
						return TOKEN_ECHAP_RETOURLIGNE;
					}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 786 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("# "))));
						FINZONESECURISEE
						return TOKEN_ECHAP_ESPACE;
					}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 793 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("#\\t"))));
						FINZONESECURISEE
						return TOKEN_ECHAP_TAB;
					}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 802 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{	
						DEBUTZONESECURISEE
						SECURISE(pilenommacro_ajout(T_S(CHAMP_STOCKAGE(general , pilenommacro)),T_S_(yytext+1),T_S_(niveauimbricationmacro)));
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))(yytext))));
						FINZONESECURISEE
						return TOKEN_MACRO;
					}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 810 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{	
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(pileentier_ajout(T_S(CHAMP_STOCKAGE(general , pileparametre)),(TRAVAIL_SCALAIRE(Entier))(T_S_(atoi(yytext+1)))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))(yytext))));
						FINZONESECURISEE
						return TOKEN_PARAMETRE;
					}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 819 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("{"))));
						FINZONESECURISEE
						return TOKEN_PARAM_DEBUT;
					}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 826 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))("}"))));
						FINZONESECURISEE
						return TOKEN_PARAM_FIN;
					}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 834 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(pilelocalisationfichier_ajout(T_S(CHAMP_STOCKAGE(general , pilelocalisation)),T_S(CHAMP_STOCKAGE(general , localisation))));
						SECURISE(pilechaine_ajout(T_S(CHAMP_STOCKAGE(general , piletexte)),T_S_((STOCKAGE_SCALAIRE(Chaine))(yytext))));
						SECURISE(analyseur_modificationerreursyntaxe(T_S(general),T_S_((STOCKAGE_SCALAIRE(Chaine))(yytext))));
						SECURISE(analyseur_modificationposition(T_S(general),analyseur_nombreretourchariot(T_S_((STOCKAGE_SCALAIRE(Chaine))(yytext)))));
						FINZONESECURISEE
						return TOKEN_TEXTE;
					}
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
#line 844 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						DEBUTZONESECURISEE
						SECURISE(analyseur_modificationposition(T_S(general),T_S_((STOCKAGE_SCALAIRE(Entier))(1))));
						FINZONESECURISEE
					}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 849 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
{
						/* RIEN */
					}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 853 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"
ECHO;
	YY_BREAK
#line 1800 "analyseur.lex.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 156 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 156 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 155);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 853 "/home/pappy/planfacile/planfacile/src/analyseur/analyseur/analyseur.lex.l"



Resultat analyseur_ouverture_fichier(TRAVAIL(General) general , REFERENCE_SCALAIRE(Booleen) finanalyse)
{
	/* Prpare la structure 'general' pour l'analyse du prochain fichier valide.
	 * Renvoie RESULTAT_ERREUR si general vaut NULL.
	 */
	TRAVAIL_SCALAIRE(NomFichier) nomfichierfile;
	TRAVAIL_SCALAIRE(NomFichier) nomfichierabsolu;
	TRAVAIL_SCALAIRE(Booleen) cheminvalide;
	TRAVAIL_SCALAIRE(Booleen) filenomfichiervide;
	TRAVAIL_SCALAIRE(Booleen) localisationcheminabsolu;
	TRAVAIL_SCALAIRE(DescripteurFichier) fichier;
	STOCKAGE_SCALAIRE(struct stat) infosfichier;
	DEBUTZONESECURISEE
	if(S_T(general)==NULL)
		return RESULTAT_ERREUR;
	T_R_(finanalyse)=T_S_(FAUX);
	for(;;)
	{
		SECURISE(filenomfichier_vide(CHAMP_TRAVAIL(general , sources),R_T_(filenomfichiervide)));
		if(filenomfichiervide==T_S_(VRAI))
		{
			/* La file des noms de fichier est vide : il n'y a plus de fichier  traiter.
			 */
			T_R_(finanalyse)=T_S_(VRAI);
			break;
		}
		SECURISE(filenomfichier_retrait_nomfichier(CHAMP_TRAVAIL(general , sources),R_T_(nomfichierfile)));
		/* Retrait d'un nom de fichier de la file.
		 */
		SECURISE(verbeux_verbeux(general,T_S_(VERBEUX_ANALYSE_SOURCE),nomfichierfile));
		if(strcmp((char*)(nomfichierfile),T_S_("-"))==0)
		{
			/* L'entre est l'entre standard.
			 */
			free(S_T_(nomfichierfile));
			SECURISE(environnement_ajout_repertoirefichier(CHAMP_TRAVAIL(general , environnement),T_S_("./"),R_T_(nomfichierabsolu),R_T_(cheminvalide)));
			/* On ajoute le repertoire courant dans la pile des repertoires.
			 * (Le rpertoire courant tant retir  chaque fin d'analyse de fichier,
			 *  il convient d'ajouter galement un repertoire pour l'entre standard)
			 * Le nomfichierabsolu retourn n'est que le chemin absolu vers le rpertoire
			 * courant : il sera rapidement dtruit.
			 */
			if(cheminvalide==T_S_(FAUX))
			{
				/* Le rpertoire courant n'a pu tre ajout  la pile des rpertoires.
				 */
				STOCKAGE(LocalisationFichier) localisationnulle;
				localisationnulle=NULL;
				SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_REPERTOIRE_COURANT),T_S(localisationnulle)));
				continue;
			}
			free(S_T_(nomfichierabsolu));
			SECURISE(localisationfichier_ajout(CHAMP_TRAVAIL(general , localisation),T_S_("-"),T_S_("-"),T_S_(stdin),T_S_(PREMIERE_LIGNE_FICHIER)));
			/* Ajout de la localisation approprie pour l'analyse.
			 */
			break;
		}
		/* L'entre n'est pas l'entre standard.
		 */
		SECURISE(environnement_ajout_repertoirefichier(CHAMP_TRAVAIL(general , environnement),nomfichierfile,R_T_(nomfichierabsolu),R_T_(cheminvalide)));
		/* On se place dans le repertoire du fichier  traiter.
		 */
		if(cheminvalide==T_S_(FAUX))
		{
			/* Le chemin vers le rpertoire du fichier n'a pu tre rsolu.
			 */
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_CHEMIN_INVALIDE),T_S(localisationnulle),nomfichierfile));
			/* Memory Leak sur nomfichierfile en cas d'erreur */
			free(S_T_(nomfichierfile));
			continue;
		}
		if((stat((char*)(nomfichierabsolu),C_S_(infosfichier))!=T_S_(0)))
		{
			/* Le fichier n'existe pas.
			 */
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			free(S_T_(nomfichierabsolu));
			SECURISE(environnement_retrait_repertoirefichier(CHAMP_TRAVAIL(general , environnement)));
			/* Retour dans le repertoire prcdent avec retrait du dernier rpertoire
			 * de la pile des rpertoires.
			 */
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_INEXISTANT),T_S(localisationnulle),nomfichierfile));
			continue;
		}
		if((S_ISDIR(CHAMP_STOCKAGE_(infosfichier , st_mode)))||(S_ISBLK(CHAMP_STOCKAGE_(infosfichier , st_mode))))
		{
			/* Le nom de fichier dsigne un rpertoire, ou un fichier de type block.
			 */
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			free(S_T_(nomfichierabsolu));
			SECURISE(environnement_retrait_repertoirefichier(CHAMP_TRAVAIL(general , environnement)));
			/* Retour dans le repertoire prcdent avec retrait du dernier rpertoire
			 * de la pile des rpertoires.
			 */
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_TYPE_INCORRECT),T_S(localisationnulle),nomfichierfile));
			continue;
		}
		if((S_T_(fichier)=(STOCKAGE_SCALAIRE(DescripteurFichier))(fopen((char*)(nomfichierabsolu),T_S_("r"))))==NULL)
		{
			/* Le fichier n'a pas pu tre ouvert en lecture.
			 */
			STOCKAGE(LocalisationFichier) localisationnulle;
			localisationnulle=NULL;
			free(S_T_(nomfichierabsolu));
			SECURISE(environnement_retrait_repertoirefichier(CHAMP_TRAVAIL(general , environnement)));
			/* Retour dans le repertoire prcdent avec retrait du dernier rpertoire
			 * de la pile des rpertoires.
			 */
			SECURISE(probleme_probleme(general,T_S_(PROBLEME_OUVERTURE_ENTREE),T_S(localisationnulle),nomfichierfile));
			/* Memory Leak sur nomfichierfile en cas d'erreur.
			 */
			free(S_T_(nomfichierfile));
			continue;
		}
		SECURISE(analyseur_verificationcheminabsolu(CHAMP_TRAVAIL(general , environnement),R_T_(localisationcheminabsolu)));
		if(localisationcheminabsolu==T_S_(VRAI))
		{
			SECURISE(localisationfichier_ajout(CHAMP_TRAVAIL(general , localisation),nomfichierabsolu,nomfichierabsolu,fichier,T_S_(PREMIERE_LIGNE_FICHIER)));
		}
		else
		{
			SECURISE(localisationfichier_ajout(CHAMP_TRAVAIL(general , localisation),nomfichierfile,nomfichierabsolu,fichier,T_S_(PREMIERE_LIGNE_FICHIER)));
		}
		/* Ajout de la localisation approprie pour l'analyse.
		 */
		free(S_T_(nomfichierfile));
		free(S_T_(nomfichierabsolu));
		break;
	}
	FINZONESECURISEE
		return RESULTAT_OK;
}

int yywrap(void )
{
	TRAVAIL_SCALAIRE(Booleen) fin_fichier;
	TRAVAIL_SCALAIRE(Booleen) fin_analyse;
	DEBUTZONESECURISEE
	fclose(T_S_(yyin));
	/* Fermeture du descripteur de fichier de l'entre analyse.
	 */
	SECURISE(environnement_retrait_repertoirefichier(T_S(CHAMP_STOCKAGE(general , environnement))));
	/* Retrait du repertoire de l'environnement.
	 */
	SECURISE(localisationfichier_retrait(T_S(CHAMP_STOCKAGE(general , localisation))));
	/* Retrait de la localisation du fichier analys.
	 */
	SECURISE(localisationfichier_vide(T_S(CHAMP_STOCKAGE(general , localisation)),R_T_(fin_fichier)));
	if(fin_fichier==T_S_(VRAI))
	{
		/* Traitement de l'entre termine.
		 */
		SECURISE(analyseur_ouverture_fichier(T_S(general),R_T_(fin_analyse)));
		/* Initialisation du traitement du fichier suivant  traiter.
		 */
		if(fin_analyse==T_S_(VRAI))
		{
			/* Fin de l'analyse. */
			yylex_destroy();
			return 1;
		}
	}
	else
	{
		SECURISE(verbeux_verbeux(T_S(general),T_S_(VERBEUX_ANALYSE_FININCLUSION)));
		SECURISE(buffer_depile());
		/* Retour d'un fichier inclus, recupration du buffer prcdent
		 */
	}
	SECURISE(localisationfichier_lecture_descripteur(T_S(CHAMP_STOCKAGE(general , localisation)),R_S_(yyin)));
	/* Branchement de yyin sur le descripteur de fichier appropri.
	 */
	return 0;/* Poursuite de l'analyse. */
	FINZONESECURISEE
}


