/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __VERBEUX__
#define __VERBEUX__

#include <src/global/global.h>

#include <src/messages/messages/sources/messages.h>
#include <src/messages/messages/sources/messageparametres.h>
#include <src/donnees/general/general.h>
#include <src/donnees/environnement/environnement.h>
#include <src/donnees/environnement/options/options.h>

typedef enum
{
	VERBEUX_ANALYSE,
	//Ce message de niveau 1 indique
	//le dbut de l'analyse du source.
	//Ce message requiert l'utilisation de :
	VERBEUX_ANALYSE_SOURCE,
	//Ce message de niveau 3 indique
	//le dbut de l'analyse d'un fichier source.
	//Ce message requiert l'utilisation de :
	//	- nom du fichier.
	VERBEUX_ANALYSE_INCLUSION,
	//Ce message de niveau 4 indique
	//le dbut de l'analyse d'un fichier source inclus.
	//Ce message requiert l'utilisation de :
	//	- nom du fichier.
	VERBEUX_ANALYSE_FININCLUSION,
	//Ce message de niveau 4 indique
	//la fin de l'analyse d'un fichier inclus.
	//Ce message requiert l'utilisation de :
	VERBEUX_RETOUCHES,
	//Ce message de niveau 1 indique
	//le dbut de la passe de retouches.
	//Ce message requiert l'utilisation de :
	VERBEUX_RETOUCHES_PARAMETRE,
	//Ce message de niveau 4 indique
	//que l'on a trouv une commande paramtre.
	//Ce message requiert l'utilisation de :
	//	- indice du paramtre.
	VERBEUX_RETOUCHES_MACRO_NORMALE,
	//Ce message de niveau 3 indique
	//que l'on a rencontr une macro qui n'est
	//pas une boucle.
	//Ce message requiert l'utilisation de :
	//	- chaine indiquant le nom de la macro ;
	//	- nombre de paramtres de la macro.
	VERBEUX_RETOUCHES_MACRO_BOUCLE,
	//Ce message de niveau 3 indique
	//que l'on a rencontr une macro qui est
	//une boucle.
	//Ce message requiert l'utilisation de :
	//	- chaine indiquant le nom de la macro ;
	//	- nombre de paramtres de la macro.
	VERBEUX_RETOUCHES_DEFRAGMENTATION,
	//Ce message de niveau 5 indique
	//la dfragmentation d'un flux
	//Ce message requiert l'utilisation de :
	//	- le type (numrique) du flux.
	VERBEUX_RETOUCHES_INCLUDE,
	//Ce message de niveau 4 indique
	//Ce message requiert l'utilisation de :
	VERBEUX_RETOUCHES_STANDARD,
	//Ce message de niveau 4 indique
	//Ce message requiert l'utilisation de :
	VERBEUX_OPTIONS,
	//Ce message de niveau 1 indique
	//le dbut de la passe de rduction d'options.
	//Ce message requiert l'utilisation de :
	VERBEUX_OPTIONS_RECHERCHE,
	//Ce message de niveau 2 indique
	//le dbut de la passe de recherche des options
	//dfinies.
	//Ce message requiert l'utilisation de :
	VERBEUX_OPTIONS_RECHERCHE_PREMIERE,
	//Ce message de niveau 3 indique
	//que la premire passe de recherche est lance.
	//Ce message requiert l'utilisation de :
	VERBEUX_OPTIONS_RECHERCHE_NOUVELLE,
	//Ce message de niveau 3 indique
	//qu'une nouvelle passe de recherche est lance.
	//Ce message requiert l'utilisation de :
	VERBEUX_OPTIONS_RECHERCHE_FIN,
	//Ce message de niveau 3 indique
	//que la recherche des options est termine.
	//Ce message requiert l'utilisation de :
	VERBEUX_OPTIONS_ENREGISTREMENT,
	//Ce message de niveau 4 indique
	//l'enregistrement d'une option.
	//Ce message requiert l'utilisation de :
	//	- nom de l'option.
	VERBEUX_OPTIONS_COMMENTAIRE,
	//Ce message de niveau 4 indique
	//l'abandon d'une option dfinie dans un commentaire.
	//Ce message requiert l'utilisation de :
	//	- nom de l'option.
	VERBEUX_OPTIONS_MACRO,
	//Ce message de niveau 4 indique
	//l'abandon d'une option dfinie dans une macro.
	//Ce message requiert l'utilisation de :
	//	- nom de l'option ;
	//	- nom de la macro.
	VERBEUX_OPTIONS_REDUCTION,
	//Ce message de niveau 2 indique
	//le dbut de la passe de rduction des commandes
	//de slection de code.
	//Ce message requiert l'utilisation de :
	VERBEUX_OPTIONS_REDUCTION_OPTIONS,
	//Ce message de niveau 4 indique
	//la rduction d'une commande #options.
	//Ce message requiert l'utilisation de :
	//	- le label de la commande.
	VERBEUX_MACROS,
	//Ce message de niveau 1 indique
	//le dbut de la passe de rduction de macros.
	//Ce message requiert l'utilisation de :
	VERBEUX_MACROS_NORMALE,
	//Ce message de niveau 3 indique
	//rduction d'une macro normale.
	//Ce message requiert l'utilisation de :
	//	- nom de la macro.
	VERBEUX_MACROS_BOUCLE,
	//Ce message de niveau 3 indique
	//rduction d'une macro boucle.
	//Ce message requiert l'utilisation de :
	//	- nom de la macro.
	VERBEUX_MACROS_PARAMETRE,
	//Ce message de niveau 4 indique
	//un remplacement de paramtre.
	//Ce message requiert l'utilisation de :
	//	- indice du paramtre.
	VERBEUX_MACROS_ITERATION,
	//Ce message de niveau 4 indique
	//une itration de boucle de macro.
	//Ce message requiert l'utilisation de :
	//	- nom de la macro ;
	//	- indice de l'itration.
	VERBEUX_VERIFICATION,
	//Ce message de niveau 1 indique
	//le dbut de la passe de vrification smantique.
	//Ce message requiert l'utilisation de :
	VERBEUX_VERIFICATION_DEFRAGMENTATION,
	//Ce message de niveau 5 indique
	//le dbut de la passe de vrification smantique.
	//Ce message requiert l'utilisation de :
	//	- le type (numrique) du flux.
	VERBEUX_VERIFICATION_ERREUR,
	//Ce message de niveau 3 indique
	//le dbut de la passe de vrification smantique.
	//Ce message requiert l'utilisation de :
	VERBEUX_VERIFICATION_AVERTISSEMENT,
	//Ce message de niveau 3 indique
	//le dbut de la passe de vrification smantique.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES,
	//Ce message de niveau 1 indique
	//le dbut de la passe d'enregistrement des styles.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES_SECTION,
	//Ce message de niveau 2 indique
	//le dbut de la passe d'enregistrement des styles
	//de section.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES_SECTION_DEFAUT,
	//Ce message de niveau 3 indique
	//l'enregistrement d'un style de section par dfaut.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES_SECTION_EXPLICITE,
	//Ce message de niveau 3 indique
	//l'enregistrement d'un style de section explicite.
	//Ce message requiert l'utilisation de :
	//	- niveau concern par l'enregistrement.
	VERBEUX_STYLES_AUTRES,
	//Ce message de niveau 2 indique
	//le dbut de la passe d'enregistrement des autres
	//styles.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES_REFERENCE_DEFAUT,
	//Ce message de niveau 3 indique
	//l'enregistrement d'un style de rfrence par dfaut.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES_REFERENCE_EXPLICITE,
	//Ce message de niveau 3 indique
	//l'enregistrement d'un style de rfrence explicite.
	//Ce message requiert l'utilisation de :
	//	- niveau concern par l'enregistrement.
	VERBEUX_STYLES_MESSAGE,
	//Ce message de niveau 3 indique
	//l'enregistrement du style de message.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES_ENTETE,
	//Ce message de niveau 3 indique
	//l'enregistrement du style d'entte.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES_PIED,
	//Ce message de niveau 3 indique
	//l'enregistrement du style de pied.
	//Ce message requiert l'utilisation de :
	VERBEUX_STYLES_RACINE,
	//Ce message de niveau 3 indique
	//l'enregistrement du niveau de la racine.
	//Ce message requiert l'utilisation de :
	//	- niveau concern par l'enregistrement.
	VERBEUX_IDEES,
	//Ce message de niveau 1 indique
	//le dbut de la passe d'enregistrement des ides.
	//Ce message requiert l'utilisation de :
	VERBEUX_IDEES_PRESENTES,
	//Ce message de niveau 2 indique
	//le dbut de la passe d'enregistrement des ides
	//prsentes.
	//Ce message requiert l'utilisation de :
	VERBEUX_IDEES_IDEE,
	//Ce message de niveau 3 indique
	//l'enregistrement d'une ide normale.
	//Ce message requiert l'utilisation de :
	//	- rfrence de l'ide.
	VERBEUX_IDEES_DEPENDANCE,
	//Ce message de niveau 4 indique
	//l'enregistrement d'une dpendance.
	//Ce message requiert l'utilisation de :
	//	- rfrence de l'ide de destination.
	VERBEUX_IDEES_AUTOMATIQUES,
	//Ce message de niveau 2 indique
	//le dbut de la passe d'enregistrement des ides
	//automatiques.
	//Ce message requiert l'utilisation de :
	VERBEUX_IDEES_MANQUANTE_DEFAUT,
	//Ce message de niveau 3 indique
	//l'enregistrement de l'ide manquante par dfaut.
	//Ce message requiert l'utilisation de :
	VERBEUX_IDEES_MANQUANTE_EXPLICITE,
	//Ce message de niveau 3 indique
	//l'enregistrement de l'ide manquante d'indice
	//explicitement donn.
	//Ce message requiert l'utilisation de :
	//	- l'indice de l'ide manquante.
	VERBEUX_IDEES_GENERIQUE_DEFAUT,
	//Ce message de niveau 3 indique
	//l'enregistrement de l'ide gnrique par dfaut.
	//Ce message requiert l'utilisation de :
	VERBEUX_IDEES_GENERIQUE_EXPLICITE,
	//Ce message de niveau 3 indique
	//l'enregistrement de l'ide gnrique de
	//rfrence parente explicitement donn.
	//Ce message requiert l'utilisation de :
	//	- la rfrence de l'ide parente.
	VERBEUX_PLAN,
	//Ce message de niveau 1 indique
	//le dbut de la passe de calcul du plan.
	//Ce message requiert l'utilisation de :
	VERBEUX_PLAN_GRAPHE,
	//Ce message de niveau 2 indique
	//le dbut de la passe de calcul du graphe
	//de dpendances.
	//Ce message requiert l'utilisation de :
	VERBEUX_PLAN_GRAPHE_VIDE,
	//Ce message de niveau 3 indique
	//le nombre d'ides utilises pour le calcul
	//du plan est nul !
	//Ce message requiert l'utilisation de :
	VERBEUX_PLAN_GRAPHE_IDEES,
	//Ce message de niveau 3 indique
	//le nombre d'ides utilises pour le calcul
	//du plan.
	//Ce message requiert l'utilisation de :
	//	- le nombre d'ides utilises.
	VERBEUX_PLAN_GRAPHE_DEPENDANCES,
	//Ce message de niveau 3 indique
	//le nombre de dpendances utilises pour le
	//calcul du plan.
	//Ce message requiert l'utilisation de :
	//	- le nombre de dpendances utilises ;
	//	- le nombre de dpendances inutiles.
	VERBEUX_PLAN_RACINE,
	//Ce message de niveau 2 indique
	//le dbut de la passe de calcul de la racine.
	//Ce message requiert l'utilisation de :
	VERBEUX_PLAN_ATTEIGNABLES,
	//Ce message de niveau 2 indique
	//le dbut de la passe de calcul de l'atteignabilit.
	//Ce message requiert l'utilisation de :
	VERBEUX_PLAN_CALCUL,
	//Ce message de niveau 2 indique
	//le dbut de la passe de calcul du plan proprement dit.
	//Ce message requiert l'utilisation de :
	VERBEUX_PLAN_TRANSFORMATION,
	//Ce message de niveau 2 indique
	//le dbut de la passe de transformation du plan calcul.
	//Ce message requiert l'utilisation de :
	VERBEUX_PLAN_TRANSFORMATION_IDEE,
	//Ce message de niveau 3 indique
	//la transformation d'une ide.
	//Ce message requiert l'utilisation de :
	//	- la rfrence de l'ide transforme.
	VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE,
	//Ce message de niveau 3 indique
	//la transformation d'une ide de rfrence vide.
	//Ce message requiert l'utilisation de :
	VERBEUX_PLAN_TRANSFORMATION_REFERENCE,
	//Ce message de niveau 4 indique
	//la compltion d'une rfrence.
	//Ce message requiert l'utilisation de :
	//	- la rfrence de la destination de la rfrence.
	VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE,
	//Ce message de niveau 4 indique
	//la compltion d'une rfrence dont la destination a une
	//rfrence vide.
	//Ce message requiert l'utilisation de :
	//	- la rfrence de la destination de la rfrence.
	VERBEUX_SORTIE,
	//Ce message de niveau 1 indique
	//le dbut de la passe de gnration du document.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_GENERATION,
	//Ce message de niveau 2 indique
	//le dbut de la passe de gnration du texte du document.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_GENERATION_ENTETE,
	//Ce message de niveau 3 indique
	//la gnration de l'entte du document.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_GENERATION_IDEE,
	//Ce message de niveau 3 indique
	//la gnration d'une ide du document.
	//Ce message requiert l'utilisation de :
	//	- la rfrence de l'ide.
	VERBEUX_SORTIE_GENERATION_IDEEVIDE,
	//Ce message de niveau 3 indique
	//la gnration d'une ide de rfrence vide.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_GENERATION_REFIRR,
	//Ce message de niveau 4 indique
	//la gnration d'une rfrence irrductible.
	//Ce message requiert l'utilisation de :
	//	- rfrence de l'ide destination.
	VERBEUX_SORTIE_GENERATION_REFIRRVIDE,
	//Ce message de niveau 4 indique
	//la gnration d'une rfrence irrductible
	//vers une ide de rfrence vide.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_GENERATION_DEPREF,
	//Ce message de niveau 4 indique
	//la gnration de la rfrence provenant
	//d'une dpendance.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_GENERATION_REFRED,
	//Ce message de niveau 4 indique
	//la gnration d'une rfrence rductible.
	//Ce message requiert l'utilisation de :
	//	- rfrence de l'ide destination.
	VERBEUX_SORTIE_GENERATION_REFREDVIDE,
	//Ce message de niveau 4 indique
	//la gnration d'une rfrence irrductible
	//vers une ide de rfrence vide.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_GENERATION_EXTREF,
	//Ce message de niveau 4 indique
	//la gnration d'une rfrence extrieure
	//Ce message requiert l'utilisation de :
	//	- l'indice de la rfrence extrieure.
	VERBEUX_SORTIE_GENERATION_EXTREFS,
	//Ce message de niveau 4 indique
	//la gnration d'une liste de rfrences
	//extrieures.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_GENERATION_PIED,
	//Ce message de niveau 3 indique
	//la gnration du pied du document.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_PRODUCTION,
	//Ce message de niveau 2 indique
	//le dbut de la passe de production du document sur la
	//sortie.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_PRODUCTION_DOCUMENT,
	//Ce message de niveau 3 indique
	//la production du document sur la sortie.
	//Ce message requiert l'utilisation de :
	VERBEUX_SORTIE_PRODUCTION_STATS
	//Ce message de niveau 3 indique
	//la production des statistiques internes du plan.
	//Ce message requiert l'utilisation de :
} CONTENEUR_SCALAIRE(Verbeux);

Resultat verbeux_verbeux(TRAVAIL(General) general , TRAVAIL_SCALAIRE(Verbeux) verbeux , ...);
/* Affiche un message indiquant l'opration effectue par le compilateur
 * sur la sortie d'erreur. Ce message servant  indiquer qu'une opration
 * interne a t effectue, aucune localisation n'est fournie.
 * Le niveau d'affichage est automatiquemen gr.
 * Renvoie RESULTAT_ERREUR si general est vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * Attention ! Les paramtres surnumraires sont les paramtres
 * du message correspondant au problme rencontr. Le nombre et le type
 * de ces arguments doivent absolument correspondre avec leurs spcifications,
 * sous peine de comportement indfini.
 */

#endif
